/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.journal.jini.ha;

import com.bigdata.ha.HAGlue;
import com.bigdata.io.SerializerUtil;
import com.bigdata.jini.start.config.ZookeeperClientConfig;
import com.bigdata.jini.util.JiniUtil;
import com.bigdata.journal.jini.ha.HAGlueServicesClient;
import com.bigdata.journal.jini.ha.HAJournalServer;
import com.bigdata.quorum.AbstractQuorumClient;
import com.bigdata.quorum.Quorum;
import com.bigdata.quorum.QuorumEvent;
import com.bigdata.quorum.QuorumListener;
import com.bigdata.quorum.zk.QuorumTokenState;
import com.bigdata.quorum.zk.ZKQuorumClient;
import com.bigdata.quorum.zk.ZKQuorumImpl;
import com.bigdata.service.IService;
import com.bigdata.service.IServiceShutdown;
import com.bigdata.service.jini.JiniClientConfig;
import com.bigdata.util.StackInfoReport;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.config.ConfigurationProvider;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.lookup.ServiceItem;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.discovery.DiscoveryEvent;
import net.jini.discovery.DiscoveryListener;
import net.jini.discovery.DiscoveryManagement;
import net.jini.discovery.LookupDiscoveryManager;
import net.jini.lease.LeaseRenewalManager;
import net.jini.lookup.ServiceDiscoveryEvent;
import net.jini.lookup.ServiceDiscoveryListener;
import net.jini.lookup.ServiceDiscoveryManager;
import org.apache.log4j.Logger;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;

public class HAClient {
    private static final Logger log = Logger.getLogger(HAClient.class);
    private final AtomicReference<HAConnection> fed = new AtomicReference();
    private final Lock connectLock = new ReentrantLock(false);
    public final JiniClientConfig jiniConfig;
    public final ZookeeperClientConfig zooConfig;
    private final Configuration config;

    public boolean isConnected() {
        return this.fed.get() != null;
    }

    public HAConnection getConnection() {
        HAConnection fed = this.fed.get();
        if (fed == null) {
            throw new IllegalStateException();
        }
        return fed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(boolean immediateShutdown) {
        this.connectLock.lock();
        try {
            HAConnection cxn = this.fed.get();
            if (cxn != null) {
                if (immediateShutdown) {
                    cxn.shutdownNow();
                } else {
                    cxn.shutdown();
                }
            }
            this.fed.set(null);
        }
        finally {
            this.connectLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HAConnection connect() {
        this.connectLock.lock();
        try {
            HAConnection cxn = this.fed.get();
            if (cxn == null) {
                cxn = new HAConnection(this.jiniConfig, this.zooConfig);
                this.fed.set(cxn);
                cxn.start(this);
            }
            HAConnection hAConnection = cxn;
            return hAConnection;
        }
        finally {
            this.connectLock.unlock();
        }
    }

    public JiniClientConfig getJiniClientConfig() {
        return this.jiniConfig;
    }

    public final ZookeeperClientConfig getZookeeperClientConfig() {
        return this.zooConfig;
    }

    public final Configuration getConfiguration() {
        return this.config;
    }

    public static HAClient newInstance(String[] args) {
        HAClient.setSecurityManager();
        try {
            return new HAClient(args);
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public HAClient(String[] args) throws ConfigurationException {
        this(HAClient.class, ConfigurationProvider.getInstance((String[])args));
    }

    public HAClient(Class<?> cls, Configuration config) throws ConfigurationException {
        if (config == null) {
            throw new IllegalArgumentException();
        }
        this.jiniConfig = new JiniClientConfig(cls.getName(), config);
        this.zooConfig = new ZookeeperClientConfig(config);
        this.config = config;
    }

    protected static void setSecurityManager() {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            System.setSecurityManager(new SecurityManager());
            if (log.isInfoEnabled()) {
                log.info((Object)"Set security manager");
            }
        } else if (log.isInfoEnabled()) {
            log.info((Object)("Security manager already in place: " + sm.getClass()));
        }
    }

    protected void serviceJoin(IService service, UUID serviceUUID) {
        if (log.isInfoEnabled()) {
            log.info((Object)("service=" + service + ", serviceUUID" + serviceUUID));
        }
    }

    protected void serviceLeave(UUID serviceUUID) {
        if (log.isInfoEnabled()) {
            log.info((Object)("serviceUUID=" + serviceUUID));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws ConfigurationException, InterruptedException, KeeperException {
        HAClient client = new HAClient(args);
        HAConnection ctx = client.connect();
        String logicalServiceId = null;
        try {
            String[] a = ctx.getHALogicalServiceIds();
            for (int i = 0; i < a.length; ++i) {
                System.out.println("logicalServiceId: " + a[i]);
            }
            if (logicalServiceId != null) {
                Quorum<HAGlue, ZKQuorumClient<HAGlue>> quorum = ctx.getHAGlueQuorum(logicalServiceId);
                quorum.addListener(new QuorumListener(){

                    @Override
                    public void notify(QuorumEvent e) {
                        System.err.println("EVENT: " + e);
                    }
                });
            }
            System.out.println("Connected - waiting for service discovery.");
            Thread.sleep(1000L);
            UUID[] serviceIds = ctx.getHAGlueServiceUUIDs(0);
            System.out.println("Found " + serviceIds.length + " services.");
            for (UUID x : serviceIds) {
                System.out.println("service: " + x + ", proxy: " + ctx.getHAGlueService(x));
            }
            if (logicalServiceId != null) {
                Thread.sleep(10000L);
            }
        }
        finally {
            ctx.shutdown();
        }
        System.out.println("Bye");
    }

    public static class HAConnection
    implements DiscoveryListener,
    ServiceDiscoveryListener,
    IServiceShutdown {
        private final JiniClientConfig jiniConfig;
        private final ZookeeperClientConfig zooConfig;
        private final AtomicReference<HAClient> clientRef = new AtomicReference();
        private ZooKeeper zk;
        private LookupDiscoveryManager lookupDiscoveryManager;
        private ServiceDiscoveryManager serviceDiscoveryManager;
        private HAGlueServicesClient discoveryClient;
        private final Map<String, Quorum<HAGlue, ZKQuorumClient<HAGlue>>> quorums = Collections.synchronizedMap(new LinkedHashMap());
        private final ReentrantLock discoveryEventLock = new ReentrantLock();
        private final Condition discoveryEvent = this.discoveryEventLock.newCondition();

        private HAConnection(JiniClientConfig jiniConfig, ZookeeperClientConfig zooConfig) {
            if (jiniConfig == null) {
                throw new IllegalArgumentException();
            }
            if (zooConfig == null) {
                throw new IllegalArgumentException();
            }
            this.jiniConfig = jiniConfig;
            this.zooConfig = zooConfig;
        }

        public HAClient getClient() {
            return this.clientRef.get();
        }

        public HAClient getClientIfOpen() {
            HAClient client = this.clientRef.get();
            if (client == null) {
                throw new IllegalStateException();
            }
            return client;
        }

        @Override
        public boolean isOpen() {
            return this.getClient() != null;
        }

        private void assertOpen() {
            if (!this.isOpen()) {
                throw new IllegalStateException();
            }
        }

        public ZookeeperClientConfig getZooConfig() {
            return this.zooConfig;
        }

        public ZooKeeper getZookeeper() {
            this.assertOpen();
            ZooKeeper zk = this.zk;
            if (zk == null) {
                throw new IllegalStateException();
            }
            return zk;
        }

        private synchronized void start(HAClient client) {
            if (client == null) {
                throw new IllegalArgumentException();
            }
            if (this.isOpen()) {
                throw new IllegalStateException();
            }
            if (log.isInfoEnabled()) {
                log.info((Object)this.jiniConfig.toString(), (Throwable)new StackInfoReport());
            }
            String[] groups = this.jiniConfig.groups;
            LookupLocator[] lookupLocators = this.jiniConfig.locators;
            try {
                this.lookupDiscoveryManager = new LookupDiscoveryManager(groups, lookupLocators, (DiscoveryListener)this, client.getConfiguration());
                try {
                    this.serviceDiscoveryManager = new ServiceDiscoveryManager((DiscoveryManagement)this.lookupDiscoveryManager, new LeaseRenewalManager(), client.getConfiguration());
                }
                catch (IOException ex) {
                    throw new RuntimeException("Could not initiate service discovery manager", ex);
                }
                long cacheMissTimeout = (Long)client.getConfiguration().getEntry(ConfigurationOptions.COMPONENT, "cacheMissTimeout", Long.TYPE, (Object)2000L);
                this.discoveryClient = new HAGlueServicesClient(this.serviceDiscoveryManager, this, cacheMissTimeout);
                log.info((Object)"Creating ZooKeeper connection.");
                this.zk = new ZooKeeper(this.zooConfig.servers, this.zooConfig.sessionTimeout, new Watcher(){

                    public void process(WatchedEvent event) {
                        if (log.isInfoEnabled()) {
                            log.info((Object)event);
                        }
                    }
                });
                boolean reverseDSNError = false;
                long begin = System.nanoTime();
                while (this.zk.getState().isAlive() && this.zk.getState() != ZooKeeper.States.CONNECTED) {
                    long elapsed = System.nanoTime() - begin;
                    if (!reverseDSNError && TimeUnit.NANOSECONDS.toSeconds(elapsed) > 4L) {
                        reverseDSNError = true;
                        log.error((Object)("Reverse DNS is not configured. The ZooKeeper client is taking too long to resolve server(s): " + this.zooConfig.servers + ", took=" + TimeUnit.NANOSECONDS.toMillis(elapsed) + "ms"));
                    }
                    if (TimeUnit.NANOSECONDS.toSeconds(elapsed) > 10L) {
                        throw new RuntimeException("Could not connect to zookeeper: state=" + this.zk.getState() + ", config" + this.zooConfig + ", elapsed=" + TimeUnit.NANOSECONDS.toMillis(elapsed) + "ms");
                    }
                    Thread.sleep(100L);
                }
                this.clientRef.set(client);
                log.info((Object)"Done.");
            }
            catch (Throwable ex) {
                log.fatal((Object)("Could not connect: " + ex.getMessage()), ex);
                try {
                    this.shutdownNow();
                }
                catch (Throwable t) {
                    log.error((Object)t.getMessage(), t);
                }
                throw new RuntimeException(ex);
            }
        }

        @Override
        public synchronized void shutdown() {
            if (!this.isOpen()) {
                return;
            }
            if (log.isInfoEnabled()) {
                log.info((Object)"begin");
            }
            this.clientRef.set(null);
            long begin = System.currentTimeMillis();
            this.terminateDiscoveryProcesses();
            long elapsed = System.currentTimeMillis() - begin;
            if (log.isInfoEnabled()) {
                log.info((Object)("Done: elapsed=" + elapsed + "ms"));
            }
        }

        @Override
        public synchronized void shutdownNow() {
            if (!this.isOpen()) {
                return;
            }
            if (log.isInfoEnabled()) {
                log.info((Object)"begin");
            }
            this.clientRef.set(null);
            long begin = System.currentTimeMillis();
            this.terminateDiscoveryProcesses();
            long elapsed = System.currentTimeMillis() - begin;
            if (log.isInfoEnabled()) {
                log.info((Object)("Done: elapsed=" + elapsed + "ms"));
            }
        }

        private void terminateDiscoveryProcesses() {
            if (this.discoveryClient != null) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Terminating " + this.discoveryClient));
                }
                this.discoveryClient.terminate();
                this.discoveryClient = null;
            }
            if (this.serviceDiscoveryManager != null) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Terminating " + this.serviceDiscoveryManager));
                }
                this.serviceDiscoveryManager.terminate();
                this.serviceDiscoveryManager = null;
            }
            if (this.lookupDiscoveryManager != null) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Terminating " + this.lookupDiscoveryManager));
                }
                this.lookupDiscoveryManager.terminate();
                this.lookupDiscoveryManager = null;
            }
            for (Quorum<HAGlue, ZKQuorumClient<HAGlue>> quorum : this.quorums.values()) {
                quorum.terminate();
            }
            log.warn((Object)"FORCING UNCURABLE ZOOKEEPER DISCONNECT");
            if (this.zk != null) {
                try {
                    this.zk.close();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                this.zk = null;
            }
        }

        public LookupDiscoveryManager getDiscoveryManagement() {
            return this.lookupDiscoveryManager;
        }

        public ServiceDiscoveryManager getServiceDiscoveryManager() {
            return this.serviceDiscoveryManager;
        }

        public HAGlueServicesClient getHAGlueServicesClient() {
            return this.discoveryClient;
        }

        public HAGlue getHAGlueService(UUID serviceUUID) {
            return this.discoveryClient.getService(serviceUUID);
        }

        public HAGlue[] getHAGlueService(UUID[] serviceUUIDs) {
            HAGlue[] a = new HAGlue[serviceUUIDs.length];
            for (int i = 0; i < a.length; ++i) {
                a[i] = this.discoveryClient.getService(serviceUUIDs[i]);
            }
            return a;
        }

        public UUID[] getHAGlueServiceUUIDs(int maxCount) {
            this.assertOpen();
            return this.discoveryClient.getServiceUUIDs(maxCount, null);
        }

        public String[] getHALogicalServiceIds() throws KeeperException, InterruptedException {
            ZookeeperClientConfig zkClientConfig = this.getZooConfig();
            String logicalServiceZPathPrefix = zkClientConfig.zroot + "/" + HAJournalServer.class.getName();
            String[] children = this.getZookeeper().getChildren(logicalServiceZPathPrefix, false).toArray(new String[0]);
            return children;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Quorum<HAGlue, ZKQuorumClient<HAGlue>> getHAGlueQuorum(String logicalServiceId) throws KeeperException, InterruptedException {
            int replicationFactor;
            Quorum<HAGlue, ZKQuorumClient<HAGlue>> quorum;
            Map<String, Quorum<HAGlue, ZKQuorumClient<HAGlue>>> map = this.quorums;
            synchronized (map) {
                quorum = this.quorums.get(logicalServiceId);
                if (quorum != null) {
                    return quorum;
                }
            }
            ZookeeperClientConfig zkClientConfig = this.getZooConfig();
            String logicalServiceZPathPrefix = zkClientConfig.zroot + "/" + HAJournalServer.class.getName();
            String logicalServiceZPath = logicalServiceZPathPrefix + "/" + logicalServiceId;
            String quorumZPath = logicalServiceZPath + "/" + "quorum";
            List<ACL> acl = zkClientConfig.acl;
            try {
                this.getZookeeper().create(zkClientConfig.zroot, new byte[0], acl, CreateMode.PERSISTENT);
            }
            catch (KeeperException.NodeExistsException ex) {
                // empty catch block
            }
            try {
                this.getZookeeper().create(logicalServiceZPathPrefix, new byte[0], acl, CreateMode.PERSISTENT);
            }
            catch (KeeperException.NodeExistsException ex) {
                // empty catch block
            }
            try {
                this.getZookeeper().create(logicalServiceZPath, new byte[0], acl, CreateMode.PERSISTENT);
            }
            catch (KeeperException.NodeExistsException ex) {
                // empty catch block
            }
            try {
                Stat stat = new Stat();
                byte[] data = this.getZookeeper().getData(quorumZPath, false, stat);
                QuorumTokenState tokenState = (QuorumTokenState)SerializerUtil.deserialize(data);
                if (log.isInfoEnabled()) {
                    log.info((Object)("Starting with quorum that has already met in the past: " + tokenState));
                }
                if ((replicationFactor = tokenState.replicationFactor()) == 0) {
                    throw new UnsupportedOperationException("The replicationFactor will be set when an HAJournalProcess is restarted: logicalServiceId=" + logicalServiceId);
                }
            }
            catch (KeeperException.NoNodeException e) {
                return null;
            }
            catch (KeeperException e) {
                throw new RuntimeException(e);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            Map<String, Quorum<HAGlue, ZKQuorumClient<HAGlue>>> map2 = this.quorums;
            synchronized (map2) {
                quorum = this.quorums.get(logicalServiceId);
                if (quorum == null) {
                    quorum = new ZKQuorumImpl<HAGlue, ZKQuorumClient<HAGlue>>(replicationFactor);
                    this.quorums.put(logicalServiceId, quorum);
                    quorum.start(new MyQuorumClient(logicalServiceZPath));
                }
            }
            return quorum;
        }

        public void serviceAdded(ServiceDiscoveryEvent e) {
            ServiceItem serviceItem = e.getPostEventServiceItem();
            if (serviceItem.service instanceof IService) {
                UUID serviceUUID = JiniUtil.serviceID2UUID(serviceItem.serviceID);
                HAClient client = this.getClient();
                if (client != null) {
                    client.serviceJoin((IService)serviceItem.service, serviceUUID);
                }
            } else if (log.isInfoEnabled()) {
                log.info((Object)("Not an " + IService.class.getName() + " : " + e));
            }
        }

        public void serviceChanged(ServiceDiscoveryEvent e) {
        }

        public void serviceRemoved(ServiceDiscoveryEvent e) {
            ServiceItem serviceItem = e.getPreEventServiceItem();
            UUID serviceUUID = JiniUtil.serviceID2UUID(serviceItem.serviceID);
            HAClient client = this.getClient();
            if (client != null) {
                client.serviceLeave(serviceUUID);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void discarded(DiscoveryEvent e) {
            try {
                this.discoveryEventLock.lockInterruptibly();
                try {
                    this.discoveryEvent.signalAll();
                }
                finally {
                    this.discoveryEventLock.unlock();
                }
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void discovered(DiscoveryEvent e) {
            try {
                this.discoveryEventLock.lockInterruptibly();
                try {
                    this.discoveryEvent.signalAll();
                }
                finally {
                    this.discoveryEventLock.unlock();
                }
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                return;
            }
        }

        public ServiceRegistrar[] awaitServiceRegistrars(long timeout, TimeUnit unit) throws TimeoutException, InterruptedException {
            long nanos;
            long begin = System.nanoTime();
            long remaining = nanos = unit.toNanos(timeout);
            ServiceRegistrar[] registrars = null;
            while ((registrars == null || registrars.length == 0) && remaining > 0L) {
                registrars = this.getDiscoveryManagement().getRegistrars();
                Thread.sleep(100L);
                long elapsed = System.nanoTime() - begin;
                remaining = nanos - elapsed;
            }
            if (registrars == null || registrars.length == 0) {
                throw new RuntimeException("Could not discover ServiceRegistrar(s)");
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Found " + registrars.length + " service registrars"));
            }
            return registrars;
        }

        private class MyQuorumClient
        extends AbstractQuorumClient<HAGlue>
        implements ZKQuorumClient<HAGlue> {
            protected MyQuorumClient(String logicalServiceZPath) {
                super(logicalServiceZPath);
            }

            @Override
            public HAGlue getService(UUID serviceId) {
                return HAConnection.this.getHAGlueService(serviceId);
            }

            @Override
            public ZooKeeper getZooKeeper() {
                return HAConnection.this.getZookeeper();
            }

            @Override
            public List<ACL> getACL() {
                return ((HAConnection)HAConnection.this).zooConfig.acl;
            }
        }
    }

    public static interface ConfigurationOptions {
        public static final String COMPONENT = HAClient.class.getName();
        public static final String CACHE_MISS_TIMEOUT = "cacheMissTimeout";
        public static final long DEFAULT_CACHE_MISS_TIMEOUT = 2000L;
    }
}

