/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.journal.jini.ha;

import com.bigdata.concurrent.FutureTaskMon;
import com.bigdata.ha.HAGlue;
import com.bigdata.ha.HAStatusEnum;
import com.bigdata.ha.QuorumService;
import com.bigdata.ha.QuorumServiceBase;
import com.bigdata.ha.halog.IHALogReader;
import com.bigdata.ha.msg.HAAwaitServiceJoinRequest;
import com.bigdata.ha.msg.HALogRequest;
import com.bigdata.ha.msg.HALogRootBlocksRequest;
import com.bigdata.ha.msg.HARebuildRequest;
import com.bigdata.ha.msg.HARootBlockRequest;
import com.bigdata.ha.msg.HAWriteSetStateRequest;
import com.bigdata.ha.msg.IHALogRequest;
import com.bigdata.ha.msg.IHALogRootBlocksResponse;
import com.bigdata.ha.msg.IHANotifyReleaseTimeResponse;
import com.bigdata.ha.msg.IHARebuildRequest;
import com.bigdata.ha.msg.IHARemoteRebuildRequest;
import com.bigdata.ha.msg.IHASendStoreResponse;
import com.bigdata.ha.msg.IHASnapshotResponse;
import com.bigdata.ha.msg.IHASyncRequest;
import com.bigdata.ha.msg.IHAWriteMessage;
import com.bigdata.ha.msg.IHAWriteSetStateResponse;
import com.bigdata.io.DirectBufferPool;
import com.bigdata.io.IBufferAccess;
import com.bigdata.jini.start.config.ZookeeperClientConfig;
import com.bigdata.jini.util.JiniUtil;
import com.bigdata.journal.AbstractJournal;
import com.bigdata.journal.IIndexManager;
import com.bigdata.journal.IRootBlockView;
import com.bigdata.journal.Journal;
import com.bigdata.journal.RootBlockUtility;
import com.bigdata.journal.jini.ha.AbstractServer;
import com.bigdata.journal.jini.ha.DefaultRestorePolicy;
import com.bigdata.journal.jini.ha.DefaultSnapshotPolicy;
import com.bigdata.journal.jini.ha.HAClient;
import com.bigdata.journal.jini.ha.HAGlueServicesClient;
import com.bigdata.journal.jini.ha.HAJournal;
import com.bigdata.journal.jini.ha.HALogNexus;
import com.bigdata.journal.jini.ha.IRestorePolicy;
import com.bigdata.journal.jini.ha.ISnapshotPolicy;
import com.bigdata.quorum.Quorum;
import com.bigdata.quorum.QuorumEvent;
import com.bigdata.quorum.QuorumException;
import com.bigdata.quorum.QuorumListener;
import com.bigdata.quorum.zk.ZKQuorumClient;
import com.bigdata.quorum.zk.ZKQuorumImpl;
import com.bigdata.rdf.sail.CreateKBTask;
import com.bigdata.rdf.sail.webapp.NanoSparqlServer;
import com.bigdata.rdf.task.AbstractApiTask;
import com.bigdata.service.AbstractHATransactionService;
import com.bigdata.service.jini.FakeLifeCycle;
import com.bigdata.util.InnerCause;
import com.bigdata.util.StackInfoReport;
import com.bigdata.util.concurrent.LatchedExecutor;
import com.bigdata.util.concurrent.MonitoredFutureTask;
import com.sun.jini.start.LifeCycle;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceItem;
import org.apache.log4j.Logger;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.webapp.WebAppContext;

public class HAJournalServer
extends AbstractServer {
    private static final Logger log = Logger.getLogger(HAJournalServer.class);
    private static final Logger haLog = Logger.getLogger((String)"com.bigdata.haLog");
    private HAJournal journal;
    private UUID serviceUUID;
    private boolean onelineDisasterRecovery;
    private LatchedExecutor singleThreadExecutor;
    private HAGlue haGlueService;
    private String logicalServiceId;
    private String logicalServiceZPathPrefix;
    private String logicalServiceZPath;
    private HAQuorumService<HAGlue, HAJournal> quorumService;
    private volatile Server jettyServer;
    private final AtomicReference<String> operatorAlert = new AtomicReference();

    WebAppContext getWebAppContext() {
        Server server = this.jettyServer;
        if (server == null) {
            throw new IllegalStateException();
        }
        WebAppContext wac = NanoSparqlServer.getWebApp(server);
        return wac;
    }

    public HAJournalServer(String[] args, LifeCycle lifeCycle) {
        super(args, lifeCycle);
        this.run();
    }

    protected void sendOperatorAlert(String msg) {
        this.operatorAlert.set(msg);
    }

    protected void clearOperatorAlert() {
        this.operatorAlert.set(null);
    }

    protected String getOperatorAlert() {
        return this.operatorAlert.get();
    }

    @Override
    protected void terminate() {
        super.terminate();
    }

    private void setupZNodes() throws KeeperException, InterruptedException {
        if (log.isInfoEnabled()) {
            log.info((Object)"Ensuring key znodes exist.");
        }
        ZookeeperClientConfig zkClientConfig = this.getHAClient().getZookeeperClientConfig();
        List<ACL> acl = zkClientConfig.acl;
        ZooKeeper zk = this.getHAClient().getConnection().getZookeeper();
        try {
            zk.create(zkClientConfig.zroot, new byte[0], acl, CreateMode.PERSISTENT);
        }
        catch (KeeperException.NodeExistsException ex) {
            // empty catch block
        }
        try {
            zk.create(this.logicalServiceZPathPrefix, new byte[0], acl, CreateMode.PERSISTENT);
        }
        catch (KeeperException.NodeExistsException ex) {
            // empty catch block
        }
        try {
            zk.create(this.logicalServiceZPath, new byte[0], acl, CreateMode.PERSISTENT);
        }
        catch (KeeperException.NodeExistsException ex) {
            // empty catch block
        }
    }

    @Override
    protected HAGlue newService(Configuration config) throws Exception {
        ServiceID serviceID;
        if (log.isInfoEnabled()) {
            log.info((Object)"Creating service impl...");
        }
        if ((serviceID = this.getServiceID()) == null) {
            throw new AssertionError((Object)"ServiceID not assigned?");
        }
        this.serviceUUID = JiniUtil.serviceID2UUID(serviceID);
        this.onelineDisasterRecovery = (Boolean)config.getEntry(ConfigurationOptions.COMPONENT, "onlineDisasterRecovery", Boolean.TYPE, (Object)false);
        ZookeeperClientConfig zkClientConfig = this.getHAClient().getZookeeperClientConfig();
        this.logicalServiceId = (String)config.getEntry(ConfigurationOptions.COMPONENT, "logicalServiceId", String.class);
        this.logicalServiceZPathPrefix = zkClientConfig.zroot + "/" + HAJournalServer.class.getName();
        this.logicalServiceZPath = this.logicalServiceZPathPrefix + "/" + this.logicalServiceId;
        int replicationFactor = (Integer)config.getEntry(ConfigurationOptions.COMPONENT, "replicationFactor", Integer.TYPE);
        ZKQuorumImpl<HAGlue, QuorumService<HAGlue>> quorum = new ZKQuorumImpl<HAGlue, QuorumService<HAGlue>>(replicationFactor);
        this.journal = this.newHAJournal(this, config, quorum);
        this.singleThreadExecutor = new LatchedExecutor(this.journal.getExecutorService(), 1);
        this.haGlueService = this.journal.newHAGlue(this.serviceUUID);
        this.quorumService = this.newQuorumService(this.logicalServiceZPath, this.serviceUUID, this.haGlueService, this.journal);
        return this.haGlueService;
    }

    private HAJournal newHAJournal(HAJournalServer server, Configuration config, Quorum<HAGlue, QuorumService<HAGlue>> quorum) throws ConfigurationException {
        String className = (String)config.getEntry(ConfigurationOptions.COMPONENT, "HAJournalClass", String.class, (Object)ConfigurationOptions.DEFAULT_HA_JOURNAL_CLASS);
        try {
            Class<?> cls = Class.forName(className);
            if (!HAJournal.class.isAssignableFrom(cls)) {
                throw new ConfigurationException("Invalid option: HAJournalClass=" + className + ":: Class does not extend " + HAJournal.class);
            }
            Constructor<?> ctor = cls.getConstructor(HAJournalServer.class, Configuration.class, Quorum.class);
            HAJournal jnl = (HAJournal)ctor.newInstance(server, config, quorum);
            return jnl;
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException("HAJournalClass=" + className, (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new ConfigurationException("HAJournalClass=" + className, (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new ConfigurationException("HAJournalClass=" + className, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationException("HAJournalClass=" + className, (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new ConfigurationException("HAJournalClass=" + className, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new ConfigurationException("HAJournalClass=" + className, (Throwable)e);
        }
    }

    @Override
    protected void startUpHook() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Starting server.");
        }
        this.startNSS();
        this.journal.getQuorum().start(this.quorumService);
    }

    private void stopNSS() {
        if (this.jettyServer != null) {
            try {
                this.jettyServer.stop();
                this.jettyServer.join();
                this.jettyServer = null;
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
            }
        }
    }

    @Override
    protected void beforeShutdownHook(boolean destroy) {
        HAJournal tjournal;
        Quorum<HAGlue, QuorumService<HAGlue>> quorum;
        if (log.isInfoEnabled()) {
            log.info((Object)("destroy=" + destroy));
        }
        Quorum<HAGlue, QuorumService<HAGlue>> quorum2 = quorum = (tjournal = this.journal) == null ? null : tjournal.getQuorum();
        if (quorum != null) {
            try {
                quorum.terminate();
            }
            catch (Throwable t) {
                log.error((Object)t, t);
            }
        }
        this.stopNSS();
        if (tjournal != null) {
            if (destroy) {
                tjournal.destroy();
            } else {
                tjournal.close();
            }
        }
    }

    private HAQuorumService<HAGlue, HAJournal> newQuorumService(String logicalServiceZPath, UUID serviceId, HAGlue remoteServiceImpl, HAJournal store) {
        return new HAQuorumService<HAGlue, HAJournal>(logicalServiceZPath, serviceId, remoteServiceImpl, store, this);
    }

    private void startNSS() {
        try {
            if (this.jettyServer != null && this.jettyServer.isRunning()) {
                throw new RuntimeException("Already running");
            }
            String jettyXml = (String)this.config.getEntry(ConfigurationOptions.COMPONENT, "jettyXml", String.class, (Object)"jetty.xml");
            this.jettyServer = NanoSparqlServer.newInstance(jettyXml, (IIndexManager)this.journal, null);
            NanoSparqlServer.awaitServerStart(this.jettyServer);
        }
        catch (Exception e1) {
            log.error((Object)("Could not start NanoSparqlServer: " + e1), (Throwable)e1);
        }
    }

    int getNSSPort() {
        return NanoSparqlServer.getLocalPort(this.jettyServer);
    }

    private void conditionalCreateDefaultKB() throws ConfigurationException, InterruptedException, ExecutionException {
        String s;
        Server server = this.jettyServer;
        if (server == null) {
            throw new IllegalStateException();
        }
        WebAppContext wac = NanoSparqlServer.getWebApp(server);
        if (wac == null) {
            throw new RuntimeException("Could not locate webapp.");
        }
        String s2 = wac.getInitParameter("namespace");
        if (s2 == null) {
            s2 = "kb";
        }
        String namespace = s2;
        if (log.isInfoEnabled()) {
            log.info((Object)("namespace=" + namespace));
        }
        boolean create = (s = wac.getInitParameter("create")) != null ? Boolean.valueOf(s) : true;
        if (log.isInfoEnabled()) {
            log.info((Object)("create=" + create));
        }
        if (create) {
            AbstractApiTask.submitApiTask(this.journal, new CreateKBTask(namespace, this.journal.getProperties())).get();
        }
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println("usage: <config-file> [config-overrides]");
            System.exit(1);
        }
        HAJournalServer server = new HAJournalServer(args, new FakeLifeCycle());
        System.exit(0);
    }

    static class HAQuorumService<S extends HAGlue, L extends HAJournal>
    extends QuorumServiceBase<S, L>
    implements ZKQuorumClient<S> {
        private final L journal;
        private final HAJournalServer server;
        private final Lock logLock;
        private final AtomicReference<FutureTask<Void>> runStateFutureRef = new AtomicReference();
        private final AtomicReference<RunStateEnum> runStateRef = new AtomicReference<Object>(null);
        private final AtomicReference<RunStateEnum> lastSubmittedRunStateRef = new AtomicReference<Object>(null);
        private final AtomicBoolean quorumStartStopGuard = new AtomicBoolean(false);
        final AtomicReference<IHAProgressListener> progressListenerRef = new AtomicReference();

        protected RunStateEnum getRunStateEnum() {
            return this.runStateRef.get();
        }

        protected void setRunState(RunStateEnum runState) {
            IRootBlockView rb;
            if (this.runStateRef.get() == RunStateEnum.Shutdown) {
                String msg = "Shutting down: can not enter runState=" + (Object)((Object)runState);
                haLog.warn((Object)msg);
                throw new IllegalStateException(msg);
            }
            RunStateEnum oldRunState = this.runStateRef.getAndSet(runState);
            if (oldRunState == runState) {
                haLog.warn((Object)("Rentering same state? runState=" + (Object)((Object)runState)));
            }
            String commitCounterStr = (rb = ((AbstractJournal)this.journal).getRootBlockView()) == null ? "N/A" : Long.toString(rb.getCommitCounter());
            haLog.warn((Object)("runState=" + (Object)((Object)runState) + ", oldRunState=" + (Object)((Object)oldRunState) + ", quorumToken=" + ((HAJournal)this.journal).getQuorumToken() + ", haStatus=" + (Object)((Object)((AbstractJournal)this.journal).getHAStatus()) + ", commitCounter=" + commitCounterStr + ", serviceName=" + this.server.getServiceName()), (Throwable)new StackInfoReport());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void start(Quorum<?, ?> quorum) {
            if (log.isInfoEnabled()) {
                log.info((Object)"", (Throwable)new StackInfoReport());
            }
            if (!this.quorumStartStopGuard.compareAndSet(false, true)) {
                throw new IllegalStateException();
            }
            try {
                this.server.getHAClient().connect();
                try {
                    this.server.setupZNodes();
                }
                catch (KeeperException e) {
                    throw new RuntimeException(e);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                super.start(quorum);
                ((AbstractJournal)this.journal).getQuorum().addListener(new QuorumListener(){

                    @Override
                    public void notify(QuorumEvent e) {
                        if (log.isTraceEnabled()) {
                            log.trace((Object)e);
                        }
                    }
                });
            }
            finally {
                this.quorumStartStopGuard.set(false);
            }
            this.runStateRef.set(null);
            this.enterRunState(new RestoreTask());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void terminate() {
            if (log.isInfoEnabled()) {
                log.info((Object)"", (Throwable)new StackInfoReport());
            }
            this.quorumStartStopGuard.set(true);
            try {
                this.runStateRef.set(RunStateEnum.Shutdown);
                FutureTask<Void> ft = this.runStateFutureRef.get();
                if (ft != null) {
                    ft.cancel(true);
                }
                this.server.getHAClient().disconnect(true);
                super.terminate();
            }
            finally {
                this.quorumStartStopGuard.set(false);
            }
        }

        @Override
        protected long getRetrySendTimeoutNanos() {
            ZooKeeper zk = this.getZooKeeper();
            if (zk == null || !zk.getState().isAlive()) {
                throw new QuorumException("ZK not connected");
            }
            int negotiatedSessionTimeoutMillis = zk.getSessionTimeout();
            long ms = (long)negotiatedSessionTimeoutMillis + ((HAJournal)this.journal).getHAExtraDelayForRetrySend();
            long ns = TimeUnit.MILLISECONDS.toNanos(ms);
            return ns;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void discardWriteSet() {
            block7: {
                this.logLock.lock();
                try {
                    log.warn((Object)"");
                    ((HAJournal)this.journal).getHALogNexus().lastLiveHAWriteMessage = null;
                    if (!((HAJournal)this.journal).getHALogNexus().isHALogOpen()) break block7;
                    try {
                        ((HAJournal)this.journal).getHALogNexus().disableHALog();
                    }
                    catch (IOException e) {
                        log.error((Object)e, (Throwable)e);
                    }
                    long token = this.getQuorum().token();
                    if (!this.isJoinedMember(token)) break block7;
                    try {
                        ((HAJournal)this.journal).getHALogNexus().createHALog(((AbstractJournal)this.journal).getRootBlockView());
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                finally {
                    this.logLock.unlock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void enterErrorState() {
            try {
                log.warn((Object)new StackInfoReport("Will enter error state"));
                this.enterRunState(new ErrorTask());
            }
            catch (Throwable t) {
                log.error((Object)t, t);
                if (InnerCause.isInnerCause(t, InterruptedException.class)) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        public Future<Void> rebuildFromLeader(IHARemoteRebuildRequest req) throws IOException {
            Quorum<HAGlue, QuorumService<HAGlue>> quorum = this.getQuorum();
            QuorumService<HAGlue> localService = quorum.getClient();
            if (localService == null) {
                return null;
            }
            long token = quorum.token();
            if (((AbstractJournal)this.journal).getHAStatus() != HAStatusEnum.NotReady) {
                return null;
            }
            UUID leaderId = quorum.getLeaderId();
            if (leaderId == null) {
                return null;
            }
            HAGlue leader = (HAGlue)localService.getService(leaderId);
            if (leader.getHAStatus() != HAStatusEnum.Leader) {
                return null;
            }
            IRootBlockView leaderRB = leader.getRootBlock(new HARootBlockRequest(null)).getRootBlock();
            IRootBlockView localRB = ((AbstractJournal)this.journal).getRootBlockView();
            if (leaderRB.getCommitCounter() == localRB.getCommitCounter()) {
                return null;
            }
            if (((AbstractJournal)this.journal).getHAStatus() != HAStatusEnum.NotReady) {
                return null;
            }
            return this.enterRunState(new RebuildTask(token));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Future<Void> enterRunState(RunStateCallable<Void> runStateTask) {
            if (runStateTask == null) {
                throw new IllegalArgumentException();
            }
            if (this.quorumStartStopGuard.get()) {
                throw new IllegalStateException();
            }
            AtomicReference<RunStateEnum> atomicReference = this.runStateRef;
            synchronized (atomicReference) {
                FutureTask<Void> futureTask;
                boolean success;
                FutureTask<Void> ft;
                block12: {
                    if (runStateTask.runState.equals((Object)this.lastSubmittedRunStateRef.get()) && !(ft = this.runStateFutureRef.get()).isDone() && !ft.isCancelled()) {
                        haLog.warn((Object)("Will not reenter active run state: " + (Object)((Object)runStateTask.runState)));
                        return null;
                    }
                    ft = new FutureTaskMon<Void>((Callable<Void>)runStateTask);
                    Future oldFuture = this.runStateFutureRef.get();
                    success = false;
                    try {
                        this.runStateFutureRef.set(ft);
                        this.lastSubmittedRunStateRef.set(runStateTask.runState);
                        ((Journal)this.journal).getExecutorService().submit(ft);
                        success = true;
                        futureTask = ft;
                        if (oldFuture == null) break block12;
                        oldFuture.cancel(true);
                    }
                    catch (Throwable throwable) {
                        if (oldFuture != null) {
                            oldFuture.cancel(true);
                        }
                        if (!success) {
                            log.error((Object)("Unable to submit task: " + runStateTask));
                            ft.cancel(true);
                            this.runStateFutureRef.set(null);
                            this.lastSubmittedRunStateRef.set(null);
                        }
                        throw throwable;
                    }
                }
                if (!success) {
                    log.error((Object)("Unable to submit task: " + runStateTask));
                    ft.cancel(true);
                    this.runStateFutureRef.set(null);
                    this.lastSubmittedRunStateRef.set(null);
                }
                return futureTask;
            }
        }

        @Override
        public Quorum<HAGlue, QuorumService<HAGlue>> getQuorum() {
            return super.getQuorum();
        }

        public HAQuorumService(String logicalServiceZPath, UUID serviceId, S remoteServiceImpl, L store, HAJournalServer server) {
            super(logicalServiceZPath, serviceId, remoteServiceImpl, store);
            this.journal = store;
            this.logLock = ((HAJournal)store).getHALogNexus().getLogLock();
            this.server = server;
        }

        @Override
        public int getPID() {
            return this.server.getPID();
        }

        @Override
        public S getService(UUID serviceId) {
            HAGlueServicesClient discoveryClient = this.server.getHAClient().getConnection().getHAGlueServicesClient();
            ServiceItem serviceItem = discoveryClient.getServiceItem(serviceId);
            if (serviceItem == null) {
                throw new QuorumException("Service not found: uuid=" + serviceId);
            }
            HAGlue service = (HAGlue)serviceItem.service;
            return (S)service;
        }

        protected void doLocalCommit(IRootBlockView rootBlock) {
            ((HAJournal)this.journal).doLocalCommit(this, rootBlock);
        }

        @Override
        public void quorumMeet(long token, UUID leaderId) {
            super.quorumMeet(token, leaderId);
            this.server.singleThreadExecutor.execute(new MonitoredFutureTask<Void>(new QuorumMeetTask(token, leaderId)));
        }

        @Override
        public void quorumBreak() {
            super.quorumBreak();
            this.server.singleThreadExecutor.execute(new MonitoredFutureTask<Void>(new EnterErrorStateTask()));
        }

        @Override
        public void serviceLeave() {
            super.serviceLeave();
            this.server.singleThreadExecutor.execute(new MonitoredFutureTask<Void>(new EnterErrorStateTask()));
        }

        @Override
        public void disconnected() {
            this.enterErrorState();
        }

        @Override
        public void memberRemove() {
            super.memberRemove();
            this.server.singleThreadExecutor.execute(new MonitoredFutureTask<Void>(new EnterErrorStateTask()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void replicateAndApplyWriteSet(UUID leaderId, S leader, long token, long closingCommitCounter) throws FileNotFoundException, IOException, InterruptedException, ExecutionException {
            boolean liveHALog;
            IHALogRootBlocksResponse resp;
            if (leader == null) {
                throw new IllegalArgumentException();
            }
            if (closingCommitCounter <= 0L) {
                throw new IllegalArgumentException();
            }
            this.getQuorum().assertQuorum(token);
            if (haLog.isInfoEnabled()) {
                haLog.info((Object)("RESYNC: commitCounter=" + closingCommitCounter));
            }
            try {
                resp = leader.getHALogRootBlocksForWriteSet(new HALogRootBlocksRequest(closingCommitCounter));
            }
            catch (FileNotFoundException ex) {
                String msg = "HALog not available: commitCounter=" + closingCommitCounter;
                log.error((Object)msg);
                if (this.server.onelineDisasterRecovery) {
                    this.enterRunState(new RebuildTask(token));
                } else {
                    this.enterRunState(new OperatorTask(msg));
                }
                throw new InterruptedException(msg);
            }
            IRootBlockView openRootBlock = resp.getOpenRootBlock();
            IRootBlockView tmpCloseRootBlock = resp.getCloseRootBlock();
            if (openRootBlock.getCommitCounter() != closingCommitCounter - 1L) {
                throw new AssertionError((Object)("Should start at the previous commit point: requested commitCounter=" + closingCommitCounter + ", openRootBlock=" + openRootBlock));
            }
            if (closingCommitCounter == 1L) {
                this.installRootBlocks(openRootBlock.asRootBlock(true), openRootBlock.asRootBlock(false));
            }
            this.logLock.lock();
            try {
                if (this.getQuorum().getMember().isJoinedMember(token)) {
                    if (((AbstractJournal)this.journal).getHAReady() != token) {
                        throw new AssertionError();
                    }
                    this.enterRunState(new RunMetTask(token, leaderId));
                    throw new InterruptedException();
                }
                if (((AbstractJournal)this.journal).getHAReady() != -1L) {
                    throw new AssertionError();
                }
                ((HAJournal)this.journal).getHALogNexus().disableHALog();
                ((HAJournal)this.journal).getHALogNexus().createHALog(openRootBlock);
            }
            finally {
                this.logLock.unlock();
            }
            boolean bl = liveHALog = openRootBlock.getCommitCounter() == tmpCloseRootBlock.getCommitCounter();
            if (liveHALog) {
                if (log.isInfoEnabled()) {
                    log.info((Object)"Joining live log");
                }
                if (this.conditionalJoinWithMetQuorum(leader, token, closingCommitCounter - 1L)) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)"CAUGHT UP");
                    }
                    throw new InterruptedException("Joined with met quorum.");
                }
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("replicateAndApplyHALog: " + closingCommitCounter));
            }
            IRootBlockView closeRootBlock = this.replicateAndApplyHALog(leader, closingCommitCounter, resp);
            this.doLocalCommit(closeRootBlock);
            this.logLock.lock();
            try {
                ((HAJournal)this.journal).getHALogNexus().closeHALog(closeRootBlock);
            }
            finally {
                this.logLock.unlock();
            }
            if (haLog.isInfoEnabled()) {
                haLog.info((Object)("Replicated write set: commitCounter=" + closingCommitCounter));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private IRootBlockView replicateAndApplyHALog(S leader, long closingCommitCounter, IHALogRootBlocksResponse resp) throws IOException, InterruptedException, ExecutionException {
            IRootBlockView closeRootBlock;
            Future<Void> ft = null;
            boolean success = false;
            try {
                if (haLog.isDebugEnabled()) {
                    haLog.debug((Object)("HALOG REPLICATION START: closingCommitCounter=" + closingCommitCounter));
                }
                ft = leader.sendHALogForWriteSet(new HALogRequest(this.server.serviceUUID, closingCommitCounter));
                ft.get();
                success = true;
            }
            finally {
                if (ft != null) {
                    ft.cancel(true);
                }
                if (haLog.isDebugEnabled()) {
                    haLog.debug((Object)("HALOG REPLICATION DONE : closingCommitCounter=" + closingCommitCounter + ", success=" + success));
                }
            }
            IRootBlockView openRootBlock = resp.getOpenRootBlock();
            IRootBlockView tmp = resp.getCloseRootBlock();
            if (openRootBlock.getCommitCounter() == tmp.getCommitCounter()) {
                IHALogRootBlocksResponse resp2 = leader.getHALogRootBlocksForWriteSet(new HALogRootBlocksRequest(closingCommitCounter));
                tmp = resp2.getCloseRootBlock();
            }
            if ((closeRootBlock = tmp).getCommitCounter() != closingCommitCounter) {
                throw new AssertionError((Object)("Wrong commitCounter for closing root block: expected commitCounter=" + closingCommitCounter + ", but closeRootBlock=" + closeRootBlock));
            }
            return closeRootBlock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean conditionalJoinWithMetQuorum(S leader, long token, long openingCommitCounter) throws IOException, InterruptedException {
            boolean sameCommitCounter;
            IHAWriteSetStateResponse currentWriteSetStateOnLeader = leader.getHAWriteSetState(new HAWriteSetStateRequest());
            boolean bl = sameCommitCounter = currentWriteSetStateOnLeader.getCommitCounter() == openingCommitCounter;
            if (haLog.isDebugEnabled()) {
                haLog.debug((Object)("sameCommitCounter=" + sameCommitCounter + ", openingCommitCounter=" + openingCommitCounter + ", currentWriteSetStateOnLeader=" + currentWriteSetStateOnLeader));
            }
            if (!sameCommitCounter || currentWriteSetStateOnLeader.getSequence() > 0L) {
                return false;
            }
            this.logLock.lock();
            try {
                IHAWriteMessage lastLiveMsg = ((HAJournal)this.journal).getHALogNexus().lastLiveHAWriteMessage;
                if (lastLiveMsg != null && lastLiveMsg.getCommitCounter() >= currentWriteSetStateOnLeader.getCommitCounter()) {
                    boolean bl2 = false;
                    return bl2;
                }
                HALogNexus logWriter = ((HAJournal)this.journal).getHALogNexus();
                if (haLog.isDebugEnabled()) {
                    haLog.debug((Object)("HALog.commitCounter=" + logWriter.getCommitCounter() + ", HALog.getSequence=" + logWriter.getSequence()));
                }
                if (logWriter.getCommitCounter() != openingCommitCounter || logWriter.getSequence() != 0L) {
                    throw new AssertionError((Object)("openingCommitCount=" + openingCommitCounter + ", logWriter.commitCounter=" + logWriter.getCommitCounter() + ", logWriter.sequence=" + logWriter.getSequence()));
                }
                this.doCastLeadersVoteAndServiceJoin(token);
                boolean bl3 = true;
                return bl3;
            }
            finally {
                this.logLock.unlock();
            }
        }

        private void pipelineSetup() throws FileNotFoundException, IOException, InterruptedException {
            long token = this.getQuorum().token();
            this.getQuorum().assertQuorum(token);
            this.awaitJournalToken(token);
        }

        @Override
        protected void incReceive(IHASyncRequest req, IHAWriteMessage msg, int nreads, int rdlen, int rem) throws Exception {
            IHAProgressListener l = this.progressListenerRef.get();
            if (l != null) {
                l.incReceive(req, msg, nreads, rdlen, rem);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void handleReplicatedWrite(IHASyncRequest req, IHAWriteMessage msg, ByteBuffer data) throws Exception {
            if (req == null && ((AbstractJournal)this.journal).getRootBlockView().getCommitCounter() == 0L && msg.getUUID() != null && !((AbstractJournal)this.journal).getUUID().equals(msg.getUUID())) {
                return;
            }
            this.pipelineSetup();
            this.logLock.lock();
            try {
                ((HAJournal)this.journal).getHALogNexus().conditionalCreateHALog();
                if (haLog.isDebugEnabled()) {
                    haLog.debug((Object)("msg=" + msg + ", buf=" + data));
                }
                if (req == null) {
                    ((HAJournal)this.journal).getHALogNexus().lastLiveHAWriteMessage = msg;
                } else if (req instanceof IHARebuildRequest) {
                    ((HAJournal)this.journal).getBufferStrategy().writeRawBuffer((HARebuildRequest)req, msg, data);
                    return;
                }
                HALogNexus logWriter = ((HAJournal)this.journal).getHALogNexus();
                assert (logWriter.isHALogOpen());
                if (msg.getCommitCounter() == logWriter.getCommitCounter() && msg.getSequence() == logWriter.getSequence() - 1L) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Ignoring message (dup): " + msg));
                    }
                    return;
                }
                RunStateEnum runState = this.runStateRef.get();
                if (RunStateEnum.Resync.equals((Object)runState)) {
                    this.handleResyncMessage((IHALogRequest)req, msg, data);
                    return;
                }
                if (req != null) {
                    this.dropMessage(req, msg, data);
                    return;
                }
                assert (req == null);
                if (((AbstractJournal)this.journal).getHAReady() == -1L || !this.isJoinedMember(msg.getQuorumToken())) {
                    this.dropMessage(req, msg, data);
                    return;
                }
                this.acceptHAWriteMessage(msg, data);
                return;
            }
            finally {
                this.logLock.unlock();
            }
        }

        private void dropMessage(IHASyncRequest req, IHAWriteMessage msg, ByteBuffer data) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Ignoring message: req=" + req + ", msg=" + msg));
            }
        }

        private void setExtent(IHAWriteMessage msg) throws IOException {
            try {
                ((HAJournal)this.journal).getBufferStrategy().setExtentForLocalStore(msg.getFileExtent());
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (RuntimeException t) {
                throw new RuntimeException("msg=" + msg + ": " + t, t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleResyncMessage(IHALogRequest req, IHAWriteMessage msg, ByteBuffer data) throws IOException, InterruptedException {
            this.logLock.lock();
            try {
                HALogNexus logWriter = ((HAJournal)this.journal).getHALogNexus();
                if (req == null) {
                    if (msg.getCommitCounter() == ((AbstractJournal)this.journal).getRootBlockView().getCommitCounter() && msg.getSequence() == logWriter.getSequence()) {
                        if (haLog.isInfoEnabled()) {
                            haLog.info((Object)("Transition to MET after seeing LIVE that is NEXT after last resync, lastLiveNexusMsg " + ((HAJournal)this.journal).getHALogNexus().lastLiveHAWriteMessage));
                        }
                        this.resyncTransitionToMetQuorum(msg, data);
                        return;
                    }
                    if (haLog.isDebugEnabled()) {
                        log.debug((Object)("Ignoring write cache block: msg=" + msg));
                    }
                    return;
                }
                if (!this.server.serviceUUID.equals(req.getServiceId())) {
                    if (haLog.isDebugEnabled()) {
                        log.debug((Object)("Ignoring write cache block: msg=" + msg));
                    }
                    return;
                }
                this.acceptHAWriteMessage(msg, data);
            }
            finally {
                this.logLock.unlock();
            }
        }

        private void resyncTransitionToMetQuorum(IHAWriteMessage msg, ByteBuffer data) throws IOException, InterruptedException {
            HALogNexus logWriter = ((HAJournal)this.journal).getHALogNexus();
            IRootBlockView rootBlock = ((AbstractJournal)this.journal).getRootBlockView();
            if (logWriter.getCommitCounter() != rootBlock.getCommitCounter()) {
                throw new AssertionError((Object)("HALogWriter.commitCounter=" + logWriter.getCommitCounter() + ", but rootBlock=" + rootBlock));
            }
            if (msg.getCommitCounter() != rootBlock.getCommitCounter() || msg.getLastCommitTime() != rootBlock.getLastCommitTime()) {
                throw new AssertionError((Object)("msg=" + msg + ", but rootBlock=" + ((AbstractJournal)this.journal).getRootBlockView()));
            }
            this.acceptHAWriteMessage(msg, data);
            this.doCastLeadersVoteAndServiceJoin(msg.getQuorumToken());
        }

        private void doCastLeadersVoteAndServiceJoin(final long token) {
            Quorum<HAGlue, QuorumService<HAGlue>> quorum = this.getQuorum();
            UUID leaderId = quorum.getLeaderId();
            final HAGlue leader = (HAGlue)this.getLeader(token);
            quorum.assertQuorum(token);
            long leadersVote = quorum.getCastVote(leaderId);
            if (haLog.isInfoEnabled()) {
                haLog.info((Object)("Will attempt to join met quorum: " + token + ", leadersVote=" + leadersVote));
            }
            this.getActor().castVote(leadersVote);
            this.getQuorum().assertQuorum(token);
            if (haLog.isInfoEnabled()) {
                haLog.info((Object)("Successful attempt to cast vote for met quorum: " + token + ", leadersVote=" + leadersVote));
            }
            final AbstractHATransactionService txs = (AbstractHATransactionService)((Journal)this.journal).getTransactionService();
            txs.runWithBarrierLock(new Runnable(){

                @Override
                public void run() {
                    IHANotifyReleaseTimeResponse resp;
                    HAQuorumService.this.getQuorum().assertQuorum(token);
                    HAQuorumService.this.getActor().serviceJoin();
                    HAQuorumService.this.getQuorum().assertQuorum(token);
                    try {
                        resp = leader.awaitServiceJoin(new HAAwaitServiceJoinRequest(HAQuorumService.this.getServiceId(), Long.MAX_VALUE, TimeUnit.SECONDS));
                        if (haLog.isInfoEnabled()) {
                            haLog.info((Object)("Obtained releaseTime from leader: " + resp));
                        }
                    }
                    catch (Exception t) {
                        throw new QuorumException("Service join not observed by leader.", t);
                    }
                    HAQuorumService.this.journal.setQuorumToken(token);
                    HAQuorumService.this.getQuorum().assertQuorum(token);
                    txs.setReleaseTime(resp.getCommitTime());
                    HAQuorumService.this.getQuorum().assertQuorum(token);
                }
            });
            if (haLog.isInfoEnabled()) {
                haLog.info((Object)"TRANSITION", (Throwable)new StackInfoReport());
            }
            this.enterRunState(new RunMetTask(token, leaderId));
        }

        private void acceptHAWriteMessage(IHAWriteMessage msg, ByteBuffer data) throws IOException, InterruptedException {
            long expectedCommitCounter = ((HAJournal)this.journal).getHALogNexus().getCommitCounter();
            long expectedBlockSequence = ((HAJournal)this.journal).getHALogNexus().getSequence();
            if (msg.getCommitCounter() != expectedCommitCounter) {
                throw new IllegalStateException("expectedCommitCounter=" + expectedCommitCounter + ", but msg=" + msg);
            }
            if (msg.getSequence() != expectedBlockSequence) {
                throw new IllegalStateException("expectedBlockSequence=" + expectedBlockSequence + ", but msg=" + msg);
            }
            this.logWriteCacheBlock(msg, data);
            this.writeWriteCacheBlock(msg, data);
        }

        @Override
        public void logWriteCacheBlock(IHAWriteMessage msg, ByteBuffer data) throws IOException {
            try {
                this.pipelineSetup();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
            this.logLock.lock();
            try {
                ((HAJournal)this.journal).getHALogNexus().conditionalCreateHALog();
                ((HAJournal)this.journal).getHALogNexus().writeOnHALog(msg, data);
            }
            catch (RuntimeException ex) {
                haLog.error((Object)ex, (Throwable)ex);
                throw ex;
            }
            catch (IOException ex) {
                haLog.error((Object)ex, (Throwable)ex);
                throw ex;
            }
            finally {
                this.logLock.unlock();
            }
        }

        private void writeWriteCacheBlock(IHAWriteMessage msg, final ByteBuffer data) throws IOException, InterruptedException {
            this.setExtent(msg);
            IBufferAccess b = new IBufferAccess(){

                @Override
                public void release(long timeout, TimeUnit unit) throws InterruptedException {
                }

                @Override
                public void release() throws InterruptedException {
                }

                @Override
                public ByteBuffer buffer() {
                    return data;
                }
            };
            ((HAJournal)this.journal).getBufferStrategy().writeRawBuffer(msg, b);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void logRootBlock(IRootBlockView rootBlock) throws IOException {
            this.logLock.lock();
            try {
                ((HAJournal)this.journal).getHALogNexus().closeHALog(rootBlock);
                ((HAJournal)this.journal).getHALogNexus().createHALog(rootBlock);
            }
            finally {
                this.logLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void purgeHALogs(long token) {
            this.logLock.lock();
            try {
                if (!this.getQuorum().isQuorumFullyMet(token)) {
                    return;
                }
                long earliestRestorableCommitPoint = ((HAJournal)this.journal).getSnapshotManager().getRestorePolicy().getEarliestRestorableCommitPoint((HAJournal)this.journal);
                long earliestRetainedSnapshotLastCommitCounter = ((HAJournal)this.journal).getSnapshotManager().deleteSnapshots(token, earliestRestorableCommitPoint);
                ((HAJournal)this.journal).getHALogNexus().deleteHALogs(token, earliestRetainedSnapshotLastCommitCounter);
            }
            finally {
                this.logLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void deleteBackups() throws IOException {
            this.logLock.lock();
            try {
                haLog.warn((Object)"Destroying local backups.");
                ((HAJournal)this.journal).getSnapshotManager().deleteAllSnapshots();
                ((HAJournal)this.journal).getHALogNexus().deleteAllHALogsExceptCurrent();
            }
            finally {
                this.logLock.unlock();
            }
        }

        @Override
        public void installRootBlocks(IRootBlockView rootBlock0, IRootBlockView rootBlock1) {
            ((HAJournal)this.journal).installRootBlocks(rootBlock0, rootBlock1);
        }

        @Override
        public File getServiceDir() {
            return this.server.getServiceDir();
        }

        private void awaitJournalToken(long token) throws IOException, InterruptedException {
            HAGlue leader = null;
            IRootBlockView rbLeader = null;
            long sleepMillis = 10L;
            int ntimes = 0;
            while (true) {
                IRootBlockView rbSelf;
                ++ntimes;
                this.getQuorum().assertQuorum(token);
                long journalToken = ((HAJournal)this.journal).getQuorumToken();
                if (journalToken != token) {
                    Thread.sleep(10L);
                    continue;
                }
                if (!this.isFollower(token) || (rbSelf = ((AbstractJournal)this.journal).getRootBlockViewWithLock()).getCommitCounter() != 0L) break;
                if (leader == null) {
                    leader = (HAGlue)this.getLeader(token);
                    rbLeader = leader.getRootBlock(new HARootBlockRequest(null)).getRootBlock();
                }
                if (rbSelf.getUUID().equals(rbLeader.getUUID())) break;
                Thread.sleep(10L);
            }
            if (ntimes > 1 && haLog.isInfoEnabled()) {
                haLog.info((Object)"Journal quorumToken is set.");
            }
        }

        @Override
        public ZooKeeper getZooKeeper() {
            return this.server.getHAClient().connect().getZookeeper();
        }

        @Override
        public List<ACL> getACL() {
            return this.server.getHAClient().getZookeeperClientConfig().acl;
        }

        public static interface IHAProgressListener {
            public void incReceive(IHASyncRequest var1, IHAWriteMessage var2, int var3, int var4, int var5) throws Exception;
        }

        private class ResyncTask
        extends RunStateCallable<Void> {
            private final long token;

            public ResyncTask(long token) {
                super(RunStateEnum.Resync);
                this.token = token;
            }

            @Override
            protected Void doRun() throws Exception {
                HAQuorumService.this.pipelineSetup();
                HAQuorumService.this.journal.doLocalAbort();
                UUID leaderId = HAQuorumService.this.getQuorum().getLeaderId();
                HAGlue leader = (HAGlue)HAQuorumService.this.getLeader(this.token);
                while (true) {
                    long commitCounter = HAQuorumService.this.journal.getRootBlockView().getCommitCounter();
                    HAQuorumService.this.replicateAndApplyWriteSet(leaderId, leader, this.token, commitCounter + 1L);
                }
            }
        }

        private class RebuildTask
        extends RunStateCallable<Void> {
            private final long token;

            public RebuildTask(long token) {
                super(RunStateEnum.Rebuild);
                this.token = token;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected Void doRun() throws Exception {
                IHASendStoreResponse resp;
                HAQuorumService.this.getQuorum().assertQuorum(this.token);
                HAGlue leader = (HAGlue)HAQuorumService.this.getLeader(this.token);
                HAQuorumService.this.awaitJournalToken(this.token);
                IRootBlockView rb = leader.getRootBlock(new HARootBlockRequest(null)).getRootBlock();
                long createTime = System.currentTimeMillis();
                RootBlockUtility rbu = new RootBlockUtility(HAQuorumService.this.journal.getBufferStrategy().getBufferMode(), rb.getOffsetBits(), createTime, this.token, rb.getUUID());
                HAQuorumService.this.getQuorum().assertQuorum(this.token);
                HAQuorumService.this.deleteBackups();
                HAQuorumService.this.installRootBlocks(rbu.rootBlock0, rbu.rootBlock1);
                Future<IHASendStoreResponse> remoteFuture = leader.sendHAStore(new HARebuildRequest(HAQuorumService.this.getServiceId()));
                try {
                    resp = remoteFuture.get();
                    log.warn((Object)"REBUILD: Copied backing store from leader.");
                }
                finally {
                    remoteFuture.cancel(true);
                }
                HAQuorumService.this.getQuorum().assertQuorum(this.token);
                HAQuorumService.this.installRootBlocks(resp.getRootBlock0(), resp.getRootBlock1());
                log.warn((Object)("REBUILD: installed root blocks @ commitCounter=" + HAQuorumService.this.journal.getRootBlockView().getCommitCounter() + ": rb0=" + resp.getRootBlock0() + ", rb1=" + resp.getRootBlock1()));
                HAQuorumService.this.enterRunState(new ResyncTask(this.token));
                return null;
            }
        }

        private class RestoreTask
        extends RunStateCallable<Void> {
            protected RestoreTask() {
                super(RunStateEnum.Restore);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected Void doRun() throws Exception {
                while (true) {
                    long commitCounter = HAQuorumService.this.journal.getRootBlockView().getCommitCounter();
                    IHALogReader r = null;
                    try {
                        r = HAQuorumService.this.journal.getHALogNexus().getReader(commitCounter + 1L);
                        if (r.isEmpty()) break;
                        if (r.getOpeningRootBlock().getCommitCounter() != commitCounter) {
                            throw new AssertionError();
                        }
                        if (r.getClosingRootBlock().getCommitCounter() != commitCounter + 1L) {
                            throw new AssertionError();
                        }
                        this.applyHALog(r);
                        HAQuorumService.this.doLocalCommit(r.getClosingRootBlock());
                        continue;
                    }
                    catch (FileNotFoundException ex) {
                    }
                    catch (IOException ex) {
                        log.error((Object)("Problem reading HALog file: commitCounter=" + commitCounter + ": " + ex), (Throwable)ex);
                    }
                    finally {
                        if (r == null) continue;
                        r.close();
                        continue;
                    }
                    break;
                }
                HAQuorumService.this.enterRunState(new SeekConsensusTask());
                return null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void applyHALog(IHALogReader r) throws IOException, InterruptedException {
                IBufferAccess buf = DirectBufferPool.INSTANCE.acquire();
                try {
                    while (r.hasMoreBuffers()) {
                        IHAWriteMessage msg = r.processNextBuffer(buf.buffer());
                        HAQuorumService.this.writeWriteCacheBlock(msg, buf.buffer());
                    }
                    haLog.warn((Object)("Applied HALog: closingCommitCounter=" + r.getClosingRootBlock().getCommitCounter()));
                }
                finally {
                    buf.release();
                }
            }
        }

        private class OperatorTask
        extends RunStateCallable<Void> {
            final String msg;

            public OperatorTask(String msg) {
                super(RunStateEnum.Operator);
                this.msg = msg;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void doRun() throws Exception {
                try {
                    HAQuorumService.this.server.sendOperatorAlert(this.msg);
                    this.blockInterruptably();
                    Void void_ = null;
                    return void_;
                }
                finally {
                    HAQuorumService.this.server.clearOperatorAlert();
                }
            }
        }

        private class RunMetTask
        extends RunStateCallable<Void> {
            private final long token;
            private final UUID leaderId;

            public RunMetTask(long token, UUID leaderId) {
                super(RunStateEnum.RunMet);
                this.token = token;
                this.leaderId = leaderId;
            }

            @Override
            public Void doRun() throws Exception {
                if (!this.leaderId.equals(HAQuorumService.this.getQuorum().getLeaderId())) {
                    throw new InterruptedException();
                }
                HAQuorumService.this.getQuorum().assertQuorum(this.token);
                if (!HAQuorumService.this.isJoinedMember(this.token)) {
                    throw new InterruptedException();
                }
                if (HAQuorumService.this.isLeader(this.token)) {
                    HAQuorumService.this.server.conditionalCreateDefaultKB();
                }
                while (HAQuorumService.this.journal.getRootBlockView().getCommitCounter() < 1L) {
                    Thread.sleep(100L);
                }
                Future<IHASnapshotResponse> ft = HAQuorumService.this.journal.getSnapshotManager().takeInitialSnapshot();
                if (ft != null) {
                    ft.get();
                }
                this.blockInterruptably();
                return null;
            }
        }

        private class SeekConsensusTask
        extends RunStateCallable<Void> {
            protected SeekConsensusTask() {
                super(RunStateEnum.SeekConsensus);
            }

            @Override
            public Void doRun() throws Exception {
                long token = HAQuorumService.this.getQuorum().token();
                if (HAQuorumService.this.isJoinedMember(token)) {
                    throw new IllegalStateException("Service joined.");
                }
                if (HAQuorumService.this.getQuorum().getCastVote(HAQuorumService.this.getServiceId()) != null) {
                    throw new IllegalStateException("Vote already cast.");
                }
                if (HAQuorumService.this.journal.getHALogNexus().isHALogOpen()) {
                    throw new IllegalStateException("HALogWriter is open.");
                }
                HAQuorumService.this.getActor().memberAdd();
                HAQuorumService.this.getActor().pipelineAdd();
                HAQuorumService.this.processEvents();
                token = HAQuorumService.this.getQuorum().token();
                if (token != -1L) {
                    HAQuorumService.this.enterRunState(new ResyncTask(token));
                    return null;
                }
                long lastCommitTime = HAQuorumService.this.journal.getLastCommitTime();
                HAQuorumService.this.getActor().castVote(lastCommitTime);
                long token2 = HAQuorumService.this.getQuorum().awaitQuorum();
                if (!HAQuorumService.this.isJoinedMember(token2)) {
                    HAQuorumService.this.enterRunState(new ResyncTask(token2));
                } else {
                    UUID leaderId = HAQuorumService.this.getQuorum().getLeaderId();
                    HAQuorumService.this.enterRunState(new RunMetTask(token2, leaderId));
                }
                return null;
            }
        }

        private class ErrorTask
        extends RunStateCallable<Void> {
            protected ErrorTask() {
                super(RunStateEnum.Error);
            }

            @Override
            public Void doRun() throws Exception {
                long t2;
                long t1;
                do {
                    int sessionTimeout1;
                    log.warn((Object)"Will do error handler.");
                    HAQuorumService.this.journal.doLocalAbort();
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Current Token: haJournalReady=" + HAQuorumService.this.journal.getHAReady() + ", getQuorum().token()=: " + HAQuorumService.this.getQuorum().token()));
                    }
                    HAQuorumService.this.journal.clearQuorumToken(HAQuorumService.this.getQuorum().token());
                    int sessionTimeout = sessionTimeout1 = ((HAQuorumService)HAQuorumService.this).server.getHAClient().zooConfig.sessionTimeout;
                    long begin = System.nanoTime();
                    while (true) {
                        int sessionTimeout2;
                        HAClient.HAConnection cxn;
                        try {
                            cxn = HAQuorumService.this.server.getHAClient().getConnection();
                        }
                        catch (IllegalStateException ex) {
                            log.error((Object)"Tearing down service: HAClient not connected.");
                            this.restartHAQuorumService();
                            break;
                        }
                        ZooKeeper zk = cxn.getZookeeper();
                        if (!zk.getState().isAlive()) {
                            log.error((Object)"Tearing down service: ZK Session is expired");
                            this.restartHAQuorumService();
                        }
                        if ((sessionTimeout2 = zk.getSessionTimeout()) > 0 && sessionTimeout2 < sessionTimeout1) {
                            sessionTimeout = sessionTimeout2;
                        }
                        if (zk.getState() == ZooKeeper.States.CONNECTED) break;
                        long elapsed = System.nanoTime() - begin;
                        if (elapsed > TimeUnit.MILLISECONDS.toNanos(sessionTimeout)) {
                            log.error((Object)("Tearing down service: ZK Session remains disconnected for " + TimeUnit.NANOSECONDS.toMillis(elapsed) + "ms, effectiveTimeout=" + sessionTimeout));
                            this.restartHAQuorumService();
                            break;
                        }
                        Thread.sleep(100L);
                    }
                    log.warn((Object)"Will attempt SERVICE LEAVE");
                    HAQuorumService.this.getActor().serviceLeave();
                    HAQuorumService.this.processEvents();
                } while ((t1 = HAQuorumService.this.journal.getQuorumToken()) != (t2 = HAQuorumService.this.journal.getQuorum().token()));
                haLog.warn((Object)("Will not re-do error handler: journal.quorumToken=" + t1 + ", quorum.token()=" + t2));
                HAQuorumService.this.enterRunState(new SeekConsensusTask());
                return null;
            }

            private void restartHAQuorumService() {
                HAQuorumService.this.journal.getExecutorService().submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            log.warn((Object)"HAQuorumService: TERMINATE");
                            HAQuorumService.this.journal.getQuorum().terminate();
                            HAQuorumService.this.journal.clearQuorumToken(-1L);
                        }
                        catch (Throwable t) {
                            log.error((Object)t, t);
                            HAQuorumService.this.enterErrorState();
                        }
                        try {
                            log.warn((Object)"HAQuorumService: START");
                            HAQuorumService.this.journal.getQuorum().start(HAQuorumService.this);
                        }
                        catch (Throwable t) {
                            log.error((Object)t, t);
                            HAQuorumService.this.enterErrorState();
                        }
                    }
                });
                try {
                    Thread.sleep(Long.MAX_VALUE);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        private class EnterErrorStateTask
        implements Callable<Void> {
            protected EnterErrorStateTask() {
                log.warn((Object)"", (Throwable)new StackInfoReport());
            }

            @Override
            public Void call() throws Exception {
                HAQuorumService.this.enterErrorState();
                return null;
            }
        }

        private class QuorumMeetTask
        implements Callable<Void> {
            private final long token;

            public QuorumMeetTask(long token, UUID leaderId) {
                this.token = token;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws Exception {
                HAQuorumService.this.journal.setQuorumToken(this.token);
                if (HAQuorumService.this.isJoinedMember(this.token)) {
                    HAQuorumService.this.logLock.lock();
                    try {
                        if (!HAQuorumService.this.journal.getHALogNexus().isHALogOpen()) {
                            if (log.isInfoEnabled()) {
                                log.info((Object)"Disable log on QuorumMeet");
                            }
                            HAQuorumService.this.journal.getHALogNexus().disableHALog();
                            HAQuorumService.this.journal.getHALogNexus().createHALog(HAQuorumService.this.journal.getRootBlockView());
                        }
                    }
                    finally {
                        HAQuorumService.this.logLock.unlock();
                    }
                }
                return null;
            }
        }

        private abstract class RunStateCallable<T>
        implements Callable<T> {
            protected final RunStateEnum runState;

            protected RunStateCallable(RunStateEnum runState) {
                if (runState == null) {
                    throw new IllegalArgumentException();
                }
                this.runState = runState;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public final T call() throws Exception {
                HAQuorumService.this.setRunState(this.runState);
                try {
                    T t = this.doRun();
                    return t;
                }
                catch (Throwable t) {
                    if (InnerCause.isInnerCause(t, InterruptedException.class)) {
                        if (log.isInfoEnabled()) {
                            log.info((Object)("Interrupted: " + (Object)((Object)this.runState)));
                        }
                        T t2 = null;
                        return t2;
                    }
                    log.error((Object)t, t);
                    Thread.sleep(250L);
                    if (this.runState == RunStateEnum.Error) {
                        haLog.warn((Object)"Detected error from ErrorTask, so clear runStateRef to allow re-entry");
                        HAQuorumService.this.runStateRef.set(null);
                    }
                    HAQuorumService.this.enterErrorState();
                    T t3 = null;
                    return t3;
                }
                finally {
                    haLog.warn((Object)((Object)((Object)this.runState) + ": exit, runStateFuture=" + HAQuorumService.this.runStateFutureRef.get()));
                }
            }

            protected abstract T doRun() throws Exception;

            protected void blockInterruptably() throws InterruptedException {
                if (haLog.isInfoEnabled()) {
                    haLog.info((Object)this.toString());
                }
                while (true) {
                    Thread.sleep(Long.MAX_VALUE);
                }
            }

            public String toString() {
                return this.getClass().getName() + "{runState=" + (Object)((Object)this.runState) + "}";
            }
        }
    }

    public static enum RunStateEnum {
        Restore,
        SeekConsensus,
        RunMet,
        Resync,
        Rebuild,
        Error,
        Shutdown,
        Operator;

    }

    public static interface ConfigurationOptions
    extends AbstractServer.ConfigurationOptions {
        public static final String COMPONENT = HAJournalServer.class.getName();
        public static final String REPLICATION_FACTOR = "replicationFactor";
        public static final String WRITE_PIPELINE_ADDR = "writePipelineAddr";
        public static final String LOGICAL_SERVICE_ID = "logicalServiceId";
        public static final String HA_RELEASE_TIME_CONSENSUS_TIMEOUT = "haReleaseTimeConsensusTimeout";
        public static final long DEFAULT_HA_RELEASE_TIME_CONSENSUS_TIMEOUT = Long.MAX_VALUE;
        public static final long MIN_HA_RELEASE_TIME_CONSENSUS_TIMEOUT = 100L;
        public static final String HA_PREPARE_TIMEOUT = "haPrepareTimeout";
        public static final long DEFAULT_HA_PREPARE_TIMEOUT = Long.MAX_VALUE;
        public static final long MIN_HA_PREPARE_TIMEOUT = 100L;
        public static final String MAXIMUM_CLOCK_SKEW = "maximumClockSkew";
        public static final long DEFAULT_MAXIMUM_CLOCK_SKEW = 5000L;
        public static final long MIN_MAXIMUM_CLOCK_SKEW = 100L;
        public static final String HA_EXTRA_DELAY_FOR_RETRY_SEND = "haExtraDelayForRetrySend";
        public static final long DEFAULT_HA_EXTRA_DELAY_FOR_RETRY_SEND = 5000L;
        public static final String HA_LOG_DIR = "haLogDir";
        public static final String DEFAULT_HA_LOG_DIR = "HALog";
        public static final String HA_LOG_PURGE_TIMEOUT = "HALogPurgeTimeout";
        public static final long DEFAULT_HA_LOG_PURGE_TIMEOUT = 0L;
        public static final String SNAPSHOT_DIR = "snapshotDir";
        public static final String DEFAULT_SNAPSHOT_DIR = "snapshot";
        public static final String STARTUP_THREADS = "startupThreads";
        public static final int DEFAULT_STARTUP_THREADS = 20;
        public static final String SNAPSHOT_POLICY = "snapshotPolicy";
        public static final ISnapshotPolicy DEFAULT_SNAPSHOT_POLICY = new DefaultSnapshotPolicy();
        public static final String RESTORE_POLICY = "restorePolicy";
        public static final IRestorePolicy DEFAULT_RESTORE_POLICY = new DefaultRestorePolicy();
        public static final String HA_JOURNAL_CLASS = "HAJournalClass";
        public static final String DEFAULT_HA_JOURNAL_CLASS = HAJournal.class.getName();
        public static final String ONLINE_DISASTER_RECOVERY = "onlineDisasterRecovery";
        public static final boolean DEFAULT_ONLINE_DISASTER_RECOVERY = false;
        public static final String JETTY_XML = "jettyXml";
        public static final String DEFAULT_JETTY_XML = "jetty.xml";
    }
}

