/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.journal.jini.ha;

import com.bigdata.btree.ITuple;
import com.bigdata.btree.ITupleIterator;
import com.bigdata.concurrent.FutureTaskInvariantMon;
import com.bigdata.ha.HAGlue;
import com.bigdata.ha.QuorumService;
import com.bigdata.ha.halog.HALogReader;
import com.bigdata.ha.halog.HALogWriter;
import com.bigdata.ha.halog.IHALogReader;
import com.bigdata.ha.halog.IHALogWriter;
import com.bigdata.ha.msg.IHAWriteMessage;
import com.bigdata.journal.CommitCounterUtility;
import com.bigdata.journal.IRootBlockView;
import com.bigdata.journal.RootBlockUtility;
import com.bigdata.journal.RootBlockView;
import com.bigdata.journal.jini.ha.HAJournal;
import com.bigdata.journal.jini.ha.HAJournalServer;
import com.bigdata.journal.jini.ha.HALogIndex;
import com.bigdata.quorum.Quorum;
import com.bigdata.striterator.Resolver;
import com.bigdata.striterator.Striterator;
import com.bigdata.util.ChecksumUtility;
import com.bigdata.util.InnerCause;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import org.apache.log4j.Logger;

public class HALogNexus
implements IHALogWriter {
    private static final Logger log = Logger.getLogger(HALogNexus.class);
    private static final Logger haLog = Logger.getLogger((String)"com.bigdata.haLog");
    private final HAJournal journal;
    private final File haLogDir;
    private final HALogWriter haLogWriter;
    private final Lock logLock = new ReentrantLock();
    volatile IHAWriteMessage lastLiveHAWriteMessage = null;
    private final AtomicInteger logAccessors = new AtomicInteger();
    private final FileFilter HALOG_FILTER_EXCLUDES_CURRENT = new FileFilter(){

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            File currentLogFile = HALogNexus.this.getHALogWriter().getFile();
            if (currentLogFile != null && f.equals(currentLogFile)) {
                return false;
            }
            return f.getName().endsWith(".ha-log");
        }
    };
    private final HALogIndex haLogIndex;
    private final long haLogPurgeTimeout;
    private final AtomicReference<Future<Void>> deleteHALogFuture = new AtomicReference();

    public HALogWriter getHALogWriter() {
        return this.haLogWriter;
    }

    public File getHALogDir() {
        return this.haLogDir;
    }

    Lock getLogLock() {
        return this.logLock;
    }

    public HALogNexus(HAJournalServer server, HAJournal journal, Configuration config) throws IOException, ConfigurationException {
        HALogIndex.IHALogRecord r;
        this.journal = journal;
        this.haLogPurgeTimeout = (Long)config.getEntry(HAJournalServer.ConfigurationOptions.COMPONENT, "HALogPurgeTimeout", Long.TYPE, (Object)0L);
        if (this.haLogPurgeTimeout < 0L) {
            throw new ConfigurationException("HALogPurgeTimeout=" + this.haLogPurgeTimeout + " : must be GTE ZERO");
        }
        File serviceDir = server.getServiceDir();
        this.haLogDir = (File)config.getEntry(HAJournalServer.ConfigurationOptions.COMPONENT, "haLogDir", File.class, (Object)new File(serviceDir, "HALog"));
        if (!this.haLogDir.exists() && !this.haLogDir.mkdirs()) {
            throw new IOException("Could not create directory: " + this.haLogDir);
        }
        this.haLogWriter = new HALogWriter(this.haLogDir, journal.isDoubleSync());
        this.haLogIndex = HALogIndex.createTransient();
        this.ensureHALogDirExists();
        HALogScanState tmp = new HALogScanState();
        this.populateIndexRecursive(this.haLogDir, IHALogReader.HALOG_FILTER, tmp);
        long commitCounterOnJournal = journal.getRootBlockView().getCommitCounter();
        if (tmp.firstBadHALogFile != null) {
            File f = tmp.firstBadHALogFile;
            long closingCommitCounter = CommitCounterUtility.parseCommitCounterFile(f.getName(), ".ha-log");
            if (commitCounterOnJournal + 1L == closingCommitCounter) {
                if (haLog.isInfoEnabled()) {
                    haLog.info((Object)("Removing bad/empty HALog file: commitCounterOnJournal=" + commitCounterOnJournal));
                }
                if (!f.delete()) {
                    log.warn((Object)("Could not remove empty HALog: " + f));
                }
            } else {
                throw new HALogException(tmp.firstBadHALogFile, tmp.firstCause);
            }
        }
        if ((r = (HALogIndex.IHALogRecord)this.haLogIndex.getNewestEntry()) != null && r.getCommitCounter() < commitCounterOnJournal) {
            throw new RuntimeException("Missing HALog(s) for committed state on journal: journal@=" + commitCounterOnJournal + ", lastHALog@" + r.getCommitCounter());
        }
    }

    private void ensureHALogDirExists() throws IOException {
        if (!this.haLogDir.exists() && !this.haLogDir.mkdirs()) {
            throw new IOException("Could not create directory: " + this.haLogDir);
        }
    }

    private void populateIndexRecursive(File f, FileFilter fileFilter, HALogScanState state) throws IOException {
        if (f.isDirectory()) {
            Object[] files = f.listFiles(fileFilter);
            Arrays.sort(files);
            for (int i = 0; i < files.length; ++i) {
                this.populateIndexRecursive((File)files[i], fileFilter, state);
            }
        } else {
            if (state.firstBadHALogFile != null) {
                throw new HALogException(state.firstBadHALogFile, state.firstCause);
            }
            try {
                this.addHALog(f);
            }
            catch (Throwable t) {
                if (InnerCause.isInnerCause(t, InterruptedException.class)) {
                    throw new RuntimeException(t);
                }
                assert (state.firstBadHALogFile == null);
                state.firstBadHALogFile = f;
                state.firstCause = t;
            }
        }
    }

    private RootBlockUtility getRootBlocksForHALog(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        byte[] b0 = new byte[340];
        byte[] b1 = new byte[340];
        if (file.length() == 0L) {
            throw new EmptyHALogException(file);
        }
        try (DataInputStream is = new DataInputStream(new FileInputStream(file));){
            int magic = is.readInt();
            if (magic != -2082883787) {
                throw new IOException("Bad journal magic: expected=-2082883787, actual=" + magic);
            }
            int version = is.readInt();
            if (version != 1) {
                throw new IOException("Bad version: expected=1, actual=" + version);
            }
            is.readFully(b0);
            is.readFully(b1);
        }
        RootBlockView rb0 = new RootBlockView(true, ByteBuffer.wrap(b0), ChecksumUtility.getCHK());
        RootBlockView rb1 = new RootBlockView(true, ByteBuffer.wrap(b1), ChecksumUtility.getCHK());
        return new RootBlockUtility(rb0, rb1);
    }

    private void addHALog(File file) throws IOException, LogicallyEmptyHALogException {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        RootBlockUtility u = this.getRootBlocksForHALog(file);
        if (u.rootBlock0.getCommitCounter() == u.rootBlock1.getCommitCounter()) {
            throw new LogicallyEmptyHALogException(file);
        }
        IRootBlockView closingRootBlock = u.chooseRootBlock();
        long sizeOnDisk = file.length();
        this.haLogIndex.add(new HALogIndex.HALogRecord(closingRootBlock, sizeOnDisk));
        long nentries = this.haLogIndex.getEntryCount();
        if (nentries % 1000L == 0L) {
            haLog.warn((Object)("Indexed " + nentries + " HALog files"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeHALog(File file) {
        IRootBlockView currentRootBlock;
        if (file == null) {
            throw new IllegalArgumentException();
        }
        try {
            currentRootBlock = this.getRootBlocksForHALog(file).chooseRootBlock();
        }
        catch (IOException ex) {
            haLog.error((Object)("Could not read root block: " + file));
            return false;
        }
        long commitTime = currentRootBlock.getLastCommitTime();
        Lock lock = this.haLogIndex.writeLock();
        lock.lock();
        try {
            HALogIndex.IHALogRecord tmp = (HALogIndex.IHALogRecord)this.haLogIndex.lookup(commitTime);
            if (tmp == null) {
                log.error((Object)("Snapshot not in index? commitTime=" + commitTime));
                boolean bl = false;
                return bl;
            }
            if (!currentRootBlock.equals(tmp.getRootBlock())) {
                log.error((Object)("Root blocks differ for index and snapshot: commitTime=" + commitTime + ", snapshot=" + currentRootBlock + ", indexRootBlock=" + tmp));
                boolean bl = false;
                return bl;
            }
            this.haLogIndex.remove(commitTime);
        }
        finally {
            lock.unlock();
        }
        return file.delete();
    }

    public Iterator<HALogIndex.IHALogRecord> getHALogs() {
        ITupleIterator itr = this.haLogIndex.rangeIterator();
        return new Striterator<ITupleIterator, HALogIndex.IHALogRecord>(itr).addFilter(new Resolver<ITupleIterator<HALogIndex.IHALogRecord>, ITuple<HALogIndex.IHALogRecord>, HALogIndex.IHALogRecord>(){
            private static final long serialVersionUID = 1L;

            @Override
            protected HALogIndex.IHALogRecord resolve(ITuple<HALogIndex.IHALogRecord> e) {
                return e.getObject();
            }
        });
    }

    public long getHALogFileBytesSinceCommitCounter(long sinceCommitCounter) {
        HALogIndex.IHALogRecord start;
        ITupleIterator titr = sinceCommitCounter == -1L ? this.haLogIndex.rangeIterator() : ((start = (HALogIndex.IHALogRecord)this.haLogIndex.findByCommitCounter(sinceCommitCounter)) == null ? this.haLogIndex.rangeIterator() : this.haLogIndex.rangeIterator(this.haLogIndex.getKey(start.getCommitTime()), null));
        long nfiles = 0L;
        long nbytes = 0L;
        while (titr.hasNext()) {
            HALogIndex.IHALogRecord r = (HALogIndex.IHALogRecord)titr.next().getObject();
            if (r.getCommitCounter() < sinceCommitCounter) continue;
            ++nfiles;
            nbytes += r.sizeOnDisk();
        }
        if (haLog.isInfoEnabled()) {
            haLog.info((Object)("sinceCommitCounter=" + sinceCommitCounter + ", files=" + nfiles + ", bytesOnDisk=" + nbytes));
        }
        return nbytes;
    }

    void addAccessor() {
        if (this.logAccessors.incrementAndGet() == 1 && log.isDebugEnabled()) {
            log.debug((Object)"Access protection added");
        }
    }

    void releaseAccessor() {
        long tmp = this.logAccessors.decrementAndGet();
        if (tmp == 0L && log.isDebugEnabled()) {
            log.debug((Object)"Access protection removed");
        }
        if (tmp < 0L) {
            throw new RuntimeException("Decremented to a negative value: " + tmp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteHALogs(long token, long earliestRetainedSnapshotCommitCounter) {
        AtomicReference<Future<Void>> atomicReference = this.deleteHALogFuture;
        synchronized (atomicReference) {
            Future<Void> f = this.deleteHALogFuture.get();
            if (f != null) {
                if (!f.isDone()) {
                    return;
                }
                try {
                    f.get();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
                catch (CancellationException e) {
                    log.warn((Object)("Cancelled: " + e));
                }
                catch (ExecutionException e) {
                    log.error((Object)e, (Throwable)e);
                }
                this.deleteHALogFuture.set(null);
            }
            Quorum<HAGlue, QuorumService<HAGlue>> quorum = this.journal.getQuorum();
            final QuorumService<HAGlue> localService = quorum.getClient();
            FutureTaskInvariantMon<Void> ft = new FutureTaskInvariantMon<Void>((Callable)new DeleteHALogsTask(token, earliestRetainedSnapshotCommitCounter), quorum){

                @Override
                protected void establishInvariants() {
                    this.assertQuorumMet();
                    this.assertJoined(localService.getServiceId());
                    this.assertMember(localService.getServiceId());
                }
            };
            this.deleteHALogFuture.set((Future<Void>)ft);
            this.journal.getExecutorService().submit(ft);
            if (this.haLogPurgeTimeout > 0L) {
                try {
                    ft.get(this.haLogPurgeTimeout, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
                catch (CancellationException e) {
                    log.warn((Object)("Cancelled: " + e));
                    return;
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e);
                }
                catch (TimeoutException e) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteAllHALogsExceptCurrent() throws IOException {
        this.logLock.lock();
        try {
            CommitCounterUtility.recursiveDelete(true, this.haLogDir, this.HALOG_FILTER_EXCLUDES_CURRENT);
            this.haLogIndex.removeAll();
            this.ensureHALogDirExists();
        }
        finally {
            this.logLock.unlock();
        }
    }

    public File getHALogFile(long closingCommitCounter) {
        return HALogWriter.getHALogFileName(this.getHALogDir(), closingCommitCounter);
    }

    public IHALogReader getReader(long commitCounter) throws FileNotFoundException, IOException {
        return this.haLogWriter.getReader(commitCounter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IHALogReader getReader(File logFile) throws IOException {
        if (logFile == null) {
            throw new IllegalArgumentException();
        }
        this.logLock.lock();
        try {
            if (this.haLogWriter.getFile().equals(logFile)) {
                long cc = this.haLogWriter.getCommitCounter() + 1L;
                IHALogReader iHALogReader = this.haLogWriter.getReader(cc);
                return iHALogReader;
            }
            HALogReader hALogReader = new HALogReader(logFile);
            return hALogReader;
        }
        finally {
            this.logLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createHALog(IRootBlockView rootBlock) throws FileNotFoundException, IOException {
        this.logLock.lock();
        try {
            this.haLogWriter.createLog(rootBlock);
        }
        finally {
            this.logLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void conditionalCreateHALog() throws FileNotFoundException, IOException {
        this.logLock.lock();
        try {
            if (!this.isHALogOpen()) {
                this.createHALog(this.journal.getRootBlockView());
            }
        }
        finally {
            this.logLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isHALogOpen() {
        this.logLock.lock();
        try {
            boolean bl = this.haLogWriter.isHALogOpen();
            return bl;
        }
        finally {
            this.logLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeHALog(IRootBlockView rootBlock) throws IOException {
        this.logLock.lock();
        try {
            long closingCommitCounter = rootBlock.getCommitCounter();
            File file = this.getHALogFile(closingCommitCounter);
            this.haLogWriter.closeHALog(rootBlock);
            boolean interrupted = false;
            while (true) {
                try {
                    this.addHALog(file);
                }
                catch (Throwable t) {
                    if (InnerCause.isInnerCause(t, InterruptedException.class)) {
                        interrupted = true;
                        continue;
                    }
                    throw new RuntimeException(t);
                }
                break;
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
        finally {
            this.logLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disableHALog() throws IOException {
        this.logLock.lock();
        try {
            this.haLogWriter.disableHALog();
        }
        finally {
            this.logLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeOnHALog(IHAWriteMessage msg, ByteBuffer data) throws IOException, IllegalStateException {
        this.logLock.lock();
        try {
            this.haLogWriter.writeOnHALog(msg, data);
        }
        finally {
            this.logLock.unlock();
        }
    }

    @Override
    public long getCommitCounter() {
        return this.haLogWriter.getCommitCounter();
    }

    @Override
    public long getSequence() {
        return this.haLogWriter.getSequence();
    }

    private class DeleteHALogsTask
    implements Callable<Void> {
        private final long token;
        private final long earliestRetainedSnapshotCommitCounter;

        DeleteHALogsTask(long token, long earliestRetainedSnapshotCommitCounter) {
            this.token = token;
            this.earliestRetainedSnapshotCommitCounter = earliestRetainedSnapshotCommitCounter;
        }

        @Override
        public Void call() throws Exception {
            long nfiles = HALogNexus.this.haLogIndex.getEntryCount();
            long ndeleted = 0L;
            long totalBytes = 0L;
            Iterator<HALogIndex.IHALogRecord> itr = HALogNexus.this.getHALogs();
            while (itr.hasNext() && HALogNexus.this.logAccessors.get() == 0) {
                boolean deleteFile;
                HALogIndex.IHALogRecord r = itr.next();
                long closingCommitCounter = r.getCommitCounter();
                boolean bl = deleteFile = closingCommitCounter < this.earliestRetainedSnapshotCommitCounter;
                if (!deleteFile || !HALogNexus.this.journal.getQuorum().isQuorumFullyMet(this.token)) break;
                File logFile = HALogNexus.this.getHALogFile(closingCommitCounter);
                HALogNexus.this.removeHALog(logFile);
                ++ndeleted;
                totalBytes += r.sizeOnDisk();
            }
            if (haLog.isInfoEnabled()) {
                haLog.info((Object)("PURGED LOGS: nfound=" + nfiles + ", ndeleted=" + ndeleted + ", totalBytes=" + totalBytes + ", earliestRetainedSnapshotCommitCounter=" + this.earliestRetainedSnapshotCommitCounter));
            }
            return null;
        }
    }

    private static class EmptyHALogException
    extends HALogException {
        private static final long serialVersionUID = 1L;

        public EmptyHALogException(File file) {
            super(file);
        }
    }

    private static class LogicallyEmptyHALogException
    extends HALogException {
        private static final long serialVersionUID = 1L;

        public LogicallyEmptyHALogException(File file) {
            super(file);
        }
    }

    private static class HALogException
    extends IOException {
        private static final long serialVersionUID = 1L;

        public HALogException(File file) {
            super(file.getAbsolutePath());
        }

        public HALogException(File file, Throwable cause) {
            super(file.getAbsolutePath(), cause);
        }
    }

    private static class HALogScanState {
        File firstBadHALogFile = null;
        Throwable firstCause = null;

        private HALogScanState() {
        }
    }
}

