/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.journal.jini.ha;

import com.bigdata.ha.halog.HALogReader;
import com.bigdata.ha.halog.HALogWriter;
import com.bigdata.ha.halog.IHALogReader;
import com.bigdata.ha.msg.IHAWriteMessage;
import com.bigdata.io.DirectBufferPool;
import com.bigdata.io.IBufferAccess;
import com.bigdata.journal.CommitCounterUtility;
import com.bigdata.journal.IHABufferStrategy;
import com.bigdata.journal.IRootBlockView;
import com.bigdata.journal.Journal;
import com.bigdata.journal.Options;
import com.bigdata.journal.jini.ha.NoSnapshotException;
import com.bigdata.journal.jini.ha.SnapshotManager;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class HARestore {
    private static final Logger haLog = Logger.getLogger((String)"com.bigdata.haLog");
    private final Journal journal;
    private final File haLogDir;

    public HARestore(Journal journal, File haLogDir) {
        if (journal == null) {
            throw new IllegalArgumentException();
        }
        if (haLogDir == null) {
            throw new IllegalArgumentException();
        }
        this.journal = journal;
        this.haLogDir = haLogDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restore(boolean listCommitPoints, long haltingCommitCounter) throws IOException, InterruptedException {
        File logFile;
        IRootBlockView initialRootBlock = this.journal.getRootBlockView();
        if (haLog.isInfoEnabled()) {
            haLog.info((Object)("JOURNAL: file=" + this.journal.getFile() + ", commitCounter=" + initialRootBlock.getCommitCounter() + ", initialRootBlock=" + initialRootBlock));
        }
        int nfound = 0;
        long totalBytes = 0L;
        IRootBlockView lastRootBlock = null;
        for (long cc = initialRootBlock.getCommitCounter(); (haltingCommitCounter == Long.MAX_VALUE || cc <= haltingCommitCounter) && (logFile = HALogWriter.getHALogFileName(this.haLogDir, cc)).exists(); ++cc) {
            try (HALogReader logReader = new HALogReader(logFile);){
                if (logReader.isEmpty()) {
                    haLog.warn((Object)("Empty HALog: commitCounter=" + cc));
                    break;
                }
                IRootBlockView lrb = logReader.getClosingRootBlock();
                if (haLog.isInfoEnabled()) {
                    haLog.info((Object)("HALog: commitCounter=" + lrb.getCommitCounter() + ", closingRootBlock=" + lrb));
                }
                HARestore.assertRootBlocksConsistent(this.journal, lrb);
                ++nfound;
                totalBytes += logFile.length();
                if (listCommitPoints) continue;
                this.applyHALog(logReader);
                this.journal.doLocalCommit(logReader.getClosingRootBlock());
                lastRootBlock = logReader.getClosingRootBlock();
                continue;
            }
        }
        if (lastRootBlock != null) {
            // empty if block
        }
        if (haLog.isInfoEnabled()) {
            haLog.info((Object)("HALogDir: nfound=" + nfound + ", totalBytes=" + totalBytes + (haltingCommitCounter == Long.MAX_VALUE ? "" : ", haltingCommitCounter=" + haltingCommitCounter)));
        }
        if (!listCommitPoints) {
            IRootBlockView finalRootBlock = this.journal.getRootBlockView();
            if (haLog.isInfoEnabled()) {
                haLog.info((Object)("JOURNAL: file=" + this.journal.getFile() + ", commitCounter=" + finalRootBlock.getCommitCounter() + ", finalRootBlock=" + finalRootBlock));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyHALog(IHALogReader r) throws IOException, InterruptedException {
        IBufferAccess buf = DirectBufferPool.INSTANCE.acquire();
        try {
            while (r.hasMoreBuffers()) {
                IHAWriteMessage msg = r.processNextBuffer(buf.buffer());
                this.writeWriteCacheBlock(msg, buf.buffer());
            }
            haLog.warn((Object)("Applied HALog: closingCommitCounter=" + r.getClosingRootBlock().getCommitCounter()));
        }
        finally {
            buf.release();
        }
    }

    private void writeWriteCacheBlock(IHAWriteMessage msg, final ByteBuffer data) throws IOException, InterruptedException {
        this.setExtent(msg);
        IBufferAccess b = new IBufferAccess(){

            @Override
            public void release(long timeout, TimeUnit unit) throws InterruptedException {
            }

            @Override
            public void release() throws InterruptedException {
            }

            @Override
            public ByteBuffer buffer() {
                return data;
            }
        };
        ((IHABufferStrategy)this.journal.getBufferStrategy()).writeRawBuffer(msg, b);
    }

    private void setExtent(IHAWriteMessage msg) throws IOException {
        try {
            ((IHABufferStrategy)this.journal.getBufferStrategy()).setExtentForLocalStore(msg.getFileExtent());
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (RuntimeException t) {
            throw new RuntimeException("msg=" + msg + ": " + t, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        String arg;
        int i;
        if (args.length == 0) {
            HARestore.usage(args);
            System.exit(1);
        }
        boolean listCommitPoints = false;
        String decompressTargetFile = null;
        long haltingCommitCounter = Long.MAX_VALUE;
        for (i = 0; i < args.length && (arg = args[i]).startsWith("-"); ++i) {
            if (arg.equals("-l")) {
                listCommitPoints = true;
                continue;
            }
            if (arg.equals("-h")) {
                haltingCommitCounter = Long.parseLong(args[++i]);
                continue;
            }
            if (arg.equals("-o")) {
                decompressTargetFile = args[++i];
                continue;
            }
            throw new RuntimeException("Unknown argument: " + arg);
        }
        if (i != args.length - 2) {
            HARestore.usage(args);
            System.exit(1);
        }
        File journalFile = new File(args[i++]);
        File haLogDir = new File(args[i++]);
        if (journalFile.isDirectory()) {
            File tmp = CommitCounterUtility.findGreatestCommitCounter(journalFile, SnapshotManager.SNAPSHOT_FILTER);
            if (tmp == null) {
                throw new NoSnapshotException("No snapshot file(s): " + journalFile);
            }
            System.out.println("Most recent snapshot: " + tmp);
            journalFile = tmp;
        }
        if (journalFile.getName().endsWith(".jnl.gz")) {
            File out;
            File in = journalFile;
            long commitCounter = SnapshotManager.parseCommitCounterFile(journalFile.getName());
            if (decompressTargetFile == null) {
                out = File.createTempFile("restored-from-snapshot-" + commitCounter + "-", ".jnl", journalFile.getAbsoluteFile().getParentFile());
            } else {
                out = new File(decompressTargetFile);
                if (out.exists()) {
                    throw new IOException("File exists: " + out);
                }
            }
            System.out.println("Decompressing " + in + " to " + out);
            SnapshotManager.decompress(in, out);
            journalFile = out;
        }
        System.out.println("Journal File: " + journalFile);
        if (!journalFile.exists()) {
            System.err.println("No such file: " + journalFile);
            System.exit(1);
        }
        if (!journalFile.isFile()) {
            System.err.println("Not a regular file: " + journalFile);
            System.exit(1);
        }
        System.out.println("Length: " + journalFile.length());
        System.out.println("Last Modified: " + new Date(journalFile.lastModified()));
        try {
            Properties properties = new Properties();
            properties.setProperty(Options.FILE, journalFile.toString());
            if (listCommitPoints) {
                properties.setProperty(Options.READ_ONLY, "true");
            }
            try (Journal journal = new Journal(properties);){
                HARestore util = new HARestore(journal, haLogDir);
                util.restore(listCommitPoints, haltingCommitCounter);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(1);
        }
    }

    private static void usage(String[] args) {
        System.err.println("usage: (-l|-h haltingCommitPoint|-o outputJournalFile) <journalFile|snapshotFile|snapshotDir> haLogDir");
    }

    private static void assertRootBlocksConsistent(Journal jnl, IRootBlockView lrb) {
        if (jnl == null) {
            throw new IllegalArgumentException();
        }
        if (lrb == null) {
            throw new IllegalArgumentException();
        }
        IRootBlockView jrb = jnl.getRootBlockView();
        if (!jrb.getUUID().equals(lrb.getUUID())) {
            throw new RuntimeException("UUID differs: journal=" + jrb + ", log=" + lrb);
        }
        if (!jrb.getStoreType().equals((Object)lrb.getStoreType())) {
            throw new RuntimeException("StoreType differs: journal=" + jrb + ", log=" + lrb);
        }
    }
}

