/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.journal.jini.ha;

import com.bigdata.btree.BTree;
import com.bigdata.btree.BytesUtil;
import com.bigdata.btree.DefaultTupleSerializer;
import com.bigdata.btree.ITuple;
import com.bigdata.btree.IndexMetadata;
import com.bigdata.btree.keys.ASCIIKeyBuilderFactory;
import com.bigdata.btree.keys.IKeyBuilderFactory;
import com.bigdata.btree.keys.KeyBuilder;
import com.bigdata.journal.AbstractCommitTimeIndex;
import com.bigdata.journal.ICommitTimeEntry;
import com.bigdata.journal.IRootBlockView;
import com.bigdata.journal.RootBlockView;
import com.bigdata.util.ChecksumUtility;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.util.UUID;

public class SnapshotIndex
extends AbstractCommitTimeIndex<ISnapshotRecord> {
    public static SnapshotIndex createTransient() {
        IndexMetadata metadata = new IndexMetadata(UUID.randomUUID());
        metadata.setTupleSerializer(new TupleSerializer(new ASCIIKeyBuilderFactory(8)));
        BTree ndx = BTree.createTransient(metadata);
        return new SnapshotIndex(ndx);
    }

    private SnapshotIndex(BTree ndx) {
        super(ndx);
    }

    protected static class TupleSerializer
    extends DefaultTupleSerializer<Long, ISnapshotRecord> {
        private static final long serialVersionUID = -2851852959439807542L;
        private static final transient byte VERSION0 = 0;
        private static final transient byte VERSION = 0;

        public TupleSerializer() {
        }

        public TupleSerializer(IKeyBuilderFactory keyBuilderFactory) {
            super(keyBuilderFactory);
        }

        @Override
        public Long deserializeKey(ITuple tuple) {
            return KeyBuilder.decodeLong(tuple.getKeyBuffer().array(), 0);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            byte version = in.readByte();
            switch (version) {
                case 0: {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown version: " + version);
                }
            }
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            out.writeByte(0);
        }
    }

    public static class SnapshotRecord
    implements ISnapshotRecord,
    Externalizable {
        private static final int VERSION0 = 0;
        private static final int currentVersion = 0;
        private IRootBlockView rootBlock;
        private long sizeOnDisk;

        public SnapshotRecord() {
        }

        public SnapshotRecord(IRootBlockView rootBlock, long sizeOnDisk) {
            if (rootBlock == null) {
                throw new IllegalArgumentException();
            }
            if (sizeOnDisk < 0L) {
                throw new IllegalArgumentException();
            }
            this.rootBlock = rootBlock;
            this.sizeOnDisk = sizeOnDisk;
        }

        @Override
        public long sizeOnDisk() {
            return this.sizeOnDisk;
        }

        @Override
        public IRootBlockView getRootBlock() {
            return this.rootBlock;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ISnapshotRecord)) {
                return false;
            }
            ISnapshotRecord t = (ISnapshotRecord)o;
            if (this.sizeOnDisk() != t.sizeOnDisk()) {
                return false;
            }
            return this.getRootBlock().equals(t.getRootBlock());
        }

        public int hashCode() {
            return this.getRootBlock().hashCode();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(0);
            byte[] a = BytesUtil.getBytes(this.rootBlock.asReadOnlyBuffer());
            int sizeOfRootBlock = a.length;
            out.writeInt(sizeOfRootBlock);
            out.write(a, 0, sizeOfRootBlock);
            out.writeLong(this.sizeOnDisk);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int version = in.readInt();
            switch (version) {
                case 0: {
                    break;
                }
                default: {
                    throw new IOException("Unknown version: " + version);
                }
            }
            int sizeOfRootBlock = in.readInt();
            byte[] a = new byte[sizeOfRootBlock];
            in.readFully(a, 0, sizeOfRootBlock);
            this.rootBlock = new RootBlockView(false, ByteBuffer.wrap(a), ChecksumUtility.getCHK());
            this.sizeOnDisk = in.readLong();
        }

        @Override
        public long getCommitCounter() {
            return this.getRootBlock().getCommitCounter();
        }

        @Override
        public long getCommitTime() {
            return this.getRootBlock().getLastCommitTime();
        }
    }

    public static interface ISnapshotRecord
    extends ICommitTimeEntry {
    }
}

