/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.journal.jini.ha;

import com.bigdata.btree.BytesUtil;
import com.bigdata.btree.ITuple;
import com.bigdata.btree.ITupleIterator;
import com.bigdata.concurrent.FutureTaskInvariantMon;
import com.bigdata.ha.HAGlue;
import com.bigdata.ha.QuorumService;
import com.bigdata.ha.msg.HASnapshotResponse;
import com.bigdata.ha.msg.IHASnapshotRequest;
import com.bigdata.ha.msg.IHASnapshotResponse;
import com.bigdata.journal.AbstractJournal;
import com.bigdata.journal.CommitCounterUtility;
import com.bigdata.journal.IRootBlockView;
import com.bigdata.journal.RootBlockUtility;
import com.bigdata.journal.RootBlockView;
import com.bigdata.journal.jini.ha.HAJournal;
import com.bigdata.journal.jini.ha.HAJournalServer;
import com.bigdata.journal.jini.ha.IRestorePolicy;
import com.bigdata.journal.jini.ha.ISnapshotPolicy;
import com.bigdata.journal.jini.ha.NoSnapshotPolicy;
import com.bigdata.journal.jini.ha.SnapshotIndex;
import com.bigdata.quorum.Quorum;
import com.bigdata.quorum.QuorumException;
import com.bigdata.service.IServiceInit;
import com.bigdata.striterator.Resolver;
import com.bigdata.striterator.Striterator;
import com.bigdata.util.ChecksumUtility;
import com.bigdata.util.concurrent.LatchedExecutor;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.security.DigestException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import org.apache.log4j.Logger;

public class SnapshotManager
implements IServiceInit<Void> {
    private static final Logger log = Logger.getLogger(SnapshotManager.class);
    private static final Logger haLog = Logger.getLogger((String)"com.bigdata.haLog");
    public static final String SNAPSHOT_EXT = ".jnl.gz";
    public static final String SNAPSHOT_TMP_PREFIX = "snapshot";
    public static final String SNAPSHOT_TMP_SUFFIX = ".tmp";
    public static final FileFilter SNAPSHOT_FILTER = new FileFilter(){

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            return f.getName().endsWith(SnapshotManager.SNAPSHOT_EXT);
        }
    };
    private static final FileFilter TEMP_FILE_FILTER = new FileFilter(){

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String name = file.getName();
            return name.startsWith(SnapshotManager.SNAPSHOT_TMP_PREFIX) && name.endsWith(SnapshotManager.SNAPSHOT_TMP_SUFFIX);
        }
    };
    private final HAJournal journal;
    private final File snapshotDir;
    private final ISnapshotPolicy snapshotPolicy;
    private final IRestorePolicy restorePolicy;
    private final int startupThreads;
    private final SnapshotIndex snapshotIndex;
    private final Lock lock = new ReentrantLock();
    private Future<IHASnapshotResponse> snapshotFuture = null;

    public ISnapshotPolicy getSnapshotPolicy() {
        return this.snapshotPolicy;
    }

    public IRestorePolicy getRestorePolicy() {
        return this.restorePolicy;
    }

    public final File getSnapshotDir() {
        return this.snapshotDir;
    }

    public SnapshotManager(HAJournalServer server, HAJournal journal, Configuration config) throws IOException, ConfigurationException {
        this.journal = journal;
        File serviceDir = server.getServiceDir();
        this.snapshotDir = (File)config.getEntry(HAJournalServer.ConfigurationOptions.COMPONENT, "snapshotDir", File.class, (Object)new File(serviceDir, SNAPSHOT_TMP_PREFIX));
        this.snapshotPolicy = (ISnapshotPolicy)config.getEntry(HAJournalServer.ConfigurationOptions.COMPONENT, "snapshotPolicy", ISnapshotPolicy.class, (Object)HAJournalServer.ConfigurationOptions.DEFAULT_SNAPSHOT_POLICY);
        this.restorePolicy = (IRestorePolicy)config.getEntry(HAJournalServer.ConfigurationOptions.COMPONENT, "restorePolicy", IRestorePolicy.class, (Object)HAJournalServer.ConfigurationOptions.DEFAULT_RESTORE_POLICY);
        this.startupThreads = (Integer)config.getEntry(HAJournalServer.ConfigurationOptions.COMPONENT, "startupThreads", Integer.TYPE, (Object)20);
        if (this.startupThreads <= 0) {
            throw new ConfigurationException("startupThreads=" + this.startupThreads + " : must be GT ZERO");
        }
        this.snapshotIndex = SnapshotIndex.createTransient();
    }

    @Override
    public Callable<Void> init() {
        return new InitTask();
    }

    private void ensureSnapshotDirExists() throws IOException {
        if (!this.snapshotDir.exists() && !this.snapshotDir.mkdirs()) {
            throw new IOException("Could not create directory: " + this.snapshotDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRootBlockView getRootBlockForSnapshot(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        byte[] b0 = new byte[340];
        byte[] b1 = new byte[340];
        try (DataInputStream is = new DataInputStream(new GZIPInputStream((InputStream)new FileInputStream(file), 688));){
            int magic = is.readInt();
            if (magic != -424361355) {
                throw new IOException("Bad journal magic: expected=-424361355, actual=" + magic);
            }
            int version = is.readInt();
            if (version != 1) {
                throw new IOException("Bad journal version: expected=1, actual=" + version);
            }
            is.readFully(b0);
            is.readFully(b1);
        }
        RootBlockView rb0 = new RootBlockView(true, ByteBuffer.wrap(b0), ChecksumUtility.getCHK());
        RootBlockView rb1 = new RootBlockView(true, ByteBuffer.wrap(b1), ChecksumUtility.getCHK());
        IRootBlockView currentRootBlock = RootBlockUtility.chooseRootBlock(rb0, rb1);
        return currentRootBlock;
    }

    private void addSnapshot(File file) throws IOException {
        this.snapshotIndex.add(this.getSnapshotRecord(file));
    }

    private SnapshotIndex.SnapshotRecord getSnapshotRecord(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        IRootBlockView currentRootBlock = SnapshotManager.getRootBlockForSnapshot(file);
        long sizeOnDisk = file.length();
        return new SnapshotIndex.SnapshotRecord(currentRootBlock, sizeOnDisk);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeSnapshot(File file) {
        IRootBlockView currentRootBlock;
        if (file == null) {
            throw new IllegalArgumentException();
        }
        try {
            currentRootBlock = SnapshotManager.getRootBlockForSnapshot(file);
        }
        catch (IOException ex) {
            haLog.error((Object)("Could not read root block: " + file));
            return false;
        }
        long commitTime = currentRootBlock.getLastCommitTime();
        Lock lock = this.snapshotIndex.writeLock();
        lock.lock();
        try {
            SnapshotIndex.ISnapshotRecord tmp = (SnapshotIndex.ISnapshotRecord)this.snapshotIndex.lookup(commitTime);
            if (tmp == null) {
                log.error((Object)("Snapshot not in index? commitTime=" + commitTime));
                boolean bl = false;
                return bl;
            }
            if (!currentRootBlock.equals(tmp.getRootBlock())) {
                log.error((Object)("Root blocks differ for index and snapshot: commitTime=" + commitTime + ", snapshot=" + currentRootBlock + ", indexRootBlock=" + tmp));
                boolean bl = false;
                return bl;
            }
            this.snapshotIndex.remove(commitTime);
        }
        finally {
            lock.unlock();
        }
        return file.delete();
    }

    public SnapshotIndex.ISnapshotRecord getOldestSnapshot() {
        return (SnapshotIndex.ISnapshotRecord)this.snapshotIndex.getOldestEntry();
    }

    public SnapshotIndex.ISnapshotRecord getNewestSnapshot() {
        return (SnapshotIndex.ISnapshotRecord)this.snapshotIndex.getNewestEntry();
    }

    public SnapshotIndex.ISnapshotRecord find(long timestamp) {
        return (SnapshotIndex.ISnapshotRecord)this.snapshotIndex.find(timestamp);
    }

    public SnapshotIndex.ISnapshotRecord findNext(long timestamp) {
        return (SnapshotIndex.ISnapshotRecord)this.snapshotIndex.findNext(timestamp);
    }

    public SnapshotIndex.ISnapshotRecord findByCommitCounter(long commitCounter) {
        return (SnapshotIndex.ISnapshotRecord)this.snapshotIndex.findByCommitCounter(commitCounter);
    }

    public SnapshotIndex.ISnapshotRecord getSnapshotByReverseIndex(int index) {
        return (SnapshotIndex.ISnapshotRecord)this.snapshotIndex.getEntryByReverseIndex(index);
    }

    public Iterator<SnapshotIndex.ISnapshotRecord> getSnapshots() {
        ITupleIterator itr = this.snapshotIndex.rangeIterator();
        return new Striterator<ITupleIterator, SnapshotIndex.ISnapshotRecord>(itr).addFilter(new Resolver<ITupleIterator<SnapshotIndex.ISnapshotRecord>, ITuple<SnapshotIndex.ISnapshotRecord>, SnapshotIndex.ISnapshotRecord>(){
            private static final long serialVersionUID = 1L;

            @Override
            protected SnapshotIndex.ISnapshotRecord resolve(ITuple<SnapshotIndex.ISnapshotRecord> e) {
                return e.getObject();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAllSnapshots() throws IOException {
        this.lock.lock();
        try {
            CommitCounterUtility.recursiveDelete(true, this.snapshotDir, SNAPSHOT_FILTER);
            this.snapshotIndex.removeAll();
            this.ensureSnapshotDirExists();
        }
        finally {
            this.lock.unlock();
        }
    }

    public long deleteSnapshots(long token, long earliestRestorableCommitPoint) {
        SnapshotIndex.ISnapshotRecord oldestSnapshot;
        long earliestRetainedSnapshotCommitCounter;
        long nbefore = this.snapshotIndex.getEntryCount();
        if (haLog.isInfoEnabled()) {
            log.info((Object)("token=" + token + ", earliestRestoreableCommitPoint=" + earliestRestorableCommitPoint + ", nsnapshots=" + nbefore));
        }
        if (nbefore == 0L) {
            return Long.MAX_VALUE;
        }
        ITupleIterator titr = this.snapshotIndex.rangeIterator();
        long ndeleted = 0L;
        long totalBytesReclaimed = 0L;
        while (titr.hasNext()) {
            SnapshotIndex.ISnapshotRecord r = (SnapshotIndex.ISnapshotRecord)titr.next().getObject();
            IRootBlockView rb = r.getRootBlock();
            long commitCounter = rb.getCommitCounter();
            boolean deleteFile = commitCounter < earliestRestorableCommitPoint;
            long len = r.sizeOnDisk();
            File file = this.getSnapshotFile(commitCounter);
            if (haLog.isInfoEnabled()) {
                log.info((Object)("snapshotFile=" + file + ", sizeOnDisk=" + len + ", deleteFile=" + deleteFile + ", commitCounter=" + commitCounter + ", earliestRestoreableCommitPoint=" + earliestRestorableCommitPoint));
            }
            if (!deleteFile || !this.journal.getQuorum().isQuorumFullyMet(token)) break;
            if (!this.removeSnapshot(file)) {
                haLog.warn((Object)("COULD NOT DELETE FILE: " + file));
                continue;
            }
            ++ndeleted;
            totalBytesReclaimed += len;
        }
        long l = earliestRetainedSnapshotCommitCounter = (oldestSnapshot = (SnapshotIndex.ISnapshotRecord)this.snapshotIndex.getOldestEntry()) == null ? 0L : oldestSnapshot.getRootBlock().getCommitCounter();
        if (haLog.isInfoEnabled()) {
            haLog.info((Object)("PURGED SNAPSHOTS: nbefore=" + nbefore + ", ndeleted=" + ndeleted + ", totalBytesReclaimed=" + totalBytesReclaimed + ", earliestRestorableCommitPoint=" + earliestRestorableCommitPoint + ", earliestRetainedSnapshotCommitCounter=" + earliestRetainedSnapshotCommitCounter));
        }
        return earliestRetainedSnapshotCommitCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<IHASnapshotResponse> getSnapshotFuture() {
        this.lock.lock();
        try {
            if (this.snapshotFuture != null) {
                if (!this.snapshotFuture.isDone()) {
                    Future<IHASnapshotResponse> future = this.snapshotFuture;
                    return future;
                }
                this.snapshotFuture = null;
            }
            Future<IHASnapshotResponse> future = this.snapshotFuture;
            return future;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<IHASnapshotResponse> takeInitialSnapshot() {
        this.lock.lock();
        try {
            if (this.getNewestSnapshot() != null) {
                Future<IHASnapshotResponse> future = null;
                return future;
            }
            if (this.snapshotPolicy instanceof NoSnapshotPolicy) {
                Future<IHASnapshotResponse> future = null;
                return future;
            }
            if (this.snapshotFuture != null) {
                if (!this.snapshotFuture.isDone()) {
                    Future<IHASnapshotResponse> future = null;
                    return future;
                }
                this.snapshotFuture = null;
            }
            this.snapshotFuture = this.takeSnapshotNow();
            Future<IHASnapshotResponse> future = this.snapshotFuture;
            return future;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<IHASnapshotResponse> takeSnapshot(IHASnapshotRequest req) {
        this.lock.lock();
        try {
            if (this.snapshotFuture != null) {
                if (!this.snapshotFuture.isDone()) {
                    Future<IHASnapshotResponse> future = this.snapshotFuture;
                    return future;
                }
                this.snapshotFuture = null;
            }
            if (req == null) {
                Future<IHASnapshotResponse> future = null;
                return future;
            }
            long token = this.journal.getQuorum().token();
            if (!this.journal.getQuorum().getClient().isJoinedMember(token)) {
                haLog.warn((Object)"Service not joined with met quorum.");
                Future<IHASnapshotResponse> future = null;
                return future;
            }
            if (!this.isReadyToSnapshot(req)) {
                Future<IHASnapshotResponse> future = null;
                return future;
            }
            this.snapshotFuture = this.takeSnapshotNow();
            Future<IHASnapshotResponse> future = this.snapshotFuture;
            return future;
        }
        finally {
            this.lock.unlock();
        }
    }

    public File getSnapshotFile(long commitCounter) {
        return SnapshotManager.getSnapshotFile(this.snapshotDir, commitCounter);
    }

    public static File getSnapshotFile(File snapshotDir, long commitCounter) {
        return CommitCounterUtility.getCommitCounterFile(snapshotDir, commitCounter, SNAPSHOT_EXT);
    }

    public static long parseCommitCounterFile(String name) throws NumberFormatException {
        return CommitCounterUtility.parseCommitCounterFile(name, SNAPSHOT_EXT);
    }

    public boolean isReadyToSnapshot(IHASnapshotRequest req) {
        boolean takeSnapshot;
        IRootBlockView snapshotRootBlock;
        if (req == null) {
            throw new IllegalArgumentException();
        }
        SnapshotIndex.ISnapshotRecord newestSnapshot = (SnapshotIndex.ISnapshotRecord)this.snapshotIndex.getNewestEntry();
        IRootBlockView iRootBlockView = snapshotRootBlock = newestSnapshot == null ? null : newestSnapshot.getRootBlock();
        if (snapshotRootBlock != null && this.journal.getRootBlockView().getCommitCounter() == snapshotRootBlock.getCommitCounter()) {
            return false;
        }
        long sinceCommitCounter = snapshotRootBlock == null ? 0L : snapshotRootBlock.getCommitCounter();
        long haLogBytesOnDisk = this.journal.getHALogNexus().getHALogFileBytesSinceCommitCounter(sinceCommitCounter);
        long journalSize = this.journal.getBufferStrategy().getExtent();
        int actualPercentLogSize = (int)(100.0 * ((double)haLogBytesOnDisk / (double)journalSize));
        int thresholdPercentLogSize = req.getPercentLogSize();
        boolean bl = takeSnapshot = actualPercentLogSize >= thresholdPercentLogSize;
        if (haLog.isInfoEnabled()) {
            haLog.info((Object)("sinceCommitCounter=" + sinceCommitCounter + ", haLogBytesOnDisk=" + haLogBytesOnDisk + ", journalSize=" + journalSize + ", thresholdPercentLogSize=" + thresholdPercentLogSize + ", percentLogSize=" + actualPercentLogSize + "%, takeSnapshot=" + takeSnapshot));
        }
        return takeSnapshot;
    }

    private Future<IHASnapshotResponse> takeSnapshotNow() {
        FutureTaskInvariantMon<IHASnapshotResponse> ft = new FutureTaskInvariantMon<IHASnapshotResponse>((Callable)new SnapshotTask(this), this.journal.getQuorum()){

            @Override
            protected void establishInvariants() {
                this.assertQuorumMet();
                this.assertJoined(SnapshotManager.this.journal.getQuorum().getClient().getServiceId());
            }
        };
        this.journal.getExecutorService().submit(ft);
        return ft;
    }

    public void getDigest(long commitCounter, MessageDigest digest) throws FileNotFoundException, IOException, DigestException {
        File file = this.getSnapshotFile(commitCounter);
        SnapshotManager.getSnapshotDigest(file, digest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getSnapshotDigest(File file, MessageDigest digest) throws FileNotFoundException, IOException, DigestException {
        try (GZIPInputStream is = new GZIPInputStream(new FileInputStream(file));){
            if (log.isInfoEnabled()) {
                log.info((Object)("Computing digest: " + file));
            }
            SnapshotManager.computeDigest(is, digest);
        }
    }

    private static void computeDigest(InputStream is, MessageDigest digest) throws DigestException, IOException {
        int bufferCapacity = 4096;
        byte[] a = new byte[4096];
        int nread;
        while ((nread = is.read(a, 0, a.length)) != -1) {
            digest.update(a, 0, nread);
        }
        return;
    }

    private static void copyStream(InputStream content, OutputStream outstr) throws IOException {
        int rdlen;
        byte[] buf = new byte[1024];
        while ((rdlen = content.read(buf)) > 0) {
            outstr.write(buf, 0, rdlen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decompress(File src, File dst) throws IOException {
        if (!src.exists()) {
            throw new FileNotFoundException(src.getAbsolutePath());
        }
        if (dst.exists() && dst.length() != 0L) {
            throw new IOException("Output file exists and is not empty: " + dst.getAbsolutePath());
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("src=" + src + ", dst=" + dst));
        }
        InputStream is = null;
        OutputStream os = null;
        try {
            is = new GZIPInputStream(new FileInputStream(src));
            os = new FileOutputStream(dst);
            SnapshotManager.copyStream(is, os);
            os.flush();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ex) {}
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    private static class SnapshotTask
    implements Callable<IHASnapshotResponse> {
        private final SnapshotManager snapshotManager;
        private final HAJournal journal;

        public SnapshotTask(SnapshotManager snapshotManager) {
            if (snapshotManager == null) {
                throw new IllegalArgumentException();
            }
            this.snapshotManager = snapshotManager;
            this.journal = snapshotManager.journal;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IHASnapshotResponse call() throws Exception {
            long token = this.journal.getQuorumToken();
            if (!this.journal.getQuorum().getClient().isJoinedMember(token)) {
                throw new QuorumException("Service not joined with met quorum");
            }
            Quorum<HAGlue, QuorumService<HAGlue>> quorum = this.journal.getQuorum();
            long txId = this.journal.newTx(-1L);
            try {
                AtomicReference<IRootBlockView> rbv = new AtomicReference<IRootBlockView>();
                AbstractJournal.ISnapshotData coreData = this.journal.snapshotAllocationData(rbv);
                File file = this.snapshotManager.getSnapshotFile(rbv.get().getCommitCounter());
                if (file.exists() && file.length() != 0L) {
                    throw new IOException("File exists: " + file);
                }
                File parentDir = file.getParentFile();
                if (!parentDir.exists() && !parentDir.mkdirs()) {
                    throw new IOException("Could not create directory: " + parentDir);
                }
                File tmp = File.createTempFile(SnapshotManager.SNAPSHOT_TMP_PREFIX, SnapshotManager.SNAPSHOT_TMP_SUFFIX, parentDir);
                FilterOutputStream os = null;
                boolean success = false;
                try {
                    os = new DataOutputStream(new GZIPOutputStream(new FileOutputStream(tmp)));
                    this.journal.getBufferStrategy().writeOnStream(os, coreData, this.journal.getQuorum(), token);
                    ((DataOutputStream)os).flush();
                    success = true;
                }
                catch (Throwable t) {
                    log.error((Object)t, t);
                    if (t instanceof Exception) {
                        throw (Exception)t;
                    }
                    throw new RuntimeException(t);
                }
                finally {
                    if (os != null) {
                        os.close();
                    }
                    if (success) {
                        if (!this.journal.getQuorum().getClient().isJoinedMember(token)) {
                            throw new QuorumException("Snapshot aborted: service not joined with met quorum.");
                        }
                        if (!tmp.renameTo(file)) {
                            log.error((Object)("Could not rename " + tmp + " as " + file));
                        } else {
                            QuorumService<HAGlue> localService;
                            this.snapshotManager.addSnapshot(file);
                            if (haLog.isInfoEnabled()) {
                                haLog.info((Object)("Captured snapshot: " + file + ", commitCounter=" + rbv.get().getCommitCounter() + ", length=" + file.length()));
                            }
                            if (quorum != null && (localService = quorum.getClient()) != null) {
                                localService.purgeHALogs(token);
                            }
                        }
                    } else if (!tmp.delete()) {
                        log.warn((Object)("Could not delete temporary file: " + tmp));
                    }
                }
                HASnapshotResponse hASnapshotResponse = new HASnapshotResponse(rbv.get());
                return hASnapshotResponse;
            }
            finally {
                this.journal.abort(txId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IHASnapshotResponse call2() throws Exception {
            long token = this.journal.getQuorumToken();
            if (!this.journal.getQuorum().getClient().isJoinedMember(token)) {
                throw new QuorumException("Service not joined with met quorum");
            }
            Quorum<HAGlue, QuorumService<HAGlue>> quorum = this.journal.getQuorum();
            long txId = this.journal.newTx(-1L);
            IRootBlockView[] rootBlocks = this.journal.getRootBlocks();
            IRootBlockView currentRootBlock = RootBlockUtility.chooseRootBlock(rootBlocks[0], rootBlocks[1]);
            File file = this.snapshotManager.getSnapshotFile(currentRootBlock.getCommitCounter());
            if (file.exists() && file.length() != 0L) {
                throw new IOException("File exists: " + file);
            }
            File parentDir = file.getParentFile();
            if (!parentDir.exists() && !parentDir.mkdirs()) {
                throw new IOException("Could not create directory: " + parentDir);
            }
            File tmp = File.createTempFile(SnapshotManager.SNAPSHOT_TMP_PREFIX, SnapshotManager.SNAPSHOT_TMP_SUFFIX, parentDir);
            DataOutputStream os = null;
            boolean success = false;
            try {
                os = new DataOutputStream(new GZIPOutputStream(new FileOutputStream(tmp)));
                os.writeInt(-424361355);
                os.writeInt(1);
                os.write(BytesUtil.toArray(rootBlocks[0].asReadOnlyBuffer()));
                os.write(BytesUtil.toArray(rootBlocks[1].asReadOnlyBuffer()));
                this.journal.getBufferStrategy().writeOnStream(os, null, this.journal.getQuorum(), token);
                os.flush();
                success = true;
            }
            catch (Throwable t) {
                log.error((Object)t, t);
                if (t instanceof Exception) {
                    throw (Exception)t;
                }
                throw new RuntimeException(t);
            }
            finally {
                this.journal.abort(txId);
                if (os != null) {
                    os.close();
                }
                if (success) {
                    if (!this.journal.getQuorum().getClient().isJoinedMember(token)) {
                        throw new QuorumException("Snapshot aborted: service not joined with met quorum.");
                    }
                    if (!tmp.renameTo(file)) {
                        log.error((Object)("Could not rename " + tmp + " as " + file));
                    } else {
                        QuorumService<HAGlue> localService;
                        this.snapshotManager.addSnapshot(file);
                        if (haLog.isInfoEnabled()) {
                            haLog.info((Object)("Captured snapshot: " + file + ", commitCounter=" + currentRootBlock.getCommitCounter() + ", length=" + file.length()));
                        }
                        if (quorum != null && (localService = quorum.getClient()) != null) {
                            localService.purgeHALogs(token);
                        }
                    }
                } else if (!tmp.delete()) {
                    log.warn((Object)("Could not delete temporary file: " + tmp));
                }
            }
            return new HASnapshotResponse(currentRootBlock);
        }
    }

    private class InitTask
    implements Callable<Void> {
        private InitTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            SnapshotManager.this.lock.lock();
            try {
                this.doRunWithLock();
                Void void_ = null;
                return void_;
            }
            finally {
                SnapshotManager.this.lock.unlock();
            }
        }

        private void doRunWithLock() throws IOException, InterruptedException, ExecutionException {
            if (log.isInfoEnabled()) {
                log.info((Object)"Starting cleanup.");
            }
            CommitCounterUtility.recursiveDelete(false, SnapshotManager.this.getSnapshotDir(), TEMP_FILE_FILTER);
            SnapshotManager.this.ensureSnapshotDirExists();
            if (log.isInfoEnabled()) {
                log.info((Object)"Starting scan.");
            }
            LatchedExecutor executor = new LatchedExecutor(SnapshotManager.this.journal.getExecutorService(), SnapshotManager.this.startupThreads);
            this.populateIndexRecursive(executor, SnapshotManager.this.getSnapshotDir(), SNAPSHOT_FILTER, 0);
            if (log.isInfoEnabled()) {
                log.info((Object)"Starting policy.");
            }
            SnapshotManager.this.snapshotPolicy.init(SnapshotManager.this.journal);
            if (log.isInfoEnabled()) {
                log.info((Object)"Done.");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private void populateIndexRecursive(LatchedExecutor executor, File f, FileFilter fileFilter, int depth) throws IOException, InterruptedException, ExecutionException {
            if (depth == CommitCounterUtility.getLeafDirectoryDepth()) {
                Future<SnapshotIndex.SnapshotRecord> ft;
                File[] children = f.listFiles(fileFilter);
                ArrayList<FutureTask<SnapshotIndex.SnapshotRecord>> futures = new ArrayList<FutureTask<SnapshotIndex.SnapshotRecord>>(children.length);
                for (int i = 0; i < children.length; ++i) {
                    final File file = children[i];
                    ft = new FutureTask<SnapshotIndex.SnapshotRecord>(new Callable<SnapshotIndex.SnapshotRecord>(){

                        @Override
                        public SnapshotIndex.SnapshotRecord call() throws Exception {
                            return SnapshotManager.this.getSnapshotRecord(file);
                        }
                    });
                    futures.add((FutureTask<SnapshotIndex.SnapshotRecord>)ft);
                }
                try {
                    void var8_16;
                    for (FutureTask futureTask : futures) {
                        executor.execute(futureTask);
                    }
                    ArrayList<SnapshotIndex.SnapshotRecord> records = new ArrayList<SnapshotIndex.SnapshotRecord>(children.length);
                    boolean bl = false;
                    while (var8_16 < children.length) {
                        ft = (Future)futures.get((int)var8_16);
                        SnapshotIndex.SnapshotRecord r = ft.get();
                        records.add(r);
                        ++var8_16;
                    }
                    for (SnapshotIndex.SnapshotRecord r : records) {
                        SnapshotManager.this.snapshotIndex.add(r);
                        long nentries = SnapshotManager.this.snapshotIndex.getEntryCount();
                        if (nentries % 1000L != 0L) continue;
                        haLog.warn((Object)("Indexed " + nentries + " snapshot files"));
                    }
                }
                finally {
                    for (Future future : futures) {
                        future.cancel(true);
                    }
                }
            } else if (f.isDirectory()) {
                File[] children = f.listFiles(fileFilter);
                for (int i = 0; i < children.length; ++i) {
                    File child = children[i];
                    this.populateIndexRecursive(executor, child, fileFilter, depth + 1);
                }
            } else {
                log.warn((Object)("Ignoring file in non-leaf directory: " + f));
            }
        }
    }
}

