/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.mdi;

import com.bigdata.btree.AbstractBTree;
import com.bigdata.btree.DelegateIndex;
import com.bigdata.btree.ITupleIterator;
import com.bigdata.btree.IndexMetadata;
import com.bigdata.btree.Tuple;
import com.bigdata.cache.LRUCache;
import com.bigdata.mdi.IMetadataIndex;
import com.bigdata.mdi.MetadataIndex;
import com.bigdata.mdi.PartitionLocator;
import org.apache.log4j.Logger;

public class MetadataIndexView
extends DelegateIndex
implements IMetadataIndex {
    protected static final Logger log = Logger.getLogger(MetadataIndexView.class);
    private final AbstractBTree delegate;
    private final boolean readOnly;
    private LRUCache<Integer, PartitionLocator> locatorCache = new LRUCache(1000);

    public MetadataIndexView(AbstractBTree delegate) {
        super(delegate);
        this.delegate = delegate;
        this.readOnly = delegate.isReadOnly();
    }

    @Override
    public MetadataIndex.MetadataIndexMetadata getIndexMetadata() {
        return (MetadataIndex.MetadataIndexMetadata)super.getIndexMetadata();
    }

    @Override
    public IndexMetadata getScaleOutIndexMetadata() {
        return this.getIndexMetadata().getManagedIndexMetadata();
    }

    @Override
    public PartitionLocator get(byte[] key) {
        return (PartitionLocator)this.delegate.lookup((Object)key);
    }

    @Override
    public PartitionLocator find(byte[] key) {
        return this.find_with_indexOf(key);
    }

    private PartitionLocator find_with_iterator(byte[] key) {
        ITupleIterator itr = this.delegate.rangeIterator(null, key, 1, 66, null);
        if (!itr.hasNext()) {
            log.warn((Object)("No index partitions defined? name=" + this.getIndexMetadata().getName()));
            return null;
        }
        return (PartitionLocator)itr.next().getObject();
    }

    private PartitionLocator find_with_indexOf(byte[] key) {
        long index = key == null ? this.delegate.getEntryCount() - 1L : this.findIndexOf(key);
        if (index == -1L) {
            return null;
        }
        if (this.readOnly && index < Integer.MAX_VALUE) {
            return this.getAndCacheLocatorAtIndex((int)index);
        }
        return this.getLocatorAtIndex(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PartitionLocator getAndCacheLocatorAtIndex(int index) {
        Integer key = index;
        LRUCache<Integer, PartitionLocator> lRUCache = this.locatorCache;
        synchronized (lRUCache) {
            PartitionLocator locator = this.locatorCache.get(key);
            if (locator == null) {
                locator = this.getLocatorAtIndex(index);
                this.locatorCache.put(key, locator, false);
            }
            return locator;
        }
    }

    @Override
    public void staleLocator(PartitionLocator locator) {
        this.locatorCache.remove(locator.getPartitionId());
    }

    private PartitionLocator getLocatorAtIndex(long index) {
        Tuple tuple = this.delegate.valueAt(index, this.delegate.getLookupTuple());
        return (PartitionLocator)tuple.getObject();
    }

    private long findIndexOf(byte[] key) {
        long pos = this.delegate.indexOf(key);
        if (pos < 0L) {
            if ((pos = -(pos + 1L)) == 0L) {
                if (this.delegate.getEntryCount() != 0L) {
                    throw new IllegalStateException("Partition not defined for empty key.");
                }
                return -1L;
            }
            return --pos;
        }
        return pos;
    }
}

