/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.mdi;

import com.bigdata.btree.BytesUtil;
import com.bigdata.io.LongPacker;
import com.bigdata.io.ShortPacker;
import com.bigdata.mdi.IPartitionMetadata;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.UUID;

public class PartitionLocator
implements IPartitionMetadata,
Externalizable {
    private static final long serialVersionUID = 5234405541356126104L;
    private int partitionId;
    private UUID dataServiceUUID;
    private byte[] leftSeparatorKey;
    private byte[] rightSeparatorKey;
    private static final transient short VERSION0 = 0;
    private static final transient short VERSION1 = 0;
    private static final transient short VERSION = 0;

    public PartitionLocator() {
    }

    public PartitionLocator(int partitionId, UUID logicalDataServiceUUID, byte[] leftSeparatorKey, byte[] rightSeparatorKey) {
        if (logicalDataServiceUUID == null) {
            throw new IllegalArgumentException();
        }
        if (leftSeparatorKey == null) {
            throw new IllegalArgumentException();
        }
        if (rightSeparatorKey != null && BytesUtil.compareBytes(leftSeparatorKey, rightSeparatorKey) >= 0) {
            throw new IllegalArgumentException("Separator keys are out of order: left=" + BytesUtil.toString(leftSeparatorKey) + ", right=" + BytesUtil.toString(rightSeparatorKey));
        }
        this.partitionId = partitionId;
        this.dataServiceUUID = logicalDataServiceUUID;
        this.leftSeparatorKey = leftSeparatorKey;
        this.rightSeparatorKey = rightSeparatorKey;
    }

    @Override
    public final int getPartitionId() {
        return this.partitionId;
    }

    public UUID getDataServiceUUID() {
        return this.dataServiceUUID;
    }

    @Override
    public final byte[] getLeftSeparatorKey() {
        return this.leftSeparatorKey;
    }

    @Override
    public final byte[] getRightSeparatorKey() {
        return this.rightSeparatorKey;
    }

    @Override
    public final int hashCode() {
        return this.partitionId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        PartitionLocator o2 = (PartitionLocator)o;
        if (this.partitionId != o2.partitionId) {
            return false;
        }
        if (!this.dataServiceUUID.equals(o2.dataServiceUUID)) {
            return false;
        }
        if (!BytesUtil.bytesEqual(this.leftSeparatorKey, o2.leftSeparatorKey)) {
            return false;
        }
        if (this.rightSeparatorKey == null && o2.rightSeparatorKey != null) {
            return false;
        }
        return BytesUtil.bytesEqual(this.rightSeparatorKey, o2.rightSeparatorKey);
    }

    public String toString() {
        return "{ partitionId=" + this.partitionId + ", dataServiceUUID=" + this.dataServiceUUID + ", leftSeparator=" + BytesUtil.toString(this.leftSeparatorKey) + ", rightSeparator=" + (this.rightSeparatorKey == null ? null : BytesUtil.toString(this.rightSeparatorKey)) + "}";
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        short version = ShortPacker.unpackShort(in);
        if (version != 0 && version != 0) {
            throw new IOException("Unknown version: " + version);
        }
        this.partitionId = version < 0 ? (int)LongPacker.unpackLong(in) : in.readInt();
        this.dataServiceUUID = new UUID(in.readLong(), in.readLong());
        int leftLen = (int)LongPacker.unpackLong(in);
        int rightLen = (int)LongPacker.unpackLong(in);
        this.leftSeparatorKey = new byte[leftLen];
        in.readFully(this.leftSeparatorKey);
        if (rightLen != 0) {
            this.rightSeparatorKey = new byte[rightLen];
            in.readFully(this.rightSeparatorKey);
        } else {
            this.rightSeparatorKey = null;
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        ShortPacker.packShort(out, (short)0);
        out.writeInt(this.partitionId);
        out.writeLong(this.dataServiceUUID.getMostSignificantBits());
        out.writeLong(this.dataServiceUUID.getLeastSignificantBits());
        LongPacker.packLong(out, (long)this.leftSeparatorKey.length);
        LongPacker.packLong(out, this.rightSeparatorKey == null ? 0L : (long)this.rightSeparatorKey.length);
        out.write(this.leftSeparatorKey);
        if (this.rightSeparatorKey != null) {
            out.write(this.rightSeparatorKey);
        }
    }
}

