/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.quorum.zk;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.UUID;

public class QuorumServiceState
implements Externalizable {
    private static final long serialVersionUID = 1L;
    protected static final byte VERSION0 = 0;
    private UUID serviceUUID;

    public String toString() {
        return this.getClass().getName() + "{serviceUUID=" + this.serviceUUID() + "}";
    }

    public QuorumServiceState() {
    }

    public QuorumServiceState(UUID serviceUUID) {
        if (serviceUUID == null) {
            throw new IllegalArgumentException();
        }
        this.serviceUUID = serviceUUID;
    }

    public UUID serviceUUID() {
        return this.serviceUUID;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte version = in.readByte();
        switch (version) {
            case 0: {
                this.serviceUUID = new UUID(in.readLong(), in.readLong());
                break;
            }
            default: {
                throw new IOException("Unknown version: " + version);
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.write(0);
        out.writeLong(this.serviceUUID.getMostSignificantBits());
        out.writeLong(this.serviceUUID.getLeastSignificantBits());
    }
}

