/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.quorum.zk;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class QuorumTokenState
implements Externalizable {
    private static final long serialVersionUID = 1L;
    protected static final byte VERSION0 = 0;
    protected static final byte VERSION1 = 1;
    protected static final byte currentVersion = 1;
    private long lastValidToken;
    private long currentToken;
    private int replicationFactor;

    public String toString() {
        return this.getClass().getName() + "{lastValidToken=" + this.lastValidToken + ",currentToken=" + this.currentToken + ",replicationFactor=" + this.replicationFactor + "}";
    }

    public QuorumTokenState() {
    }

    public QuorumTokenState(long lastValidToken, long currentToken, int replicationFactor) {
        this.lastValidToken = lastValidToken;
        this.currentToken = currentToken;
        this.replicationFactor = replicationFactor;
        if (currentToken != -1L && lastValidToken != currentToken) {
            throw new IllegalArgumentException();
        }
        if (replicationFactor < 1) {
            throw new IllegalArgumentException();
        }
        if (replicationFactor % 2 == 0) {
            throw new IllegalArgumentException("replicationFactor must be odd: " + replicationFactor);
        }
    }

    public final long lastValidToken() {
        return this.lastValidToken;
    }

    public final long token() {
        return this.currentToken;
    }

    public final int replicationFactor() {
        return this.replicationFactor;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte version = in.readByte();
        switch (version) {
            case 0: {
                this.lastValidToken = in.readLong();
                this.currentToken = in.readLong();
                this.replicationFactor = 0;
                break;
            }
            case 1: {
                this.lastValidToken = in.readLong();
                this.currentToken = in.readLong();
                this.replicationFactor = in.readInt();
                break;
            }
            default: {
                throw new IOException("Unknown version: " + version);
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.write(1);
        out.writeLong(this.lastValidToken);
        out.writeLong(this.currentToken);
        out.writeInt(this.replicationFactor);
    }
}

