/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.quorum.zk;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

class UnorderedSetDifference<T extends Comparable<T>> {
    private final List<T> added = new LinkedList<T>();
    private final List<T> removed = new LinkedList<T>();

    public List<T> added() {
        return Collections.unmodifiableList(this.added);
    }

    public List<T> removed() {
        return Collections.unmodifiableList(this.removed);
    }

    public UnorderedSetDifference(T[] aold, T[] anew) {
        T t;
        boolean found;
        int i;
        Arrays.sort(aold);
        Arrays.sort(anew);
        for (i = 0; i < aold.length; ++i) {
            found = false;
            t = aold[i];
            for (T u : anew) {
                if (!t.equals(u)) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.removed.add(t);
        }
        for (i = 0; i < anew.length; ++i) {
            found = false;
            t = anew[i];
            for (T u : aold) {
                if (!t.equals(u)) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.added.add(t);
        }
    }

    public String toString() {
        return this.getClass().getName() + "{removed=" + this.removed + ",added=" + this.added + "}";
    }
}

