/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.quorum.zk;

import com.bigdata.ha.HAPipelineGlue;
import com.bigdata.io.SerializerUtil;
import com.bigdata.quorum.AbstractQuorum;
import com.bigdata.quorum.QuorumEventEnum;
import com.bigdata.quorum.QuorumException;
import com.bigdata.quorum.zk.OrderedSetDifference;
import com.bigdata.quorum.zk.QuorumPipelineState;
import com.bigdata.quorum.zk.QuorumServiceState;
import com.bigdata.quorum.zk.QuorumTokenState;
import com.bigdata.quorum.zk.UnorderedSetDifference;
import com.bigdata.quorum.zk.ZKQuorum;
import com.bigdata.quorum.zk.ZKQuorumClient;
import com.bigdata.quorum.zk.ZKQuorumImpl;
import com.bigdata.util.InnerCause;
import com.bigdata.util.concurrent.DaemonThreadFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.rmi.Remote;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;

public class ZKQuorumImpl<S extends Remote, C extends ZKQuorumClient<S>>
extends AbstractQuorum<S, C>
implements ZKQuorum<S, C> {
    public List<ACL> getZookeeperACL() {
        return ((ZKQuorumClient)this.getClientNoLock()).getACL();
    }

    public ZooKeeper getZookeeper() throws InterruptedException {
        return ((ZKQuorumClient)this.getClientNoLock()).getZooKeeper();
    }

    public ZKQuorumImpl(int k) {
        super(k);
    }

    @Override
    protected AbstractQuorum.QuorumActorBase newActor(String logicalServiceId, UUID serviceId) {
        return new ZkQuorumActor(logicalServiceId, serviceId);
    }

    @Override
    protected AbstractQuorum.QuorumWatcherBase newWatcher(String logicalServiceId) {
        return new ZkQuorumWatcher(logicalServiceId);
    }

    @Override
    protected long getLastValidTokenFromQuorumState(C client) {
        String logicalServiceZPath = client.getLogicalServiceZPath();
        String quorumZPath = logicalServiceZPath + "/" + "quorum";
        try {
            QuorumTokenState tokenState;
            while (true) {
                Stat stat = new Stat();
                byte[] data = this.getZookeeper().getData(quorumZPath, false, stat);
                tokenState = (QuorumTokenState)SerializerUtil.deserialize(data);
                if (log.isInfoEnabled()) {
                    log.info((Object)("Starting with quorum that has already met in the past: " + tokenState));
                }
                if (tokenState.replicationFactor() != 0 && tokenState.replicationFactor() == this.replicationFactor()) break;
                if (tokenState.token() != -1L) {
                    throw new QuorumException("Can not change replication factor of a met quorum: newValue=" + this.replicationFactor() + ", oldValue=" + tokenState.replicationFactor());
                }
                try {
                    this.updateQuorumStateWithReplicationFactor(client, quorumZPath, tokenState, stat);
                }
                catch (KeeperException.BadVersionException e) {
                    log.warn((Object)("Concurrent update (retry): zpath=" + quorumZPath));
                    continue;
                }
                break;
            }
            return tokenState.lastValidToken();
        }
        catch (KeeperException.NoNodeException e) {
            return -1L;
        }
        catch (KeeperException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private void updateQuorumStateWithReplicationFactor(C client, String quorumZPath, QuorumTokenState oldState, Stat stat) throws KeeperException.BadVersionException {
        QuorumTokenState newState = new QuorumTokenState(oldState.lastValidToken(), oldState.token(), this.replicationFactor());
        try {
            this.getZookeeper().setData(quorumZPath, SerializerUtil.serialize(newState), stat.getVersion());
            log.warn((Object)("Set replicationFactor: zpath=" + quorumZPath + ", newState=" + newState));
            return;
        }
        catch (KeeperException.BadVersionException ex) {
            throw ex;
        }
        catch (KeeperException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
    }

    public static void setupQuorum(String logicalServiceZPath, int replicationFactor, ZooKeeper zk, List<ACL> acl) throws KeeperException, InterruptedException {
        try {
            QuorumTokenState tokenState = new QuorumTokenState(-1L, -1L, replicationFactor);
            zk.create(logicalServiceZPath + "/" + "quorum", SerializerUtil.serialize(tokenState), acl, CreateMode.PERSISTENT);
        }
        catch (KeeperException.NodeExistsException ex) {
            // empty catch block
        }
        try {
            zk.create(logicalServiceZPath + "/" + "quorum" + "/" + "member", new byte[0], acl, CreateMode.PERSISTENT);
        }
        catch (KeeperException.NodeExistsException ex) {
            // empty catch block
        }
        try {
            zk.create(logicalServiceZPath + "/" + "quorum" + "/" + "votes", new byte[0], acl, CreateMode.PERSISTENT);
        }
        catch (KeeperException.NodeExistsException ex) {
            // empty catch block
        }
        try {
            zk.create(logicalServiceZPath + "/" + "quorum" + "/" + "joined", new byte[0], acl, CreateMode.PERSISTENT);
        }
        catch (KeeperException.NodeExistsException ex) {
            // empty catch block
        }
        try {
            zk.create(logicalServiceZPath + "/" + "quorum" + "/" + "pipeline", new byte[0], acl, CreateMode.PERSISTENT);
        }
        catch (KeeperException.NodeExistsException ex) {
            // empty catch block
        }
    }

    private static class VoteComparator
    implements Comparator<String> {
        static final VoteComparator INSTANCE = new VoteComparator();

        private VoteComparator() {
        }

        @Override
        public int compare(String arg0, String arg1) {
            long v1;
            long v0 = Long.parseLong(arg0);
            if (v0 < (v1 = Long.parseLong(arg1))) {
                return -1;
            }
            if (v0 > v1) {
                return 1;
            }
            return 0;
        }
    }

    protected class ZkQuorumWatcher
    extends AbstractQuorum.QuorumWatcherBase {
        private final AtomicReference<ExecutorService> watcherServiceRef;

        protected ZkQuorumWatcher(String logicalServiceZPath) {
            super(logicalServiceZPath);
            this.watcherServiceRef = new AtomicReference();
        }

        @Override
        protected void start() {
            super.start();
            this.watcherServiceRef.set(Executors.newSingleThreadExecutor(new DaemonThreadFactory(this.getClass().getName())));
            try {
                ZKQuorumImpl.setupQuorum(this.logicalServiceId, ZKQuorumImpl.this.replicationFactor(), ZKQuorumImpl.this.getZookeeper(), ZKQuorumImpl.this.getZookeeperACL());
                this.setupWatchers(ZKQuorumImpl.this.getZookeeper());
            }
            catch (KeeperException e) {
                throw new QuorumException(e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
        }

        @Override
        protected void terminate() {
            ExecutorService watcherService = this.watcherServiceRef.get();
            if (watcherService != null) {
                List<Runnable> notrun = watcherService.shutdownNow();
                for (Runnable r : notrun) {
                    if (!(r instanceof Future)) continue;
                    ((Future)((Object)r)).cancel(true);
                }
                this.watcherServiceRef.set(null);
            }
            super.terminate();
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        protected void accept(InternalQuorumWatcher watcher, WatchedEvent e, boolean synchronous) {
            HandleEventRunnable r = new HandleEventRunnable(this, watcher, e);
            if (synchronous) {
                r.run();
                return;
            }
            ExecutorService watcherService = this.watcherServiceRef.get();
            if (watcherService != null) {
                watcherService.execute(r);
            }
        }

        private void handleExpired() {
            log.error((Object)("ZOOKEEPER SESSION EXPIRED: token=" + ZKQuorumImpl.this.token()));
            this.doNotifyClientDisconnected();
        }

        private void handleDisconnected() {
            log.warn((Object)("ZOOKEEPER CLIENT DISCONNECTED: token=" + ZKQuorumImpl.this.token()));
        }

        private void doNotifyClientDisconnected() {
            log.warn((Object)("ZOOKEEPER DISCONNECT NOTIFY: token=" + ZKQuorumImpl.this.token()));
            Object client = ZKQuorumImpl.this.getClient();
            if (client != null) {
                try {
                    client.disconnected();
                }
                catch (Exception t) {
                    ZKQuorumImpl.this.launderThrowable(t);
                }
            }
            ZKQuorumImpl.this.sendEvent(new AbstractQuorum.E(QuorumEventEnum.QUORUM_DISCONNECTED, ZKQuorumImpl.this.lastValidToken(), ZKQuorumImpl.this.token(), null));
        }

        private void setupWatchers(ZooKeeper zk) throws KeeperException, InterruptedException {
            QuorumTokenState tmp;
            Stat stat = new Stat();
            try {
                byte[] data = ZKQuorumImpl.this.getZookeeper().getData(this.logicalServiceId + "/" + "quorum", false, stat);
                tmp = (QuorumTokenState)SerializerUtil.deserialize(data);
            }
            catch (KeeperException.NoNodeException e) {
                tmp = null;
            }
            catch (KeeperException e) {
                throw new RuntimeException(e);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            QuorumTokenState tokenState = tmp;
            new QuorumMemberWatcher(this.logicalServiceId + "/" + "quorum" + "/" + "member").start();
            new QuorumPipelineWatcher(this.logicalServiceId + "/" + "quorum" + "/" + "pipeline").start();
            new QuorumLastCommitTimesWatcher(this.logicalServiceId + "/" + "quorum" + "/" + "votes").start();
            new QuorumJoinedWatcher(this.logicalServiceId + "/" + "quorum" + "/" + "joined").start();
            new QuorumTokenStateWatcher(this.logicalServiceId + "/" + "quorum").start();
            if (tokenState != null) {
                this.conditionalClearQuorumToken(tokenState, stat);
            }
        }

        private void conditionalClearQuorumToken(QuorumTokenState tokenState, Stat stat) {
            if (tokenState == null) {
                throw new IllegalArgumentException();
            }
            if (stat == null) {
                throw new IllegalArgumentException();
            }
            try {
                UUID[] joined = ZKQuorumImpl.this.getJoined();
                if (tokenState.token() != -1L && !ZKQuorumImpl.this.isQuorum(joined.length)) {
                    try {
                        QuorumTokenState tmp = new QuorumTokenState(tokenState.lastValidToken(), -1L, ZKQuorumImpl.this.replicationFactor());
                        ZKQuorumImpl.this.getZookeeper().setData(this.logicalServiceId + "/" + "quorum", SerializerUtil.serialize(tmp), stat.getVersion());
                    }
                    catch (KeeperException.BadVersionException ex) {
                        if (log.isInfoEnabled()) {
                            log.info((Object)("Version no longer current: " + (Object)((Object)ex)));
                        }
                    }
                }
            }
            catch (KeeperException e) {
                throw new RuntimeException(e);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        /*
         * Signature claims super is com.bigdata.quorum.zk.ZKQuorumImpl$ZkQuorumWatcher.AbstractSetQuorumWatcher, not com.bigdata.quorum.zk.ZKQuorumImpl$ZkQuorumWatcher$AbstractSetQuorumWatcher - discarding signature.
         */
        private class QuorumVotesWatcher
        extends AbstractSetQuorumWatcher {
            private final Long lastCommitTime;

            QuorumVotesWatcher(String zpath, Long lastCommitTime) {
                super(zpath);
                if (lastCommitTime == null) {
                    throw new IllegalArgumentException();
                }
                this.lastCommitTime = lastCommitTime;
            }

            @Override
            protected void handleEvent(ZooKeeper zk) throws KeeperException, InterruptedException {
                Object[] children;
                try {
                    children = zk.getChildren(this.zpath, (Watcher)this).toArray(new String[0]);
                }
                catch (KeeperException.NoNodeException ex) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)("No votes remain: lastCommitTime=" + this.lastCommitTime + ", zpath=" + this.zpath));
                    }
                    return;
                }
                Arrays.sort(children);
                Map<Long, UUID[]> votes = ZKQuorumImpl.this.getVotes();
                UUID[] aold = votes.containsKey(this.lastCommitTime) ? votes.get(this.lastCommitTime) : new UUID[]{};
                LinkedList<UUID> tmp = new LinkedList<UUID>();
                for (Object s : children) {
                    try {
                        QuorumServiceState state = (QuorumServiceState)SerializerUtil.deserialize(zk.getData(this.zpath + "/" + (String)s, false, null));
                        tmp.add(state.serviceUUID());
                    }
                    catch (KeeperException.NoNodeException ex) {
                        // empty catch block
                    }
                }
                UUID[] anew = tmp.toArray(new UUID[0]);
                this.applyOrderedSetSemantics(aold, anew);
            }

            @Override
            protected void add(UUID serviceId) {
                ZkQuorumWatcher.this.castVote(serviceId, this.lastCommitTime);
            }

            @Override
            protected void remove(UUID serviceId) {
                ZkQuorumWatcher.this.withdrawVote(serviceId);
            }
        }

        /*
         * Signature claims super is com.bigdata.quorum.zk.ZKQuorumImpl$ZkQuorumWatcher.InternalQuorumWatcher, not com.bigdata.quorum.zk.ZKQuorumImpl$ZkQuorumWatcher$InternalQuorumWatcher - discarding signature.
         */
        private class QuorumLastCommitTimesWatcher
        extends InternalQuorumWatcher {
            QuorumLastCommitTimesWatcher(String zpath) {
                super(zpath);
            }

            @Override
            public void start() {
                Long[] lastCommitTimes;
                ZkQuorumWatcher.this.accept(this, new WatchedEvent(Watcher.Event.EventType.NodeChildrenChanged, Watcher.Event.KeeperState.SyncConnected, this.zpath), true);
                for (Long lastCommitTime : lastCommitTimes = ZKQuorumImpl.this.getVotes().keySet().toArray(new Long[0])) {
                    new QuorumVotesWatcher(this.zpath + "/" + lastCommitTime, lastCommitTime).start();
                }
            }

            @Override
            protected void handleEvent(ZooKeeper zk) throws KeeperException, InterruptedException {
                String[] children = zk.getChildren(this.zpath, (Watcher)this).toArray(new String[0]);
                Map<Long, UUID[]> votes = ZKQuorumImpl.this.getVotes();
                Comparable[] aold = votes.keySet().toArray(new Long[0]);
                Comparable[] anew = new Long[children.length];
                int i = 0;
                for (String s : children) {
                    anew[i++] = Long.valueOf(s);
                }
                UnorderedSetDifference diff = new UnorderedSetDifference(aold, anew);
                for (Long t : diff.removed()) {
                    UUID[] a;
                    for (UUID x : a = votes.get(t)) {
                        ZkQuorumWatcher.this.withdrawVote(x);
                    }
                }
                for (Long t : diff.added()) {
                    new QuorumVotesWatcher(this.zpath + "/" + t, t).start();
                }
            }
        }

        /*
         * Signature claims super is com.bigdata.quorum.zk.ZKQuorumImpl$ZkQuorumWatcher.InternalQuorumWatcher, not com.bigdata.quorum.zk.ZKQuorumImpl$ZkQuorumWatcher$InternalQuorumWatcher - discarding signature.
         */
        private class QuorumTokenStateWatcher
        extends InternalQuorumWatcher {
            protected QuorumTokenStateWatcher(String zpath) {
                super(zpath);
            }

            @Override
            public void start() {
                ZkQuorumWatcher.this.accept(this, new WatchedEvent(Watcher.Event.EventType.NodeChildrenChanged, Watcher.Event.KeeperState.SyncConnected, this.zpath), true);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void handleEvent(ZooKeeper zk) throws KeeperException, InterruptedException {
                QuorumTokenState state = (QuorumTokenState)SerializerUtil.deserialize(zk.getData(this.zpath, (Watcher)this, null));
                ZKQuorumImpl.this.lock.lock();
                try {
                    long tok = ZKQuorumImpl.this.token();
                    if (state.token() == -1L && tok != -1L) {
                        ZkQuorumWatcher.this.clearToken();
                    } else if (ZKQuorumImpl.this.lastValidToken() != state.lastValidToken() || ZKQuorumImpl.this.token() != state.token()) {
                        UUID[] joined = ZKQuorumImpl.this.getJoined();
                        int k = ZKQuorumImpl.this.replicationFactor();
                        if (ZKQuorumImpl.this.isQuorum(joined.length)) {
                            ZkQuorumWatcher.this.setToken(state.lastValidToken());
                        } else {
                            log.warn((Object)("Can not set token - not enough joined services: k=" + k + ", joined=" + joined.length));
                        }
                    } else if (log.isInfoEnabled()) {
                        log.info((Object)("Nothing to do: currentState=" + state + ", token()=" + tok));
                    }
                }
                finally {
                    ZKQuorumImpl.this.lock.unlock();
                }
            }
        }

        /*
         * Signature claims super is com.bigdata.quorum.zk.ZKQuorumImpl$ZkQuorumWatcher.AbstractSetQuorumWatcher, not com.bigdata.quorum.zk.ZKQuorumImpl$ZkQuorumWatcher$AbstractSetQuorumWatcher - discarding signature.
         */
        private class QuorumJoinedWatcher
        extends AbstractSetQuorumWatcher {
            QuorumJoinedWatcher(String zpath) {
                super(zpath);
            }

            @Override
            protected void handleEvent(ZooKeeper zk) throws KeeperException, InterruptedException {
                Object[] children = zk.getChildren(this.zpath, (Watcher)this).toArray(new String[0]);
                Arrays.sort(children);
                UUID[] aold = ZKQuorumImpl.this.getJoined();
                LinkedList<UUID> tmp = new LinkedList<UUID>();
                for (Object s : children) {
                    try {
                        QuorumServiceState state = (QuorumServiceState)SerializerUtil.deserialize(zk.getData(this.zpath + "/" + (String)s, false, null));
                        tmp.add(state.serviceUUID());
                    }
                    catch (KeeperException.NoNodeException ex) {
                        // empty catch block
                    }
                }
                UUID[] anew = tmp.toArray(new UUID[0]);
                this.applyOrderedSetSemantics(aold, anew);
            }

            @Override
            protected void add(UUID serviceId) {
                ZkQuorumWatcher.this.serviceJoin(serviceId);
            }

            @Override
            protected void remove(UUID serviceId) {
                ZkQuorumWatcher.this.serviceLeave(serviceId);
            }
        }

        /*
         * Signature claims super is com.bigdata.quorum.zk.ZKQuorumImpl$ZkQuorumWatcher.AbstractSetQuorumWatcher, not com.bigdata.quorum.zk.ZKQuorumImpl$ZkQuorumWatcher$AbstractSetQuorumWatcher - discarding signature.
         */
        private class QuorumPipelineWatcher
        extends AbstractSetQuorumWatcher {
            QuorumPipelineWatcher(String zpath) {
                super(zpath);
            }

            @Override
            protected void handleEvent(ZooKeeper zk) throws KeeperException, InterruptedException {
                Object[] children = zk.getChildren(this.zpath, (Watcher)this).toArray(new String[0]);
                Arrays.sort(children);
                UUID[] aold = ZKQuorumImpl.this.getPipeline();
                LinkedList<UUID> tmp = new LinkedList<UUID>();
                for (Object s : children) {
                    try {
                        QuorumPipelineState state = (QuorumPipelineState)SerializerUtil.deserialize(zk.getData(this.zpath + "/" + (String)s, false, null));
                        tmp.add(state.serviceUUID());
                    }
                    catch (KeeperException.NoNodeException ex) {
                        // empty catch block
                    }
                }
                UUID[] anew = tmp.toArray(new UUID[0]);
                this.applyOrderedSetSemantics(aold, anew);
            }

            @Override
            protected void add(UUID serviceId) {
                ZkQuorumWatcher.this.pipelineAdd(serviceId);
            }

            @Override
            protected void remove(UUID serviceId) {
                ZkQuorumWatcher.this.pipelineRemove(serviceId);
            }
        }

        /*
         * Signature claims super is com.bigdata.quorum.zk.ZKQuorumImpl$ZkQuorumWatcher.AbstractSetQuorumWatcher, not com.bigdata.quorum.zk.ZKQuorumImpl$ZkQuorumWatcher$AbstractSetQuorumWatcher - discarding signature.
         */
        private class QuorumMemberWatcher
        extends AbstractSetQuorumWatcher {
            QuorumMemberWatcher(String zpath) {
                super(zpath);
            }

            @Override
            protected void handleEvent(ZooKeeper zk) throws KeeperException, InterruptedException {
                List children = zk.getChildren(this.zpath, (Watcher)this);
                UUID[] aold = ZKQuorumImpl.this.getMembers();
                UUID[] anew = new UUID[children.size()];
                int i = 0;
                for (String s : children) {
                    String uuidStr = s.substring("member".length(), s.length());
                    anew[i++] = UUID.fromString(uuidStr);
                }
                this.applyUnorderedSetSemantics(aold, anew);
            }

            @Override
            protected void add(UUID serviceId) {
                ZkQuorumWatcher.this.memberAdd(serviceId);
            }

            @Override
            protected void remove(UUID serviceId) {
                ZkQuorumWatcher.this.memberRemove(serviceId);
            }
        }

        /*
         * Signature claims super is com.bigdata.quorum.zk.ZKQuorumImpl$ZkQuorumWatcher.InternalQuorumWatcher, not com.bigdata.quorum.zk.ZKQuorumImpl$ZkQuorumWatcher$InternalQuorumWatcher - discarding signature.
         */
        private abstract class AbstractSetQuorumWatcher
        extends InternalQuorumWatcher {
            protected AbstractSetQuorumWatcher(String zpath) {
                super(zpath);
            }

            @Override
            public void start() {
                ZkQuorumWatcher.this.accept(this, new WatchedEvent(Watcher.Event.EventType.NodeChildrenChanged, Watcher.Event.KeeperState.SyncConnected, this.zpath), true);
            }

            protected void applyOrderedSetSemantics(UUID[] aold, UUID[] anew) {
                OrderedSetDifference<UUID> diff = new OrderedSetDifference<UUID>(aold, anew);
                for (UUID t : diff.removed()) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("removing: " + t));
                    }
                    this.remove(t);
                }
                for (UUID t : diff.added()) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("adding: " + t));
                    }
                    this.add(t);
                }
            }

            protected void applyUnorderedSetSemantics(UUID[] aold, UUID[] anew) {
                UnorderedSetDifference diff = new UnorderedSetDifference((Comparable[])aold, (Comparable[])anew);
                for (UUID t : diff.removed()) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("removing: " + t));
                    }
                    this.remove(t);
                }
                for (UUID t : diff.added()) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("adding: " + t));
                    }
                    this.add(t);
                }
            }

            protected abstract void add(UUID var1);

            protected abstract void remove(UUID var1);
        }

        private abstract class InternalQuorumWatcher
        implements Watcher {
            final String zpath;

            protected InternalQuorumWatcher(String zpath) {
                this.zpath = zpath;
            }

            public final void process(WatchedEvent event) {
                ZkQuorumWatcher.this.accept(this, event, false);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("zpath=" + this.zpath + ", event=" + event));
                }
            }

            public abstract void start();

            protected abstract void handleEvent(ZooKeeper var1) throws KeeperException, InterruptedException;
        }

        private static class HandleEventRunnable
        implements Runnable {
            private final com.bigdata.quorum.zk.ZKQuorumImpl$ZkQuorumWatcher.InternalQuorumWatcher watcher;
            private final WatchedEvent e;
            final /* synthetic */ ZkQuorumWatcher this$1;

            HandleEventRunnable(com.bigdata.quorum.zk.ZKQuorumImpl$ZkQuorumWatcher.InternalQuorumWatcher watcher, WatchedEvent e) {
                this.this$1 = var1_1;
                this.watcher = watcher;
                this.e = e;
            }

            @Override
            public void run() {
                try {
                    if (log.isInfoEnabled()) {
                        log.info((Object)this.e.toString());
                    }
                    switch (this.e.getState()) {
                        case Disconnected: {
                            this.this$1.handleDisconnected();
                            return;
                        }
                        case SyncConnected: {
                            break;
                        }
                        case Expired: {
                            log.error((Object)this.e);
                            this.this$1.handleExpired();
                        }
                    }
                    ZooKeeper zk = this.this$1.ZKQuorumImpl.this.getZookeeper();
                    this.watcher.handleEvent(zk);
                }
                catch (KeeperException.SessionExpiredException e1) {
                    log.error((Object)this.e, (Throwable)e1);
                    this.this$1.handleExpired();
                }
                catch (KeeperException e1) {
                    log.error((Object)this.e, (Throwable)e1);
                }
                catch (Throwable e1) {
                    if (InnerCause.isInnerCause(e1, InterruptedException.class)) {
                        if (log.isInfoEnabled()) {
                            log.info((Object)e1);
                        }
                    }
                    log.error((Object)this.e, e1);
                }
            }
        }
    }

    protected class ZkQuorumActor
    extends AbstractQuorum.QuorumActorBase {
        private final String serviceIdStr;

        protected ZkQuorumActor(String logicalServiceZPath, UUID serviceId) {
            super(logicalServiceZPath, serviceId);
            this.serviceIdStr = serviceId.toString();
        }

        @Override
        protected void doMemberAdd() {
            ZooKeeper zk;
            try {
                zk = ZKQuorumImpl.this.getZookeeper();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
            try {
                QuorumServiceState state = new QuorumServiceState(this.serviceId);
                zk.create(this.logicalServiceId + "/" + "quorum" + "/" + "member" + "/" + "member" + this.serviceIdStr, SerializerUtil.serialize(state), ZKQuorumImpl.this.getZookeeperACL(), CreateMode.EPHEMERAL);
            }
            catch (KeeperException.NodeExistsException e) {
            }
            catch (KeeperException e) {
                throw new RuntimeException(e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
        }

        @Override
        protected void doMemberRemove(UUID service) {
            ZooKeeper zk;
            try {
                zk = ZKQuorumImpl.this.getZookeeper();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
            try {
                zk.delete(this.logicalServiceId + "/" + "quorum" + "/" + "member" + "/" + "member" + service.toString(), -1);
            }
            catch (KeeperException.NoNodeException e) {
            }
            catch (KeeperException e) {
                throw new RuntimeException(e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
        }

        @Override
        protected void doPipelineAdd() {
            ZooKeeper zk;
            InetSocketAddress addrNext;
            HAPipelineGlue tmp = (HAPipelineGlue)ZKQuorumImpl.this.getMember().getService();
            try {
                addrNext = tmp.getWritePipelineAddr();
            }
            catch (IOException e1) {
                throw new RuntimeException(e1);
            }
            QuorumPipelineState pipelineState = new QuorumPipelineState(this.serviceId, addrNext);
            try {
                zk = ZKQuorumImpl.this.getZookeeper();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
            try {
                String zpath = this.logicalServiceId + "/" + "quorum" + "/" + "pipeline";
                Object[] children = zk.getChildren(zpath, false).toArray(new String[0]);
                Arrays.sort(children);
                for (Object s : children) {
                    QuorumServiceState state = (QuorumServiceState)SerializerUtil.deserialize(zk.getData(zpath + "/" + (String)s, false, null));
                    if (!this.serviceId.equals(state.serviceUUID())) continue;
                    log.warn((Object)"Service already in pipeline");
                    return;
                }
                zk.create(zpath + "/" + "pipeline", SerializerUtil.serialize(pipelineState), ZKQuorumImpl.this.getZookeeperACL(), CreateMode.EPHEMERAL_SEQUENTIAL);
            }
            catch (KeeperException e) {
                throw new RuntimeException(e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
        }

        @Override
        protected void doPipelineRemove(UUID service) {
            ZooKeeper zk;
            try {
                zk = ZKQuorumImpl.this.getZookeeper();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
            try {
                String zpath = this.logicalServiceId + "/" + "quorum" + "/" + "pipeline";
                Object[] children = zk.getChildren(zpath, false).toArray(new String[0]);
                Arrays.sort(children);
                for (Object s : children) {
                    byte[] b;
                    try {
                        b = zk.getData(zpath + "/" + (String)s, false, null);
                    }
                    catch (KeeperException.NoNodeException ex) {
                        continue;
                    }
                    QuorumServiceState state = (QuorumServiceState)SerializerUtil.deserialize(b);
                    if (!service.equals(state.serviceUUID())) continue;
                    zk.delete(zpath + "/" + (String)s, -1);
                    return;
                }
            }
            catch (KeeperException e) {
                throw new RuntimeException(e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
        }

        private String getVotesZPath() {
            return this.logicalServiceId + "/" + "quorum" + "/" + "votes";
        }

        private String getLastCommitTimeZPath(long lastCommitTime) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getVotesZPath());
            sb.append("/");
            sb.append(lastCommitTime);
            String lastCommitTimeZPath = sb.toString();
            return lastCommitTimeZPath;
        }

        @Override
        protected void doCastVote(long lastCommitTime) {
            ZooKeeper zk;
            String lastCommitTimeZPath = this.getLastCommitTimeZPath(lastCommitTime);
            if (log.isInfoEnabled()) {
                log.info((Object)("lastCommitTime=" + lastCommitTime + ", lastCommitTimeZPath=" + lastCommitTimeZPath));
            }
            try {
                zk = ZKQuorumImpl.this.getZookeeper();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
            try {
                zk.create(lastCommitTimeZPath, new byte[0], ZKQuorumImpl.this.getZookeeperACL(), CreateMode.PERSISTENT);
            }
            catch (KeeperException.NodeExistsException e) {
            }
            catch (KeeperException e) {
                throw new RuntimeException(e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
            try {
                QuorumServiceState state = new QuorumServiceState(this.serviceId);
                zk.create(lastCommitTimeZPath + "/" + "vote", SerializerUtil.serialize(state), ZKQuorumImpl.this.getZookeeperACL(), CreateMode.EPHEMERAL_SEQUENTIAL);
            }
            catch (KeeperException.NoNodeException e) {
                log.warn((Object)("Concurrent delete (retrying): zpath=" + lastCommitTimeZPath));
            }
            catch (KeeperException e) {
                throw new RuntimeException(e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
        }

        @Override
        protected void doWithdrawVote(UUID service) {
            String[] lastCommitTimes;
            ZooKeeper zk;
            String votesZPath = this.getVotesZPath();
            if (log.isInfoEnabled()) {
                log.info((Object)("votesZPath=" + votesZPath));
            }
            try {
                zk = ZKQuorumImpl.this.getZookeeper();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
            try {
                List tmp = zk.getChildren(votesZPath, false);
                lastCommitTimes = tmp.toArray(new String[tmp.size()]);
                Arrays.sort(lastCommitTimes, VoteComparator.INSTANCE);
            }
            catch (KeeperException e) {
                throw new RuntimeException(e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
            for (String lastCommitTime : lastCommitTimes) {
                List votes;
                String lastCommitTimeZPath = votesZPath + "/" + lastCommitTime;
                try {
                    votes = zk.getChildren(lastCommitTimeZPath, false);
                }
                catch (KeeperException.NoNodeException ex) {
                    continue;
                }
                catch (KeeperException ex) {
                    throw new RuntimeException(ex);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
                if (votes.isEmpty()) {
                    try {
                        zk.delete(lastCommitTimeZPath, -1);
                    }
                    catch (KeeperException.NoNodeException e) {
                        continue;
                    }
                    catch (KeeperException.NotEmptyException e) {
                        continue;
                    }
                    catch (KeeperException e) {
                        throw new RuntimeException(e);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                }
                for (String vote : votes) {
                    QuorumServiceState state;
                    String voteZPath = lastCommitTimeZPath + "/" + vote;
                    try {
                        state = (QuorumServiceState)SerializerUtil.deserialize(zk.getData(voteZPath, false, null));
                    }
                    catch (KeeperException.NoNodeException e) {
                        continue;
                    }
                    catch (KeeperException e) {
                        throw new RuntimeException(e);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                    if (!service.equals(state.serviceUUID())) continue;
                    try {
                        zk.delete(voteZPath, -1);
                        if (votes.size() == 1) {
                            try {
                                zk.delete(lastCommitTimeZPath, -1);
                            }
                            catch (KeeperException.NoNodeException e) {
                                continue;
                            }
                            catch (KeeperException.NotEmptyException e) {
                                continue;
                            }
                            catch (KeeperException e) {
                                throw new RuntimeException(e);
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                                return;
                            }
                        }
                        if (log.isInfoEnabled()) {
                            log.info((Object)("withdrawn: serviceId=" + service.toString() + ", lastCommitTime=" + lastCommitTime));
                        }
                        return;
                    }
                    catch (KeeperException.NoNodeException e) {
                    }
                    catch (KeeperException e) {
                        throw new RuntimeException(e);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                }
            }
        }

        @Override
        protected void doServiceJoin() {
            ZooKeeper zk;
            try {
                zk = ZKQuorumImpl.this.getZookeeper();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
            try {
                String zpath = this.logicalServiceId + "/" + "quorum" + "/" + "joined";
                Object[] children = zk.getChildren(zpath, false).toArray(new String[0]);
                Arrays.sort(children);
                for (Object s : children) {
                    QuorumServiceState state = (QuorumServiceState)SerializerUtil.deserialize(zk.getData(zpath + "/" + (String)s, false, null));
                    if (!this.serviceId.equals(state.serviceUUID())) continue;
                    log.warn((Object)("Service " + this.serviceId + " already joined in quorum of " + children.length));
                    return;
                }
                QuorumServiceState state = new QuorumServiceState(this.serviceId);
                zk.create(zpath + "/" + "joined", SerializerUtil.serialize(state), ZKQuorumImpl.this.getZookeeperACL(), CreateMode.EPHEMERAL_SEQUENTIAL);
            }
            catch (KeeperException e) {
                throw new RuntimeException(e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
        }

        @Override
        protected void doServiceLeave(UUID service) {
            ZooKeeper zk;
            try {
                zk = ZKQuorumImpl.this.getZookeeper();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
            try {
                String zpath = this.logicalServiceId + "/" + "quorum" + "/" + "joined";
                Object[] children = zk.getChildren(zpath, false).toArray(new String[0]);
                Arrays.sort(children);
                for (Object s : children) {
                    byte[] b;
                    try {
                        b = zk.getData(zpath + "/" + (String)s, false, null);
                    }
                    catch (KeeperException.NoNodeException ex) {
                        continue;
                    }
                    QuorumServiceState state = (QuorumServiceState)SerializerUtil.deserialize(b);
                    if (!service.equals(state.serviceUUID())) continue;
                    zk.delete(zpath + "/" + (String)s, -1);
                    return;
                }
            }
            catch (KeeperException e) {
                throw new RuntimeException(e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
        }

        @Override
        protected void doClearToken() {
            ZooKeeper zk;
            try {
                zk = ZKQuorumImpl.this.getZookeeper();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
            while (true) {
                QuorumTokenState oldState;
                Stat stat = new Stat();
                try {
                    oldState = (QuorumTokenState)SerializerUtil.deserialize(zk.getData(this.logicalServiceId + "/" + "quorum", false, stat));
                }
                catch (KeeperException e) {
                    throw new RuntimeException(e);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
                if (oldState.token() == -1L) {
                    return;
                }
                QuorumTokenState newState = new QuorumTokenState(oldState.lastValidToken(), -1L, ZKQuorumImpl.this.replicationFactor());
                try {
                    zk.setData(this.logicalServiceId + "/" + "quorum", SerializerUtil.serialize(newState), stat.getVersion());
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Cleared token: serviceId=" + this.serviceId));
                    }
                    return;
                }
                catch (KeeperException.BadVersionException e) {
                    log.warn((Object)("Concurrent update (retry): serviceId=" + this.serviceIdStr));
                    continue;
                }
                catch (KeeperException e) {
                    throw new RuntimeException(e);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
                break;
            }
        }

        @Override
        protected void doSetToken(long newToken) {
            ZooKeeper zk;
            if (newToken == -1L) {
                throw new IllegalArgumentException();
            }
            try {
                zk = ZKQuorumImpl.this.getZookeeper();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
            while (true) {
                QuorumTokenState oldState;
                Stat stat = new Stat();
                try {
                    oldState = (QuorumTokenState)SerializerUtil.deserialize(zk.getData(this.logicalServiceId + "/" + "quorum", false, stat));
                }
                catch (KeeperException e) {
                    throw new RuntimeException(e);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
                if (oldState.lastValidToken() >= newToken) {
                    throw new QuorumException("New value must be GT old value: oldValue=" + oldState.lastValidToken() + ", but newValue=" + newToken);
                }
                if (oldState.token() != -1L) {
                    throw new QuorumException("The quorum token has not been cleared");
                }
                try {
                    QuorumTokenState newState = new QuorumTokenState(newToken, newToken, ZKQuorumImpl.this.replicationFactor());
                    zk.setData(this.logicalServiceId + "/" + "quorum", SerializerUtil.serialize(newState), stat.getVersion());
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Set: lastValidToken=" + newToken));
                    }
                    return;
                }
                catch (KeeperException.BadVersionException e) {
                    log.warn((Object)("Concurrent update (retry): serviceId=" + this.serviceIdStr));
                    continue;
                }
                catch (KeeperException e) {
                    throw new RuntimeException(e);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
                break;
            }
        }
    }
}

