/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf;

import com.bigdata.rdf.rio.json.BigdataSPARQLResultsJSONParserFactory;
import com.bigdata.rdf.rio.json.BigdataSPARQLResultsJSONParserForConstructFactory;
import com.bigdata.rdf.rio.json.BigdataSPARQLResultsJSONWriterFactory;
import com.bigdata.rdf.rio.json.BigdataSPARQLResultsJSONWriterForConstructFactory;
import com.bigdata.rdf.rio.ntriples.BigdataNTriplesParserFactory;
import com.bigdata.rdf.rio.turtle.BigdataTurtleParserFactory;
import com.bigdata.rdf.rio.turtle.BigdataTurtleWriterFactory;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.apache.log4j.Logger;
import org.openrdf.query.resultio.TupleQueryResultParserRegistry;
import org.openrdf.query.resultio.TupleQueryResultWriterRegistry;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFParserRegistry;
import org.openrdf.rio.RDFWriterRegistry;

public class ServiceProviderHook {
    private static final Logger log = Logger.getLogger(ServiceProviderHook.class);
    private static boolean loaded = false;
    public static final RDFFormat TURTLE_RDR = new RDFFormat("Turtle-RDR", Arrays.asList("application/x-turtle-RDR"), Charset.forName("UTF-8"), Arrays.asList("ttlx"), true, false);
    public static final RDFFormat NTRIPLES_RDR = new RDFFormat("N-Triples-RDR", "application/x-n-triples-RDR", Charset.forName("US-ASCII"), "ntx", false, false);
    public static final RDFFormat JSON_RDR = new RDFFormat("SPARQL/JSON", Arrays.asList("application/sparql-results+json", "application/json"), Charset.forName("UTF-8"), Arrays.asList("srj", "json"), false, true);

    public static synchronized void forceLoad() {
        if (loaded) {
            return;
        }
        log.warn((Object)"Running.");
        if (log.isInfoEnabled()) {
            for (RDFFormat f : RDFFormat.values()) {
                log.info((Object)("RDFFormat: before: " + f));
            }
            for (RDFFormat f : RDFParserRegistry.getInstance().getAll()) {
                log.info((Object)("RDFParserFactory: before: " + f));
            }
            for (RDFFormat f : RDFWriterRegistry.getInstance().getAll()) {
                log.info((Object)("RDFWriterFactory: before: " + f));
            }
            for (RDFFormat f : TupleQueryResultWriterRegistry.getInstance().getAll()) {
                log.info((Object)("TupleQueryResultWriterFactory: before: " + f));
            }
        }
        RDFFormat.register((RDFFormat)TURTLE_RDR);
        RDFFormat.register((RDFFormat)NTRIPLES_RDR);
        RDFFormat.register((RDFFormat)JSON_RDR);
        RDFParserRegistry r = RDFParserRegistry.getInstance();
        r.add((Object)new BigdataNTriplesParserFactory());
        assert (r.has((Object)new BigdataNTriplesParserFactory().getRDFFormat()));
        r.add((Object)new BigdataTurtleParserFactory());
        assert (r.has((Object)new BigdataTurtleParserFactory().getRDFFormat()));
        r.add((Object)new BigdataSPARQLResultsJSONParserForConstructFactory());
        r = TupleQueryResultWriterRegistry.getInstance();
        r.add((Object)new BigdataSPARQLResultsJSONWriterFactory());
        r = TupleQueryResultParserRegistry.getInstance();
        r.add((Object)new BigdataSPARQLResultsJSONParserFactory());
        r = RDFWriterRegistry.getInstance();
        r.add((Object)new BigdataTurtleWriterFactory());
        r.add((Object)new BigdataSPARQLResultsJSONWriterForConstructFactory());
        if (log.isInfoEnabled()) {
            for (RDFFormat f : RDFFormat.values()) {
                log.info((Object)("RDFFormat: after: " + f));
            }
            for (RDFFormat f : RDFParserRegistry.getInstance().getAll()) {
                log.info((Object)("RDFParserFactory: after: " + f));
            }
            for (RDFFormat f : RDFWriterRegistry.getInstance().getAll()) {
                log.info((Object)("RDFWriterFactory: after: " + f));
            }
            for (RDFFormat f : TupleQueryResultWriterRegistry.getInstance().getAll()) {
                log.info((Object)("TupleQueryResultWriterFactory: after: " + f));
            }
        }
        loaded = true;
    }

    static {
        ServiceProviderHook.forceLoad();
    }
}

