/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.axioms;

import com.bigdata.btree.keys.KeyBuilder;
import com.bigdata.io.LongPacker;
import com.bigdata.rdf.axioms.Axioms;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.IVUtility;
import com.bigdata.rdf.model.BigdataStatement;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.model.BigdataValueFactoryImpl;
import com.bigdata.rdf.model.StatementEnum;
import com.bigdata.rdf.rio.StatementBuffer;
import com.bigdata.rdf.spo.SPO;
import com.bigdata.rdf.spo.SPOKeyOrder;
import com.bigdata.rdf.store.AbstractTripleStore;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public abstract class BaseAxioms
implements Axioms,
Externalizable {
    private Set<SPO> axioms;
    private String namespace;
    private static final transient byte VERSION1 = 1;
    private static final transient byte currentVersion = 1;

    @Override
    public final String getNamespace() {
        return this.namespace;
    }

    protected final BigdataValueFactory getValueFactory() {
        return BigdataValueFactoryImpl.getInstance(this.namespace);
    }

    protected BaseAxioms() {
    }

    protected BaseAxioms(String namespace) {
        if (namespace == null) {
            throw new IllegalArgumentException();
        }
        this.namespace = namespace;
    }

    public final void init(AbstractTripleStore db) {
        LinkedHashSet<BigdataStatement> axioms = new LinkedHashSet<BigdataStatement>(200);
        this.addAxioms(axioms);
        this.axioms = this.writeAxioms(db, axioms);
    }

    protected void addAxioms(Collection<BigdataStatement> axioms) {
        if (axioms == null) {
            throw new IllegalArgumentException();
        }
    }

    private Set<SPO> writeAxioms(AbstractTripleStore db, Collection<BigdataStatement> axioms) {
        if (db == null) {
            throw new IllegalArgumentException();
        }
        if (axioms == null) {
            throw new IllegalArgumentException();
        }
        int naxioms = axioms.size();
        LinkedHashSet<SPO> ret = new LinkedHashSet<SPO>(naxioms);
        if (naxioms > 0) {
            SPO[] stmts;
            int capacity = Math.max(1, naxioms);
            MyStatementBuffer buffer = new MyStatementBuffer(db, capacity);
            for (BigdataStatement triple : axioms) {
                assert (triple.getStatementType() == StatementEnum.Axiom);
                buffer.add(triple);
            }
            buffer.flush();
            for (SPO spo : stmts = buffer.stmts) {
                ret.add(spo);
            }
        }
        return ret;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte version = in.readByte();
        switch (version) {
            case 1: {
                this.readVersion1(in);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown version: " + version);
            }
        }
    }

    private void readVersion1(ObjectInput in) throws IOException {
        this.namespace = in.readUTF();
        int naxioms = LongPacker.unpackInt(in);
        this.axioms = new LinkedHashSet<SPO>(naxioms);
        for (int i = 0; i < naxioms; ++i) {
            int nbytes = LongPacker.unpackInt(in);
            byte[] key = new byte[nbytes];
            in.readFully(key);
            Object[] ivs = IVUtility.decodeAll(key);
            if (ivs.length != 3) {
                throw new IOException("Expecting 3 IVs, not: " + Arrays.toString(ivs));
            }
            IV s = ivs[0];
            IV p = ivs[1];
            Object o = ivs[2];
            SPO spo = new SPO(s, p, (IV)o, StatementEnum.Axiom);
            this.axioms.add(spo);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(1);
        switch (1) {
            case 1: {
                this.writeVersion1(out);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    private void writeVersion1(ObjectOutput out) throws IOException {
        out.writeUTF(this.namespace);
        LongPacker.packLong(out, (long)this.axioms.size());
        KeyBuilder keyBuilder = new KeyBuilder(24);
        for (SPO spo : this.axioms) {
            byte[] key = SPOKeyOrder.SPO.encodeKey(keyBuilder, spo);
            Object[] ivs = IVUtility.decodeAll(key);
            if (ivs.length != 3) {
                throw new IOException("Expecting 3 IVs, not: " + Arrays.toString(ivs) + " for " + spo);
            }
            IV s = ivs[0];
            IV p = ivs[1];
            Object o = ivs[2];
            SPO spo2 = new SPO(s, p, (IV)o, StatementEnum.Axiom);
            if (!spo.equals(spo2)) {
                throw new IOException("Expecting: " + spo + ", not " + spo2);
            }
            LongPacker.packLong(out, (long)key.length);
            out.write(key);
        }
    }

    @Override
    public final boolean isAxiom(IV s, IV p, IV o) {
        if (this.axioms == null) {
            throw new IllegalStateException();
        }
        if (s == null || p == null || o == null) {
            return false;
        }
        SPO spo = new SPO(s, p, o, StatementEnum.Axiom);
        return this.axioms.contains(spo);
    }

    @Override
    public final int size() {
        if (this.axioms == null) {
            throw new IllegalStateException();
        }
        return this.axioms.size();
    }

    @Override
    public final Iterator<SPO> axioms() {
        if (this.axioms == null) {
            throw new IllegalStateException();
        }
        return Collections.unmodifiableSet(this.axioms).iterator();
    }

    private static class MyStatementBuffer
    extends StatementBuffer {
        SPO[] stmts;

        public MyStatementBuffer(AbstractTripleStore database, int capacity) {
            super(database, capacity);
        }

        @Override
        protected long writeSPOs(SPO[] stmts, int numStmts) {
            if (this.stmts == null) {
                this.stmts = new SPO[numStmts];
                System.arraycopy(stmts, 0, this.stmts, 0, numStmts);
                Arrays.sort(this.stmts, SPOKeyOrder.SPO.getComparator());
            }
            return super.writeSPOs(stmts, numStmts);
        }
    }
}

