/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.changesets;

import com.bigdata.rdf.changesets.IChangeLog;
import com.bigdata.rdf.changesets.IChangeRecord;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.BigdataStatementIterator;
import com.bigdata.rdf.store.BigdataStatementIteratorImpl;
import com.bigdata.striterator.ChunkedWrappedIterator;
import java.util.LinkedHashSet;
import java.util.Set;

public class InferenceChangeLogReporter
implements IChangeLog {
    private final AbstractTripleStore kb;
    private final Set<ISPO> added = new LinkedHashSet<ISPO>();
    private final Set<ISPO> removed = new LinkedHashSet<ISPO>();

    public InferenceChangeLogReporter(AbstractTripleStore kb) {
        this.kb = kb;
    }

    public void clear() {
        this.added.clear();
        this.removed.clear();
    }

    @Override
    public void changeEvent(IChangeRecord record) {
        ISPO spo = record.getStatement();
        if (!spo.isInferred()) {
            return;
        }
        switch (record.getChangeAction()) {
            case INSERTED: {
                this.added.add(spo);
                break;
            }
            case REMOVED: {
                this.removed.add(spo);
                break;
            }
            case UPDATED: {
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    @Override
    public void transactionBegin() {
    }

    @Override
    public void transactionPrepare() {
    }

    @Override
    public void transactionCommited(long commitTime) {
    }

    @Override
    public void transactionAborted() {
    }

    public BigdataStatementIterator addedIterator() {
        ChunkedWrappedIterator<ISPO> src = new ChunkedWrappedIterator<ISPO>(this.added.iterator());
        return new BigdataStatementIteratorImpl(this.kb, src).start(this.kb.getExecutorService());
    }

    public BigdataStatementIterator removedIterator() {
        ChunkedWrappedIterator<ISPO> src = new ChunkedWrappedIterator<ISPO>(this.removed.iterator());
        return new BigdataStatementIteratorImpl(this.kb, src).start(this.kb.getExecutorService());
    }
}

