/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.graph.impl.bd;

import com.bigdata.bop.Constant;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.bindingSet.ListBindingSet;
import com.bigdata.journal.IIndexManager;
import com.bigdata.rdf.graph.IBinder;
import com.bigdata.rdf.graph.IGASContext;
import com.bigdata.rdf.graph.IGASEngine;
import com.bigdata.rdf.graph.IGASProgram;
import com.bigdata.rdf.graph.IGASSchedulerImpl;
import com.bigdata.rdf.graph.IGASState;
import com.bigdata.rdf.graph.IGASStats;
import com.bigdata.rdf.graph.IGraphAccessor;
import com.bigdata.rdf.graph.IPredecessor;
import com.bigdata.rdf.graph.IReducer;
import com.bigdata.rdf.graph.TraversalDirectionEnum;
import com.bigdata.rdf.graph.impl.GASEngine;
import com.bigdata.rdf.graph.impl.GASState;
import com.bigdata.rdf.graph.impl.bd.BigdataGASEngine;
import com.bigdata.rdf.graph.impl.scheduler.CHMScheduler;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.lexicon.LexiconRelation;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueImpl;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sparql.ast.DummyConstantNode;
import com.bigdata.rdf.sparql.ast.GraphPatternGroup;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.VarNode;
import com.bigdata.rdf.sparql.ast.service.BigdataNativeServiceOptions;
import com.bigdata.rdf.sparql.ast.service.BigdataServiceCall;
import com.bigdata.rdf.sparql.ast.service.CustomServiceFactory;
import com.bigdata.rdf.sparql.ast.service.IServiceOptions;
import com.bigdata.rdf.sparql.ast.service.ServiceCall;
import com.bigdata.rdf.sparql.ast.service.ServiceCallCreateParams;
import com.bigdata.rdf.sparql.ast.service.ServiceNode;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.striterator.ChunkedArrayIterator;
import cutthecrap.utils.striterators.ICloseableIterator;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.URIImpl;

public class GASService
implements CustomServiceFactory {
    private static final transient Logger log = Logger.getLogger(GASService.class);
    private static List<URI> OUT_VARS = Collections.unmodifiableList(Arrays.asList(Options.OUT, Options.OUT1, Options.OUT2, Options.OUT3, Options.OUT4, Options.OUT5, Options.OUT6, Options.OUT7, Options.OUT8, Options.OUT9));
    private final BigdataNativeServiceOptions serviceOptions = new BigdataNativeServiceOptions();
    static final Set<URI> gasUris;

    public GASService() {
        this.serviceOptions.setRunFirst(true);
    }

    @Override
    public IServiceOptions getServiceOptions() {
        return this.serviceOptions;
    }

    @Override
    public void startConnection(BigdataSail.BigdataSailConnection conn) {
    }

    @Override
    public ServiceCall<?> create(ServiceCallCreateParams params) {
        if (params == null) {
            throw new IllegalArgumentException();
        }
        AbstractTripleStore store = params.getTripleStore();
        if (store == null) {
            throw new IllegalArgumentException();
        }
        return new GASServiceCall(store, params.getServiceNode(), this.getServiceOptions());
    }

    static {
        LinkedHashSet<URI> set = new LinkedHashSet<URI>();
        set.add(Options.PROGRAM);
        gasUris = Collections.unmodifiableSet(set);
    }

    private static class GASServiceCall<VS, ES, ST>
    implements BigdataServiceCall {
        private final AbstractTripleStore store;
        private final GraphPatternGroup<IGroupMemberNode> graphPattern;
        private final IServiceOptions serviceOptions;
        private final int nthreads;
        private final TraversalDirectionEnum traversalDirection;
        private final int maxIterations;
        private final int maxIterationsAfterTargets;
        private final int maxVisited;
        private final URI linkType;
        private final URI linkAttrType;
        private final Class<IGASProgram<VS, ES, ST>> gasClass;
        private final Class<IGASSchedulerImpl> schedulerClass;
        private final Value[] initialFrontier;
        private final Value[] targetVertices;
        private final IVariable<?>[] outVars;

        public GASServiceCall(AbstractTripleStore store, ServiceNode serviceNode, IServiceOptions serviceOptions) {
            Class<?> cls;
            if (store == null) {
                throw new IllegalArgumentException();
            }
            if (serviceNode == null) {
                throw new IllegalArgumentException();
            }
            if (serviceOptions == null) {
                throw new IllegalArgumentException();
            }
            this.store = store;
            this.graphPattern = serviceNode.getGraphPattern();
            this.serviceOptions = serviceOptions;
            this.nthreads = ((Literal)this.getOnlyArg(Options.PROGRAM, Options.NTHREADS, store.getValueFactory().createLiteral(4))).intValue();
            this.traversalDirection = TraversalDirectionEnum.valueOf(((Literal)this.getOnlyArg(Options.PROGRAM, Options.TRAVERSAL_DIRECTION, store.getValueFactory().createLiteral(Options.DEFAULT_DIRECTED_TRAVERSAL.name()))).stringValue());
            this.maxIterations = ((Literal)this.getOnlyArg(Options.PROGRAM, Options.MAX_ITERATIONS, store.getValueFactory().createLiteral(Integer.MAX_VALUE))).intValue();
            this.maxIterationsAfterTargets = ((Literal)this.getOnlyArg(Options.PROGRAM, Options.MAX_ITERATIONS_AFTER_TARGETS, store.getValueFactory().createLiteral(Integer.MAX_VALUE))).intValue();
            this.maxVisited = ((Literal)this.getOnlyArg(Options.PROGRAM, Options.MAX_VISITED, store.getValueFactory().createLiteral(Integer.MAX_VALUE))).intValue();
            this.linkType = (URI)this.getOnlyArg(Options.PROGRAM, Options.LINK_TYPE, null);
            this.linkAttrType = (URI)this.getOnlyArg(Options.PROGRAM, Options.LINK_ATTR_TYPE, null);
            Literal tmp = (Literal)this.getOnlyArg(Options.PROGRAM, Options.GAS_CLASS);
            if (tmp == null) {
                throw new IllegalArgumentException("Required predicate not specified: " + Options.GAS_CLASS);
            }
            String className = tmp.stringValue();
            try {
                cls = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("No such class: " + className);
            }
            if (!IGASProgram.class.isAssignableFrom(cls)) {
                throw new IllegalArgumentException(Options.GAS_CLASS + " must extend " + IGASProgram.class.getName());
            }
            this.gasClass = cls;
            tmp = (Literal)this.getOnlyArg(Options.PROGRAM, Options.SCHEDULER_CLASS);
            if (tmp == null) {
                this.schedulerClass = null;
            } else {
                className = tmp.stringValue();
                try {
                    cls = Class.forName(className);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException("No such class: " + className);
                }
                if (!IGASSchedulerImpl.class.isAssignableFrom(cls)) {
                    throw new IllegalArgumentException(Options.SCHEDULER_CLASS + " must extend " + IGASSchedulerImpl.class.getName());
                }
                this.schedulerClass = cls;
            }
            this.initialFrontier = this.getArg(Options.PROGRAM, Options.IN);
            this.targetVertices = this.getArg(Options.PROGRAM, Options.TARGET);
            this.outVars = new IVariable[10];
            int i = 0;
            for (URI uri : OUT_VARS) {
                this.outVars[i++] = this.getVar(Options.PROGRAM, uri);
            }
        }

        private IVariable<?> getVar(URI s, URI p) {
            if (s == null) {
                throw new IllegalArgumentException();
            }
            if (p == null) {
                throw new IllegalArgumentException();
            }
            LinkedList tmp = null;
            for (IGroupMemberNode child : this.graphPattern.getChildren()) {
                StatementPatternNode sp;
                if (!(child instanceof StatementPatternNode) || !(sp = (StatementPatternNode)child).s().isConstant() || !sp.p().isConstant() || !s.equals((Object)sp.s().getValue()) || !p.equals((Object)sp.p().getValue())) continue;
                if (tmp == null) {
                    tmp = new LinkedList();
                }
                return ((VarNode)sp.o()).getValueExpression();
            }
            return null;
        }

        private Value[] getArg(URI s, URI p) {
            if (s == null) {
                throw new IllegalArgumentException();
            }
            if (p == null) {
                throw new IllegalArgumentException();
            }
            LinkedList<BigdataValue> tmp = null;
            for (IGroupMemberNode child : this.graphPattern.getChildren()) {
                StatementPatternNode sp;
                if (!(child instanceof StatementPatternNode) || !(sp = (StatementPatternNode)child).s().isConstant() || !sp.p().isConstant() || !s.equals((Object)sp.s().getValue()) || !p.equals((Object)sp.p().getValue())) continue;
                if (tmp == null) {
                    tmp = new LinkedList<BigdataValue>();
                }
                tmp.add(sp.o().getValue());
            }
            if (tmp == null) {
                return null;
            }
            return tmp.toArray(new Value[tmp.size()]);
        }

        private Value getOnlyArg(URI s, URI p) {
            Value[] tmp = this.getArg(s, p);
            if (tmp == null) {
                return null;
            }
            if (tmp.length > 1) {
                throw new IllegalArgumentException("Multiple values: s=" + s + ", p=" + p);
            }
            return tmp[0];
        }

        private Value getOnlyArg(URI s, URI p, Value def) {
            Value tmp = this.getOnlyArg(s, p);
            if (tmp == null) {
                return def;
            }
            return tmp;
        }

        @Override
        public IServiceOptions getServiceOptions() {
            return this.serviceOptions;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ICloseableIterator<IBindingSet> call(IBindingSet[] bindingSets) throws Exception {
            IGASEngine gasEngine = null;
            try {
                gasEngine = this.newGasEngine(this.store.getIndexManager(), this.nthreads);
                if (this.schedulerClass != null) {
                    ((GASEngine)gasEngine).setSchedulerClass(this.schedulerClass);
                }
                IGraphAccessor graphAccessor = this.newGraphAccessor(this.store);
                IGASProgram<VS, ES, ST> gasProgram = this.newGASProgram(this.gasClass);
                IGASContext<VS, ES, ST> gasContext = gasEngine.newGASContext(graphAccessor, gasProgram);
                gasContext.setTraversalDirection(this.traversalDirection);
                gasContext.setMaxIterations(this.maxIterations);
                gasContext.setMaxIterationsAfterTargets(this.maxIterationsAfterTargets);
                gasContext.setMaxVisited(this.maxVisited);
                if (this.targetVertices != null) {
                    gasContext.setTargetVertices(GASServiceCall.toIV(this.targetVertices));
                }
                if (this.linkType != null) {
                    gasContext.setLinkType(this.linkType);
                }
                if (this.linkAttrType != null) {
                    gasContext.setLinkAttributeType(this.linkAttrType);
                }
                IGASState<VS, ES, ST> gasState = gasContext.getGASState();
                if (this.initialFrontier != null) {
                    Value[] tmp = GASServiceCall.toIV(this.initialFrontier);
                    gasState.setFrontier(gasContext, tmp);
                }
                IGASStats stats = gasContext.call();
                if (this.targetVertices != null && gasProgram instanceof IPredecessor) {
                    Value[] tmp = GASServiceCall.toIV(this.targetVertices);
                    IPredecessor t = (IPredecessor)((Object)gasProgram);
                    t.prunePaths(gasContext, tmp);
                }
                if (log.isInfoEnabled()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("GAS");
                    sb.append(": analytic=" + gasProgram.getClass().getSimpleName());
                    sb.append(", nthreads=" + this.nthreads);
                    sb.append(", scheduler=" + ((GASState)gasState).getScheduler().getClass().getSimpleName());
                    sb.append(", gasEngine=" + gasEngine.getClass().getSimpleName());
                    sb.append(", stats=" + stats);
                    log.info((Object)sb.toString());
                }
                IBindingSet[] out = (IBindingSet[])gasState.reduce(new BindingSetReducer<VS, ES, ST>(this.outVars, this.store, gasProgram, gasContext));
                ChunkedArrayIterator<IBindingSet> chunkedArrayIterator = new ChunkedArrayIterator<IBindingSet>(out);
                return chunkedArrayIterator;
            }
            finally {
                if (gasEngine != null) {
                    gasEngine.shutdownNow();
                    gasEngine = null;
                }
            }
        }

        private static IV[] toIV(Value[] values) {
            IV[] tmp = new IV[values.length];
            int i = 0;
            for (Value v : values) {
                tmp[i++] = ((BigdataValue)v).getIV();
            }
            return tmp;
        }

        private IGASEngine newGasEngine(IIndexManager indexManager, int nthreads) {
            return new BigdataGASEngine(indexManager, nthreads);
        }

        private IGASProgram<VS, ES, ST> newGASProgram(Class<IGASProgram<VS, ES, ST>> cls) {
            if (cls == null) {
                throw new IllegalArgumentException();
            }
            try {
                Constructor<IGASProgram<VS, ES, ST>> ctor = cls.getConstructor(new Class[0]);
                IGASProgram<VS, ES, ST> gasProgram = ctor.newInstance(new Object[0]);
                return gasProgram;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private IGraphAccessor newGraphAccessor(AbstractTripleStore kb) {
            BigdataGASEngine.BigdataGraphAccessor graphAccessor = new BigdataGASEngine.BigdataGraphAccessor(kb.getIndexManager(), kb.getNamespace(), kb.getIndexManager().getLastCommitTime());
            return graphAccessor;
        }

        public static class BindingSetReducer<VS, ES, ST>
        implements IReducer<VS, ES, ST, IBindingSet[]> {
            private final IVariable<?>[] outVars;
            private final AbstractTripleStore store;
            private final LexiconRelation lex;
            private final ValueFactory vf;
            private final List<IBinder<VS, ES, ST>> binderList;
            private final List<IBindingSet> tmp = new LinkedList<IBindingSet>();

            public BindingSetReducer(IVariable<?>[] outVars, AbstractTripleStore store, IGASProgram<VS, ES, ST> gasProgram, IGASContext<VS, ES, ST> ctx) {
                this.outVars = outVars;
                this.store = store;
                this.lex = store.getLexiconRelation();
                this.vf = store.getValueFactory();
                this.binderList = gasProgram.getBinderList();
            }

            @Override
            public void visit(IGASState<VS, ES, ST> state, Value u) {
                LinkedList<ListBindingSet> bSets = new LinkedList<ListBindingSet>();
                bSets.add(new ListBindingSet());
                for (IBinder<VS, ES, ST> b : this.binderList) {
                    IVariable<?> var = this.outVars[b.getIndex()];
                    if (var == null) continue;
                    Iterator it = bSets.iterator();
                    LinkedList<IBindingSet> bSets2 = new LinkedList<IBindingSet>();
                    while (it.hasNext()) {
                        List<Value> vals;
                        IBindingSet parent = (IBindingSet)it.next();
                        if (log.isTraceEnabled()) {
                            log.trace((Object)("parent: " + parent));
                        }
                        if ((vals = b.bind(this.vf, state, u, this.outVars, parent)).size() == 0) continue;
                        if (vals.size() == 1) {
                            Value val = vals.get(0);
                            this.bind(var, val, parent);
                            if (!log.isTraceEnabled()) continue;
                            log.trace((Object)("parent (after bind): " + parent));
                            continue;
                        }
                        for (Value val : vals) {
                            IBindingSet child = parent.clone();
                            this.bind(var, val, child);
                            if (log.isTraceEnabled()) {
                                log.trace((Object)("child: " + child));
                            }
                            bSets2.add(child);
                        }
                        it.remove();
                    }
                    bSets.addAll(bSets2);
                }
                this.tmp.addAll(bSets);
            }

            protected void bind(IVariable<?> var, Value val, IBindingSet bs) {
                if (val == null) {
                    return;
                }
                if (val instanceof IV) {
                    bs.set(var, new Constant<IV>((IV)val));
                } else {
                    IV iv = this.lex.getLexiconConfiguration().createInlineIV(val);
                    if (iv != null) {
                        iv.setValue((BigdataValueImpl)val);
                        bs.set(var, new Constant<IV>(iv));
                    } else if (val instanceof BigdataValue) {
                        bs.set(var, new Constant<IV>(DummyConstantNode.toDummyIV((BigdataValue)val)));
                    } else {
                        throw new RuntimeException("FIXME");
                    }
                }
            }

            @Override
            public IBindingSet[] get() {
                return this.tmp.toArray(new IBindingSet[this.tmp.size()]);
            }
        }
    }

    public static interface Options {
        public static final String NAMESPACE = "http://www.bigdata.com/rdf/gas#";
        public static final URI SERVICE_KEY = new URIImpl("http://www.bigdata.com/rdf/gas#service");
        public static final URI PROGRAM = new URIImpl("http://www.bigdata.com/rdf/gas#program");
        public static final URI GAS_CLASS = new URIImpl("http://www.bigdata.com/rdf/gas#gasClass");
        public static final URI NTHREADS = new URIImpl("http://www.bigdata.com/rdf/gas#nthreads");
        public static final int DEFAULT_NTHREADS = 4;
        public static final URI TRAVERSAL_DIRECTION = new URIImpl("http://www.bigdata.com/rdf/gas#traversalDirection");
        public static final TraversalDirectionEnum DEFAULT_DIRECTED_TRAVERSAL = TraversalDirectionEnum.Forward;
        public static final URI MAX_ITERATIONS = new URIImpl("http://www.bigdata.com/rdf/gas#maxIterations");
        public static final int DEFAULT_MAX_ITERATIONS = Integer.MAX_VALUE;
        public static final URI MAX_ITERATIONS_AFTER_TARGETS = new URIImpl("http://www.bigdata.com/rdf/gas#maxIterationsAfterTargets");
        public static final int DEFAULT_MAX_ITERATIONS_AFTER_TARGETS = Integer.MAX_VALUE;
        public static final URI MAX_VISITED = new URIImpl("http://www.bigdata.com/rdf/gas#maxVisited");
        public static final int DEFAULT_MAX_VISITED = Integer.MAX_VALUE;
        public static final URI LINK_TYPE = new URIImpl("http://www.bigdata.com/rdf/gas#linkType");
        public static final URI LINK_ATTR_TYPE = new URIImpl("http://www.bigdata.com/rdf/gas#linkAttrType");
        public static final URI SCHEDULER_CLASS = new URIImpl("http://www.bigdata.com/rdf/gas#schedulerClass");
        public static final Class<? extends IGASSchedulerImpl> DEFAULT_SCHEDULER = CHMScheduler.class;
        public static final URI IN = new URIImpl("http://www.bigdata.com/rdf/gas#in");
        public static final URI TARGET = new URIImpl("http://www.bigdata.com/rdf/gas#target");
        public static final URI OUT = new URIImpl("http://www.bigdata.com/rdf/gas#out");
        public static final URI OUT1 = new URIImpl("http://www.bigdata.com/rdf/gas#out1");
        public static final URI OUT2 = new URIImpl("http://www.bigdata.com/rdf/gas#out2");
        public static final URI OUT3 = new URIImpl("http://www.bigdata.com/rdf/gas#out3");
        public static final URI OUT4 = new URIImpl("http://www.bigdata.com/rdf/gas#out4");
        public static final URI OUT5 = new URIImpl("http://www.bigdata.com/rdf/gas#out5");
        public static final URI OUT6 = new URIImpl("http://www.bigdata.com/rdf/gas#out6");
        public static final URI OUT7 = new URIImpl("http://www.bigdata.com/rdf/gas#out7");
        public static final URI OUT8 = new URIImpl("http://www.bigdata.com/rdf/gas#out8");
        public static final URI OUT9 = new URIImpl("http://www.bigdata.com/rdf/gas#out9");
    }
}

