/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.graph.impl.util;

import com.bigdata.rdf.graph.impl.util.IArraySlice;
import com.bigdata.rdf.graph.impl.util.IManagedArray;
import cutthecrap.utils.striterators.ArrayIterator;
import java.lang.reflect.Array;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class ManagedArray<T>
implements IManagedArray<T> {
    private static final transient Logger log = Logger.getLogger(ManagedArray.class);
    public static final int DEFAULT_INITIAL_CAPACITY = 128;
    private final Class<? extends T> elementClass;
    private T[] buf;

    @Override
    public final T[] array() {
        return this.buf;
    }

    @Override
    public final int off() {
        return 0;
    }

    @Override
    public final int len() {
        return this.buf.length;
    }

    private T[] newArray(int capacity) {
        return (Object[])Array.newInstance(this.elementClass, capacity);
    }

    protected static int assertNonNegative(String msg, int v) {
        if (v < 0) {
            throw new IllegalArgumentException(msg);
        }
        return v;
    }

    public ManagedArray(Class<T> elementClass) {
        this(elementClass, 128);
    }

    public ManagedArray(Class<? extends T> elementClass, int initialCapacity) {
        if (elementClass == null) {
            throw new IllegalArgumentException();
        }
        this.elementClass = elementClass;
        this.buf = this.newArray(ManagedArray.assertNonNegative("initialCapacity", initialCapacity));
    }

    public ManagedArray(T[] array) {
        if (array == null) {
            throw new IllegalArgumentException();
        }
        this.elementClass = array.getClass().getComponentType();
        this.buf = array;
    }

    public final String toString() {
        return this.getClass().getName() + "{capacity=" + this.capacity() + "}";
    }

    @Override
    public final void ensureCapacity(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        if (this.buf == null) {
            this.buf = this.newArray(capacity);
            return;
        }
        int overflow = capacity - this.buf.length;
        if (overflow > 0) {
            T[] tmp = this.newArray(this.extend(capacity));
            System.arraycopy(this.buf, 0, tmp, 0, this.buf.length);
            this.buf = tmp;
        }
    }

    @Override
    public final int capacity() {
        return this.buf == null ? 0 : this.buf.length;
    }

    private int extend(int required) {
        int capacity = Math.max(required, this.capacity() * 2);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Extending buffer to capacity=" + capacity + " bytes."));
        }
        return capacity;
    }

    @Override
    public Iterator<T> iterator() {
        return new ArrayIterator<T>(this.array(), this.off(), this.len());
    }

    @Override
    public final void put(int pos, T[] b) {
        this.put(pos, b, 0, b.length);
    }

    @Override
    public final void put(int pos, T[] b, int off, int len) {
        this.ensureCapacity(pos + len);
        System.arraycopy(b, off, this.buf, pos, len);
    }

    @Override
    public final void get(int srcoff, T[] dst) {
        this.get(srcoff, dst, 0, dst.length);
    }

    @Override
    public final void get(int srcoff, T[] dst, int dstoff, int dstlen) {
        System.arraycopy(this.buf, srcoff, dst, dstoff, dstlen);
    }

    @Override
    public final void put(int pos, T v) {
        if (pos + 1 > this.buf.length) {
            this.ensureCapacity(pos + 1);
        }
        this.buf[pos] = v;
    }

    @Override
    public final T get(int pos) {
        return this.buf[pos];
    }

    @Override
    public final T[] toArray() {
        T[] tmp = this.newArray(this.buf.length);
        System.arraycopy(this.buf, 0, tmp, 0, this.buf.length);
        return tmp;
    }

    @Override
    public IArraySlice<T> slice(int off, int len) {
        return new SliceImpl(off, len);
    }

    private class SliceImpl
    implements IArraySlice<T> {
        private final int off;
        private final int len;

        @Override
        public final int off() {
            return this.off;
        }

        @Override
        public final int len() {
            return this.len;
        }

        protected SliceImpl(int off, int len) {
            if (off < 0) {
                throw new IllegalArgumentException("off<0");
            }
            if (len < 0) {
                throw new IllegalArgumentException("len<0");
            }
            this.off = off;
            this.len = len;
        }

        public String toString() {
            return super.toString() + "{off=" + this.off() + ",len=" + this.len() + "}";
        }

        @Override
        public T[] array() {
            return ManagedArray.this.array();
        }

        private boolean rangeCheck(int aoff, int alen) {
            if (aoff < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (alen < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (aoff + alen > this.len) {
                throw new IndexOutOfBoundsException();
            }
            return true;
        }

        @Override
        public final void put(int pos, T[] b) {
            this.put(pos, b, 0, b.length);
        }

        @Override
        public final void put(int dstoff, T[] src, int srcoff, int srclen) {
            assert (this.rangeCheck(dstoff, srclen));
            System.arraycopy(src, srcoff, this.array(), this.off + dstoff, srclen);
        }

        @Override
        public final void get(int srcoff, T[] dst) {
            this.get(srcoff, dst, 0, dst.length);
        }

        @Override
        public final void get(int srcoff, T[] dst, int dstoff, int dstlen) {
            assert (this.rangeCheck(srcoff, dstlen));
            System.arraycopy(this.array(), this.off + srcoff, dst, dstoff, dstlen);
        }

        @Override
        public final void put(int pos, T v) {
            assert (this.rangeCheck(pos, 1));
            this.array()[pos] = v;
        }

        @Override
        public final T get(int pos) {
            assert (this.rangeCheck(pos, 1));
            Object v = this.array()[pos];
            return v;
        }

        @Override
        public final T[] toArray() {
            Object[] tmp = ManagedArray.this.newArray(this.len);
            System.arraycopy(this.array(), this.off, tmp, 0, this.len);
            return tmp;
        }

        @Override
        public IArraySlice<T> slice(int aoff, int alen) {
            final ManagedArray outer = ManagedArray.this;
            assert (this.rangeCheck(aoff, alen));
            return new SliceImpl(this.off() + aoff, alen){

                @Override
                public T[] array() {
                    return outer.array();
                }
            };
        }

        @Override
        public Iterator<T> iterator() {
            return new ArrayIterator(this.array(), this.off(), this.len());
        }
    }
}

