/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.inf;

import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.spo.SPOFilter;
import com.bigdata.rdf.vocab.Vocabulary;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;

public class RdfTypeRdfsResourceFilter<E extends ISPO>
extends SPOFilter<E>
implements Externalizable {
    private static final long serialVersionUID = -2157234197316632000L;
    private IV rdfType;
    private IV rdfsResource;
    private static final transient short VERSION0 = 0;
    private static final transient short VERSION = 0;

    public RdfTypeRdfsResourceFilter() {
    }

    public RdfTypeRdfsResourceFilter(Vocabulary vocab) {
        this.rdfType = vocab.get((Value)RDF.TYPE);
        this.rdfsResource = vocab.get((Value)RDFS.RESOURCE);
    }

    @Override
    public boolean isValid(Object o) {
        if (!this.canAccept(o)) {
            return true;
        }
        return this.accept((ISPO)o);
    }

    private boolean accept(ISPO spo) {
        return spo.p().equals(this.rdfType) && spo.o().equals(this.rdfsResource);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        short version = in.readShort();
        switch (version) {
            case 0: {
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown version: " + version);
            }
        }
        this.rdfType = (IV)in.readObject();
        this.rdfsResource = (IV)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeShort(0);
        out.writeObject(this.rdfType);
        out.writeObject(this.rdfsResource);
    }
}

