/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal;

import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.impl.literal.AbstractLiteralIV;
import com.bigdata.rdf.internal.impl.uri.URIExtensionIV;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.vocab.Vocabulary;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;

public abstract class InlineURIHandler {
    protected final String namespace;
    protected final int len;
    protected transient IV namespaceIV;

    public InlineURIHandler(String namespace) {
        this.namespace = namespace;
        this.len = namespace.length();
    }

    public void init(Vocabulary vocab) {
        this.namespaceIV = vocab.get((Value)new URIImpl(this.namespace));
    }

    public String getNamespace() {
        return this.namespace;
    }

    protected URIExtensionIV createInlineIV(URI uri) {
        String localName;
        AbstractLiteralIV localNameIV;
        if (this.namespaceIV == null) {
            return null;
        }
        if (uri.stringValue().startsWith(this.namespace) && (localNameIV = this.createInlineIV(localName = uri.stringValue().substring(this.len))) != null) {
            return new URIExtensionIV(localNameIV, this.namespaceIV);
        }
        return null;
    }

    public String getLocalNameFromDelegate(AbstractLiteralIV<BigdataLiteral, ?> delegate) {
        return delegate.getInlineValue().toString();
    }

    protected abstract AbstractLiteralIV createInlineIV(String var1);
}

