/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal;

import com.bigdata.rdf.internal.DTE;
import com.bigdata.rdf.internal.IDatatypeURIResolver;
import com.bigdata.rdf.internal.IExtension;
import com.bigdata.rdf.internal.IExtensionFactory;
import com.bigdata.rdf.internal.IInlineURIFactory;
import com.bigdata.rdf.internal.ILexiconConfiguration;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.VTE;
import com.bigdata.rdf.internal.impl.AbstractInlineIV;
import com.bigdata.rdf.internal.impl.bnode.FullyInlineUnicodeBNodeIV;
import com.bigdata.rdf.internal.impl.bnode.NumericBNodeIV;
import com.bigdata.rdf.internal.impl.bnode.UUIDBNodeIV;
import com.bigdata.rdf.internal.impl.literal.AbstractLiteralIV;
import com.bigdata.rdf.internal.impl.literal.FullyInlineTypedLiteralIV;
import com.bigdata.rdf.internal.impl.literal.LiteralExtensionIV;
import com.bigdata.rdf.internal.impl.literal.UUIDLiteralIV;
import com.bigdata.rdf.internal.impl.literal.XSDBooleanIV;
import com.bigdata.rdf.internal.impl.literal.XSDDecimalIV;
import com.bigdata.rdf.internal.impl.literal.XSDIntegerIV;
import com.bigdata.rdf.internal.impl.literal.XSDNumericIV;
import com.bigdata.rdf.internal.impl.literal.XSDUnsignedByteIV;
import com.bigdata.rdf.internal.impl.literal.XSDUnsignedIntIV;
import com.bigdata.rdf.internal.impl.literal.XSDUnsignedLongIV;
import com.bigdata.rdf.internal.impl.literal.XSDUnsignedShortIV;
import com.bigdata.rdf.internal.impl.uri.FullyInlineURIIV;
import com.bigdata.rdf.internal.impl.uri.IPv4AddrIV;
import com.bigdata.rdf.internal.impl.uri.URIExtensionIV;
import com.bigdata.rdf.model.BigdataBNode;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataResource;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.model.BigdataValueSerializer;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.vocab.Vocabulary;
import com.bigdata.util.InnerCause;
import java.math.BigInteger;
import java.net.UnknownHostException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.datatypes.XMLDatatypeUtil;
import org.openrdf.model.impl.URIImpl;

public class LexiconConfiguration<V extends BigdataValue>
implements ILexiconConfiguration<V> {
    private static final Logger log = Logger.getLogger(LexiconConfiguration.class);
    private final int blobsThreshold;
    private final long MAX_UNSIGNED_BYTE = 256L;
    private final long MAX_UNSIGNED_SHORT = 65536L;
    private final long MAX_UNSIGNED_INT = 0x100000000L;
    private final BigInteger MAX_UNSIGNED_LONG = BigInteger.valueOf(0x200000000L).multiply(BigInteger.valueOf(0x200000000L).subtract(BigInteger.valueOf(1L)));
    private final boolean inlineXSDDatatypeLiterals;
    private final boolean inlineTextLiterals;
    private final int maxInlineTextLength;
    private final boolean inlineBNodes;
    private final boolean inlineDateTimes;
    private final TimeZone inlineDateTimesTimeZone;
    final boolean rejectInvalidXSDValues;
    private final IExtensionFactory xFactory;
    private final Vocabulary vocab;
    private final BigdataValueFactory valueFactory;
    private final IInlineURIFactory uriFactory;
    private final Map<IV, IExtension<BigdataValue>> iv2ext;
    private final Map<String, IExtension<BigdataValue>> datatype2ext;

    @Override
    public final BigdataValueFactory getValueFactory() {
        return this.valueFactory;
    }

    @Override
    public int getMaxInlineStringLength() {
        return this.maxInlineTextLength;
    }

    @Override
    public boolean isInlineTextLiterals() {
        return this.inlineTextLiterals;
    }

    @Override
    public boolean isInlineLiterals() {
        return this.inlineXSDDatatypeLiterals;
    }

    @Override
    public boolean isInlineDateTimes() {
        return this.inlineDateTimes;
    }

    @Override
    public TimeZone getInlineDateTimesTimeZone() {
        return this.inlineDateTimesTimeZone;
    }

    @Override
    public int getBlobsThreshold() {
        return this.blobsThreshold;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append("{ " + AbstractTripleStore.Options.BLOBS_THRESHOLD + "=" + this.blobsThreshold);
        sb.append(", " + AbstractTripleStore.Options.INLINE_XSD_DATATYPE_LITERALS + "=" + this.inlineXSDDatatypeLiterals);
        sb.append(", " + AbstractTripleStore.Options.INLINE_TEXT_LITERALS + "=" + this.inlineTextLiterals);
        sb.append(", " + AbstractTripleStore.Options.MAX_INLINE_TEXT_LENGTH + "=" + this.maxInlineTextLength);
        sb.append(", " + AbstractTripleStore.Options.INLINE_BNODES + "=" + this.inlineBNodes);
        sb.append(", " + AbstractTripleStore.Options.INLINE_DATE_TIMES + "=" + this.inlineDateTimes);
        sb.append(", " + AbstractTripleStore.Options.REJECT_INVALID_XSD_VALUES + "=" + this.rejectInvalidXSDValues);
        sb.append(", " + AbstractTripleStore.Options.EXTENSION_FACTORY_CLASS + "=" + this.xFactory.getClass().getName());
        sb.append(", " + AbstractTripleStore.Options.VOCABULARY_CLASS + "=" + this.vocab.getClass().getName());
        sb.append(", " + AbstractTripleStore.Options.INLINE_URI_FACTORY_CLASS + "=" + this.uriFactory.getClass().getName());
        sb.append("}");
        return sb.toString();
    }

    public LexiconConfiguration(int blobsThreshold, boolean inlineXSDDatatypeLiterals, boolean inlineTextLiterals, int maxInlineTextLength, boolean inlineBNodes, boolean inlineDateTimes, TimeZone inlineDateTimesTimeZone, boolean rejectInvalidXSDValues, IExtensionFactory xFactory, Vocabulary vocab, BigdataValueFactory valueFactory, IInlineURIFactory uriFactory) {
        if (blobsThreshold < 0) {
            throw new IllegalArgumentException();
        }
        if (maxInlineTextLength < 0) {
            throw new IllegalArgumentException();
        }
        if (vocab == null) {
            throw new IllegalArgumentException();
        }
        if (valueFactory == null) {
            throw new IllegalArgumentException();
        }
        this.blobsThreshold = blobsThreshold;
        this.inlineXSDDatatypeLiterals = inlineXSDDatatypeLiterals;
        this.inlineTextLiterals = inlineTextLiterals;
        this.maxInlineTextLength = maxInlineTextLength;
        this.inlineBNodes = inlineBNodes;
        this.inlineDateTimes = inlineDateTimes;
        this.inlineDateTimesTimeZone = inlineDateTimesTimeZone;
        this.rejectInvalidXSDValues = rejectInvalidXSDValues;
        this.xFactory = xFactory;
        this.vocab = vocab;
        this.valueFactory = valueFactory;
        this.uriFactory = uriFactory;
        this.iv2ext = new LinkedHashMap<IV, IExtension<BigdataValue>>();
        this.datatype2ext = new LinkedHashMap<String, IExtension<BigdataValue>>();
    }

    @Override
    public void initExtensions(IDatatypeURIResolver resolver) {
        this.xFactory.init(resolver, this);
        for (IExtension extension : this.xFactory.getExtensions()) {
            for (BigdataURI datatype : extension.getDatatypes()) {
                if (datatype == null) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("adding extension for: " + datatype));
                }
                if (this.iv2ext.containsKey(datatype.getIV())) {
                    log.warn((Object)("multiple IExtension implementations for: " + datatype));
                }
                this.iv2ext.put(datatype.getIV(), extension);
                this.datatype2ext.put(datatype.stringValue(), extension);
            }
        }
    }

    @Override
    public V asValue(LiteralExtensionIV<?> iv) {
        IV<BigdataURI, ?> datatypeIV = iv.getExtensionIV();
        IExtension<BigdataValue> ext = this.iv2ext.get(datatypeIV);
        if (ext == null) {
            throw new RuntimeException("Unknown extension: " + datatypeIV);
        }
        return (V)ext.asValue(iv, this.valueFactory);
    }

    @Override
    public V asValueFromVocab(IV<?, ?> iv) {
        return (V)((BigdataValue)this.vocab.asValue(iv));
    }

    @Override
    public IV createInlineIV(Value value) {
        IV<BigdataBNode, ?> tmp;
        IV<BigdataResource, Object> iv = value instanceof URI ? ((tmp = this.vocab.get(value)) != null ? tmp : this.createInlineURIIV((URI)value)) : (value instanceof Literal ? this.createInlineLiteralIV((Literal)value) : (value instanceof BNode ? this.createInlineBNodeIV((BNode)value) : null));
        if (iv != null && value instanceof BigdataValue) {
            ((BigdataValue)value).setIV(iv);
        }
        return iv;
    }

    private IV<BigdataURI, ?> createInlineURIIV(URI value) {
        String namespace;
        IV namespaceIV;
        URIExtensionIV<BigdataURI> inline = this.uriFactory.createInlineURIIV(value);
        if (inline != null) {
            return inline;
        }
        if (this.maxInlineTextLength == 0) {
            return null;
        }
        if (value.stringValue().length() <= this.maxInlineTextLength) {
            return new FullyInlineURIIV<BigdataURI>(value);
        }
        String localName = value.getLocalName();
        if (localName.length() < this.maxInlineTextLength && (namespaceIV = this.vocab.get((Value)new URIImpl(namespace = value.getNamespace()))) != null) {
            FullyInlineTypedLiteralIV<BigdataLiteral> localNameIV = new FullyInlineTypedLiteralIV<BigdataLiteral>(localName);
            return new URIExtensionIV<BigdataURI>(localNameIV, namespaceIV);
        }
        return null;
    }

    @Override
    public String getInlineURILocalNameFromDelegate(URI namespace, AbstractLiteralIV<BigdataLiteral, ?> delegate) {
        return this.uriFactory.getLocalNameFromDelegate(namespace, delegate);
    }

    private IV<BigdataLiteral, ?> createInlineLiteralIV(Literal value) {
        URI datatype = value.getDatatype();
        AbstractInlineIV<BigdataLiteral, ?> iv = null;
        if (datatype != null && this.datatype2ext.containsKey(datatype.stringValue()) && (iv = this.createExtensionIV(value, datatype)) != null) {
            return iv;
        }
        iv = this.createInlineDatatypeIV(value, datatype);
        if (iv != null) {
            return iv;
        }
        if (this.inlineTextLiterals && this.maxInlineTextLength > 0 && (iv = this.createInlineUnicodeLiteral(value)) != null) {
            return iv;
        }
        return null;
    }

    private AbstractInlineIV<BigdataLiteral, ?> createExtensionIV(Literal value, URI datatype) {
        IExtension<BigdataValue> xFactory = this.datatype2ext.get(datatype.stringValue());
        try {
            LiteralExtensionIV iv = xFactory.createIV((Value)value);
            return iv;
        }
        catch (Throwable t) {
            if (InnerCause.isInnerCause(t, InterruptedException.class)) {
                throw new RuntimeException(t);
            }
            if (InnerCause.isInnerCause(t, Error.class)) {
                throw new Error(t);
            }
            log.error((Object)(t.getMessage() + ": value=" + value.stringValue()));
            return null;
        }
    }

    private AbstractInlineIV<BigdataLiteral, ?> createInlineUnicodeLiteral(Literal value) {
        long totalLength;
        if (this.maxInlineTextLength > 0 && (totalLength = BigdataValueSerializer.getStringLength((Value)value)) <= (long)this.maxInlineTextLength) {
            return new FullyInlineTypedLiteralIV<BigdataLiteral>(value.getLabel(), value.getLanguage(), value.getDatatype());
        }
        return null;
    }

    private AbstractInlineIV<BigdataLiteral, ?> createInlineDatatypeIV(Literal value, URI datatype) {
        DTE dte = DTE.valueOf(datatype);
        if (dte == null) {
            return null;
        }
        if (!this.isInline(VTE.LITERAL, dte)) {
            return null;
        }
        String v = value.stringValue();
        try {
            switch (dte) {
                case XSDBoolean: {
                    return new XSDBooleanIV<BigdataLiteral>(XMLDatatypeUtil.parseBoolean((String)v));
                }
                case XSDByte: {
                    return new XSDNumericIV<BigdataLiteral>(XMLDatatypeUtil.parseByte((String)v));
                }
                case XSDShort: {
                    return new XSDNumericIV<BigdataLiteral>(XMLDatatypeUtil.parseShort((String)v));
                }
                case XSDInt: {
                    return new XSDNumericIV<BigdataLiteral>(XMLDatatypeUtil.parseInt((String)v));
                }
                case XSDLong: {
                    return new XSDNumericIV<BigdataLiteral>(XMLDatatypeUtil.parseLong((String)v));
                }
                case XSDFloat: {
                    return new XSDNumericIV<BigdataLiteral>(XMLDatatypeUtil.parseFloat((String)v));
                }
                case XSDDouble: {
                    return new XSDNumericIV<BigdataLiteral>(XMLDatatypeUtil.parseDouble((String)v));
                }
                case XSDInteger: {
                    return new XSDIntegerIV<BigdataLiteral>(XMLDatatypeUtil.parseInteger((String)v));
                }
                case XSDDecimal: {
                    return new XSDDecimalIV<BigdataLiteral>(XMLDatatypeUtil.parseDecimal((String)v));
                }
                case UUID: {
                    return new UUIDLiteralIV<BigdataLiteral>(UUID.fromString(v));
                }
                case XSDUnsignedByte: {
                    return new XSDUnsignedByteIV<BigdataLiteral>(this.parseUnsignedByte(v));
                }
                case XSDUnsignedShort: {
                    return new XSDUnsignedShortIV<BigdataLiteral>(this.parseUnsignedShort(v));
                }
                case XSDUnsignedInt: {
                    return new XSDUnsignedIntIV<BigdataLiteral>(this.parseUnsignedInt(v));
                }
                case XSDUnsignedLong: {
                    return new XSDUnsignedLongIV<BigdataLiteral>(this.parseUnsignedLong(v));
                }
                case Extension: {
                    return new IPv4AddrIV<BigdataLiteral>(v);
                }
            }
            return null;
        }
        catch (NumberFormatException ex) {
            if (this.rejectInvalidXSDValues) {
                throw new RuntimeException(ex + ": value=" + v, ex);
            }
            if (log.isInfoEnabled()) {
                log.warn((Object)("Value does not validate against datatype: " + value));
            }
            return null;
        }
        catch (UnknownHostException ex) {
            if (this.rejectInvalidXSDValues) {
                throw new RuntimeException(ex + ": value=" + v, ex);
            }
            if (log.isInfoEnabled()) {
                log.warn((Object)("Value does not validate against datatype: " + value));
            }
            return null;
        }
    }

    private byte parseUnsignedByte(String v) {
        short pv = XMLDatatypeUtil.parseShort((String)v);
        if (pv < 0 || (long)pv > 256L) {
            throw new NumberFormatException("Value out of range for unsigned byte");
        }
        pv = (short)(pv - 128);
        return (byte)pv;
    }

    private short parseUnsignedShort(String v) {
        int pv = XMLDatatypeUtil.parseInt((String)v);
        if (pv < 0 || (long)pv > 65536L) {
            throw new NumberFormatException("Value out of range for unsigned short");
        }
        return (short)(pv -= 32768);
    }

    private int parseUnsignedInt(String v) {
        long pv = XMLDatatypeUtil.parseLong((String)v);
        if (pv < 0L || pv > 0x100000000L) {
            throw new NumberFormatException("Value out of range for unsigned int");
        }
        return (int)(pv += Integer.MIN_VALUE);
    }

    private long parseUnsignedLong(String v) {
        BigInteger pv = XMLDatatypeUtil.parseInteger((String)v);
        if (pv.signum() == -1 || pv.compareTo(this.MAX_UNSIGNED_LONG) > 0) {
            throw new NumberFormatException("Value out of range for unsigned long");
        }
        return pv.subtract(BigInteger.valueOf(Long.MIN_VALUE)).longValue();
    }

    private IV<BigdataBNode, ?> createInlineBNodeIV(BNode value) {
        String id = value.getID();
        char c = id.charAt(0);
        if (c == 'u' && id.length() == 37 && this.isInline(VTE.BNODE, DTE.UUID)) {
            try {
                String subStr = id.substring(1);
                UUID uuid = UUID.fromString(subStr);
                if (uuid.toString().equals(subStr)) {
                    return new UUIDBNodeIV<BigdataBNode>(uuid);
                }
            }
            catch (Exception ex) {}
        } else if (c == 'i' && this.isInline(VTE.BNODE, DTE.XSDInt)) {
            try {
                String subStr = id.substring(1);
                Integer i = Integer.valueOf(subStr);
                if (i.toString().equals(subStr)) {
                    return new NumericBNodeIV<BigdataBNode>(i);
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (this.maxInlineTextLength > 0 && id.length() <= this.maxInlineTextLength) {
            return new FullyInlineUnicodeBNodeIV<BigdataBNode>(id);
        }
        return null;
    }

    private boolean isInline(VTE vte, DTE dte) {
        switch (vte) {
            case STATEMENT: {
                return true;
            }
            case BNODE: {
                return this.inlineBNodes && this.isSupported(dte);
            }
            case LITERAL: {
                return this.inlineXSDDatatypeLiterals && this.isSupported(dte);
            }
        }
        return false;
    }

    private boolean isSupported(DTE dte) {
        switch (dte) {
            case XSDBoolean: 
            case XSDByte: 
            case XSDShort: 
            case XSDInt: 
            case XSDLong: 
            case XSDFloat: 
            case XSDDouble: 
            case XSDInteger: 
            case XSDDecimal: 
            case UUID: 
            case Extension: {
                return true;
            }
            case XSDString: {
                return true;
            }
            case XSDUnsignedByte: 
            case XSDUnsignedShort: 
            case XSDUnsignedInt: 
            case XSDUnsignedLong: {
                return true;
            }
        }
        throw new AssertionError();
    }
}

