/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal.constraints;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IValueExpression;
import com.bigdata.bop.NV;
import com.bigdata.rdf.error.SparqlTypeErrorException;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.XSD;
import com.bigdata.rdf.internal.constraints.INeedsMaterialization;
import com.bigdata.rdf.internal.constraints.IVValueExpression;
import com.bigdata.rdf.model.BigdataBNode;
import com.bigdata.rdf.sparql.ast.GlobalAnnotations;
import java.util.Map;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;

public class BNodeBOp
extends IVValueExpression<IV>
implements INeedsMaterialization {
    private static final long serialVersionUID = -8448763718374010166L;

    public BNodeBOp(GlobalAnnotations globals) {
        super(globals, new NV[0]);
    }

    public BNodeBOp(IValueExpression<? extends IV> x, GlobalAnnotations globals) {
        this(new BOp[]{x}, BNodeBOp.anns(globals, new NV[0]));
    }

    public BNodeBOp(BOp[] args, Map<String, Object> anns) {
        super(args, anns);
        if (args.length != 1 || args[0] == null) {
            throw new IllegalArgumentException();
        }
    }

    public BNodeBOp(BNodeBOp op) {
        super(op);
    }

    @Override
    public INeedsMaterialization.Requirement getRequirement() {
        return INeedsMaterialization.Requirement.SOMETIMES;
    }

    @Override
    public IV get(IBindingSet bs) throws SparqlTypeErrorException {
        if (this.arity() == 0) {
            return super.asIV(this.getValueFactory().createBNode(), bs);
        }
        Literal lit = this.getAndCheckLiteralValue(0, bs);
        URI dt = lit.getDatatype();
        if (dt != null && !dt.stringValue().equals(XSD.STRING.stringValue())) {
            throw new SparqlTypeErrorException();
        }
        BigdataBNode bnode = this.getValueFactory().createBNode("-bnode-func-" + lit.getLabel());
        return super.asIV(bnode, bs);
    }
}

