/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal.constraints;

import com.bigdata.bop.BOp;
import com.bigdata.bop.Constant;
import com.bigdata.bop.IBind;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IValueExpression;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.ImmutableBOp;
import com.bigdata.bop.NV;
import com.bigdata.rdf.error.SparqlTypeErrorException;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.constraints.IPassesMaterialization;
import java.util.Map;

public class ConditionalBind<E extends IV>
extends ImmutableBOp
implements IValueExpression<E>,
IBind<E>,
IPassesMaterialization {
    private static final long serialVersionUID = 1L;
    protected transient Boolean projection;

    public ConditionalBind(ConditionalBind<E> op) {
        super(op);
    }

    public ConditionalBind(IVariable<E> var, IValueExpression<E> expr, boolean projection) {
        this(new BOp[]{var, expr}, NV.asMap(new NV(Annotations.PROJECTION, projection)));
        this.projection = projection;
    }

    public ConditionalBind(BOp[] args, Map<String, Object> annotations) {
        super(args, annotations);
        if (this.getProperty(Annotations.PROJECTION) == null) {
            throw new IllegalArgumentException();
        }
    }

    boolean isProjection() {
        if (this.projection == null) {
            this.projection = (Boolean)this.getRequiredProperty(Annotations.PROJECTION);
        }
        return this.projection;
    }

    @Override
    public IVariable<E> getVar() {
        return (IVariable)this.get(0);
    }

    @Override
    public IValueExpression<E> getExpr() {
        return (IValueExpression)this.get(1);
    }

    @Override
    public E get(IBindingSet bindingSet) {
        IVariable<E> var = this.getVar();
        IValueExpression<E> expr = this.getExpr();
        IV val = (IV)expr.get(bindingSet);
        IV existing = (IV)var.get(bindingSet);
        try {
            if (val == null) {
                throw new SparqlTypeErrorException.UnboundVarException();
            }
            if (existing == null) {
                bindingSet.set(var, new Constant<IV>(val));
                return (E)val;
            }
            return (E)(val.equals(existing) ? val : null);
        }
        catch (SparqlTypeErrorException typeError) {
            if (existing != null) {
                return null;
            }
            throw typeError;
        }
    }

    public static interface Annotations
    extends BOp.Annotations {
        public static final String PROJECTION = ConditionalBind.class.getName() + ".projection";
    }
}

