/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal.constraints;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IValueExpression;
import com.bigdata.rdf.error.SparqlTypeErrorException;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.constraints.INeedsMaterialization;
import com.bigdata.rdf.internal.constraints.XSDBooleanIVValueExpression;
import com.bigdata.rdf.internal.impl.literal.XSDBooleanIV;
import java.util.Map;
import org.openrdf.model.Value;
import org.openrdf.query.algebra.evaluation.ValueExprEvaluationException;
import org.openrdf.query.algebra.evaluation.util.QueryEvaluationUtil;

public class EBVBOp
extends XSDBooleanIVValueExpression
implements INeedsMaterialization {
    private static final long serialVersionUID = -5701967329003122236L;

    public EBVBOp(IValueExpression<? extends IV> x) {
        this(new BOp[]{x}, BOp.NOANNS);
    }

    public EBVBOp(BOp[] args, Map<String, Object> anns) {
        super(args, anns);
        if (args.length != 1 || args[0] == null) {
            throw new IllegalArgumentException();
        }
    }

    public EBVBOp(EBVBOp op) {
        super(op);
    }

    @Override
    public boolean accept(IBindingSet bs) {
        IV iv = this.getAndCheckBound(0, bs);
        if (iv instanceof XSDBooleanIV) {
            return ((XSDBooleanIV)iv).booleanValue();
        }
        Value val = XSDBooleanIVValueExpression.asValue(iv);
        try {
            return QueryEvaluationUtil.getEffectiveBooleanValue((Value)val);
        }
        catch (ValueExprEvaluationException ex) {
            throw new SparqlTypeErrorException();
        }
    }

    @Override
    public INeedsMaterialization.Requirement getRequirement() {
        return INeedsMaterialization.Requirement.SOMETIMES;
    }
}

