/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal.constraints;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IValueExpression;
import com.bigdata.bop.NV;
import com.bigdata.rdf.error.SparqlTypeErrorException;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.constraints.INeedsMaterialization;
import com.bigdata.rdf.internal.constraints.IVValueExpression;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.sparql.ast.GlobalAnnotations;
import java.util.Map;
import org.apache.log4j.Logger;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.query.algebra.evaluation.ValueExprEvaluationException;
import org.openrdf.query.algebra.evaluation.function.Function;
import org.openrdf.query.algebra.evaluation.function.FunctionRegistry;

public class FuncBOp
extends IVValueExpression<IV>
implements INeedsMaterialization {
    private static final long serialVersionUID = 2587499644967260639L;
    private static final transient Logger log = Logger.getLogger(FuncBOp.class);
    private volatile transient Function funct;

    public FuncBOp(IValueExpression<? extends IV>[] args, String func, GlobalAnnotations globals) {
        this(args, FuncBOp.anns(globals, new NV(Annotations.FUNCTION, func)));
    }

    public FuncBOp(BOp[] args, Map<String, Object> anns) {
        super(args, anns);
        if (this.getProperty(Annotations.NAMESPACE) == null) {
            throw new IllegalArgumentException();
        }
        if (this.getProperty(Annotations.FUNCTION) == null) {
            throw new IllegalArgumentException();
        }
    }

    private Function getFunc() {
        if (this.funct == null) {
            String funcName = (String)this.getRequiredProperty(Annotations.FUNCTION);
            this.funct = (Function)FunctionRegistry.getInstance().get((Object)funcName);
            if (this.funct == null) {
                throw new RuntimeException("Unknown function '" + funcName + "'");
            }
        }
        return this.funct;
    }

    public FuncBOp(FuncBOp op) {
        super(op);
    }

    @Override
    public IV get(IBindingSet bs) {
        Value val;
        Value[] vals = new Value[this.arity()];
        for (int i = 0; i < vals.length; ++i) {
            IV iv = this.getAndCheckBound(i, bs);
            val = FuncBOp.asValue(iv);
            if (log.isDebugEnabled()) {
                log.debug((Object)("iv: " + iv + ", class=" + iv.getClass()));
                log.debug((Object)("val: " + val + ", class=" + val.getClass()));
            }
            vals[i] = val;
        }
        Function func = this.getFunc();
        BigdataValueFactory vf = this.getValueFactory();
        try {
            val = func.evaluate((ValueFactory)vf, vals);
            IV iv = this.asIV(val, bs);
            if (log.isDebugEnabled()) {
                log.debug((Object)("val: " + val + ", class=" + val.getClass()));
                log.debug((Object)("iv: " + iv + ", class=" + iv.getClass()));
            }
            return iv;
        }
        catch (ValueExprEvaluationException ex) {
            throw new SparqlTypeErrorException();
        }
    }

    @Override
    public INeedsMaterialization.Requirement getRequirement() {
        return INeedsMaterialization.Requirement.SOMETIMES;
    }

    public static interface Annotations
    extends IVValueExpression.Annotations {
        public static final String FUNCTION = FuncBOp.class.getName() + ".function";
    }
}

