/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal.constraints;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IValueExpression;
import com.bigdata.rdf.error.SparqlTypeErrorException;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.constraints.InBOp;
import java.util.LinkedHashSet;
import java.util.Map;

public class InHashBOp
extends InBOp {
    private static final long serialVersionUID = 8032412126003678642L;
    private volatile transient IValueExpression<IV> valueExpr;
    private volatile transient LinkedHashSet<IV> set;
    private transient boolean not;

    public InHashBOp(InHashBOp op) {
        super(op);
    }

    public InHashBOp(BOp[] args, Map<String, Object> annotations) {
        super(args, annotations);
    }

    public InHashBOp(boolean not, IValueExpression<? extends IV> var, IConstant<? extends IV> ... set) {
        super(not, var, set);
    }

    private void init() {
        this.valueExpr = this.getValueExpression();
        IConstant<IV>[] a = this.getSet();
        this.set = new LinkedHashSet(a.length);
        for (IConstant<IV> IV2 : a) {
            IV val = (IV)IV2.get();
            this.set.add(val);
        }
        this.not = (Boolean)this.getProperty(InBOp.Annotations.NOT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean accept(IBindingSet bindingSet) {
        IV v;
        if (this.valueExpr == null || this.set == null) {
            InHashBOp inHashBOp = this;
            synchronized (inHashBOp) {
                if (this.valueExpr == null || this.set == null) {
                    this.init();
                }
            }
        }
        if ((v = this.valueExpr.get(bindingSet)) == null) {
            throw new SparqlTypeErrorException.UnboundVarException();
        }
        boolean found = this.set.contains(v);
        return this.not ? !found : found;
    }
}

