/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal.constraints;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IValueExpression;
import com.bigdata.bop.NV;
import com.bigdata.rdf.error.SparqlTypeErrorException;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.XSD;
import com.bigdata.rdf.internal.constraints.INeedsMaterialization;
import com.bigdata.rdf.internal.constraints.IVValueExpression;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.sparql.ast.GlobalAnnotations;
import java.util.Map;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;

public class IriBOp
extends IVValueExpression<IV>
implements INeedsMaterialization {
    private static final long serialVersionUID = -8448763718374010166L;

    public IriBOp(IValueExpression<? extends IV> x, String baseURI, GlobalAnnotations globals) {
        super(x, globals, new NV(Annotations.BASE_URI, baseURI));
    }

    public IriBOp(BOp[] args, Map<String, Object> anns) {
        super(args, anns);
        if (args.length != 1 || args[0] == null) {
            throw new IllegalArgumentException();
        }
    }

    public IriBOp(IriBOp op) {
        super(op);
    }

    @Override
    public INeedsMaterialization.Requirement getRequirement() {
        return INeedsMaterialization.Requirement.SOMETIMES;
    }

    @Override
    public IV get(IBindingSet bs) throws SparqlTypeErrorException {
        IV iv = this.getAndCheckBound(0, bs);
        if (iv.isURI()) {
            return iv;
        }
        if (!iv.isLiteral()) {
            throw new SparqlTypeErrorException();
        }
        String baseURI = this.getProperty(Annotations.BASE_URI, "");
        Literal lit = IriBOp.asLiteral(iv);
        URI dt = lit.getDatatype();
        if (dt != null && !dt.stringValue().equals(XSD.STRING.stringValue())) {
            throw new SparqlTypeErrorException();
        }
        BigdataURI uri = null;
        try {
            uri = this.getValueFactory().createURI(lit.getLabel());
        }
        catch (IllegalArgumentException e) {
            try {
                uri = this.getValueFactory().createURI(baseURI, lit.getLabel());
            }
            catch (IllegalArgumentException e1) {
                throw new SparqlTypeErrorException();
            }
        }
        return super.asIV(uri, bs);
    }

    public static interface Annotations
    extends BOp.Annotations {
        public static final String BASE_URI = (IriBOp.class.getName() + ".baseURI").intern();
    }
}

