/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal.constraints;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IValueExpression;
import com.bigdata.bop.constraint.Constraint;
import com.bigdata.rdf.error.SparqlTypeErrorException;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.constraints.EBVBOp;
import com.bigdata.rdf.internal.constraints.XSDBooleanIVValueExpression;
import com.bigdata.rdf.internal.impl.literal.XSDBooleanIV;
import com.bigdata.util.InnerCause;
import java.util.Map;
import org.apache.log4j.Logger;

public class SPARQLConstraint<X extends XSDBooleanIV>
extends Constraint<X> {
    private static final long serialVersionUID = -5796492538735372727L;
    private static final transient Logger log = Logger.getLogger(SPARQLConstraint.class);

    private static XSDBooleanIVValueExpression wrap(IValueExpression<? extends IV> ve) {
        return ve instanceof XSDBooleanIVValueExpression ? (XSDBooleanIVValueExpression)ve : new EBVBOp(ve);
    }

    public SPARQLConstraint(IValueExpression<? extends IV> x) {
        this(new BOp[]{SPARQLConstraint.wrap(x)}, null);
    }

    public SPARQLConstraint(BOp[] args, Map<String, Object> anns) {
        super(args, anns);
        if (args.length != 1 || args[0] == null) {
            throw new IllegalArgumentException();
        }
    }

    public SPARQLConstraint(SPARQLConstraint<X> op) {
        super(op);
    }

    @Override
    public IValueExpression<? extends XSDBooleanIV> get(int i) {
        return (IValueExpression)super.get(i);
    }

    @Override
    public boolean accept(IBindingSet bs) {
        try {
            XSDBooleanIV iv = (XSDBooleanIV)this.get(0).get(bs);
            return iv.booleanValue();
        }
        catch (Throwable t) {
            if (InnerCause.isInnerCause(t, SparqlTypeErrorException.class)) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("discarding solution due to type error: " + bs + " : " + t));
                }
                return false;
            }
            throw new RuntimeException(t);
        }
    }

    @Override
    public String toShortString() {
        return super.toShortString() + "{condition=" + this.getValueExpression().toShortString() + "}";
    }
}

