/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal.encoder;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.IndexAnnotations;
import com.bigdata.bop.ap.Predicate;
import com.bigdata.btree.BTree;
import com.bigdata.btree.BloomFilterFactory;
import com.bigdata.btree.Checkpoint;
import com.bigdata.btree.IndexMetadata;
import com.bigdata.btree.Tuple;
import com.bigdata.btree.keys.ASCIIKeyBuilderFactory;
import com.bigdata.btree.keys.IKeyBuilder;
import com.bigdata.btree.raba.codec.FrontCodedRabaCoder;
import com.bigdata.btree.raba.codec.SimpleRabaCoder;
import com.bigdata.rawstore.IRawStore;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.IVUtility;
import com.bigdata.rdf.internal.encoder.IVBindingSetEncoder;
import com.bigdata.rdf.internal.impl.BlobIV;
import com.bigdata.rdf.lexicon.BlobsIndexHelper;
import com.bigdata.rdf.lexicon.BlobsTupleSerializer;
import com.bigdata.rdf.lexicon.Id2TermTupleSerializer;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.model.BigdataValueFactoryImpl;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;

public class IVBindingSetEncoderWithIVCache
extends IVBindingSetEncoder {
    private final String namespace;
    private final BigdataValueFactory valueFactory;
    private final AtomicReference<BTree> ivCache = new AtomicReference();
    private final AtomicReference<BTree> blobsCache = new AtomicReference();

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("{namespace=" + this.namespace);
        if (this.ivCache.get() != null) {
            sb.append(",ivCacheSize=" + this.getIVCacheSize());
        }
        if (this.blobsCache.get() != null) {
            sb.append(",blobCacheSize=" + this.getBlobsCacheSize());
        }
        sb.append("}");
        return sb.toString();
    }

    private long getIVCacheSize() {
        BTree ndx = this.ivCache.get();
        if (ndx != null) {
            return ndx.getEntryCount();
        }
        return 0L;
    }

    private long getBlobsCacheSize() {
        BTree ndx = this.blobsCache.get();
        if (ndx != null) {
            return ndx.getEntryCount();
        }
        return 0L;
    }

    private IndexMetadata getIVCacheIndexMetadata(BOp op) {
        IndexMetadata metadata = new IndexMetadata(UUID.randomUUID());
        int branchingFactor = 256;
        int ratio = 32;
        metadata.setBranchingFactor(256);
        metadata.setWriteRetentionQueueCapacity(op.getProperty(IndexAnnotations.WRITE_RETENTION_QUEUE_CAPACITY, 4000));
        metadata.setTupleSerializer(new Id2TermTupleSerializer(this.namespace, this.valueFactory, new ASCIIKeyBuilderFactory(8), new FrontCodedRabaCoder(32), SimpleRabaCoder.INSTANCE));
        metadata.setBloomFilterFactory(BloomFilterFactory.DEFAULT);
        metadata.setRawRecords(true);
        metadata.setMaxRecLen(16);
        return metadata;
    }

    private IndexMetadata getBlobsCacheIndexMetadata(BOp op) {
        IndexMetadata metadata = new IndexMetadata(UUID.randomUUID());
        metadata.setTupleSerializer(new BlobsTupleSerializer(this.namespace, this.valueFactory));
        metadata.setRawRecords(true);
        metadata.setMaxRecLen(0);
        int branchingFactor = 256;
        metadata.setBranchingFactor(256);
        metadata.setWriteRetentionQueueCapacity(op.getProperty(IndexAnnotations.WRITE_RETENTION_QUEUE_CAPACITY, 4000));
        metadata.setBloomFilterFactory(BloomFilterFactory.DEFAULT);
        return metadata;
    }

    public IVBindingSetEncoderWithIVCache(IRawStore store, boolean filter, BOp op) {
        super(filter);
        if (!filter) {
            this.namespace = ((String[])op.getRequiredProperty(Predicate.Annotations.RELATION_NAME))[0];
            this.valueFactory = BigdataValueFactoryImpl.getInstance(this.namespace);
            this.ivCache.set(BTree.create(store, this.getIVCacheIndexMetadata(op)));
            this.blobsCache.set(BTree.create(store, this.getBlobsCacheIndexMetadata(op)));
        } else {
            this.namespace = null;
            this.valueFactory = null;
        }
    }

    @Override
    public boolean isValueCache() {
        return !this.filter;
    }

    public void saveSolutionSet() {
        this.flush();
        this.checkpointBTree(this.ivCache);
        this.checkpointBTree(this.blobsCache);
    }

    private void checkpointBTree(AtomicReference<BTree> ref) {
        BTree tmp = ref.get();
        if (tmp != null) {
            Checkpoint checkpoint = tmp.writeCheckpoint2();
            BTree readOnly = BTree.load(tmp.getStore(), checkpoint.getCheckpointAddr(), true);
            if (!ref.compareAndSet(tmp, readOnly)) {
                throw new IllegalStateException();
            }
        }
    }

    @Override
    public void release() {
        BTree tmp2 = this.ivCache.getAndSet(null);
        if (tmp2 != null) {
            tmp2.close();
        }
        if ((tmp2 = (BTree)this.blobsCache.getAndSet(null)) != null) {
            tmp2.close();
        }
        super.release();
    }

    @Override
    public void flush() {
        if (this.filter) {
            super.flush();
            return;
        }
        BTree ivCache = this.ivCache.get();
        BTree blobsCache = this.blobsCache.get();
        BlobsIndexHelper h = null;
        Id2TermTupleSerializer tupSer = (Id2TermTupleSerializer)ivCache.getIndexMetadata().getTupleSerializer();
        for (Map.Entry e : this.cache.entrySet()) {
            IV iv = (IV)e.getKey();
            BigdataValue value = (BigdataValue)e.getValue();
            if (iv instanceof BlobIV) {
                if (h == null) {
                    h = new BlobsIndexHelper();
                }
                IKeyBuilder keyBuilder = h.newKeyBuilder();
                byte[] key = iv.encode(keyBuilder.reset()).getKey();
                byte[] val = this.valueFactory.getValueSerializer().serialize(value);
                if (blobsCache.contains(key)) continue;
                blobsCache.insert(key, val);
                continue;
            }
            byte[] key = tupSer.serializeKey(iv);
            if (ivCache.contains(key)) continue;
            ivCache.insert(key, tupSer.serializeVal(value));
        }
        super.flush();
    }

    @Override
    public void resolveCachedValues(IBindingSet bset) {
        BTree ivCache = this.ivCache.get();
        BTree blobsCache = this.blobsCache.get();
        if (!(ivCache != null && ivCache.getEntryCount() != 0L || blobsCache != null && blobsCache.getEntryCount() != 0L)) {
            return;
        }
        Id2TermTupleSerializer tupSer = (Id2TermTupleSerializer)ivCache.getIndexMetadata().getTupleSerializer();
        IKeyBuilder keyBuilder = tupSer.getKeyBuilder();
        Tuple ivCacheTuple = new Tuple(ivCache, 3);
        BlobsIndexHelper h = null;
        Iterator<Map.Entry<IVariable, IConstant>> itr = bset.iterator();
        while (itr.hasNext()) {
            IV iv;
            Map.Entry<IVariable, IConstant> e = itr.next();
            IVariable v = e.getKey();
            if (!this.ivCacheSchema.contains(v) || (iv = (IV)e.getValue().get()).hasValue()) continue;
            keyBuilder.reset();
            if (iv instanceof BlobIV) {
                byte[] val;
                BlobIV blobIV = (BlobIV)iv;
                if (h == null) {
                    h = new BlobsIndexHelper();
                }
                if ((val = h.lookup(blobsCache, blobIV, keyBuilder)) == null) continue;
                BigdataValue value = this.valueFactory.getValueSerializer().deserialize(val);
                iv.setValue(value);
                continue;
            }
            IVUtility.encode(keyBuilder, iv);
            byte[] key = keyBuilder.getKey();
            if (ivCache.lookup(key, ivCacheTuple) == null) continue;
            BigdataValue value = tupSer.deserialize(ivCacheTuple);
            iv.setValue(value);
        }
    }
}

