/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal.impl;

import com.bigdata.btree.keys.IKeyBuilder;
import com.bigdata.rdf.internal.DTE;
import com.bigdata.rdf.internal.IExtensionIV;
import com.bigdata.rdf.internal.IInlineUnicode;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.IVUnicode;
import com.bigdata.rdf.internal.IVUtility;
import com.bigdata.rdf.internal.NotMaterializedException;
import com.bigdata.rdf.internal.VTE;
import com.bigdata.rdf.internal.impl.AbstractNonInlineExtensionIVWithDelegateIV;
import com.bigdata.rdf.internal.impl.bnode.FullyInlineUnicodeBNodeIV;
import com.bigdata.rdf.internal.impl.bnode.NumericBNodeIV;
import com.bigdata.rdf.internal.impl.literal.AbstractLiteralIV;
import com.bigdata.rdf.internal.impl.literal.FullyInlineTypedLiteralIV;
import com.bigdata.rdf.internal.impl.literal.LiteralExtensionIV;
import com.bigdata.rdf.internal.impl.literal.XSDUnsignedByteIV;
import com.bigdata.rdf.internal.impl.literal.XSDUnsignedIntIV;
import com.bigdata.rdf.internal.impl.literal.XSDUnsignedLongIV;
import com.bigdata.rdf.internal.impl.literal.XSDUnsignedShortIV;
import com.bigdata.rdf.internal.impl.uri.FullyInlineURIIV;
import com.bigdata.rdf.internal.impl.uri.URIExtensionIV;
import com.bigdata.rdf.internal.impl.uri.VocabURIByteIV;
import com.bigdata.rdf.internal.impl.uri.VocabURIShortIV;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataValue;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.UUID;

public abstract class AbstractIV<V extends BigdataValue, T>
implements IV<V, T> {
    private static final long serialVersionUID = 4710700756635103123L;
    protected final byte flags;
    private static final int VTE_SHIFT = 6;
    private static final int VTE_MASK = 192;
    private static final int INLINE_SHIFT = 5;
    private static final int INLINE_MASK = 32;
    private static final int EXTENSION_SHIFT = 4;
    private static final int EXTENSION_MASK = 16;
    private static final int DTE_MASK = 15;
    private volatile transient V cache = null;

    protected AbstractIV(VTE vte, boolean inline, boolean extension, DTE dte) {
        this(AbstractIV.toFlags(vte, inline, extension, dte));
    }

    public static byte toFlags(VTE vte, boolean inline, boolean extension, DTE dte) {
        return (byte)((vte.v() << 6 | (inline ? 1 : 0) << 5 | (extension ? 1 : 0) << 4 | dte.v()) & 0xFF);
    }

    protected AbstractIV(byte flags) {
        this.flags = flags;
    }

    @Override
    public final byte flags() {
        return this.flags;
    }

    public static boolean isInline(byte flags) {
        return (flags & 0x20) != 0;
    }

    public static boolean isExtension(byte flags) {
        return (flags & 0x10) != 0;
    }

    public static final VTE getVTE(byte flags) {
        return VTE.valueOf((byte)((flags & 0xC0) >>> 6 & 0xFF));
    }

    @Override
    public final VTE getVTE() {
        return AbstractIV.getVTE(this.flags);
    }

    @Override
    public final DTE getDTE() {
        return DTE.valueOf((byte)(this.flags & 0xF & 0xFF));
    }

    public static final VTE getInternalValueTypeEnum(byte flags) {
        return VTE.valueOf((byte)((flags & 0xC0) >>> 6 & 0xFF));
    }

    public static DTE getDTE(byte flags) {
        return DTE.valueOf((byte)(flags & 0xF & 0xFF));
    }

    @Override
    public final boolean isLiteral() {
        return (this.flags & 0xC0) >>> 6 == VTE.LITERAL.v();
    }

    @Override
    public final boolean isBNode() {
        return (this.flags & 0xC0) >>> 6 == VTE.BNODE.v();
    }

    @Override
    public final boolean isURI() {
        return (this.flags & 0xC0) >>> 6 == VTE.URI.v();
    }

    @Override
    public final boolean isStatement() {
        return (this.flags & 0xC0) >>> 6 == VTE.STATEMENT.v();
    }

    @Override
    public final boolean isResource() {
        return this.isURI() || this.isBNode();
    }

    @Override
    public boolean isInline() {
        return AbstractIV.isInline(this.flags);
    }

    @Override
    public boolean isExtension() {
        return AbstractIV.isExtension(this.flags);
    }

    @Override
    public boolean isVocabulary() {
        return false;
    }

    @Override
    public boolean isNullIV() {
        return false;
    }

    @Override
    public boolean isNumeric() {
        return this.isInline() && this.getDTE().isNumeric();
    }

    @Override
    public final boolean isSignedNumeric() {
        return this.isInline() && this.getDTE().isSignedNumeric();
    }

    @Override
    public final boolean isUnsignedNumeric() {
        return this.isInline() && this.getDTE().isUnsignedNumeric();
    }

    @Override
    public final boolean isFixedNumeric() {
        return this.isInline() && this.getDTE().isFixedNumeric();
    }

    @Override
    public final boolean isBigNumeric() {
        return this.isInline() && this.getDTE().isBigNumeric();
    }

    @Override
    public final boolean isFloatingPointNumeric() {
        return this.isInline() && this.getDTE().isFloatingPointNumeric();
    }

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    @Override
    public final int compareTo(IV o) {
        if (this == o) {
            return 0;
        }
        if (o == null) {
            return 1;
        }
        AbstractIV t = (AbstractIV)o;
        int ret = this.flags - t.flags;
        if (ret < 0) {
            return -1;
        }
        if (ret > 0) {
            return 1;
        }
        return this._compareTo(t);
    }

    public abstract int _compareTo(IV var1);

    @Override
    public IKeyBuilder encode(IKeyBuilder keyBuilder) {
        keyBuilder.appendSigned(this.flags);
        if (!this.isInline()) {
            if (this.isExtension()) {
                AbstractNonInlineExtensionIVWithDelegateIV t = (AbstractNonInlineExtensionIVWithDelegateIV)this;
                keyBuilder.appendSigned(t.getExtensionByte());
                IVUtility.encode(keyBuilder, t.getExtensionIV());
                IVUtility.encode(keyBuilder, t.getDelegate());
                return keyBuilder;
            }
            throw new AssertionError((Object)(this.getClass().getName() + ":" + this.toString()));
        }
        if (this.isURI()) {
            if (this.isExtension()) {
                URIExtensionIV extension = (URIExtensionIV)this;
                IVUtility.encode(keyBuilder, extension.getExtensionIV());
                IVUtility.encode(keyBuilder, extension.getLocalNameIV());
                return keyBuilder;
            }
            switch (this.getDTE()) {
                case XSDByte: {
                    keyBuilder.append(((VocabURIByteIV)this).byteValue());
                    break;
                }
                case XSDShort: {
                    keyBuilder.append(((VocabURIShortIV)this).getInlineValue());
                    break;
                }
                case XSDString: {
                    FullyInlineURIIV iv = (FullyInlineURIIV)this;
                    String uriString = iv.getInlineValue().stringValue();
                    byte[] b = IVUnicode.encode1(uriString);
                    keyBuilder.append(b);
                    iv.setByteLength(1 + b.length);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("dte=" + (Object)((Object)this.getDTE()));
                }
            }
            return keyBuilder;
        }
        if (this.isBNode()) {
            switch (this.getDTE()) {
                case XSDInt: {
                    keyBuilder.append(((NumericBNodeIV)this).intValue());
                    break;
                }
                case UUID: {
                    keyBuilder.append((UUID)this.getInlineValue());
                    break;
                }
                case XSDString: {
                    FullyInlineUnicodeBNodeIV iv = (FullyInlineUnicodeBNodeIV)this;
                    byte[] b = IVUnicode.encode1(iv.getInlineValue());
                    keyBuilder.append(b);
                    iv.setByteLength(1 + b.length);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("dte=" + (Object)((Object)this.getDTE()));
                }
            }
            return keyBuilder;
        }
        DTE dte = this.getDTE();
        assert (this.getVTE() == VTE.LITERAL);
        if (this.isExtension()) {
            IExtensionIV extension = (IExtensionIV)((Object)this);
            IVUtility.encode(keyBuilder, extension.getExtensionIV());
        }
        AbstractLiteralIV<BigdataLiteral, ?> t = this.isExtension() ? ((LiteralExtensionIV)this).getDelegate() : (AbstractLiteralIV<BigdataLiteral, ?>)this;
        switch (dte) {
            case XSDBoolean: {
                keyBuilder.appendSigned((byte)(t.booleanValue() ? 1 : 0));
                break;
            }
            case XSDByte: {
                keyBuilder.appendSigned(t.byteValue());
                break;
            }
            case XSDShort: {
                keyBuilder.append(t.shortValue());
                break;
            }
            case XSDInt: {
                keyBuilder.append(t.intValue());
                break;
            }
            case XSDLong: {
                keyBuilder.append(t.longValue());
                break;
            }
            case XSDFloat: {
                keyBuilder.append(t.floatValue());
                break;
            }
            case XSDDouble: {
                keyBuilder.append(t.doubleValue());
                break;
            }
            case XSDInteger: {
                keyBuilder.append(t.integerValue());
                break;
            }
            case XSDDecimal: {
                keyBuilder.append(t.decimalValue());
                break;
            }
            case UUID: {
                keyBuilder.append((UUID)t.getInlineValue());
                break;
            }
            case XSDUnsignedByte: {
                keyBuilder.appendSigned(((XSDUnsignedByteIV)t).rawValue());
                break;
            }
            case XSDUnsignedShort: {
                keyBuilder.append(((XSDUnsignedShortIV)t).rawValue());
                break;
            }
            case XSDUnsignedInt: {
                keyBuilder.append(((XSDUnsignedIntIV)t).rawValue());
                break;
            }
            case XSDUnsignedLong: {
                keyBuilder.append(((XSDUnsignedLongIV)t).rawValue());
                break;
            }
            case XSDString: {
                if (this instanceof FullyInlineTypedLiteralIV) {
                    FullyInlineTypedLiteralIV iv = (FullyInlineTypedLiteralIV)this;
                    int pos0 = keyBuilder.len();
                    keyBuilder.append(iv.getTermCode());
                    if (iv.getLanguage() != null) {
                        keyBuilder.append(IVUnicode.encode1(iv.getLanguage()));
                    } else if (iv.getDatatype() != null) {
                        keyBuilder.append(IVUnicode.encode1(iv.getDatatype().stringValue()));
                    }
                    keyBuilder.append(IVUnicode.encode1(iv.getLabel()));
                    int len = keyBuilder.len() - pos0;
                    iv.setByteLength(1 + len);
                    return keyBuilder;
                }
                keyBuilder.append((byte)2);
                byte[] b = IVUnicode.encode1((String)t.getInlineValue());
                keyBuilder.append(b);
                ((IInlineUnicode)((Object)t)).setByteLength(2 + b.length);
                return keyBuilder;
            }
            default: {
                throw new AssertionError((Object)this.toString());
            }
        }
        return keyBuilder;
    }

    @Override
    public final V getValue() {
        V v = this.cache;
        if (v == null) {
            throw new NotMaterializedException(this.toString());
        }
        return v;
    }

    @Override
    public final V setValue(V v) {
        this.cache = v;
        return this.cache;
    }

    protected final V getValueCache() {
        return this.cache;
    }

    @Override
    public final boolean hasValue() {
        return this.cache != null;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.getValueCache());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        BigdataValue v = (BigdataValue)in.readObject();
        if (v != null) {
            this.setValue(v);
        }
    }
}

