/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal.impl.extensions;

import com.bigdata.rdf.internal.IDatatypeURIResolver;
import com.bigdata.rdf.internal.IExtension;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.XSD;
import com.bigdata.rdf.internal.impl.literal.LiteralExtensionIV;
import com.bigdata.rdf.internal.impl.literal.XSDIntegerIV;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import java.math.BigInteger;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.datatypes.XMLDatatypeUtil;

public class DerivedNumericsExtension<V extends BigdataValue>
implements IExtension<V> {
    private static final transient Logger log = Logger.getLogger(DerivedNumericsExtension.class);
    private final Map<IV, BigdataURI> datatypes = new LinkedHashMap<IV, BigdataURI>();

    public DerivedNumericsExtension(IDatatypeURIResolver resolver) {
        this.resolve(resolver, XSD.POSITIVE_INTEGER);
        this.resolve(resolver, XSD.NEGATIVE_INTEGER);
        this.resolve(resolver, XSD.NON_POSITIVE_INTEGER);
        this.resolve(resolver, XSD.NON_NEGATIVE_INTEGER);
    }

    private void resolve(IDatatypeURIResolver resolver, URI uri) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("resolving: " + uri));
        }
        BigdataURI val = resolver.resolve(uri);
        this.datatypes.put(val.getIV(), val);
    }

    @Override
    public Set<BigdataURI> getDatatypes() {
        return new LinkedHashSet<BigdataURI>(this.datatypes.values());
    }

    @Override
    public LiteralExtensionIV createIV(Value value) {
        if (!(value instanceof Literal)) {
            throw new IllegalArgumentException();
        }
        Literal lit = (Literal)value;
        URI dt = lit.getDatatype();
        if (dt == null) {
            throw new IllegalArgumentException();
        }
        String dts = dt.stringValue();
        BigdataURI resolvedDT = null;
        for (BigdataURI val : this.datatypes.values()) {
            if (!val.stringValue().equals(dts)) continue;
            resolvedDT = val;
        }
        if (resolvedDT == null) {
            throw new IllegalArgumentException();
        }
        String s = lit.getLabel();
        boolean valid = dts.equals(XSD.POSITIVE_INTEGER.stringValue()) ? XMLDatatypeUtil.isValidPositiveInteger((String)s) : (dts.equals(XSD.NEGATIVE_INTEGER.stringValue()) ? XMLDatatypeUtil.isValidNegativeInteger((String)s) : (dts.equals(XSD.NON_POSITIVE_INTEGER.stringValue()) ? XMLDatatypeUtil.isValidNonPositiveInteger((String)s) : (dts.equals(XSD.NON_NEGATIVE_INTEGER.stringValue()) ? XMLDatatypeUtil.isValidNonNegativeInteger((String)s) : false)));
        if (!valid) {
            throw new RuntimeException("could not correctly parse label: " + s + " for datatype: " + dts);
        }
        BigInteger bi = XMLDatatypeUtil.parseInteger((String)s);
        XSDIntegerIV<BigdataLiteral> delegate = new XSDIntegerIV<BigdataLiteral>(bi);
        return new LiteralExtensionIV(delegate, resolvedDT.getIV());
    }

    @Override
    public V asValue(LiteralExtensionIV iv, BigdataValueFactory vf) {
        if (!this.datatypes.containsKey(iv.getExtensionIV())) {
            throw new IllegalArgumentException("unrecognized datatype");
        }
        BigInteger bi = iv.getDelegate().integerValue();
        BigdataURI dt = this.datatypes.get(iv.getExtensionIV());
        String s = bi.toString();
        return (V)vf.createLiteral(s, dt);
    }
}

