/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal.impl.literal;

import com.bigdata.rdf.internal.DTE;
import com.bigdata.rdf.internal.VTE;
import com.bigdata.rdf.internal.impl.AbstractInlineIV;
import com.bigdata.rdf.model.BigdataLiteral;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.xml.datatype.XMLGregorianCalendar;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.datatypes.XMLDatatypeUtil;

public abstract class AbstractLiteralIV<V extends BigdataLiteral, T>
extends AbstractInlineIV<V, T>
implements Literal {
    private static final long serialVersionUID = 5962615541158537189L;

    protected AbstractLiteralIV(DTE dte) {
        super(VTE.LITERAL, dte);
    }

    @Override
    public final boolean needsMaterialization() {
        return false;
    }

    public String stringValue() {
        return this.getLabel();
    }

    public String getLabel() {
        return this.getInlineValue().toString();
    }

    public URI getDatatype() {
        return this.getDTE().getDatatypeURI();
    }

    public String getLanguage() {
        return null;
    }

    public boolean booleanValue() {
        return XMLDatatypeUtil.parseBoolean((String)this.getLabel());
    }

    public byte byteValue() {
        return XMLDatatypeUtil.parseByte((String)this.getLabel());
    }

    public short shortValue() {
        return XMLDatatypeUtil.parseShort((String)this.getLabel());
    }

    public int intValue() {
        return XMLDatatypeUtil.parseInt((String)this.getLabel());
    }

    public long longValue() {
        return XMLDatatypeUtil.parseLong((String)this.getLabel());
    }

    public float floatValue() {
        return XMLDatatypeUtil.parseFloat((String)this.getLabel());
    }

    public double doubleValue() {
        return XMLDatatypeUtil.parseDouble((String)this.getLabel());
    }

    public BigInteger integerValue() {
        return XMLDatatypeUtil.parseInteger((String)this.getLabel());
    }

    public BigDecimal decimalValue() {
        return XMLDatatypeUtil.parseDecimal((String)this.getLabel());
    }

    public XMLGregorianCalendar calendarValue() {
        return XMLDatatypeUtil.parseCalendar((String)this.getLabel());
    }

    public String toString() {
        return (Object)((Object)super.getDTE()) + "(" + this.stringValue() + ")";
    }
}

