/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.lexicon;

import com.bigdata.btree.BytesUtil;
import com.bigdata.btree.DefaultTupleSerializer;
import com.bigdata.btree.ITuple;
import com.bigdata.btree.keys.IKeyBuilder;
import com.bigdata.btree.keys.IKeyBuilderFactory;
import com.bigdata.btree.raba.codec.IRabaCoder;
import com.bigdata.io.ByteArrayBuffer;
import com.bigdata.io.DataOutputBuffer;
import com.bigdata.io.ShortPacker;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.IVUtility;
import com.bigdata.search.ITermDocKey;
import com.bigdata.search.ITermDocRecord;
import com.bigdata.search.ITermDocVal;
import com.bigdata.search.ReadOnlyTermDocKey;
import com.bigdata.search.ReadOnlyTermDocRecord;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.log4j.Logger;
import org.apache.lucene.search.Similarity;

public class RDFFullTextIndexTupleSerializer
extends DefaultTupleSerializer<ITermDocKey, ITermDocVal> {
    private static final transient Logger log = Logger.getLogger(RDFFullTextIndexTupleSerializer.class);
    private static final transient int NO_FIELD = -1;
    private final transient DataOutputBuffer buf = new DataOutputBuffer(24);
    private static final transient byte VERSION0 = 0;
    private static final transient byte VERSION = 0;

    public RDFFullTextIndexTupleSerializer() {
    }

    public RDFFullTextIndexTupleSerializer(IKeyBuilderFactory keyBuilderFactory, IRabaCoder leafKeysCoder, IRabaCoder leafValsCoder, boolean fieldsEnabled) {
        super(keyBuilderFactory, leafKeysCoder, leafValsCoder);
    }

    @Override
    public byte[] serializeKey(Object obj) {
        ITermDocKey entry = (ITermDocKey)obj;
        String termText = entry.getToken();
        double termWeight = entry.getLocalTermWeight();
        byte termWeightCompact = Similarity.encodeNorm((float)((float)termWeight));
        IV docId = (IV)entry.getDocId();
        IKeyBuilder keyBuilder = this.getKeyBuilder();
        keyBuilder.reset();
        keyBuilder.appendText(termText, true, false);
        keyBuilder.append(termWeightCompact);
        IVUtility.encode(keyBuilder, docId);
        byte[] key = keyBuilder.getKey();
        if (log.isDebugEnabled()) {
            log.debug((Object)("{" + termText + "," + docId + "}, key=" + BytesUtil.toString(key)));
        }
        return key;
    }

    @Override
    public byte[] serializeVal(ITermDocVal obj) {
        ITermDocVal val = obj;
        if (log.isDebugEnabled()) {
            log.debug((Object)val);
        }
        this.buf.reset();
        int byteLen = ((IV)((ITermDocRecord)obj).getDocId()).byteLength();
        if (byteLen > Short.MAX_VALUE) {
            throw new IllegalArgumentException("cannot serialize IVs longer than Short.MAX_VALUE");
        }
        this.buf.packShort((short)byteLen);
        return this.buf.toByteArray();
    }

    @Override
    public ITermDocKey deserializeKey(ITuple tuple) {
        return this.deserialize(tuple, true);
    }

    @Override
    public ITermDocRecord deserialize(ITuple tuple) {
        return (ITermDocRecord)this.deserialize(tuple, false);
    }

    protected ITermDocKey deserialize(ITuple tuple, boolean keyOnly) {
        short byteLength;
        ByteArrayBuffer kbuf = tuple.getKeyBuffer();
        try {
            byteLength = ShortPacker.unpackShort(tuple.getValueStream());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        int docIdOffset = kbuf.limit() - byteLength;
        IV docId = IVUtility.decodeFromOffset(kbuf.array(), docIdOffset);
        int termWeightOffset = docIdOffset - 1;
        byte termWeightCompact = kbuf.getByte(termWeightOffset);
        double termWeight = Similarity.decodeNorm((byte)termWeightCompact);
        if (keyOnly) {
            return new ReadOnlyTermDocKey<IV>(docId, -1, termWeight);
        }
        return new ReadOnlyTermDocRecord<IV>(null, docId, -1, termWeight);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        byte version = in.readByte();
        switch (version) {
            case 0: {
                break;
            }
            default: {
                throw new IOException("unknown version=" + version);
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeByte(0);
    }
}

