/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.lexicon;

import com.bigdata.btree.BytesUtil;
import com.bigdata.btree.ICounter;
import com.bigdata.btree.IIndex;
import com.bigdata.btree.keys.KeyBuilder;
import com.bigdata.btree.proc.AbstractKeyArrayIndexProcedure;
import com.bigdata.btree.proc.AbstractKeyArrayIndexProcedureConstructor;
import com.bigdata.btree.proc.IParallelizableIndexProcedure;
import com.bigdata.btree.raba.codec.IRabaCoder;
import com.bigdata.io.DataOutputBuffer;
import com.bigdata.io.LongPacker;
import com.bigdata.io.ShortPacker;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.IVUtility;
import com.bigdata.rdf.internal.VTE;
import com.bigdata.rdf.internal.impl.TermId;
import com.bigdata.rdf.lexicon.TermIdEncoder;
import com.bigdata.relation.IMutableRelationIndexWriteProcedure;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class Term2IdWriteProc
extends AbstractKeyArrayIndexProcedure<Result>
implements IParallelizableIndexProcedure<Result>,
IMutableRelationIndexWriteProcedure<Result> {
    private static final Logger log = Logger.getLogger(Term2IdWriteProc.class);
    private static boolean enableGroundTruth = false;
    private static ConcurrentHashMap<Long, byte[]> groundTruthId2Term;
    private static ConcurrentHashMap<byte[], Long> groundTruthTerm2Id;
    private static final long serialVersionUID = -4736465754523655679L;
    private boolean readOnly;
    private boolean storeBlankNodes;
    private int scaleOutTermIdBitsToReverse;

    @Override
    public final boolean isReadOnly() {
        return this.readOnly;
    }

    public final boolean isStoreBlankNodes() {
        return this.storeBlankNodes;
    }

    public Term2IdWriteProc() {
    }

    protected Term2IdWriteProc(IRabaCoder keySer, int fromIndex, int toIndex, byte[][] keys, boolean readOnly, boolean storeBlankNodes, int scaleOutTermIdBitsToReverse) {
        super(keySer, null, fromIndex, toIndex, keys, null);
        this.readOnly = readOnly;
        this.storeBlankNodes = storeBlankNodes;
        this.scaleOutTermIdBitsToReverse = scaleOutTermIdBitsToReverse;
    }

    @Override
    public Result apply(IIndex ndx) {
        boolean DEBUG = log.isDebugEnabled();
        int numTerms = this.getKeyCount();
        assert (numTerms > 0) : "numTerms=" + numTerms;
        IV[] ivs = new IV[numTerms];
        ICounter counter = ndx.getCounter();
        DataOutputBuffer idbuf = new DataOutputBuffer();
        TermIdEncoder encoder = this.readOnly ? null : (this.scaleOutTermIdBitsToReverse == 0 ? null : new TermIdEncoder(this.scaleOutTermIdBitsToReverse));
        int nnew = 0;
        for (int i = 0; i < numTerms; ++i) {
            byte[] key = this.getKey(i);
            byte code = key[0];
            if (!this.storeBlankNodes && code == 5) {
                if (this.readOnly) {
                    ivs[i] = null;
                    continue;
                }
                long ctr = counter.incrementAndGet();
                long termId = encoder == null ? ctr : encoder.encode(ctr);
                ivs[i] = new TermId(Term2IdWriteProc.VTE(code), termId);
                continue;
            }
            byte[] tmp = ndx.lookup(key);
            if (tmp == null) {
                if (this.readOnly) {
                    ivs[i] = null;
                    continue;
                }
                long ctr = counter.incrementAndGet();
                long termId = encoder == null ? ctr : encoder.encode(ctr);
                TermId iv = new TermId(Term2IdWriteProc.VTE(code), termId);
                if (DEBUG && enableGroundTruth) {
                    this.groundTruthTest(key, termId, ndx, counter);
                }
                byte[] bytes = iv.encode(KeyBuilder.newInstance()).getKey();
                idbuf.reset().write(bytes);
                if (ndx.insert(key, idbuf.toByteArray()) != null) {
                    throw new AssertionError();
                }
                ++nnew;
                ivs[i] = iv;
                continue;
            }
            ivs[i] = IVUtility.decode(tmp);
        }
        return new Result(ivs);
    }

    private void groundTruthTest(byte[] key, long termId, IIndex ndx, ICounter counter) {
        Long oldId;
        if (groundTruthId2Term.isEmpty()) {
            log.warn((Object)"Ground truth testing enabled.");
        }
        if ((oldId = groundTruthTerm2Id.putIfAbsent(key, termId)) != null && oldId != termId) {
            throw new AssertionError((Object)("different termId assigned: oldId=" + oldId + ", newId=" + termId + ", key=" + BytesUtil.toString(key) + ", pmd=" + ndx.getIndexMetadata().getPartitionMetadata()));
        }
        byte[] oldKey = groundTruthId2Term.putIfAbsent(termId, key);
        if (oldKey != null && !BytesUtil.bytesEqual(oldKey, key)) {
            throw new AssertionError((Object)("assignment not unique: termId=" + termId + ", oldKey=" + BytesUtil.toString(oldKey) + ", newKey=" + BytesUtil.toString(key) + ", pmd=" + ndx.getIndexMetadata().getPartitionMetadata() + ", counter=" + counter + ", counter=" + counter.getClass().getName()));
        }
    }

    @Override
    protected void readMetadata(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readMetadata(in);
        this.readOnly = in.readBoolean();
        this.scaleOutTermIdBitsToReverse = in.readByte();
    }

    @Override
    protected void writeMetadata(ObjectOutput out) throws IOException {
        super.writeMetadata(out);
        out.writeBoolean(this.readOnly);
        out.writeByte((byte)this.scaleOutTermIdBitsToReverse);
    }

    public static final VTE VTE(byte code) {
        switch (code) {
            case 1: {
                return VTE.URI;
            }
            case 5: {
                return VTE.BNODE;
            }
            case 2: 
            case 3: 
            case 4: {
                return VTE.LITERAL;
            }
        }
        throw new IllegalArgumentException("code=" + code);
    }

    static {
        if (log.isDebugEnabled() && enableGroundTruth) {
            log.warn((Object)"Will track ground truth assignments");
            groundTruthId2Term = new ConcurrentHashMap(500000);
            groundTruthTerm2Id = new ConcurrentHashMap(500000);
        }
    }

    public static class Result
    implements Externalizable {
        public IV[] ivs;
        private static final long serialVersionUID = -8307927320589290348L;
        private static final transient short VERSION0 = 0;

        public Result() {
        }

        public Result(IV[] ivs) {
            assert (ivs != null);
            assert (ivs.length > 0);
            this.ivs = ivs;
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            short version = ShortPacker.unpackShort(in);
            if (version != 0) {
                throw new IOException("Unknown version: " + version);
            }
            int n = (int)LongPacker.unpackLong(in);
            this.ivs = new IV[n];
            for (int i = 0; i < n; ++i) {
                this.ivs[i] = (IV)in.readObject();
            }
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            int n = this.ivs.length;
            ShortPacker.packShort(out, (short)0);
            LongPacker.packLong(out, (long)n);
            for (int i = 0; i < n; ++i) {
                out.writeObject(this.ivs[i]);
            }
        }
    }

    public static class Term2IdWriteProcConstructor
    extends AbstractKeyArrayIndexProcedureConstructor<Term2IdWriteProc> {
        private final boolean readOnly;
        private final boolean storeBlankNodes;
        private final int scaleOutTermIdBitsToReverse;

        @Override
        public final boolean sendValues() {
            return false;
        }

        public Term2IdWriteProcConstructor(boolean readOnly, boolean storeBlankNodes, int scaleOutTermIdBitsToReverse) {
            this.readOnly = readOnly;
            this.storeBlankNodes = storeBlankNodes;
            this.scaleOutTermIdBitsToReverse = scaleOutTermIdBitsToReverse;
        }

        @Override
        public Term2IdWriteProc newInstance(IRabaCoder keySer, IRabaCoder valSer, int fromIndex, int toIndex, byte[][] keys, byte[][] vals) {
            assert (vals == null);
            if (log.isInfoEnabled()) {
                log.info((Object)("TERM2ID Proc Ctor: ntuples=" + (toIndex - fromIndex)));
            }
            return new Term2IdWriteProc(keySer, fromIndex, toIndex, keys, this.readOnly, this.storeBlankNodes, this.scaleOutTermIdBitsToReverse);
        }
    }
}

