/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.load;

import com.bigdata.journal.IResourceLock;
import com.bigdata.rdf.ServiceProviderHook;
import com.bigdata.rdf.inf.ClosureStats;
import com.bigdata.rdf.load.MappedRDFFileLoadTask;
import com.bigdata.rdf.load.RDFFilenameFilter;
import com.bigdata.rdf.rio.RDFParserOptions;
import com.bigdata.rdf.rules.InferenceEngine;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.ScaleOutTripleStore;
import com.bigdata.relation.locator.DefaultResourceLocator;
import com.bigdata.service.IBigdataClient;
import com.bigdata.service.IBigdataFederation;
import com.bigdata.service.jini.JiniClient;
import com.bigdata.service.jini.JiniFederation;
import com.bigdata.service.jini.master.AbstractAsynchronousClientTask;
import com.bigdata.service.jini.master.ClientLocator;
import com.bigdata.service.jini.master.INotifyOutcome;
import com.bigdata.service.jini.master.MappedTaskMaster;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import org.apache.log4j.Logger;
import org.apache.zookeeper.KeeperException;
import org.openrdf.rio.RDFFormat;

public class MappedRDFDataLoadMaster<S extends JobState, T extends AbstractAsynchronousClientTask<U, V, L>, U, L extends ClientLocator, V extends Serializable>
extends MappedTaskMaster<S, T, L, U, V> {
    protected static final Logger log = Logger.getLogger(MappedRDFDataLoadMaster.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws ConfigurationException, ExecutionException, InterruptedException, KeeperException {
        IBigdataFederation fed = new JiniClient(args).connect();
        try {
            MappedRDFDataLoadMaster task = new MappedRDFDataLoadMaster((JiniFederation)fed);
            task.execute();
        }
        finally {
            ((JiniFederation)fed).shutdown();
        }
    }

    public MappedRDFDataLoadMaster(JiniFederation fed) throws ConfigurationException {
        super(fed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void runJob() throws Exception {
        long tps;
        long statementsAdded;
        long statementCount;
        long elapsed;
        JobState jobState = (JobState)this.getJobState();
        long begin = System.currentTimeMillis();
        AbstractTripleStore tripleStore = this.openTripleStore();
        long statementCount0 = tripleStore.getStatementCount();
        if (jobState.loadData) {
            super.runJob();
            elapsed = System.currentTimeMillis() - begin;
            statementCount = tripleStore.getStatementCount();
            statementsAdded = statementCount - statementCount0;
            tps = (long)((double)statementsAdded / (double)elapsed * 1000.0);
            System.out.println("Load: tps=" + tps + ", ntriples=" + statementCount + ", nnew=" + statementsAdded + ", elapsed=" + elapsed + "ms");
            System.out.println(this.getKBInfo(tripleStore));
        }
        if (jobState.computeClosure) {
            IResourceLock lock = this.fed.getResourceLockService().acquireLock(tripleStore.getNamespace());
            try {
                if (jobState.forceOverflowBeforeClosure) {
                    this.forceOverflow();
                    System.out.println(this.getKBInfo(tripleStore));
                }
                long statementCount1 = tripleStore.getStatementCount();
                long beginClosure = System.currentTimeMillis();
                System.out.println("Computing closure: now=" + new Date().toString());
                InferenceEngine inf = tripleStore.getInferenceEngine();
                ClosureStats closureStats = inf.computeClosure(null);
                System.out.println("closure: " + closureStats);
                long elapsed2 = System.currentTimeMillis() - beginClosure;
                long statementCount2 = tripleStore.getStatementCount();
                long statementsAdded2 = statementCount2 - statementCount1;
                long tps2 = (long)((double)statementsAdded2 / (double)elapsed2 * 1000.0);
                System.out.println("Closure: tps=" + tps2 + ", ntriples=" + statementCount2 + ", nnew=" + statementsAdded2 + ", elapsed=" + elapsed2 + "ms");
                System.out.println(this.getKBInfo(tripleStore));
            }
            finally {
                lock.unlock();
            }
        }
        if (jobState.loadData && jobState.computeClosure) {
            elapsed = System.currentTimeMillis() - begin;
            statementCount = tripleStore.getStatementCount();
            statementsAdded = statementCount - statementCount0;
            tps = (long)((double)statementsAdded / (double)elapsed * 1000.0);
            System.out.println("Net: tps=" + tps + ", ntriples=" + statementCount + ", nnew=" + statementsAdded + ", elapsed=" + elapsed + "ms");
        }
        if (jobState.forceOverflow) {
            System.out.println("Forcing overflow: now=" + new Date());
            this.fed.forceOverflow(true, true);
            System.out.println("Forced overflow: now=" + new Date());
            System.out.println(this.getKBInfo(tripleStore));
        }
    }

    protected StringBuilder getKBInfo(AbstractTripleStore tripleStore) {
        StringBuilder sb = new StringBuilder();
        try {
            sb.append("namespace\t" + tripleStore.getNamespace() + "\n");
            sb.append("class\t" + tripleStore.getClass().getName() + "\n");
            sb.append("indexManager\t" + tripleStore.getIndexManager().getClass().getName() + "\n");
            sb.append("statementCount\t" + tripleStore.getStatementCount() + "\n");
            sb.append("termCount\t" + tripleStore.getTermCount() + "\n");
            sb.append("uriCount\t" + tripleStore.getURICount() + "\n");
            sb.append("literalCount\t" + tripleStore.getLiteralCount() + "\n");
            sb.append("bnodeCount\t" + (tripleStore.getLexiconRelation().isStoreBlankNodes() ? "" + tripleStore.getBNodeCount() : "N/A") + "\n");
        }
        catch (Throwable t) {
            log.warn((Object)t.getMessage(), t);
        }
        return sb;
    }

    @Override
    protected void beginJob(S jobState) throws Exception {
        super.beginJob(jobState);
        System.out.println("namespace=" + ((JobState)jobState).namespace + ", jobName=" + ((JobState)jobState).jobName + ", nclients=" + ((JobState)jobState).nclients);
        this.openTripleStore();
    }

    public AbstractTripleStore openTripleStore() throws ConfigurationException {
        JobState jobState = (JobState)this.getJobState();
        AbstractTripleStore tripleStore = (AbstractTripleStore)((DefaultResourceLocator)this.fed.getResourceLocator()).locate(jobState.namespace, 0L);
        if (tripleStore == null) {
            if (!jobState.create) {
                throw new RuntimeException("Does not exist: " + jobState.namespace);
            }
            tripleStore = this.createTripleStore();
            this.showProperties(tripleStore);
            try {
                this.loadOntology(tripleStore);
            }
            catch (Exception ex) {
                throw new RuntimeException("Could not load: " + jobState.ontology, ex);
            }
        } else {
            if (log.isInfoEnabled()) {
                log.info((Object)("Re-opened tripleStore: " + jobState.namespace));
            }
            this.showProperties(tripleStore);
        }
        return tripleStore;
    }

    protected AbstractTripleStore createTripleStore() throws ConfigurationException {
        JobState jobState = (JobState)this.getJobState();
        if (log.isInfoEnabled()) {
            log.info((Object)("Creating tripleStore: " + jobState.namespace));
        }
        Properties properties = ((JiniClient)this.fed.getClient()).getProperties(jobState.component);
        ScaleOutTripleStore tripleStore = new ScaleOutTripleStore(this.fed, jobState.namespace, 0L, properties);
        tripleStore.create();
        System.out.println("axiomCount=" + tripleStore.getStatementCount());
        if (log.isInfoEnabled()) {
            log.info((Object)("Created tripleStore: " + jobState.namespace));
        }
        return tripleStore;
    }

    protected void loadOntology(AbstractTripleStore tripleStore) throws IOException {
        JobState jobState = (JobState)this.getJobState();
        if (jobState.ontology == null) {
            return;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Loading ontology: " + jobState.ontology));
        }
        tripleStore.getDataLoader().loadFiles(jobState.ontology, jobState.ontology.getPath(), jobState.getRDFFormat(), jobState.defaultGraph, jobState.ontologyFileFilter);
        System.out.println("axiomAndOntologyCount=" + tripleStore.getStatementCount());
        if (log.isInfoEnabled()) {
            log.info((Object)("Loaded ontology: " + jobState.ontology));
        }
    }

    public void showProperties(AbstractTripleStore tripleStore) {
        if (!log.isInfoEnabled()) {
            return;
        }
        log.info((Object)("tripleStore: namespace=" + tripleStore.getNamespace()));
        Properties p = tripleStore.getProperties();
        log.info((Object)(AbstractTripleStore.Options.CHUNK_CAPACITY + "=" + p.getProperty(AbstractTripleStore.Options.CHUNK_CAPACITY)));
        log.info((Object)(AbstractTripleStore.Options.CHUNK_TIMEOUT + "=" + p.getProperty(AbstractTripleStore.Options.CHUNK_TIMEOUT, "10")));
        log.info((Object)(IBigdataClient.Options.CLIENT_RANGE_QUERY_CAPACITY + "=" + p.getProperty(IBigdataClient.Options.CLIENT_RANGE_QUERY_CAPACITY, "10000")));
        log.info((Object)(AbstractTripleStore.Options.FULLY_BUFFERED_READ_THRESHOLD + "=" + p.getProperty(AbstractTripleStore.Options.FULLY_BUFFERED_READ_THRESHOLD, "200")));
        log.info((Object)(AbstractTripleStore.Options.MAX_PARALLEL_SUBQUERIES + "=" + p.getProperty(AbstractTripleStore.Options.MAX_PARALLEL_SUBQUERIES)));
    }

    @Override
    protected T newClientTask(INotifyOutcome<V, L> notifyProxy, L locator) {
        return (T)new MappedRDFFileLoadTask<JobState, V, L>((JobState)this.getJobState(), notifyProxy, locator);
    }

    @Override
    protected S newJobState(String component, Configuration config) throws ConfigurationException {
        return (S)new JobState(component, config);
    }

    public static class JobState
    extends MappedTaskMaster.JobState {
        private static final long serialVersionUID = 2L;
        public final String namespace;
        public final File ontology;
        public final FilenameFilter ontologyFileFilter;
        public final int parserPoolSize;
        public final int parserQueueCapacity;
        public final long rejectedExecutionDelay;
        public final int term2IdWriterPoolSize;
        public final int otherWriterPoolSize;
        public final int notifyPoolSize;
        public final long unbufferedStatementThreshold;
        public final int producerChunkSize;
        public final int valuesInitialCapacity;
        public final int bnodesInitialCapacity;
        public final boolean create;
        public final boolean loadData;
        public final boolean computeClosure;
        final boolean forceOverflowBeforeClosure;
        public final RDFParserOptions parserOptions;
        private transient RDFFormat rdfFormat;
        public final String defaultGraph;

        public RDFFormat getRDFFormat() {
            return this.rdfFormat;
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
            out.writeObject(this.rdfFormat == null ? null : this.rdfFormat.getName());
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            String tmp = (String)in.readObject();
            if (tmp != null) {
                this.rdfFormat = RDFFormat.valueOf((String)tmp);
                if (this.rdfFormat == null) {
                    log.error((Object)("Could not resolve RDFFormat: name=" + tmp));
                }
            }
        }

        @Override
        protected void toString(StringBuilder sb) {
            super.toString(sb);
            sb.append(", namespace=" + this.namespace);
            sb.append(", ontology=" + this.ontology);
            sb.append(", ontologyFileFilter=" + this.ontologyFileFilter);
            sb.append(", parserPoolSize=" + this.parserPoolSize);
            sb.append(", parserQueueCapacity=" + this.parserQueueCapacity);
            sb.append(", rejectedExecutionDelay=" + this.rejectedExecutionDelay);
            sb.append(", term2IdWriterPoolSize=" + this.term2IdWriterPoolSize);
            sb.append(", otherWriterPoolSize=" + this.otherWriterPoolSize);
            sb.append(", notifyPoolSize=" + this.notifyPoolSize);
            sb.append(", producerChunkSize=" + this.producerChunkSize);
            sb.append(", valuesInitialCapacity=" + this.valuesInitialCapacity);
            sb.append(", bnodesInitialCapacity=" + this.bnodesInitialCapacity);
            sb.append(", create=" + this.create);
            sb.append(", loadData=" + this.loadData);
            sb.append(", computeClosure=" + this.computeClosure);
            sb.append(", parserOptions=" + this.parserOptions);
            sb.append(", rdfFormat=" + this.rdfFormat);
            sb.append(", defaultGraph=" + this.defaultGraph);
            sb.append(", forceOverflowBeforeClosure=" + this.forceOverflowBeforeClosure);
        }

        public JobState(String component, Configuration config) throws ConfigurationException {
            super(component, config);
            this.namespace = (String)config.getEntry(component, "namespace", String.class);
            this.ontology = (File)config.getEntry(component, "ontology", File.class, null);
            this.ontologyFileFilter = (FilenameFilter)config.getEntry(component, "ontologyFileFilter", FilenameFilter.class, (Object)new RDFFilenameFilter());
            this.parserPoolSize = (Integer)config.getEntry(component, "parserPoolSize", Integer.TYPE, (Object)5);
            this.parserQueueCapacity = (Integer)config.getEntry(component, "parserQueueCapacity", Integer.TYPE, (Object)(this.parserPoolSize * 2));
            this.term2IdWriterPoolSize = (Integer)config.getEntry(component, "term2IdWriterPoolSize", Integer.TYPE, (Object)5);
            this.otherWriterPoolSize = (Integer)config.getEntry(component, "otherWriterPoolSize", Integer.TYPE, (Object)5);
            this.notifyPoolSize = (Integer)config.getEntry(component, "notifyPoolSize", Integer.TYPE, (Object)5);
            this.unbufferedStatementThreshold = (Long)config.getEntry(component, "unbufferedStatementThreshold", Long.TYPE, (Object)0x100000L);
            this.producerChunkSize = (Integer)config.getEntry(component, "producerChunkSize", Integer.TYPE);
            this.valuesInitialCapacity = (Integer)config.getEntry(component, "valuesInitialCapacity", Integer.TYPE);
            this.bnodesInitialCapacity = (Integer)config.getEntry(component, "bnodesInitialCapacity", Integer.TYPE);
            this.create = (Boolean)config.getEntry(component, "create", Boolean.TYPE);
            this.loadData = (Boolean)config.getEntry(component, "loadData", Boolean.TYPE);
            this.computeClosure = (Boolean)config.getEntry(component, "computeClosure", Boolean.TYPE);
            this.forceOverflowBeforeClosure = (Boolean)config.getEntry(component, "forceOverflowBeforeClosure", Boolean.TYPE);
            this.parserOptions = (RDFParserOptions)config.getEntry(component, "parserOptions", RDFParserOptions.class, (Object)new RDFParserOptions());
            String tmp = (String)config.getEntry(component, "rdfFormat", String.class, (Object)ConfigurationOptions.DEFAULT_RDF_FORMAT.toString());
            if (tmp != null) {
                ServiceProviderHook.forceLoad();
                this.rdfFormat = RDFFormat.valueOf((String)tmp);
                if (this.rdfFormat == null) {
                    log.error((Object)("Could not resolve RDFFormat: name=" + tmp));
                }
            }
            this.defaultGraph = (String)config.getEntry(component, "defaultGraph", String.class, (Object)ConfigurationOptions.DEFAULT_DEFAULT_GRAPH);
            this.rejectedExecutionDelay = (Long)config.getEntry(component, "rejectedExecutionDelay", Long.TYPE, (Object)250L);
        }

        static {
            ServiceProviderHook.forceLoad();
        }
    }

    public static interface ConfigurationOptions
    extends MappedTaskMaster.ConfigurationOptions {
        public static final String NAMESPACE = "namespace";
        public static final String ONTOLOGY = "ontology";
        public static final String ONTOLOGY_FILE_FILTER = "ontologyFileFilter";
        public static final String PARSER_POOL_SIZE = "parserPoolSize";
        public static final int DEFAULT_PARSER_POOL_SIZE = 5;
        public static final String PARSER_QUEUE_CAPACITY = "parserQueueCapacity";
        public static final String REJECTED_EXECUTION_DELAY = "rejectedExecutionDelay";
        public static final long DEFAULT_REJECTED_EXECUTION_DELAY = 250L;
        public static final String TERM2ID_WRITER_POOL_SIZE = "term2IdWriterPoolSize";
        public static final int DEFAULT_TERM2ID_WRITER_POOL_SIZE = 5;
        public static final String OTHER_WRITER_POOL_SIZE = "otherWriterPoolSize";
        public static final int DEFAULT_OTHER_WRITER_POOL_SIZE = 5;
        public static final String NOTIFY_POOL_SIZE = "notifyPoolSize";
        public static final int DEFAULT_NOTIFY_POOL_SIZE = 5;
        public static final String UNBUFFERED_STATEMENT_THRESHOLD = "unbufferedStatementThreshold";
        public static final long DEFAULT_UNBUFFERED_STATEMENT_THRESHOLD = 0x100000L;
        public static final String PRODUCER_CHUNK_SIZE = "producerChunkSize";
        public static final String VALUES_INITIAL_CAPACITY = "valuesInitialCapacity";
        public static final String BNODES_INITIAL_CAPACITY = "bnodesInitialCapacity";
        public static final String CREATE = "create";
        public static final String LOAD_DATA = "loadData";
        public static final String COMPUTE_CLOSURE = "computeClosure";
        public static final String FORCE_OVERFLOW_BEFORE_CLOSURE = "forceOverflowBeforeClosure";
        public static final String PARSER_OPTIONS = "parserOptions";
        public static final String RDF_FORMAT = "rdfFormat";
        public static final String DEFAULT_RDF_FORMAT = RDFFormat.RDFXML.getName();
        public static final String DEFAULT_GRAPH = "defaultGraph";
        public static final String DEFAULT_DEFAULT_GRAPH = null;
    }
}

