/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.model;

import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.IVUtility;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.model.BigdataValueFactoryImpl;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public abstract class BigdataValueImpl
implements BigdataValue {
    private static final long serialVersionUID = 3114316856174115308L;
    private volatile transient BigdataValueFactory valueFactory;
    protected volatile IV iv;

    @Override
    public final BigdataValueFactory getValueFactory() {
        return this.valueFactory;
    }

    protected BigdataValueImpl(BigdataValueFactory valueFactory, IV iv) {
        this.valueFactory = valueFactory;
        this.iv = iv;
    }

    @Override
    public final void clearInternalValue() {
        this.iv = null;
    }

    @Override
    public final boolean isRealIV() {
        if (this.iv == null) {
            return false;
        }
        return !this.iv.isNullIV();
    }

    @Override
    public IV getIV() {
        return this.iv;
    }

    @Override
    public final void setIV(IV iv) {
        if (iv == null) {
            throw new IllegalArgumentException("Can not set IV to null: term=" + this);
        }
        if (this.iv != null && !IVUtility.equals(this.iv, iv)) {
            throw new IllegalStateException("Already assigned: old=" + this.iv + ", new=" + iv + ", this: " + this);
        }
        this.iv = iv;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeUTF(((BigdataValueFactoryImpl)this.valueFactory).getNamespace());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        String namespace = in.readUTF();
        this.valueFactory = BigdataValueFactoryImpl.getInstance(namespace);
    }

    @Override
    public Object get(int index) {
        if (index == 0) {
            return this;
        }
        if (index == 1) {
            return this.getIV();
        }
        throw new IllegalArgumentException();
    }
}

