/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.relation.rule;

import com.bigdata.bop.Constant;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IVariable;
import com.bigdata.btree.keys.IKeyBuilder;
import com.bigdata.btree.keys.ISortKeyBuilder;
import com.bigdata.rdf.internal.IV;
import java.io.Serializable;

public class BindingSetSortKeyBuilder
implements ISortKeyBuilder<IBindingSet> {
    private final IKeyBuilder keyBuilder;
    private final IVariable[] vars;

    public BindingSetSortKeyBuilder(IKeyBuilder keyBuilder, IVariable[] vars) {
        if (keyBuilder == null) {
            throw new IllegalArgumentException();
        }
        if (vars == null || vars.length == 0) {
            throw new IllegalArgumentException();
        }
        this.keyBuilder = keyBuilder;
        this.vars = vars;
    }

    @Override
    public byte[] getSortKey(IBindingSet bindingSet) {
        this.keyBuilder.reset();
        for (int i = 0; i < this.vars.length; ++i) {
            IVariable var = this.vars[i];
            Serializable val = bindingSet.get(var);
            if (val == null) {
                val = Long.valueOf(0L);
            } else if (val instanceof Constant) {
                val = ((Constant)val).get();
            }
            if (val instanceof IV) {
                IV iv = (IV)val;
                iv.encode(this.keyBuilder);
                continue;
            }
            this.keyBuilder.append(val);
        }
        return this.keyBuilder.getKey();
    }
}

