/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.rio;

import com.bigdata.rdf.changesets.ChangeAction;
import com.bigdata.rdf.changesets.ChangeRecord;
import com.bigdata.rdf.changesets.IChangeLog;
import com.bigdata.rdf.model.BigdataBNode;
import com.bigdata.rdf.model.BigdataBNodeImpl;
import com.bigdata.rdf.model.BigdataResource;
import com.bigdata.rdf.model.BigdataStatement;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.model.StatementEnum;
import com.bigdata.rdf.rio.IStatementBuffer;
import com.bigdata.rdf.rio.UnificationException;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.spo.SPO;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.TempTripleStore;
import com.bigdata.striterator.ChunkedArrayIterator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.openrdf.model.BNode;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.RDF;

public class StatementBuffer<S extends Statement>
implements IStatementBuffer<S> {
    private static final Logger log = Logger.getLogger(StatementBuffer.class);
    protected final BigdataValue[] values;
    protected final BigdataStatement[] stmts;
    protected int numValues;
    protected int numStmts;
    protected int numURIs;
    protected int numLiterals;
    protected int numBNodes;
    protected int numSIDs;
    private final Map<Value, BigdataValue> distinctTermMap;
    private Map<String, BigdataBNode> bnodes;
    private Set<BigdataStatement> deferredStmts;
    private Map<BigdataBNodeImpl, ReifiedStmt> reifiedStmts;
    private boolean statementIdentifiers;
    private final AbstractTripleStore statementStore;
    protected final AbstractTripleStore database;
    private final int arity;
    protected final BigdataValueFactory valueFactory;
    private final BigdataURI RDF_SUBJECT;
    private final BigdataURI RDF_PREDICATE;
    private final BigdataURI RDF_OBJECT;
    private final BigdataURI RDF_STATEMENT;
    private final BigdataURI RDF_TYPE;
    protected final int capacity;
    private boolean readOnly = false;
    private IChangeLog changeLog;

    @Override
    public final AbstractTripleStore getStatementStore() {
        return this.statementStore;
    }

    @Override
    public final AbstractTripleStore getDatabase() {
        return this.database;
    }

    @Override
    public boolean isEmpty() {
        return this.numStmts == 0;
    }

    @Override
    public int size() {
        return this.numStmts;
    }

    public String toString() {
        return "numURIs=" + this.numURIs + ", numLiterals=" + this.numLiterals + ", numBNodes=" + this.numBNodes + ", numStmts=" + this.numStmts + ", numValues=" + this.numValues + ", numSids=" + this.numSIDs + ", values.length=" + (this.values != null ? String.valueOf(this.values.length) : "null") + ", stmts.length=" + (this.stmts != null ? String.valueOf(this.stmts.length) : "null") + ", bnodes.size()=" + (this.bnodes != null ? String.valueOf(this.bnodes.size()) : "null") + ", distinctTermMap.size()=" + (this.distinctTermMap != null ? String.valueOf(this.distinctTermMap.size()) : "null") + ", reifiedStmts.size()=" + (this.reifiedStmts != null ? String.valueOf(this.reifiedStmts.size()) : "null") + ", deferredStmts.size()=" + (this.deferredStmts != null ? String.valueOf(this.deferredStmts.size()) : "null");
    }

    public void setReadOnly() {
        this.readOnly = true;
    }

    public void setChangeLog(IChangeLog changeLog) {
        this.changeLog = changeLog;
    }

    public StatementBuffer(AbstractTripleStore database, int capacity) {
        this(null, database, capacity);
    }

    public StatementBuffer(TempTripleStore statementStore, AbstractTripleStore database, int capacity) {
        if (database == null) {
            throw new IllegalArgumentException();
        }
        if (capacity <= 0) {
            throw new IllegalArgumentException();
        }
        this.statementStore = statementStore;
        this.database = database;
        this.arity = database.getSPOKeyArity();
        this.valueFactory = database.getValueFactory();
        this.capacity = capacity;
        this.values = new BigdataValue[capacity * this.arity + 5];
        this.stmts = new BigdataStatement[capacity];
        this.distinctTermMap = new HashMap<Value, BigdataValue>(capacity * this.arity);
        this.statementIdentifiers = database.getStatementIdentifiers();
        if (log.isInfoEnabled()) {
            log.info((Object)("capacity=" + capacity + ", sids=" + this.statementIdentifiers + ", statementStore=" + statementStore + ", database=" + database + ", arity=" + this.arity));
        }
        this.RDF_SUBJECT = this.valueFactory.asValue(RDF.SUBJECT);
        this.RDF_PREDICATE = this.valueFactory.asValue(RDF.PREDICATE);
        this.RDF_OBJECT = this.valueFactory.asValue(RDF.OBJECT);
        this.RDF_STATEMENT = this.valueFactory.asValue(RDF.STATEMENT);
        this.RDF_TYPE = this.valueFactory.asValue(RDF.TYPE);
        this.getDistinctTerm(this.RDF_SUBJECT, true);
        this.getDistinctTerm(this.RDF_PREDICATE, true);
        this.getDistinctTerm(this.RDF_OBJECT, true);
        this.getDistinctTerm(this.RDF_STATEMENT, true);
        this.getDistinctTerm(this.RDF_TYPE, true);
    }

    @Override
    public long flush() {
        this.incrementalWrite();
        this.reset();
        return 0L;
    }

    @Override
    public void reset() {
        this._clear();
        this.bnodes = null;
        this.deferredStmts = null;
        this.reifiedStmts = null;
    }

    @Override
    public void setBNodeMap(Map<String, BigdataBNode> bnodes) {
        if (bnodes == null) {
            throw new IllegalArgumentException();
        }
        if (this.bnodes != null) {
            throw new IllegalStateException();
        }
        this.bnodes = bnodes;
    }

    protected void _clear() {
        int i;
        for (i = 0; i < this.numValues; ++i) {
            this.values[i] = null;
        }
        for (i = 0; i < this.numStmts; ++i) {
            this.stmts[i] = null;
        }
        this.numValues = 0;
        this.numStmts = 0;
        this.numBNodes = 0;
        this.numLiterals = 0;
        this.numURIs = 0;
        this.numSIDs = 0;
        if (this.distinctTermMap != null) {
            this.distinctTermMap.clear();
            this.getDistinctTerm(this.RDF_SUBJECT, true);
            this.getDistinctTerm(this.RDF_PREDICATE, true);
            this.getDistinctTerm(this.RDF_OBJECT, true);
            this.getDistinctTerm(this.RDF_STATEMENT, true);
            this.getDistinctTerm(this.RDF_TYPE, true);
        }
    }

    protected void incrementalWrite() {
        int i;
        if (this.bnodes != null) {
            for (BigdataBNode bnode : this.bnodes.values()) {
                if (bnode.isStatementIdentifier() || bnode.getIV() != null) continue;
                this.values[this.numValues++] = bnode;
                ++this.numBNodes;
            }
        }
        long begin = System.currentTimeMillis();
        if (log.isInfoEnabled()) {
            log.info((Object)("numValues=" + this.numValues + " (uris=" + this.numURIs + ", lits=" + this.numLiterals + ", bnodes=" + this.numBNodes + ")" + ", numStmts=" + this.numStmts));
        }
        if (this.numValues > 0) {
            if (log.isDebugEnabled()) {
                for (i = 0; i < this.numValues; ++i) {
                    log.debug((Object)("adding term: " + this.values[i] + " (termId=" + this.values[i].getIV() + ")" + (this.values[i] instanceof BNode ? "sid=" + ((BigdataBNode)this.values[i]).isStatementIdentifier() : "")));
                }
            }
            this.addTerms(this.values, this.numValues);
            if (log.isDebugEnabled()) {
                for (i = 0; i < this.numValues; ++i) {
                    log.debug((Object)(" added term: " + this.values[i] + " (termId=" + this.values[i].getIV() + ")" + (this.values[i] instanceof BNode ? "sid=" + ((BigdataBNode)this.values[i]).isStatementIdentifier() : "")));
                }
            }
        }
        if (this.numStmts > 0) {
            if (log.isDebugEnabled()) {
                for (i = 0; i < this.numStmts; ++i) {
                    log.debug((Object)("adding stmt: " + this.stmts[i]));
                }
            }
            this.addStatements(this.stmts, this.numStmts);
            if (log.isDebugEnabled()) {
                for (i = 0; i < this.numStmts; ++i) {
                    log.debug((Object)(" added stmt: " + this.stmts[i]));
                }
            }
        }
        if (log.isInfoEnabled()) {
            long elapsed = System.currentTimeMillis() - begin;
            log.info((Object)("numValues=" + this.numValues + ", numStmts=" + this.numStmts + ", elapsed=" + elapsed + "ms"));
        }
        this._clear();
    }

    protected void addTerms(BigdataValue[] terms, int numTerms) {
        if (log.isInfoEnabled()) {
            log.info((Object)("writing " + numTerms));
            for (int i = 0; i < numTerms; ++i) {
                log.info((Object)("term: " + terms[i]));
            }
        }
        this.database.getLexiconRelation().addTerms(terms, numTerms, this.readOnly);
    }

    @Override
    public void add(Resource s, URI p, Value o) {
        this.add(s, p, o, null, StatementEnum.Explicit);
    }

    @Override
    public void add(Resource s, URI p, Value o, Resource c) {
        this.add(s, p, o, c, StatementEnum.Explicit);
    }

    @Override
    public void add(Resource s, URI p, Value o, Resource c, StatementEnum type) {
        if (this.nearCapacity()) {
            this.incrementalWrite();
        }
        this.handleStatement(s, p, o, c, type);
    }

    @Override
    public void add(Statement e) {
        this.add(e.getSubject(), e.getPredicate(), e.getObject(), e.getContext(), e instanceof BigdataStatement ? ((BigdataStatement)e).getStatementType() : null);
    }

    protected final long addStatements(BigdataStatement[] stmts, int numStmts) {
        SPO[] tmp = new SPO[numStmts];
        for (int i = 0; i < tmp.length; ++i) {
            BigdataStatement stmt = stmts[i];
            SPO spo = new SPO(stmt);
            if (log.isDebugEnabled()) {
                log.debug((Object)("adding: " + stmt.toString() + " (" + spo + ")"));
            }
            if (!spo.isFullyBound()) {
                throw new AssertionError((Object)("Not fully bound? : " + spo));
            }
            tmp[i] = spo;
        }
        long nwritten = this.writeSPOs((SPO[])tmp.clone(), numStmts);
        block6: for (int i = 0; i < numStmts; ++i) {
            if (!tmp[i].isModified()) continue;
            stmts[i].setModified(tmp[i].getModified());
            if (this.changeLog == null) continue;
            switch (stmts[i].getModified()) {
                case INSERTED: {
                    this.changeLog.changeEvent(new ChangeRecord(stmts[i], ChangeAction.INSERTED));
                    continue block6;
                }
                case UPDATED: {
                    this.changeLog.changeEvent(new ChangeRecord(stmts[i], ChangeAction.UPDATED));
                    continue block6;
                }
                case REMOVED: {
                    throw new AssertionError();
                }
            }
        }
        return nwritten;
    }

    protected long writeSPOs(SPO[] stmts, int numStmts) {
        AbstractTripleStore sink;
        ChunkedArrayIterator<ISPO> itr = new ChunkedArrayIterator<ISPO>(numStmts, stmts, null);
        AbstractTripleStore abstractTripleStore = sink = this.statementStore != null ? this.statementStore : this.database;
        if (log.isInfoEnabled()) {
            log.info((Object)("writing " + numStmts + " on " + (this.statementStore != null ? "statementStore" : "database")));
            for (int i = 0; i < numStmts; ++i) {
                log.info((Object)("spo: " + stmts[i]));
            }
        }
        return this.database.addStatements(sink, false, itr, null);
    }

    public boolean nearCapacity() {
        if (this.numStmts + 1 > this.capacity) {
            return true;
        }
        return this.numValues + this.arity > this.values.length;
    }

    protected BigdataValue getDistinctTerm(BigdataValue term, boolean addIfAbsent) {
        if (term == null) {
            return null;
        }
        if (term instanceof BNode) {
            BigdataBNode bnode = (BigdataBNode)term;
            BigdataStatement stmt = bnode.getStatement();
            if (stmt != null) {
                bnode.setStatement(this.valueFactory.createStatement((BigdataResource)this.getDistinctTerm(stmt.getSubject(), true), (BigdataURI)this.getDistinctTerm(stmt.getPredicate(), true), this.getDistinctTerm(stmt.getObject(), true)));
                return bnode;
            }
            String id = bnode.getID();
            if (this.bnodes == null) {
                this.bnodes = new HashMap<String, BigdataBNode>(this.capacity);
                this.bnodes.put(id, bnode);
            } else {
                BigdataBNode existingBNode = this.bnodes.get(id);
                if (existingBNode != null) {
                    return existingBNode;
                }
                this.bnodes.put(id, bnode);
            }
        } else {
            BigdataValue existingTerm = this.distinctTermMap.get(term);
            if (existingTerm != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("duplicate: " + term));
                }
                if (this.equals(existingTerm, this.RDF_SUBJECT, this.RDF_PREDICATE, this.RDF_OBJECT, this.RDF_TYPE, this.RDF_STATEMENT) && addIfAbsent) {
                    this.addTerm(term);
                }
                return existingTerm;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("new term: " + term));
            }
            if (this.distinctTermMap.put(term, term) != null) {
                throw new AssertionError();
            }
        }
        if (addIfAbsent) {
            this.addTerm(term);
        }
        return term;
    }

    protected void addTerm(BigdataValue term) {
        if (term == null) {
            return;
        }
        if (term instanceof URI) {
            ++this.numURIs;
            this.values[this.numValues++] = term;
        } else if (!(term instanceof BNode)) {
            ++this.numLiterals;
            this.values[this.numValues++] = term;
        }
    }

    protected void handleStatement(Resource _s, URI _p, Value _o, Resource _c, StatementEnum type) {
        Object object = _c = this.database.isQuads() ? _c : null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("handle stmt: " + _s + ", " + _p + ", " + _o + ", " + _c));
        }
        BigdataResource s = (BigdataResource)this.getDistinctTerm(this.valueFactory.asValue(_s), true);
        BigdataURI p = (BigdataURI)this.getDistinctTerm(this.valueFactory.asValue(_p), true);
        BigdataValue o = this.getDistinctTerm(this.valueFactory.asValue(_o), true);
        BigdataResource c = (BigdataResource)this.getDistinctTerm(this.valueFactory.asValue(_c), true);
        BigdataStatement stmt = this.valueFactory.createStatement(s, p, o, c, type);
        if (this.statementIdentifiers && s instanceof BNode) {
            if (this.equals(p, this.RDF_SUBJECT, this.RDF_PREDICATE, this.RDF_OBJECT)) {
                ReifiedStmt reifiedStmt;
                BigdataBNodeImpl sid = (BigdataBNodeImpl)s;
                if (sid.getStatement() != null) {
                    this.checkSid(sid, p, o);
                    log.warn((Object)("seeing a duplicate value for " + sid + ": " + p + "=" + o));
                    return;
                }
                if (this.reifiedStmts == null) {
                    this.reifiedStmts = new HashMap<BigdataBNodeImpl, ReifiedStmt>();
                }
                if (this.reifiedStmts.containsKey(sid)) {
                    reifiedStmt = this.reifiedStmts.get(sid);
                } else {
                    reifiedStmt = new ReifiedStmt();
                    this.reifiedStmts.put(sid, reifiedStmt);
                }
                reifiedStmt.set(p, o);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("reified piece: " + stmt));
                }
                if (reifiedStmt.isFullyBound(this.arity)) {
                    sid.setStatement(reifiedStmt.toStatement(this.valueFactory));
                    this.reifiedStmts.remove(sid);
                }
                return;
            }
            if (this.equals(o, this.RDF_STATEMENT) && this.equals(p, this.RDF_TYPE)) {
                return;
            }
        }
        this.stmts[this.numStmts++] = stmt;
    }

    private void checkSid(BigdataBNode sid, URI p, Value o) {
        BigdataStatement stmt = sid.getStatement();
        if (p == this.RDF_SUBJECT && stmt.getSubject() != o || p == this.RDF_PREDICATE && stmt.getPredicate() != o || p == this.RDF_OBJECT && stmt.getObject() != o) {
            throw new UnificationException("sid cannot refer to multiple statements");
        }
    }

    private boolean equals(BigdataValue v1, BigdataValue ... v2) {
        if (v2.length == 1) {
            return this._equals(v1, v2[0]);
        }
        for (BigdataValue v : v2) {
            if (!this._equals(v1, v)) continue;
            return true;
        }
        return false;
    }

    private boolean _equals(BigdataValue v1, BigdataValue v2) {
        return v1 == v2;
    }

    private static class ReifiedStmt
    implements Statement {
        private static final long serialVersionUID = -7706421769807306702L;
        private BigdataResource s;
        private BigdataURI p;
        private BigdataValue o;
        private BigdataResource c;

        public boolean isFullyBound(int arity) {
            return this.s != null && this.p != null && this.o != null && (arity <= 3 || this.c != null);
        }

        public BigdataResource getContext() {
            return this.c;
        }

        public BigdataValue getObject() {
            return this.o;
        }

        public BigdataURI getPredicate() {
            return this.p;
        }

        public BigdataResource getSubject() {
            return this.s;
        }

        public void set(URI p, BigdataValue o) {
            if (p.toString().equals(RDF.SUBJECT.toString())) {
                this.setSubject((BigdataResource)o);
            } else if (p.toString().equals(RDF.PREDICATE.toString())) {
                this.setPredicate((BigdataURI)o);
            } else if (p.toString().equals(RDF.OBJECT.toString())) {
                this.setObject(o);
            } else {
                throw new IllegalArgumentException();
            }
        }

        public void setSubject(BigdataResource s) {
            this.s = s;
        }

        public void setPredicate(BigdataURI p) {
            this.p = p;
        }

        public void setObject(BigdataValue o) {
            this.o = o;
        }

        public void setContext(BigdataResource c) {
            this.c = c;
        }

        public String toString() {
            return "<" + this.s + ", " + this.p + ", " + this.o + ", " + this.c + ">";
        }

        public BigdataStatement toStatement(BigdataValueFactory vf) {
            return vf.createStatement(this.s, this.p, this.o, this.c);
        }
    }
}

