/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.rules;

import com.bigdata.bop.Constant;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IPredicate;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.IVariableOrConstant;
import com.bigdata.bop.Var;
import com.bigdata.btree.keys.IKeyBuilder;
import com.bigdata.btree.keys.ISortKeyBuilder;
import com.bigdata.btree.keys.KeyBuilder;
import com.bigdata.journal.IIndexManager;
import com.bigdata.rdf.inf.Justification;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.VTE;
import com.bigdata.rdf.internal.impl.TermId;
import com.bigdata.rdf.relation.rule.BindingSetSortKeyBuilder;
import com.bigdata.rdf.rules.BackchainAccessPath;
import com.bigdata.rdf.rules.RDFJoinNexusFactory;
import com.bigdata.rdf.spo.SPO;
import com.bigdata.rdf.spo.SPORelation;
import com.bigdata.rdf.spo.SPOSortKeyBuilder;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.relation.IMutableRelation;
import com.bigdata.relation.IRelation;
import com.bigdata.relation.accesspath.IAccessPath;
import com.bigdata.relation.accesspath.IBuffer;
import com.bigdata.relation.rule.IAccessPathExpander;
import com.bigdata.relation.rule.IRule;
import com.bigdata.relation.rule.IStep;
import com.bigdata.relation.rule.eval.AbstractJoinNexus;
import com.bigdata.relation.rule.eval.AbstractSolutionBuffer;
import com.bigdata.relation.rule.eval.ActionEnum;
import com.bigdata.relation.rule.eval.IJoinNexus;
import com.bigdata.relation.rule.eval.IRuleState;
import com.bigdata.relation.rule.eval.IRuleStatisticsFactory;
import com.bigdata.relation.rule.eval.ISolution;
import com.bigdata.relation.rule.eval.RuleStats;
import com.bigdata.striterator.ChunkedArrayIterator;
import com.bigdata.striterator.IChunkedOrderedIterator;
import com.bigdata.striterator.IKeyOrder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.apache.log4j.Logger;

public class RDFJoinNexus
extends AbstractJoinNexus
implements IJoinNexus {
    protected static final transient Logger log = Logger.getLogger(RDFJoinNexus.class);
    private final RDFJoinNexusFactory joinNexusFactory;
    private final boolean justify;
    private final boolean backchain;
    private final IRuleStatisticsFactory ruleStatisticsFactory = new IRuleStatisticsFactory(){

        @Override
        public RuleStats newInstance(IStep step) {
            return new RDFRuleStats(step);
        }

        @Override
        public RuleStats newInstance(IRuleState ruleState) {
            return new RDFRuleStats(null, RDFJoinNexus.this.getReadTimestamp(), ruleState);
        }
    };
    private static final transient IConstant<IV> fakeTermId = new Constant(TermId.mockIV(VTE.URI));

    public RDFJoinNexus(RDFJoinNexusFactory joinNexusFactory, IIndexManager indexManager) {
        super(joinNexusFactory, indexManager);
        this.joinNexusFactory = joinNexusFactory;
        this.justify = joinNexusFactory.justify;
        this.backchain = joinNexusFactory.backchain;
    }

    @Override
    public IRuleStatisticsFactory getRuleStatisticsFactory() {
        return this.ruleStatisticsFactory;
    }

    @Override
    public IAccessPath getTailAccessPath(IRelation relation, IPredicate predicate) {
        IKeyOrder keyOrder = relation.getKeyOrder(predicate);
        BackchainAccessPath accessPath = relation.getAccessPath(this.indexManager, keyOrder, predicate);
        IAccessPathExpander expander = predicate.getAccessPathExpander();
        if (this.backchain && relation instanceof SPORelation && (expander == null || expander.backchain())) {
            SPORelation spoRelation = (SPORelation)relation;
            accessPath = new BackchainAccessPath(spoRelation.getContainer(), accessPath, this.joinNexusFactory.isOwlSameAsUsed ? Boolean.TRUE : Boolean.FALSE);
        }
        return accessPath;
    }

    @Override
    public IConstant fakeBinding(IPredicate pred, Var var) {
        return fakeTermId;
    }

    @Override
    public ISortKeyBuilder<IBindingSet> newBindingSetSortKeyBuilder(IRule rule) {
        IKeyBuilder keyBuilder = KeyBuilder.newUnicodeInstance();
        int nvars = rule.getVariableCount();
        IVariable[] vars = new IVariable[nvars];
        Iterator<IVariable> itr = rule.getVariables();
        int i = 0;
        while (itr.hasNext()) {
            vars[i++] = itr.next();
        }
        return new BindingSetSortKeyBuilder(keyBuilder, vars);
    }

    @Override
    protected ISortKeyBuilder<?> newSortKeyBuilder(IPredicate<?> head) {
        return new SPOSortKeyBuilder(head.arity());
    }

    @Override
    public IBuffer<ISolution[]> newInsertBuffer(IMutableRelation relation) {
        if (this.getAction() != ActionEnum.Insert) {
            throw new IllegalStateException();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("relation=" + relation));
        }
        if (this.justify) {
            return new InsertSPOAndJustificationBuffer(this.chunkOfChunksCapacity, relation);
        }
        return new AbstractSolutionBuffer.InsertSolutionBuffer(this.chunkOfChunksCapacity, relation);
    }

    public static class InsertSPOAndJustificationBuffer<E>
    extends AbstractSolutionBuffer<E> {
        public InsertSPOAndJustificationBuffer(int capacity, IMutableRelation<E> relation) {
            super(capacity, relation);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected long flush(IChunkedOrderedIterator<ISolution<E>> itr) {
            try {
                long mutationCount = 0L;
                while (itr.hasNext()) {
                    ISolution[] chunk = (ISolution[])itr.nextChunk();
                    mutationCount += this.writeChunk(chunk);
                }
                long l = mutationCount;
                return l;
            }
            finally {
                itr.close();
            }
        }

        private long writeChunk(ISolution<E>[] chunk) {
            long mutationCount;
            int n = chunk.length;
            if (log.isDebugEnabled()) {
                log.debug((Object)("chunkSize=" + n));
            }
            long begin = System.currentTimeMillis();
            final SPO[] a = new SPO[n];
            final Justification[] b = new Justification[n];
            for (int i = 0; i < chunk.length; ++i) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("chunk[" + i + "] = " + chunk[i]));
                }
                ISolution<E> solution = chunk[i];
                a[i] = (SPO)solution.get();
                b[i] = new Justification(solution);
            }
            final SPORelation r = (SPORelation)this.getRelation();
            ArrayList<Callable<Long>> tasks = new ArrayList<Callable<Long>>(2);
            tasks.add(new Callable<Long>(){

                @Override
                public Long call() {
                    return r.insert(a, a.length, null);
                }
            });
            tasks.add(new Callable<Long>(){

                @Override
                public Long call() {
                    return r.addJustifications(new ChunkedArrayIterator<Justification>(b.length, b, null));
                }
            });
            try {
                List futures = r.getExecutorService().invokeAll(tasks);
                mutationCount = (Long)futures.get(0).get();
                futures.get(1).get();
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
            catch (ExecutionException ex) {
                throw new RuntimeException(ex);
            }
            long elapsed = System.currentTimeMillis() - begin;
            if (log.isInfoEnabled()) {
                log.info((Object)("Wrote " + mutationCount + " statements and justifications in " + elapsed + "ms"));
            }
            return mutationCount;
        }
    }

    private static class RDFRuleStats
    extends RuleStats {
        private final IIndexManager indexManager;
        private final long timestamp;

        public RDFRuleStats(IStep step) {
            super(step);
            this.indexManager = null;
            this.timestamp = 0L;
        }

        public RDFRuleStats(IIndexManager indexManager, long timestamp, IRuleState ruleState) {
            super(ruleState);
            this.indexManager = indexManager;
            this.timestamp = timestamp;
        }

        @Override
        protected String toString(IPredicate pred) {
            String o;
            String p;
            String s;
            if (this.indexManager == null) {
                return pred.toString().replace(", ", " ");
            }
            SPORelation spoRelation = (SPORelation)this.indexManager.getResourceLocator().locate(pred.getRelationName(0), this.timestamp);
            AbstractTripleStore db = spoRelation.getContainer();
            try {
                IVariableOrConstant t = pred.get(0);
                s = t.isVar() ? t.getName() : db.toString((IV)t.get());
                t = pred.get(1);
                p = t.isVar() ? t.getName() : db.toString((IV)t.get());
                t = pred.get(2);
                o = t.isVar() ? t.getName() : db.toString((IV)t.get());
            }
            catch (Throwable t) {
                throw new RuntimeException("pred=" + pred + ", timestamp=" + this.timestamp + ", indexManager=" + this.indexManager + ", db=" + db, t);
            }
            return "(" + s + " " + p + " " + o + ")";
        }
    }
}

