/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail;

import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.engine.QueryTimeoutException;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.util.InnerCause;
import cutthecrap.utils.striterators.ICloseableIterator;
import info.aduna.iteration.CloseableIteration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;
import org.openrdf.model.Value;
import org.openrdf.query.Binding;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryInterruptedException;
import org.openrdf.query.impl.MapBindingSet;

public class Bigdata2Sesame2BindingSetIterator
implements CloseableIteration<BindingSet, QueryEvaluationException> {
    protected static final Logger log = Logger.getLogger(Bigdata2Sesame2BindingSetIterator.class);
    private final ICloseableIterator<IBindingSet> src;
    private final BindingSet constants;
    private volatile boolean open = true;
    private BindingSet next = null;

    public Bigdata2Sesame2BindingSetIterator(ICloseableIterator<IBindingSet> src) {
        this(src, null);
    }

    public Bigdata2Sesame2BindingSetIterator(ICloseableIterator<IBindingSet> src, BindingSet constants) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        this.src = src;
        this.constants = constants;
    }

    public boolean hasNext() throws QueryEvaluationException {
        try {
            if (!this.open) {
                return false;
            }
            if (this.next != null) {
                return true;
            }
            if (!this.src.hasNext()) {
                this.close();
                return false;
            }
            IBindingSet bset = (IBindingSet)this.src.next();
            this.next = this.getBindingSet(bset);
            return true;
        }
        catch (Throwable t) {
            if (!this.open) {
                return false;
            }
            try {
                this.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (InnerCause.isInnerCause(t, QueryTimeoutException.class)) {
                throw new QueryInterruptedException(t);
            }
            throw new QueryEvaluationException(t);
        }
    }

    public BindingSet next() throws QueryEvaluationException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        BindingSet tmp = this.next;
        this.next = null;
        return tmp;
    }

    private BindingSet getBindingSet(IBindingSet src) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        int n = src.size();
        MapBindingSet bindingSet = new MapBindingSet(n);
        Iterator<Map.Entry<IVariable, IConstant>> itr = src.iterator();
        while (itr.hasNext()) {
            Map.Entry<IVariable, IConstant> entry = itr.next();
            IVariable v = entry.getKey();
            IConstant c = entry.getValue();
            Object val = c.get();
            BigdataValue value = val instanceof IV ? ((IV)val).getValue() : (BigdataValue)val;
            bindingSet.addBinding(v.getName(), (Value)value);
        }
        if (this.constants != null) {
            for (Binding b : this.constants) {
                bindingSet.addBinding(b.getName(), b.getValue());
            }
        }
        return bindingSet;
    }

    public void remove() throws QueryEvaluationException {
        throw new UnsupportedOperationException();
    }

    public void close() throws QueryEvaluationException {
        if (this.open) {
            this.open = false;
            this.src.close();
        }
    }
}

