/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail;

import com.bigdata.btree.IIndex;
import com.bigdata.btree.IndexMetadata;
import com.bigdata.journal.IIndexManager;
import com.bigdata.journal.IJournal;
import com.bigdata.journal.Journal;
import com.bigdata.rdf.axioms.NoAxioms;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.store.DataLoader;
import com.bigdata.rdf.store.LocalTripleStore;
import com.bigdata.rdf.store.ScaleOutTripleStore;
import com.bigdata.relation.RelationSchema;
import com.bigdata.service.AbstractFederation;
import com.bigdata.service.IBigdataFederation;
import com.bigdata.service.jini.JiniClient;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import net.jini.config.ConfigurationException;
import org.openrdf.sail.SailException;

public class BigdataSailHelper {
    public BigdataSail getSail(IBigdataFederation<?> fed, String namespace, long timestamp) {
        ScaleOutTripleStore tripleStore = (ScaleOutTripleStore)fed.getResourceLocator().locate(namespace, timestamp);
        if (tripleStore == null) {
            if (timestamp == 0L) {
                System.out.println("Creating tripleStore: namespace=" + namespace);
                tripleStore = new ScaleOutTripleStore(fed, namespace, timestamp, this.getProperties());
                tripleStore.create();
            } else {
                throw new RuntimeException("No such triple store: namespace=" + namespace + ", timestamp=" + timestamp);
            }
        }
        return new BigdataSail(tripleStore);
    }

    public BigdataSail getSail(String filename, String namespace, long timestamp) {
        Properties properties = new Properties();
        properties.setProperty(BigdataSail.Options.FILE, filename);
        Journal journal = new Journal(properties);
        System.err.println("createTime=" + journal.getRootBlockView().getCreateTime());
        System.err.println("lastCommitTime=" + journal.getLastCommitTime());
        LocalTripleStore tripleStore = (LocalTripleStore)journal.getResourceLocator().locate(namespace, timestamp);
        if (tripleStore == null) {
            if (timestamp == 0L) {
                System.out.println("Creating tripleStore: namespace=" + namespace);
                tripleStore = new LocalTripleStore(journal, namespace, timestamp, this.getProperties());
                tripleStore.create();
            } else {
                throw new RuntimeException("No such triple store: namespace=" + namespace + ", timestamp=" + timestamp);
            }
        }
        return new BigdataSail(tripleStore);
    }

    public Properties getProperties() {
        Properties properties = new Properties();
        properties.setProperty(BigdataSail.Options.INITIAL_EXTENT, "209715200");
        properties.setProperty(BigdataSail.Options.MAXIMUM_EXTENT, "209715200");
        properties.setProperty(BigdataSail.Options.TRUTH_MAINTENANCE, "false");
        properties.setProperty(BigdataSail.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        properties.setProperty(BigdataSail.Options.MAX_PARALLEL_SUBQUERIES, "0");
        properties.setProperty(BigdataSail.Options.CHUNK_CAPACITY, "100");
        properties.setProperty(DataLoader.Options.CLOSURE, DataLoader.ClosureEnum.None.toString());
        properties.setProperty(DataLoader.Options.COMMIT, DataLoader.CommitEnum.None.toString());
        properties.setProperty(BigdataSail.Options.STATEMENT_IDENTIFIERS, "false");
        properties.setProperty(BigdataSail.Options.QUADS, "false");
        properties.setProperty(BigdataSail.Options.JUSTIFY, "false");
        return properties;
    }

    public Properties getProperties(BigdataSail sail) {
        return this.getProperties(sail.getDatabase().getIndexManager(), sail.getDatabase().getNamespace());
    }

    protected Properties getProperties(IIndexManager indexManager, String namespace) {
        Map<String, Object> map = indexManager.getGlobalRowStore().read(RelationSchema.INSTANCE, namespace);
        Properties properties = new Properties();
        properties.putAll(map);
        return properties;
    }

    public Properties setProperties(BigdataSail sail, Properties properties) {
        return this.setProperties(sail.getDatabase().getIndexManager(), sail.getDatabase().getNamespace(), properties);
    }

    protected Properties setProperties(IIndexManager indexManager, String namespace, Properties properties) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(RelationSchema.NAMESPACE, namespace);
        Enumeration<?> e = properties.propertyNames();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            String name = (String)key;
            map.put(name, properties.getProperty(name));
        }
        Properties p2 = new Properties();
        p2.putAll(indexManager.getGlobalRowStore().write(RelationSchema.INSTANCE, map));
        if (indexManager instanceof IJournal) {
            ((Journal)indexManager).commit();
        }
        return p2;
    }

    protected static void showProperties(Properties p) {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        for (Map.Entry<Object, Object> entry : p.entrySet()) {
            map.put(entry.getKey().toString(), entry.getValue());
        }
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            System.out.println((String)entry.getKey() + "=" + entry.getValue());
        }
    }

    public static void showLexiconIndexDetails(BigdataSail sail) {
        IIndex ndx = sail.getDatabase().getLexiconRelation().getBlobsIndex();
        IndexMetadata md = ndx.getIndexMetadata();
        System.out.println("Lexicon:");
        System.out.println(md.toString());
        System.out.println(md.getTupleSerializer().toString());
    }

    public static void showSPOIndexDetails(BigdataSail sail) {
        IIndex ndx = sail.getDatabase().getSPORelation().getPrimaryIndex();
        IndexMetadata md = ndx.getIndexMetadata();
        System.out.println(md.getName() + ":");
        System.out.println(md.toString());
        System.out.println(md.getTupleSerializer().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws SailException, ConfigurationException, IOException {
        IBigdataFederation fed;
        BigdataSail sail;
        File propertyFile;
        FederationEnum fedType;
        if (args.length == 0) {
            System.err.println("usage: filename (LTS|JDS (namespace (timestamp)))");
            System.exit(1);
        }
        String filename = args[0];
        File file = new File(filename);
        if (args.length > 1) {
            fedType = FederationEnum.valueOf(args[1]);
        } else if (filename.endsWith(".properties")) {
            fedType = FederationEnum.LTS;
        } else if (filename.endsWith(".config")) {
            fedType = FederationEnum.JDS;
        } else {
            fedType = null;
            System.err.println("Must specify the federation type: " + filename);
            System.exit(1);
        }
        switch (fedType) {
            case LTS: 
            case JDS: {
                if (!file.isDirectory()) break;
                System.err.println((Object)((Object)fedType) + " requires plain file, not a directory: dir=" + filename);
                System.exit(1);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        String namespace = args.length > 2 ? args[2] : "kb";
        long timestamp = args.length > 3 ? Long.valueOf(args[3]) : 0L;
        File file2 = propertyFile = args.length > 4 ? new File(args[4]) : null;
        if (propertyFile != null && !propertyFile.exists()) {
            System.err.println("No such file: " + propertyFile);
            System.exit(1);
        }
        BigdataSailHelper helper = new BigdataSailHelper();
        System.out.println("filename: " + filename);
        switch (fedType) {
            case LTS: {
                sail = helper.getSail(filename, namespace, timestamp);
                fed = null;
                break;
            }
            case JDS: {
                fed = new JiniClient(new String[]{args[0]}).connect();
                sail = helper.getSail(fed, namespace, timestamp);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        try {
            sail.initialize();
            System.out.println("\npre-modification properties::");
            BigdataSailHelper.showProperties(helper.getProperties(sail));
            BigdataSailHelper.showLexiconIndexDetails(sail);
            BigdataSailHelper.showSPOIndexDetails(sail);
            Properties p = new Properties();
            if (propertyFile != null) {
                System.out.println("reading new properties from file::");
                try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(propertyFile));){
                    p.load(is);
                }
                p.store(System.out, "Will apply properties::");
            } else {
                System.out.println("reading new properties from stdin::");
                p.load(System.in);
            }
            System.out.println("\npost-modification properties::");
            BigdataSailHelper.showProperties(helper.setProperties(sail, p));
        }
        finally {
            sail.shutDown();
            if (fed != null) {
                ((AbstractFederation)fed).shutdownNow();
            }
        }
    }

    private static enum FederationEnum {
        LTS,
        JDS;

    }
}

