/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail;

import com.bigdata.ha.HAGlue;
import com.bigdata.ha.QuorumService;
import com.bigdata.journal.IIndexManager;
import com.bigdata.journal.IJournal;
import com.bigdata.journal.ITransactionService;
import com.bigdata.journal.Journal;
import com.bigdata.quorum.AsynchronousQuorumCloseException;
import com.bigdata.quorum.Quorum;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.LocalTripleStore;
import com.bigdata.rdf.store.ScaleOutTripleStore;
import com.bigdata.rdf.task.AbstractApiTask;
import com.bigdata.util.InnerCause;
import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.log4j.Logger;

public class CreateKBTask
extends AbstractApiTask<Void> {
    private static final transient Logger log = Logger.getLogger(CreateKBTask.class);
    private final Properties properties;

    protected Properties getProperties() {
        return this.properties;
    }

    public CreateKBTask(String namespace, Properties properties) {
        super(namespace, 0L, true);
        if (properties == null) {
            throw new IllegalArgumentException();
        }
        this.properties = new Properties(properties);
        this.properties.setProperty(BigdataSail.Options.NAMESPACE, namespace);
    }

    @Override
    public final boolean isReadOnly() {
        return false;
    }

    @Override
    public Void call() throws Exception {
        try {
            this.doRun();
        }
        catch (Throwable t) {
            if (InnerCause.isInnerCause(t, AsynchronousQuorumCloseException.class)) {
                log.warn((Object)t);
            } else {
                log.error((Object)t, t);
            }
            throw new Exception(t);
        }
        return null;
    }

    private void doRun() {
        IIndexManager indexManager = this.getIndexManager();
        if (indexManager instanceof IJournal) {
            boolean isSoloOrLeader;
            IJournal jnl = (IJournal)indexManager;
            Quorum<HAGlue, QuorumService<HAGlue>> quorum = jnl.getQuorum();
            if (quorum == null) {
                isSoloOrLeader = true;
            } else {
                long token;
                try {
                    long tmp = quorum.token();
                    if (tmp == -1L) {
                        log.warn((Object)"Awaiting quorum.");
                        tmp = quorum.awaitQuorum();
                    }
                    token = tmp;
                    assert (token != -1L);
                }
                catch (AsynchronousQuorumCloseException e1) {
                    throw new RuntimeException(e1);
                }
                catch (InterruptedException e1) {
                    throw new RuntimeException(e1);
                }
                try {
                    jnl.awaitHAReady(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
                }
                catch (AsynchronousQuorumCloseException e) {
                    throw new RuntimeException(e);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                catch (TimeoutException e) {
                    throw new RuntimeException(e);
                }
                isSoloOrLeader = quorum.getMember().isLeader(token);
                IJournal journal = jnl;
                if (journal.isGroupCommit() && journal.getRootBlockView().getCommitCounter() == 0L) {
                    journal.getGlobalRowStore();
                    journal.commit();
                }
            }
            if (isSoloOrLeader && indexManager.getResourceLocator().locate(this.namespace, 0L) == null) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Creating KB instance: namespace=" + this.namespace));
                }
                this.createLTS(jnl, this.getProperties());
                if (log.isInfoEnabled()) {
                    log.info((Object)("Created tripleStore: " + this.namespace));
                }
            }
        } else if (indexManager.getResourceLocator().locate(this.namespace, 0L) == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Creating KB instance: namespace=" + this.namespace));
            }
            ScaleOutTripleStore lts = new ScaleOutTripleStore(indexManager, this.namespace, 0L, this.getProperties());
            lts.create();
            if (log.isInfoEnabled()) {
                log.info((Object)("Created tripleStore: " + this.namespace));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractTripleStore createLTS(IJournal indexManager, Properties properties) {
        ITransactionService txService = indexManager.getLocalTransactionManager().getTransactionService();
        String namespace = properties.getProperty(BigdataSail.Options.NAMESPACE, "kb");
        BigdataSail.checkProperties(properties);
        boolean isGroupCommit = indexManager.isGroupCommit();
        boolean acquiredConnection = false;
        try {
            LocalTripleStore lts;
            if (!isGroupCommit) {
                try {
                    ((Journal)indexManager).acquireUnisolatedConnection();
                    acquiredConnection = true;
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            if ((lts = (LocalTripleStore)indexManager.getResourceLocator().locate(namespace, 0L)) != null) {
                LocalTripleStore localTripleStore = lts;
                return localTripleStore;
            }
            if (Boolean.parseBoolean(properties.getProperty(BigdataSail.Options.ISOLATABLE_INDICES, "false"))) {
                long txCreate = txService.newTx(0L);
                boolean ok = false;
                try {
                    LocalTripleStore txCreateView = new LocalTripleStore(indexManager, namespace, txCreate, properties);
                    txCreateView.create();
                    txService.commit(txCreate);
                    ok = true;
                }
                finally {
                    if (!ok) {
                        txService.abort(txCreate);
                    }
                }
            } else {
                lts = new LocalTripleStore(indexManager, namespace, 0L, properties);
                lts.create();
            }
            lts = (LocalTripleStore)indexManager.getResourceLocator().locate(namespace, 0L);
            if (lts == null) {
                throw new RuntimeException("Concurrent create/destroy: " + namespace);
            }
            LocalTripleStore localTripleStore = lts;
            return localTripleStore;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (!isGroupCommit && acquiredConnection) {
                ((Journal)indexManager).releaseUnisolatedConnection();
            }
        }
    }
}

