/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.remote;

import com.bigdata.journal.BufferMode;
import com.bigdata.journal.Journal;
import com.bigdata.rdf.axioms.NoAxioms;
import com.bigdata.rdf.axioms.OwlAxioms;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.BigdataSailRepository;
import com.bigdata.rdf.sail.remote.BigdataSailRemoteRepository;
import java.io.File;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;

public class BigdataSailFactory {
    public static BigdataSailRemoteRepository connect(String host, int port) {
        return BigdataSailFactory.connect("http://" + host + ":" + port);
    }

    public static BigdataSailRemoteRepository connect(String serviceEndpoint) {
        return new BigdataSailRemoteRepository(BigdataSailFactory.normalizeEndpoint(serviceEndpoint));
    }

    public static String testServiceEndpointUrl(String serviceEndpoint) {
        return BigdataSailFactory.normalizeEndpoint(serviceEndpoint);
    }

    private static String normalizeEndpoint(String serviceEndpoint) {
        if (serviceEndpoint.endsWith("/sparql")) {
            return serviceEndpoint.substring(0, serviceEndpoint.length() - "/sparql".length());
        }
        if (serviceEndpoint.endsWith("/sparql/")) {
            return serviceEndpoint.substring(0, serviceEndpoint.length() - "/sparql/".length());
        }
        if (serviceEndpoint.endsWith("/bigdata/")) {
            return serviceEndpoint.substring(0, serviceEndpoint.length() - 1);
        }
        if (serviceEndpoint.endsWith("/bigdata")) {
            return serviceEndpoint;
        }
        if (serviceEndpoint.contains("/bigdata") && serviceEndpoint.endsWith("/")) {
            return serviceEndpoint.substring(0, serviceEndpoint.length() - 1);
        }
        if (serviceEndpoint.contains("/bigdata")) {
            return serviceEndpoint;
        }
        if (serviceEndpoint.endsWith("/")) {
            return serviceEndpoint + "bigdata";
        }
        return serviceEndpoint + "/bigdata";
    }

    public static BigdataSailRepository openRepository(String file) {
        return new BigdataSailRepository(BigdataSailFactory.openSail(file, false));
    }

    public static BigdataSailRepository openRepository(String file, boolean create) {
        return new BigdataSailRepository(BigdataSailFactory.openSail(file, create));
    }

    public static BigdataSail openSail(String file) {
        return BigdataSailFactory.openSail(file, false);
    }

    public static BigdataSail openSail(String file, boolean create) {
        if (!new File(file).exists()) {
            if (!create) {
                throw new IllegalArgumentException("journal does not exist at specified location");
            }
            return BigdataSailFactory.createSail(file, new Option[0]);
        }
        Properties props = new Properties();
        props.setProperty(BigdataSail.Options.FILE, file);
        BigdataSail sail = new BigdataSail(props);
        return sail;
    }

    public static BigdataSailRepository createRepository(Option ... args) {
        return BigdataSailFactory.createRepository(new Properties(), null, args);
    }

    public static BigdataSailRepository createRepository(Properties props, Option ... args) {
        return BigdataSailFactory.createRepository(props, null, args);
    }

    public static BigdataSailRepository createRepository(String file, Option ... args) {
        return BigdataSailFactory.createRepository(new Properties(), file, args);
    }

    public static BigdataSailRepository createRepository(Properties props, String file, Option ... args) {
        return new BigdataSailRepository(BigdataSailFactory.createSail(props, file, args));
    }

    public static BigdataSail createSail(Option ... args) {
        return BigdataSailFactory.createSail(new Properties(), null, args);
    }

    public static BigdataSail createSail(String file, Option ... args) {
        return BigdataSailFactory.createSail(new Properties(), null, args);
    }

    public static BigdataSail createSail(Properties props, String file, Option ... args) {
        LinkedList<Option> options = args != null ? Arrays.asList(args) : new LinkedList<Option>();
        BigdataSailFactory.checkArgs(file, options);
        if (file != null) {
            props.setProperty(BigdataSail.Options.FILE, file);
            props.setProperty(Journal.Options.BUFFER_MODE, BufferMode.DiskRW.toString());
        } else {
            props.setProperty(Journal.Options.BUFFER_MODE, BufferMode.MemStore.toString());
        }
        if (options.contains((Object)Option.Inference)) {
            props.setProperty(BigdataSail.Options.AXIOMS_CLASS, OwlAxioms.class.getName());
            props.setProperty(BigdataSail.Options.TRUTH_MAINTENANCE, "true");
            props.setProperty(BigdataSail.Options.JUSTIFY, "true");
        } else {
            props.setProperty(BigdataSail.Options.AXIOMS_CLASS, NoAxioms.class.getName());
            props.setProperty(BigdataSail.Options.TRUTH_MAINTENANCE, "false");
            props.setProperty(BigdataSail.Options.JUSTIFY, "false");
        }
        props.setProperty(BigdataSail.Options.TEXT_INDEX, String.valueOf(options.contains((Object)Option.TextIndex)));
        props.setProperty(BigdataSail.Options.STATEMENT_IDENTIFIERS, String.valueOf(options.contains((Object)Option.RDR)));
        props.setProperty(BigdataSail.Options.QUADS, String.valueOf(options.contains((Object)Option.Quads)));
        props.setProperty("com.bigdata.service.AbstractTransactionService.minReleaseAge", "1");
        props.setProperty("com.bigdata.btree.writeRetentionQueue.capacity", "4000");
        props.setProperty("com.bigdata.btree.BTree.branchingFactor", "128");
        props.setProperty("com.bigdata.namespace.kb.lex.com.bigdata.btree.BTree.branchingFactor", "400");
        props.setProperty("com.bigdata.namespace.kb.spo.com.bigdata.btree.BTree.branchingFactor", "1024");
        BigdataSail sail = new BigdataSail(props);
        return sail;
    }

    protected static void checkArgs(String file, List<Option> options) {
        if (options.contains((Object)Option.Inference) && options.contains((Object)Option.Quads)) {
            throw new IllegalArgumentException();
        }
        if (options.contains((Object)Option.RDR) && options.contains((Object)Option.Quads)) {
            throw new IllegalArgumentException();
        }
    }

    public static enum Option {
        Inference,
        Quads,
        RDR,
        TextIndex;

    }
}

