/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.sparql;

import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.VTE;
import com.bigdata.rdf.internal.impl.TermId;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.sail.sparql.ASTVisitorBase;
import com.bigdata.rdf.sail.sparql.BigdataASTContext;
import com.bigdata.rdf.sail.sparql.ast.ASTBlankNode;
import com.bigdata.rdf.sail.sparql.ast.ASTFalse;
import com.bigdata.rdf.sail.sparql.ast.ASTIRI;
import com.bigdata.rdf.sail.sparql.ast.ASTNumericLiteral;
import com.bigdata.rdf.sail.sparql.ast.ASTOperationContainer;
import com.bigdata.rdf.sail.sparql.ast.ASTQName;
import com.bigdata.rdf.sail.sparql.ast.ASTRDFLiteral;
import com.bigdata.rdf.sail.sparql.ast.ASTRDFValue;
import com.bigdata.rdf.sail.sparql.ast.ASTString;
import com.bigdata.rdf.sail.sparql.ast.ASTTrue;
import com.bigdata.rdf.sail.sparql.ast.VisitorException;
import com.bigdata.rdf.store.BD;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.query.MalformedQueryException;

public class BatchRDFValueResolver
extends ASTVisitorBase {
    private static final Logger log = Logger.getLogger(BatchRDFValueResolver.class);
    private final BigdataASTContext context;
    private final boolean readOnly;
    private final BigdataValueFactory valueFactory;
    private final LinkedHashMap<ASTRDFValue, BigdataValue> nodes;

    public BatchRDFValueResolver(BigdataASTContext context, boolean readOnly) {
        this.context = context;
        this.readOnly = readOnly;
        this.valueFactory = context.valueFactory;
        this.nodes = new LinkedHashMap();
    }

    public void process(ASTOperationContainer qc) throws MalformedQueryException {
        try {
            qc.jjtAccept(new RDFValueResolver(), null);
        }
        catch (VisitorException e) {
            throw new MalformedQueryException((Throwable)e);
        }
        BigdataValueFactory f = this.context.valueFactory;
        Map<Value, BigdataValue> vocab = this.context.vocab;
        vocab.put((Value)RDF.FIRST, f.asValue(RDF.FIRST));
        vocab.put((Value)RDF.REST, f.asValue(RDF.REST));
        vocab.put((Value)RDF.NIL, f.asValue(RDF.NIL));
        vocab.put((Value)BD.VIRTUAL_GRAPH, f.asValue(BD.VIRTUAL_GRAPH));
        for (BigdataValue value : this.nodes.values()) {
            vocab.put(value, value);
        }
        BigdataValue[] values = this.context.vocab.values().toArray(new BigdataValue[0]);
        this.context.lexicon.addTerms(values, values.length, this.readOnly);
        for (BigdataValue value : values) {
            IV iv = value.getIV();
            if (iv == null) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Not in knowledge base: " + value));
                }
                TermId<?> dummyIV = TermId.mockIV(VTE.valueOf(value));
                value.setIV(dummyIV);
                dummyIV.setValue(value);
                continue;
            }
            iv.setValue(value);
        }
        for (Map.Entry<ASTRDFValue, BigdataValue> e : this.nodes.entrySet()) {
            ASTRDFValue node = e.getKey();
            BigdataValue value = e.getValue();
            BigdataValue resolvedValue = this.context.vocab.get(value);
            node.setRDFValue(resolvedValue);
        }
    }

    private class RDFValueResolver
    extends ASTVisitorBase {
        private RDFValueResolver() {
        }

        @Override
        public Object visit(ASTQName node, Object data) throws VisitorException {
            throw new VisitorException("QNames must be resolved before resolving RDF Values");
        }

        @Override
        public Object visit(ASTBlankNode node, Object data) throws VisitorException {
            throw new VisitorException("Blank nodes must be replaced with variables before resolving RDF Values");
        }

        @Override
        public Void visit(ASTIRI node, Object data) throws VisitorException {
            try {
                BatchRDFValueResolver.this.nodes.put(node, ((BatchRDFValueResolver)BatchRDFValueResolver.this).context.valueFactory.createURI(node.getValue()));
                return null;
            }
            catch (IllegalArgumentException e) {
                throw new VisitorException(e.getMessage());
            }
        }

        @Override
        public Void visit(ASTRDFLiteral node, Object data) throws VisitorException {
            BigdataLiteral literal;
            String label = (String)node.getLabel().jjtAccept(this, null);
            String lang = node.getLang();
            ASTIRI datatypeNode = node.getDatatype();
            if (datatypeNode != null) {
                BigdataURI datatype;
                try {
                    datatype = BatchRDFValueResolver.this.valueFactory.createURI(datatypeNode.getValue());
                }
                catch (IllegalArgumentException e) {
                    throw new VisitorException(e);
                }
                literal = BatchRDFValueResolver.this.valueFactory.createLiteral(label, datatype);
            } else {
                literal = lang != null ? BatchRDFValueResolver.this.valueFactory.createLiteral(label, lang) : BatchRDFValueResolver.this.valueFactory.createLiteral(label);
            }
            BatchRDFValueResolver.this.nodes.put(node, literal);
            return null;
        }

        @Override
        public Void visit(ASTNumericLiteral node, Object data) throws VisitorException {
            BatchRDFValueResolver.this.nodes.put(node, ((BatchRDFValueResolver)BatchRDFValueResolver.this).context.valueFactory.createLiteral(node.getValue(), node.getDatatype()));
            return null;
        }

        @Override
        public Void visit(ASTTrue node, Object data) throws VisitorException {
            BatchRDFValueResolver.this.nodes.put(node, ((BatchRDFValueResolver)BatchRDFValueResolver.this).context.valueFactory.createLiteral(true));
            return null;
        }

        @Override
        public Void visit(ASTFalse node, Object data) throws VisitorException {
            BatchRDFValueResolver.this.nodes.put(node, ((BatchRDFValueResolver)BatchRDFValueResolver.this).context.valueFactory.createLiteral(false));
            return null;
        }

        @Override
        public String visit(ASTString node, Object data) throws VisitorException {
            return node.getValue();
        }
    }
}

