/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.sparql;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IConstraint;
import com.bigdata.bop.IValueExpression;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.IVariableOrConstant;
import com.bigdata.bop.bindingSet.ListBindingSet;
import com.bigdata.bop.solutions.GroupByState;
import com.bigdata.rdf.sail.sparql.BigdataASTContext;
import com.bigdata.rdf.sail.sparql.GroupGraphPatternBuilder;
import com.bigdata.rdf.sail.sparql.ast.ASTAskQuery;
import com.bigdata.rdf.sail.sparql.ast.ASTBindingSet;
import com.bigdata.rdf.sail.sparql.ast.ASTBindingValue;
import com.bigdata.rdf.sail.sparql.ast.ASTBindingsClause;
import com.bigdata.rdf.sail.sparql.ast.ASTConstruct;
import com.bigdata.rdf.sail.sparql.ast.ASTConstructQuery;
import com.bigdata.rdf.sail.sparql.ast.ASTDescribe;
import com.bigdata.rdf.sail.sparql.ast.ASTDescribeQuery;
import com.bigdata.rdf.sail.sparql.ast.ASTGraphPatternGroup;
import com.bigdata.rdf.sail.sparql.ast.ASTGroupClause;
import com.bigdata.rdf.sail.sparql.ast.ASTHavingClause;
import com.bigdata.rdf.sail.sparql.ast.ASTLimit;
import com.bigdata.rdf.sail.sparql.ast.ASTNamedSubquery;
import com.bigdata.rdf.sail.sparql.ast.ASTOffset;
import com.bigdata.rdf.sail.sparql.ast.ASTOrderClause;
import com.bigdata.rdf.sail.sparql.ast.ASTOrderCondition;
import com.bigdata.rdf.sail.sparql.ast.ASTProjectionElem;
import com.bigdata.rdf.sail.sparql.ast.ASTQuery;
import com.bigdata.rdf.sail.sparql.ast.ASTQueryContainer;
import com.bigdata.rdf.sail.sparql.ast.ASTSelect;
import com.bigdata.rdf.sail.sparql.ast.ASTSelectQuery;
import com.bigdata.rdf.sail.sparql.ast.ASTVar;
import com.bigdata.rdf.sail.sparql.ast.ASTWhereClause;
import com.bigdata.rdf.sail.sparql.ast.Node;
import com.bigdata.rdf.sail.sparql.ast.SimpleNode;
import com.bigdata.rdf.sail.sparql.ast.VisitorException;
import com.bigdata.rdf.sparql.ast.AssignmentNode;
import com.bigdata.rdf.sparql.ast.BindingsClause;
import com.bigdata.rdf.sparql.ast.ConstantNode;
import com.bigdata.rdf.sparql.ast.ConstructNode;
import com.bigdata.rdf.sparql.ast.GraphPatternGroup;
import com.bigdata.rdf.sparql.ast.GroupByNode;
import com.bigdata.rdf.sparql.ast.HavingNode;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.IProjectionDecl;
import com.bigdata.rdf.sparql.ast.IValueExpressionNode;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.NamedSubqueriesNode;
import com.bigdata.rdf.sparql.ast.NamedSubqueryRoot;
import com.bigdata.rdf.sparql.ast.OrderByExpr;
import com.bigdata.rdf.sparql.ast.OrderByNode;
import com.bigdata.rdf.sparql.ast.ProjectionNode;
import com.bigdata.rdf.sparql.ast.QueryBase;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.QueryType;
import com.bigdata.rdf.sparql.ast.SliceNode;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.StaticAnalysis;
import com.bigdata.rdf.sparql.ast.SubqueryRoot;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.ValueExpressionNode;
import com.bigdata.rdf.sparql.ast.VarNode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

public class BigdataExprBuilder
extends GroupGraphPatternBuilder {
    private static final Logger log = Logger.getLogger(BigdataExprBuilder.class);

    public BigdataExprBuilder(BigdataASTContext context) {
        super(context);
    }

    @Override
    public QueryRoot visit(ASTQueryContainer node, Object data) throws VisitorException {
        if (log.isInfoEnabled()) {
            log.info((Object)("\n" + node.dump(">")));
        }
        QueryRoot query = (QueryRoot)node.getQuery().jjtAccept(this, null);
        return query;
    }

    @Override
    public QueryBase visit(ASTSelectQuery astQuery, Object data) throws VisitorException {
        QueryBase queryRoot = this.getQueryBase(astQuery, data, QueryType.SELECT);
        this.handleNamedSubqueryClause(astQuery, queryRoot);
        this.handleSelect(astQuery.getSelect(), queryRoot);
        this.handleWhereClause(astQuery, queryRoot);
        this.handleGroupBy(astQuery, queryRoot);
        this.handleHaving(astQuery, queryRoot);
        this.handleOrderBy(astQuery, queryRoot);
        this.handleSlice(astQuery, queryRoot);
        this.handleBindings(astQuery, queryRoot);
        return queryRoot;
    }

    @Override
    public QueryBase visit(ASTAskQuery node, Object data) throws VisitorException {
        QueryBase queryRoot = this.getQueryBase(node, data, QueryType.ASK);
        this.handleNamedSubqueryClause(node, queryRoot);
        this.handleWhereClause(node, queryRoot);
        SliceNode slice = new SliceNode(0L, 1L);
        queryRoot.setSlice(slice);
        this.handleBindings(node, queryRoot);
        return queryRoot;
    }

    @Override
    public QueryBase visit(ASTDescribeQuery node, Object data) throws VisitorException {
        QueryBase queryRoot = this.getQueryBase(node, data, QueryType.DESCRIBE);
        this.handleNamedSubqueryClause(node, queryRoot);
        node.getDescribe().jjtAccept(this, queryRoot);
        this.handleWhereClause(node, queryRoot);
        this.handleGroupBy(node, queryRoot);
        this.handleHaving(node, queryRoot);
        this.handleOrderBy(node, queryRoot);
        this.handleSlice(node, queryRoot);
        this.handleBindings(node, queryRoot);
        return queryRoot;
    }

    @Override
    public Void visit(ASTDescribe node, Object data) throws VisitorException {
        QueryBase queryRoot = (QueryBase)data;
        ProjectionNode projection = new ProjectionNode();
        queryRoot.setProjection(projection);
        if (node.isWildcard()) {
            projection.addProjectionVar(new VarNode("*"));
        } else {
            int nchildren = node.jjtGetNumChildren();
            for (int i = 0; i < nchildren; ++i) {
                TermNode resource = (TermNode)node.jjtGetChild(i).jjtAccept(this, null);
                if (resource instanceof VarNode) {
                    projection.addProjectionVar((VarNode)resource);
                    continue;
                }
                VarNode anonVar = this.context.createAnonVar("-iri-");
                projection.addExpr(new AssignmentNode(anonVar, resource));
            }
        }
        return null;
    }

    @Override
    public QueryBase visit(ASTConstructQuery node, Object data) throws VisitorException {
        QueryBase queryRoot = this.getQueryBase(node, data, QueryType.CONSTRUCT);
        this.handleNamedSubqueryClause(node, queryRoot);
        ASTConstruct constructNode = node.getConstruct();
        ConstructNode tmp = (ConstructNode)constructNode.jjtAccept(this, null);
        this.handleWhereClause(node, queryRoot);
        if (tmp.isEmpty()) {
            JoinGroupNode whereClause = (JoinGroupNode)queryRoot.getWhereClause();
            for (IGroupMemberNode child : whereClause) {
                if (!(child instanceof StatementPatternNode)) {
                    throw new VisitorException("CONSTRUCT WHERE only permits statement patterns in the WHERE clause.");
                }
                StatementPatternNode sp = (StatementPatternNode)((StatementPatternNode)child).clone();
                tmp.addChild(sp);
            }
        }
        queryRoot.setConstruct(tmp);
        this.handleGroupBy(node, queryRoot);
        this.handleHaving(node, queryRoot);
        this.handleOrderBy(node, queryRoot);
        this.handleSlice(node, queryRoot);
        this.handleBindings(node, queryRoot);
        return queryRoot;
    }

    @Override
    public final GroupByNode visit(ASTGroupClause node, Object data) throws VisitorException {
        GroupByNode groupBy = new GroupByNode();
        int childCount = node.jjtGetNumChildren();
        for (int i = 0; i < childCount; ++i) {
            AssignmentNode expr = (AssignmentNode)node.jjtGetChild(i).jjtAccept(this, null);
            groupBy.addExpr(expr);
        }
        return groupBy;
    }

    @Override
    public final List<OrderByExpr> visit(ASTOrderClause node, Object data) throws VisitorException {
        int childCount = node.jjtGetNumChildren();
        ArrayList<OrderByExpr> elements = new ArrayList<OrderByExpr>(childCount);
        for (int i = 0; i < childCount; ++i) {
            elements.add((OrderByExpr)node.jjtGetChild(i).jjtAccept(this, null));
        }
        return elements;
    }

    @Override
    public final OrderByExpr visit(ASTOrderCondition node, Object data) throws VisitorException {
        ValueExpressionNode valueExpr = (ValueExpressionNode)node.jjtGetChild(0).jjtAccept(this, null);
        return new OrderByExpr(valueExpr, node.isAscending());
    }

    @Override
    public final Long visit(ASTLimit node, Object data) throws VisitorException {
        return node.getValue();
    }

    @Override
    public final Long visit(ASTOffset node, Object data) throws VisitorException {
        return node.getValue();
    }

    private void handleNamedSubqueryClause(ASTQuery astQuery, QueryBase queryRoot) throws VisitorException {
        ASTNamedSubquery aNamedSubquery = astQuery.jjtGetChild(ASTNamedSubquery.class);
        if (aNamedSubquery == null) {
            return;
        }
        if (!(queryRoot instanceof QueryRoot)) {
            throw new VisitorException("WITH SubSelect AS %namedSet only allowed for top-level query.");
        }
        NamedSubqueriesNode namedSubqueries = new NamedSubqueriesNode();
        ((QueryRoot)queryRoot).setNamedSubqueries(namedSubqueries);
        int nchildren = astQuery.jjtGetNumChildren();
        for (int i = 0; i < nchildren; ++i) {
            Node aChild = astQuery.jjtGetChild(i);
            if (!(aChild instanceof ASTNamedSubquery)) continue;
            ASTNamedSubquery aNamedSubquery2 = (ASTNamedSubquery)aChild;
            SubqueryRoot subquery = (SubqueryRoot)aNamedSubquery2.jjtAccept(this, queryRoot);
            NamedSubqueryRoot namedSubquery = new NamedSubqueryRoot(subquery.getQueryType(), aNamedSubquery2.getName());
            namedSubqueries.add(namedSubquery);
            for (BOp arg : subquery.args()) {
                namedSubquery.addArg(arg);
            }
            namedSubquery.copyAll(subquery.annotations());
        }
    }

    private QueryBase getQueryBase(ASTQuery node, Object data, QueryType queryType) {
        Node p = node.jjtGetParent();
        if (log.isInfoEnabled()) {
            log.info((Object)("parent=" + p + ", data=" + (data == null ? "null" : data.getClass().getSimpleName())));
        }
        if (p instanceof ASTQueryContainer) {
            return new QueryRoot(queryType);
        }
        return new SubqueryRoot(queryType);
    }

    protected void handleSelect(ASTSelect select, IProjectionDecl queryRoot) throws VisitorException {
        ProjectionNode projection = new ProjectionNode();
        queryRoot.setProjection(projection);
        if (select.isDistinct()) {
            projection.setDistinct(true);
        }
        if (select.isReduced()) {
            projection.setReduced(true);
        }
        if (select.isWildcard()) {
            projection.addProjectionVar(new VarNode("*"));
        } else {
            HashSet<String> vars = new HashSet<String>();
            for (ASTProjectionElem e : select.getProjectionElemList()) {
                String varname;
                if (!e.hasAlias()) {
                    ASTVar aVar = (ASTVar)e.jjtGetChild(0);
                    varname = aVar.getName();
                    projection.addProjectionVar(new VarNode(varname));
                } else {
                    SimpleNode expr = (SimpleNode)e.jjtGetChild(0);
                    IValueExpressionNode ve = (IValueExpressionNode)expr.jjtAccept(this, null);
                    varname = e.getAlias();
                    projection.addProjectionExpression(new AssignmentNode(new VarNode(varname), ve));
                }
                if (vars.add(varname)) continue;
                throw new VisitorException("duplicate variable in projection: " + varname);
            }
        }
    }

    private void handleWhereClause(ASTQuery astQuery, QueryBase queryRoot) throws VisitorException {
        ASTWhereClause whereClause = astQuery.getWhereClause();
        if (whereClause != null) {
            ASTGraphPatternGroup graphPatternGroup = whereClause.getGraphPatternGroup();
            this.graphPattern = this.scopedGroupGraphPattern(astQuery);
            GraphPatternGroup ret = (GraphPatternGroup)graphPatternGroup.jjtAccept(this, null);
            queryRoot.setWhereClause(ret);
        }
    }

    private void handleGroupBy(ASTQuery astQuery, QueryBase queryRoot) throws VisitorException {
        ASTGroupClause groupNode = astQuery.getGroupClause();
        if (groupNode == null) {
            return;
        }
        GroupByNode groupBy = (GroupByNode)groupNode.jjtAccept(this, null);
        queryRoot.setGroupBy(groupBy);
    }

    private void handleHaving(ASTQuery astQuery, QueryBase queryRoot) throws VisitorException {
        ASTHavingClause havingClause = astQuery.getHavingClause();
        if (havingClause != null) {
            HavingNode havingNode = new HavingNode();
            int nchildren = havingClause.jjtGetNumChildren();
            for (int i = 0; i < nchildren; ++i) {
                IValueExpressionNode ve = (IValueExpressionNode)havingClause.jjtGetChild(i).jjtAccept(this, null);
                havingNode.addExpr(ve);
            }
            queryRoot.setHaving(havingNode);
        }
    }

    private void handleOrderBy(ASTQuery astQuery, QueryBase queryRoot) throws VisitorException {
        ASTOrderClause orderNode = astQuery.getOrderClause();
        if (orderNode != null) {
            OrderByNode orderBy = new OrderByNode();
            List orderElemements = (List)orderNode.jjtAccept(this, null);
            for (OrderByExpr orderByExpr : orderElemements) {
                orderBy.addExpr(orderByExpr);
            }
            queryRoot.setOrderBy(orderBy);
        }
    }

    private void handleSlice(ASTQuery astQuery, QueryBase queryRoot) {
        ASTLimit theLimit = astQuery.getLimit();
        ASTOffset theOffset = astQuery.getOffset();
        if (theLimit != null || theOffset != null) {
            SliceNode theSlice = new SliceNode();
            if (theLimit != null) {
                theSlice.setLimit(theLimit.getValue());
            }
            if (theOffset != null) {
                theSlice.setOffset(theOffset.getValue());
            }
            queryRoot.setSlice(theSlice);
        }
    }

    private void handleBindings(ASTQuery astQuery, QueryBase queryRoot) throws VisitorException {
        ASTBindingsClause bindingsClause = astQuery.getBindingsClause();
        if (bindingsClause == null) {
            return;
        }
        BindingsClause bindingSets = this.visit(bindingsClause, null);
        if (bindingSets.getBindingSetsCount() > 0) {
            queryRoot.setBindingsClause(bindingSets);
        }
    }

    @Override
    public final BindingsClause visit(ASTBindingsClause node, Object data) throws VisitorException {
        List<ASTVar> varNodes = node.jjtGetChildren(ASTVar.class);
        int nvars = varNodes.size();
        LinkedHashSet vars = new LinkedHashSet(nvars);
        for (ASTVar varNode : varNodes) {
            VarNode var = (VarNode)varNode.jjtAccept(this, data);
            IVariableOrConstant v = var.getValueExpression();
            if (vars.add((IVariable<?>)v)) continue;
            throw new VisitorException("duplicate variable in BINDINGS");
        }
        List<ASTBindingSet> bindingNodes = node.jjtGetChildren(ASTBindingSet.class);
        LinkedList<IBindingSet> bindingSets = new LinkedList<IBindingSet>();
        IVariable[] declaredVars = vars.toArray(new IVariable[nvars]);
        for (ASTBindingSet bindingNode : bindingNodes) {
            IBindingSet bindingSet = (IBindingSet)bindingNode.jjtAccept(this, declaredVars);
            bindingSets.add(bindingSet);
        }
        return new BindingsClause(vars, bindingSets);
    }

    @Override
    public IBindingSet visit(ASTBindingSet node, Object data) throws VisitorException {
        IVariable[] vars = (IVariable[])data;
        int numberOfBindingValues = node.jjtGetNumChildren();
        if (numberOfBindingValues != vars.length) {
            throw new VisitorException("number of values in bindingset does not match variables in BINDINGS clause");
        }
        ListBindingSet bset = new ListBindingSet();
        for (int i = 0; i < numberOfBindingValues; ++i) {
            ConstantNode ve = (ConstantNode)node.jjtGetChild(i).jjtAccept(this, null);
            if (ve == null) continue;
            bset.set(vars[i], (IConstant)ve.getValueExpression());
        }
        return bset;
    }

    @Override
    public ValueExpressionNode visit(ASTBindingValue node, Object data) throws VisitorException {
        if (node.jjtGetNumChildren() > 0) {
            return (ValueExpressionNode)node.jjtGetChild(0).jjtAccept(this, data);
        }
        return null;
    }

    public static void verifyAggregate(QueryBase queryBase) throws VisitorException {
        GroupByNode groupBy;
        ProjectionNode projection;
        ProjectionNode projectionNode = queryBase.getProjection() == null ? null : (projection = queryBase.getProjection().isEmpty() ? null : queryBase.getProjection());
        GroupByNode groupByNode = queryBase.getGroupBy() == null ? null : (groupBy = queryBase.getGroupBy().isEmpty() ? null : queryBase.getGroupBy());
        HavingNode having = queryBase.getHaving() == null ? null : (queryBase.getHaving().isEmpty() ? null : queryBase.getHaving());
        boolean isAggregate = StaticAnalysis.isAggregate(projection, groupBy, having);
        if (isAggregate) {
            if (projection.isWildcard()) {
                throw new VisitorException("Wildcard not allowed with aggregate.");
            }
            IValueExpression[] projectExprs = projection.getValueExpressions();
            IValueExpression[] groupByExprs = groupBy == null ? null : groupBy.getValueExpressions();
            IConstraint[] havingExprs = having == null ? null : having.getConstraints();
            try {
                new GroupByState(projectExprs, groupByExprs, havingExprs);
            }
            catch (IllegalArgumentException ex) {
                throw new VisitorException("Bad aggregate", ex);
            }
        }
    }
}

