/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.sparql;

import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.sail.sparql.BigdataASTContext;
import com.bigdata.rdf.sail.sparql.ast.ASTDatasetClause;
import com.bigdata.rdf.sail.sparql.ast.ASTIRI;
import com.bigdata.rdf.sail.sparql.ast.ASTOperation;
import com.bigdata.rdf.sail.sparql.ast.ASTOperationContainer;
import com.bigdata.rdf.sail.sparql.ast.ASTUpdateContainer;
import com.bigdata.rdf.sparql.ast.DatasetNode;
import com.bigdata.rdf.sparql.ast.QuadsOperationInTriplesModeException;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.store.BD;
import com.bigdata.relation.accesspath.IAccessPath;
import com.bigdata.striterator.IChunkedOrderedIterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.openrdf.query.MalformedQueryException;

public class DatasetDeclProcessor {
    private final BigdataASTContext context;
    private Set<IV<?, ?>> defaultGraphs = null;
    private Set<IV<?, ?>> namedGraphs = null;

    private void addGraph(IV<?, ?> graph, boolean named) {
        if (graph == null) {
            throw new IllegalArgumentException();
        }
        if (named) {
            if (this.namedGraphs == null) {
                this.namedGraphs = new LinkedHashSet();
            }
            this.namedGraphs.add(graph);
        } else {
            if (this.defaultGraphs == null) {
                this.defaultGraphs = new LinkedHashSet();
            }
            this.defaultGraphs.add(graph);
        }
    }

    public DatasetDeclProcessor(BigdataASTContext context) {
        this.context = context;
    }

    public DatasetNode process(ASTOperationContainer qc) throws MalformedQueryException {
        boolean update = qc instanceof ASTUpdateContainer;
        ASTOperation op = qc.getOperation();
        if (op == null) {
            return null;
        }
        List<ASTDatasetClause> datasetClauses = op.getDatasetClauseList();
        BigdataURI virtualGraph = null;
        if (!datasetClauses.isEmpty()) {
            if (!this.context.tripleStore.isQuads()) {
                throw new QuadsOperationInTriplesModeException("NAMED clauses in queries are not supported in triples mode.");
            }
            for (ASTDatasetClause dc : datasetClauses) {
                ASTIRI astIri = dc.jjtGetChild(ASTIRI.class);
                try {
                    BigdataURI uri = (BigdataURI)astIri.getRDFValue();
                    if (dc.isVirtual()) {
                        if (uri.getIV().isNullIV()) {
                            throw new RuntimeException("Not declared: " + uri);
                        }
                        if (virtualGraph == null && ((virtualGraph = (BigdataURI)this.context.vocab.get(BD.VIRTUAL_GRAPH)) == null || virtualGraph.getIV() == null)) {
                            throw new RuntimeException("Not declared: " + BD.VIRTUAL_GRAPH);
                        }
                        IAccessPath<ISPO> ap = this.context.tripleStore.getSPORelation().getAccessPath(uri.getIV(), virtualGraph.getIV(), null, null);
                        IChunkedOrderedIterator<ISPO> itr = ap.iterator();
                        while (itr.hasNext()) {
                            IV memberGraph = ((ISPO)itr.next()).o();
                            this.addGraph(memberGraph, dc.isNamed());
                        }
                        continue;
                    }
                    this.addGraph(uri.getIV(), dc.isNamed());
                }
                catch (IllegalArgumentException e) {
                    throw new MalformedQueryException(e.getMessage(), (Throwable)e);
                }
            }
        }
        if (this.defaultGraphs == null && this.namedGraphs == null) {
            return null;
        }
        DatasetNode dsn = new DatasetNode(this.defaultGraphs, this.namedGraphs, update);
        return dsn;
    }
}

