/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.sparql;

import com.bigdata.bop.aggregate.AggregateBase;
import com.bigdata.rdf.internal.constraints.IriBOp;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.sail.sparql.BigdataASTContext;
import com.bigdata.rdf.sail.sparql.BigdataASTVisitorBase;
import com.bigdata.rdf.sail.sparql.GroupGraphPattern;
import com.bigdata.rdf.sail.sparql.ast.ASTAbs;
import com.bigdata.rdf.sail.sparql.ast.ASTAggregate;
import com.bigdata.rdf.sail.sparql.ast.ASTAnd;
import com.bigdata.rdf.sail.sparql.ast.ASTAvg;
import com.bigdata.rdf.sail.sparql.ast.ASTBNodeFunc;
import com.bigdata.rdf.sail.sparql.ast.ASTBound;
import com.bigdata.rdf.sail.sparql.ast.ASTCeil;
import com.bigdata.rdf.sail.sparql.ast.ASTCoalesce;
import com.bigdata.rdf.sail.sparql.ast.ASTCompare;
import com.bigdata.rdf.sail.sparql.ast.ASTConcat;
import com.bigdata.rdf.sail.sparql.ast.ASTContains;
import com.bigdata.rdf.sail.sparql.ast.ASTCount;
import com.bigdata.rdf.sail.sparql.ast.ASTDatatype;
import com.bigdata.rdf.sail.sparql.ast.ASTDay;
import com.bigdata.rdf.sail.sparql.ast.ASTEncodeForURI;
import com.bigdata.rdf.sail.sparql.ast.ASTExistsFunc;
import com.bigdata.rdf.sail.sparql.ast.ASTFloor;
import com.bigdata.rdf.sail.sparql.ast.ASTFunctionCall;
import com.bigdata.rdf.sail.sparql.ast.ASTGroupConcat;
import com.bigdata.rdf.sail.sparql.ast.ASTGroupCondition;
import com.bigdata.rdf.sail.sparql.ast.ASTHours;
import com.bigdata.rdf.sail.sparql.ast.ASTIRIFunc;
import com.bigdata.rdf.sail.sparql.ast.ASTIf;
import com.bigdata.rdf.sail.sparql.ast.ASTIn;
import com.bigdata.rdf.sail.sparql.ast.ASTInfix;
import com.bigdata.rdf.sail.sparql.ast.ASTIsBlank;
import com.bigdata.rdf.sail.sparql.ast.ASTIsIRI;
import com.bigdata.rdf.sail.sparql.ast.ASTIsLiteral;
import com.bigdata.rdf.sail.sparql.ast.ASTIsNumeric;
import com.bigdata.rdf.sail.sparql.ast.ASTLang;
import com.bigdata.rdf.sail.sparql.ast.ASTLangMatches;
import com.bigdata.rdf.sail.sparql.ast.ASTLowerCase;
import com.bigdata.rdf.sail.sparql.ast.ASTMD5;
import com.bigdata.rdf.sail.sparql.ast.ASTMath;
import com.bigdata.rdf.sail.sparql.ast.ASTMax;
import com.bigdata.rdf.sail.sparql.ast.ASTMin;
import com.bigdata.rdf.sail.sparql.ast.ASTMinutes;
import com.bigdata.rdf.sail.sparql.ast.ASTMonth;
import com.bigdata.rdf.sail.sparql.ast.ASTNot;
import com.bigdata.rdf.sail.sparql.ast.ASTNotExistsFunc;
import com.bigdata.rdf.sail.sparql.ast.ASTNotIn;
import com.bigdata.rdf.sail.sparql.ast.ASTNow;
import com.bigdata.rdf.sail.sparql.ast.ASTOr;
import com.bigdata.rdf.sail.sparql.ast.ASTRand;
import com.bigdata.rdf.sail.sparql.ast.ASTRegexExpression;
import com.bigdata.rdf.sail.sparql.ast.ASTReplace;
import com.bigdata.rdf.sail.sparql.ast.ASTRound;
import com.bigdata.rdf.sail.sparql.ast.ASTSHA1;
import com.bigdata.rdf.sail.sparql.ast.ASTSHA224;
import com.bigdata.rdf.sail.sparql.ast.ASTSHA256;
import com.bigdata.rdf.sail.sparql.ast.ASTSHA384;
import com.bigdata.rdf.sail.sparql.ast.ASTSHA512;
import com.bigdata.rdf.sail.sparql.ast.ASTSTRUUID;
import com.bigdata.rdf.sail.sparql.ast.ASTSameTerm;
import com.bigdata.rdf.sail.sparql.ast.ASTSample;
import com.bigdata.rdf.sail.sparql.ast.ASTSeconds;
import com.bigdata.rdf.sail.sparql.ast.ASTStr;
import com.bigdata.rdf.sail.sparql.ast.ASTStrAfter;
import com.bigdata.rdf.sail.sparql.ast.ASTStrBefore;
import com.bigdata.rdf.sail.sparql.ast.ASTStrDt;
import com.bigdata.rdf.sail.sparql.ast.ASTStrEnds;
import com.bigdata.rdf.sail.sparql.ast.ASTStrLang;
import com.bigdata.rdf.sail.sparql.ast.ASTStrLen;
import com.bigdata.rdf.sail.sparql.ast.ASTStrStarts;
import com.bigdata.rdf.sail.sparql.ast.ASTSubstr;
import com.bigdata.rdf.sail.sparql.ast.ASTSum;
import com.bigdata.rdf.sail.sparql.ast.ASTTimezone;
import com.bigdata.rdf.sail.sparql.ast.ASTTz;
import com.bigdata.rdf.sail.sparql.ast.ASTUUID;
import com.bigdata.rdf.sail.sparql.ast.ASTUpperCase;
import com.bigdata.rdf.sail.sparql.ast.ASTYear;
import com.bigdata.rdf.sail.sparql.ast.Node;
import com.bigdata.rdf.sail.sparql.ast.SimpleNode;
import com.bigdata.rdf.sail.sparql.ast.VisitorException;
import com.bigdata.rdf.sparql.ast.AssignmentNode;
import com.bigdata.rdf.sparql.ast.ConstantNode;
import com.bigdata.rdf.sparql.ast.ExistsNode;
import com.bigdata.rdf.sparql.ast.FunctionNode;
import com.bigdata.rdf.sparql.ast.FunctionRegistry;
import com.bigdata.rdf.sparql.ast.GraphPatternGroup;
import com.bigdata.rdf.sparql.ast.IValueExpressionNode;
import com.bigdata.rdf.sparql.ast.NotExistsNode;
import com.bigdata.rdf.sparql.ast.ValueExpressionNode;
import com.bigdata.rdf.sparql.ast.VarNode;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.openrdf.model.URI;
import org.openrdf.model.vocabulary.FN;

public class ValueExprBuilder
extends BigdataASTVisitorBase {
    protected GroupGraphPattern graphPattern;

    public ValueExprBuilder(BigdataASTContext context) {
        super(context);
    }

    protected ValueExpressionNode left(SimpleNode node) throws VisitorException {
        return (ValueExpressionNode)node.jjtGetChild(0).jjtAccept(this, null);
    }

    protected ValueExpressionNode right(SimpleNode node) throws VisitorException {
        return (ValueExpressionNode)node.jjtGetChild(1).jjtAccept(this, null);
    }

    protected FunctionNode noneary(SimpleNode node, URI functionURI) throws VisitorException {
        return new FunctionNode(functionURI, null, new ValueExpressionNode[0]);
    }

    protected FunctionNode unary(SimpleNode node, URI functionURI) throws VisitorException {
        return new FunctionNode(functionURI, null, this.left(node));
    }

    protected FunctionNode binary(SimpleNode node, URI functionURI) throws VisitorException {
        return new FunctionNode(functionURI, null, this.left(node), this.right(node));
    }

    protected FunctionNode ternary(SimpleNode node, URI functionURI) throws VisitorException {
        return new FunctionNode(functionURI, null, this.left(node), this.right(node), (ValueExpressionNode)node.jjtGetChild(2).jjtAccept(this, null));
    }

    protected FunctionNode quadary(SimpleNode node, URI functionURI) throws VisitorException {
        return new FunctionNode(functionURI, null, this.left(node), this.right(node), (ValueExpressionNode)node.jjtGetChild(2).jjtAccept(this, null), (ValueExpressionNode)node.jjtGetChild(3).jjtAccept(this, null));
    }

    protected FunctionNode nary(SimpleNode node, URI functionURI) throws VisitorException {
        int nargs = node.jjtGetNumChildren();
        ValueExpressionNode[] args = new ValueExpressionNode[nargs];
        for (int i = 0; i < nargs; ++i) {
            Node argNode = node.jjtGetChild(i);
            args[i] = (ValueExpressionNode)argNode.jjtAccept(this, null);
        }
        if (functionURI.equals((Object)FunctionRegistry.COALESCE)) {
            return new FunctionNode(FunctionRegistry.COALESCE, null, args);
        }
        if (functionURI.equals((Object)FN.SUBSTRING)) {
            return new FunctionNode(FunctionRegistry.SUBSTR, null, args);
        }
        if (functionURI.equals((Object)FN.CONCAT)) {
            return new FunctionNode(FunctionRegistry.CONCAT, null, args);
        }
        throw new IllegalArgumentException();
    }

    protected FunctionNode aggregate(ASTAggregate node, URI functionURI) throws VisitorException {
        Map<String, Object> scalarValues = null;
        if (node.isDistinct()) {
            scalarValues = Collections.singletonMap(AggregateBase.Annotations.DISTINCT, Boolean.TRUE);
        }
        if (node instanceof ASTCount && ((ASTCount)node).isWildcard()) {
            return new FunctionNode(functionURI, scalarValues, new VarNode("*"));
        }
        return new FunctionNode(functionURI, scalarValues, this.left(node));
    }

    @Override
    public final FunctionNode visit(ASTOr node, Object data) throws VisitorException {
        return this.binary(node, FunctionRegistry.OR);
    }

    @Override
    public final FunctionNode visit(ASTAnd node, Object data) throws VisitorException {
        return this.binary(node, FunctionRegistry.AND);
    }

    @Override
    public final FunctionNode visit(ASTNot node, Object data) throws VisitorException {
        return this.unary(node, FunctionRegistry.NOT);
    }

    @Override
    public final FunctionNode visit(ASTCoalesce node, Object data) throws VisitorException {
        return this.nary(node, FunctionRegistry.COALESCE);
    }

    @Override
    public final FunctionNode visit(ASTCompare node, Object data) throws VisitorException {
        URI functionURI;
        switch (node.getOperator()) {
            case LT: {
                functionURI = FunctionRegistry.LT;
                break;
            }
            case GT: {
                functionURI = FunctionRegistry.GT;
                break;
            }
            case EQ: {
                functionURI = FunctionRegistry.EQ;
                break;
            }
            case LE: {
                functionURI = FunctionRegistry.LE;
                break;
            }
            case GE: {
                functionURI = FunctionRegistry.GE;
                break;
            }
            case NE: {
                functionURI = FunctionRegistry.NE;
                break;
            }
            default: {
                throw new UnsupportedOperationException(node.getOperator().getSymbol());
            }
        }
        return this.binary(node, functionURI);
    }

    @Override
    public final FunctionNode visit(ASTSubstr node, Object data) throws VisitorException {
        return this.nary(node, FN.SUBSTRING);
    }

    @Override
    public final FunctionNode visit(ASTConcat node, Object data) throws VisitorException {
        return this.nary(node, FN.CONCAT);
    }

    @Override
    public final FunctionNode visit(ASTAbs node, Object data) throws VisitorException {
        return this.unary(node, FN.NUMERIC_ABS);
    }

    @Override
    public final FunctionNode visit(ASTCeil node, Object data) throws VisitorException {
        return this.unary(node, FN.NUMERIC_CEIL);
    }

    @Override
    public final FunctionNode visit(ASTContains node, Object data) throws VisitorException {
        return this.binary(node, FN.CONTAINS);
    }

    @Override
    public final FunctionNode visit(ASTFloor node, Object data) throws VisitorException {
        return this.unary(node, FN.NUMERIC_FLOOR);
    }

    @Override
    public final FunctionNode visit(ASTRound node, Object data) throws VisitorException {
        return this.unary(node, FN.NUMERIC_ROUND);
    }

    @Override
    public final FunctionNode visit(ASTRand node, Object data) throws VisitorException {
        return this.noneary(node, FunctionRegistry.RAND);
    }

    @Override
    public final FunctionNode visit(ASTSameTerm node, Object data) throws VisitorException {
        return this.binary(node, FunctionRegistry.SAME_TERM);
    }

    @Override
    public final FunctionNode visit(ASTMath node, Object data) throws VisitorException {
        URI functionURI;
        switch (node.getOperator()) {
            case PLUS: {
                functionURI = FunctionRegistry.ADD;
                break;
            }
            case MINUS: {
                functionURI = FunctionRegistry.SUBTRACT;
                break;
            }
            case MULTIPLY: {
                functionURI = FunctionRegistry.MULTIPLY;
                break;
            }
            case DIVIDE: {
                functionURI = FunctionRegistry.DIVIDE;
                break;
            }
            default: {
                throw new UnsupportedOperationException(node.getOperator().getSymbol());
            }
        }
        return this.binary(node, functionURI);
    }

    @Override
    public final FunctionNode visit(ASTFunctionCall node, Object data) throws VisitorException {
        ConstantNode uriNode = (ConstantNode)node.jjtGetChild(0).jjtAccept(this, null);
        BigdataURI functionURI = (BigdataURI)uriNode.getValue();
        int nargs = node.jjtGetNumChildren() - 1;
        ValueExpressionNode[] args = new ValueExpressionNode[nargs];
        for (int i = 0; i < nargs; ++i) {
            Node argNode = node.jjtGetChild(i + 1);
            args[i] = (ValueExpressionNode)argNode.jjtAccept(this, null);
        }
        return new FunctionNode(functionURI, null, args);
    }

    @Override
    public final FunctionNode visit(ASTEncodeForURI node, Object data) throws VisitorException {
        return this.unary(node, FN.ENCODE_FOR_URI);
    }

    @Override
    public final FunctionNode visit(ASTStr node, Object data) throws VisitorException {
        return this.unary(node, FunctionRegistry.STR);
    }

    @Override
    public final FunctionNode visit(ASTStrDt node, Object data) throws VisitorException {
        return this.binary(node, FunctionRegistry.STR_DT);
    }

    @Override
    public final FunctionNode visit(ASTStrStarts node, Object data) throws VisitorException {
        return this.binary(node, FN.STARTS_WITH);
    }

    @Override
    public final FunctionNode visit(ASTStrEnds node, Object data) throws VisitorException {
        return this.binary(node, FN.ENDS_WITH);
    }

    @Override
    public final FunctionNode visit(ASTStrLen node, Object data) throws VisitorException {
        return this.unary(node, FN.STRING_LENGTH);
    }

    @Override
    public final FunctionNode visit(ASTStrAfter node, Object data) throws VisitorException {
        return this.binary(node, FunctionRegistry.STR_AFTER);
    }

    @Override
    public final FunctionNode visit(ASTStrBefore node, Object data) throws VisitorException {
        return this.binary(node, FunctionRegistry.STR_BEFORE);
    }

    @Override
    public final FunctionNode visit(ASTUpperCase node, Object data) throws VisitorException {
        return this.unary(node, FN.UPPER_CASE);
    }

    @Override
    public final FunctionNode visit(ASTLowerCase node, Object data) throws VisitorException {
        return this.unary(node, FN.LOWER_CASE);
    }

    @Override
    public final FunctionNode visit(ASTStrLang node, Object data) throws VisitorException {
        return this.binary(node, FunctionRegistry.STR_LANG);
    }

    @Override
    public final FunctionNode visit(ASTNow node, Object data) throws VisitorException {
        return this.noneary(node, FunctionRegistry.NOW);
    }

    @Override
    public final FunctionNode visit(ASTYear node, Object data) throws VisitorException {
        return this.unary(node, FN.YEAR_FROM_DATETIME);
    }

    @Override
    public final FunctionNode visit(ASTMonth node, Object data) throws VisitorException {
        return this.unary(node, FN.MONTH_FROM_DATETIME);
    }

    @Override
    public final FunctionNode visit(ASTDay node, Object data) throws VisitorException {
        return this.unary(node, FN.DAY_FROM_DATETIME);
    }

    @Override
    public final FunctionNode visit(ASTHours node, Object data) throws VisitorException {
        return this.unary(node, FN.HOURS_FROM_DATETIME);
    }

    @Override
    public final FunctionNode visit(ASTMinutes node, Object data) throws VisitorException {
        return this.unary(node, FN.MINUTES_FROM_DATETIME);
    }

    @Override
    public final FunctionNode visit(ASTSeconds node, Object data) throws VisitorException {
        return this.unary(node, FN.SECONDS_FROM_DATETIME);
    }

    @Override
    public final FunctionNode visit(ASTTimezone node, Object data) throws VisitorException {
        return this.unary(node, FunctionRegistry.TIMEZONE);
    }

    @Override
    public final FunctionNode visit(ASTTz node, Object data) throws VisitorException {
        return this.unary(node, FunctionRegistry.TZ);
    }

    @Override
    public final FunctionNode visit(ASTMD5 node, Object data) throws VisitorException {
        return this.unary(node, FunctionRegistry.MD5);
    }

    @Override
    public final FunctionNode visit(ASTSHA1 node, Object data) throws VisitorException {
        return this.unary(node, FunctionRegistry.SHA1);
    }

    @Override
    public final FunctionNode visit(ASTSHA224 node, Object data) throws VisitorException {
        return this.unary(node, FunctionRegistry.SHA224);
    }

    @Override
    public final FunctionNode visit(ASTSHA256 node, Object data) throws VisitorException {
        return this.unary(node, FunctionRegistry.SHA256);
    }

    @Override
    public final FunctionNode visit(ASTSHA384 node, Object data) throws VisitorException {
        return this.unary(node, FunctionRegistry.SHA384);
    }

    @Override
    public final FunctionNode visit(ASTSHA512 node, Object data) throws VisitorException {
        return this.unary(node, FunctionRegistry.SHA512);
    }

    @Override
    public FunctionNode visit(ASTUUID node, Object data) throws VisitorException {
        return this.noneary(node, FunctionRegistry.UUID);
    }

    @Override
    public FunctionNode visit(ASTSTRUUID node, Object data) throws VisitorException {
        return this.noneary(node, FunctionRegistry.STRUUID);
    }

    @Override
    public final FunctionNode visit(ASTIRIFunc node, Object data) throws VisitorException {
        return new FunctionNode(FunctionRegistry.IRI, Collections.singletonMap(IriBOp.Annotations.BASE_URI, node.getBaseURI()), this.left(node));
    }

    @Override
    public final FunctionNode visit(ASTLang node, Object data) throws VisitorException {
        return this.unary(node, FunctionRegistry.LANG);
    }

    @Override
    public final FunctionNode visit(ASTDatatype node, Object data) throws VisitorException {
        return this.unary(node, FunctionRegistry.DATATYPE);
    }

    @Override
    public final FunctionNode visit(ASTLangMatches node, Object data) throws VisitorException {
        return this.binary(node, FunctionRegistry.LANG_MATCHES);
    }

    @Override
    public final FunctionNode visit(ASTBound node, Object data) throws VisitorException {
        return this.unary(node, FunctionRegistry.BOUND);
    }

    @Override
    public final FunctionNode visit(ASTIsIRI node, Object data) throws VisitorException {
        return this.unary(node, FunctionRegistry.IS_IRI);
    }

    @Override
    public final FunctionNode visit(ASTIsBlank node, Object data) throws VisitorException {
        return this.unary(node, FunctionRegistry.IS_BLANK);
    }

    @Override
    public final FunctionNode visit(ASTIsLiteral node, Object data) throws VisitorException {
        return this.unary(node, FunctionRegistry.IS_LITERAL);
    }

    @Override
    public final FunctionNode visit(ASTIsNumeric node, Object data) throws VisitorException {
        return this.unary(node, FunctionRegistry.IS_NUMERIC);
    }

    @Override
    public final FunctionNode visit(ASTBNodeFunc node, Object data) throws VisitorException {
        if (node.jjtGetNumChildren() == 0) {
            return this.noneary(node, FunctionRegistry.BNODE);
        }
        return this.unary(node, FunctionRegistry.BNODE);
    }

    @Override
    public final FunctionNode visit(ASTRegexExpression node, Object data) throws VisitorException {
        if (node.jjtGetNumChildren() == 2) {
            return this.binary(node, FunctionRegistry.REGEX);
        }
        return this.ternary(node, FunctionRegistry.REGEX);
    }

    @Override
    public FunctionNode visit(ASTReplace node, Object data) throws VisitorException {
        if (node.jjtGetNumChildren() == 3) {
            return this.ternary(node, FunctionRegistry.REPLACE);
        }
        return this.quadary(node, FunctionRegistry.REPLACE);
    }

    @Override
    public final ExistsNode visit(ASTExistsFunc node, Object data) throws VisitorException {
        VarNode anonvar = this.context.createAnonVar("-exists-");
        GroupGraphPattern parentGP = this.graphPattern;
        this.graphPattern = this.scopedGroupGraphPattern(node);
        GraphPatternGroup innerGraphPattern = (GraphPatternGroup)node.jjtGetChild(0).jjtAccept(this, null);
        ExistsNode fn = new ExistsNode(anonvar, innerGraphPattern);
        this.graphPattern = parentGP;
        return fn;
    }

    @Override
    public final NotExistsNode visit(ASTNotExistsFunc node, Object data) throws VisitorException {
        VarNode anonvar = this.context.createAnonVar("-exists-");
        GroupGraphPattern parentGP = this.graphPattern;
        this.graphPattern = this.scopedGroupGraphPattern(node);
        GraphPatternGroup innerGraphPattern = (GraphPatternGroup)node.jjtGetChild(0).jjtAccept(this, null);
        NotExistsNode fn = new NotExistsNode(anonvar, innerGraphPattern);
        this.graphPattern = parentGP;
        return fn;
    }

    @Override
    public final FunctionNode visit(ASTIf node, Object data) throws VisitorException {
        return this.ternary(node, FunctionRegistry.IF);
    }

    @Override
    public final FunctionNode visit(ASTInfix node, Object data) throws VisitorException {
        Node left = node.jjtGetChild(0);
        Node op = node.jjtGetChild(1);
        op.jjtInsertChild(left, 0);
        return (FunctionNode)op.jjtAccept(this, data);
    }

    @Override
    public final FunctionNode visit(ASTIn node, Object data) throws VisitorException {
        int nargs = node.jjtGetNumChildren();
        ValueExpressionNode[] args = new ValueExpressionNode[nargs];
        for (int i = 0; i < nargs; ++i) {
            Node argNode = node.jjtGetChild(i);
            args[i] = (ValueExpressionNode)argNode.jjtAccept(this, null);
        }
        return new FunctionNode(FunctionRegistry.IN, null, args);
    }

    @Override
    public final FunctionNode visit(ASTNotIn node, Object data) throws VisitorException {
        int nargs = node.jjtGetNumChildren();
        ValueExpressionNode[] args = new ValueExpressionNode[nargs];
        for (int i = 0; i < nargs; ++i) {
            Node argNode = node.jjtGetChild(i);
            args[i] = (ValueExpressionNode)argNode.jjtAccept(this, null);
        }
        return new FunctionNode(FunctionRegistry.NOT_IN, null, args);
    }

    @Override
    public final AssignmentNode visit(ASTGroupCondition node, Object data) throws VisitorException {
        IValueExpressionNode ve = (IValueExpressionNode)node.jjtGetChild(0).jjtAccept(this, data);
        if (node.jjtGetNumChildren() == 2) {
            IValueExpressionNode asVar = (IValueExpressionNode)node.jjtGetChild(1).jjtAccept(this, data);
            return new AssignmentNode((VarNode)asVar, ve);
        }
        if (ve instanceof VarNode) {
            return new AssignmentNode((VarNode)ve, (VarNode)ve);
        }
        return new AssignmentNode(this.context.createAnonVar("-groupBy-"), ve);
    }

    @Override
    public final FunctionNode visit(ASTCount node, Object data) throws VisitorException {
        return this.aggregate(node, FunctionRegistry.COUNT);
    }

    @Override
    public final FunctionNode visit(ASTMax node, Object data) throws VisitorException {
        return this.aggregate(node, FunctionRegistry.MAX);
    }

    @Override
    public final FunctionNode visit(ASTMin node, Object data) throws VisitorException {
        return this.aggregate(node, FunctionRegistry.MIN);
    }

    @Override
    public final FunctionNode visit(ASTSum node, Object data) throws VisitorException {
        return this.aggregate(node, FunctionRegistry.SUM);
    }

    @Override
    public final FunctionNode visit(ASTAvg node, Object data) throws VisitorException {
        return this.aggregate(node, FunctionRegistry.AVERAGE);
    }

    @Override
    public final FunctionNode visit(ASTSample node, Object data) throws VisitorException {
        return this.aggregate(node, FunctionRegistry.SAMPLE);
    }

    @Override
    public final FunctionNode visit(ASTGroupConcat node, Object data) throws VisitorException {
        LinkedHashMap<String, Object> scalarValues = new LinkedHashMap<String, Object>();
        if (node.isDistinct()) {
            scalarValues.put(AggregateBase.Annotations.DISTINCT, Boolean.TRUE);
        }
        if (node.jjtGetNumChildren() > 1) {
            ConstantNode separator = (ConstantNode)node.jjtGetChild(1).jjtAccept(this, data);
            scalarValues.put("separator", separator.getValue().stringValue());
        }
        return new FunctionNode(FunctionRegistry.GROUP_CONCAT, scalarValues, this.left(node));
    }
}

