/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp;

import com.bigdata.Banner;
import com.bigdata.bop.engine.QueryEngine;
import com.bigdata.bop.fed.QueryEngineFactory;
import com.bigdata.cache.SynchronizedHardReferenceQueueWithTimeout;
import com.bigdata.counters.CounterSet;
import com.bigdata.counters.ICounterSetAccess;
import com.bigdata.io.DirectBufferPool;
import com.bigdata.journal.IIndexManager;
import com.bigdata.journal.ITransactionService;
import com.bigdata.journal.Journal;
import com.bigdata.rdf.ServiceProviderHook;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.CreateKBTask;
import com.bigdata.rdf.sail.webapp.BigdataRDFContext;
import com.bigdata.rdf.sail.webapp.BigdataRDFServlet;
import com.bigdata.rdf.sail.webapp.BigdataServlet;
import com.bigdata.rdf.sail.webapp.ConfigParams;
import com.bigdata.rdf.sail.webapp.SparqlEndpointConfig;
import com.bigdata.rdf.task.AbstractApiTask;
import com.bigdata.service.AbstractDistributedFederation;
import com.bigdata.service.DefaultClientDelegate;
import com.bigdata.service.IBigdataClient;
import com.bigdata.service.IBigdataFederation;
import com.bigdata.service.jini.JiniClient;
import com.bigdata.util.httpd.AbstractHTTPD;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.log4j.Logger;

public class BigdataRDFServletContextListener
implements ServletContextListener {
    private static final transient Logger log = Logger.getLogger(BigdataRDFServletContextListener.class);
    private Journal jnl = null;
    private JiniClient<?> jiniClient = null;
    private ITransactionService txs = null;
    private Long readLock = null;
    private long readLockTx;
    private BigdataRDFContext rdfContext;
    private Map<String, String> effectiveInitParams;
    private boolean closeIndexManager;
    public static final String INIT_PARAM_OVERRIDES = "INIT_PARAMS_OVERRIDES";

    protected String getInitParameter(String key) {
        return this.effectiveInitParams.get(key);
    }

    protected BigdataRDFContext getBigdataRDFContext() {
        return this.rdfContext;
    }

    public void contextInitialized(ServletContextEvent e) {
        String s;
        long queryTimeout;
        String s2;
        boolean readOnly;
        String s3;
        boolean describeEachNamedGraph;
        int queryThreadPoolSize;
        long timestamp;
        IIndexManager indexManager;
        String s4;
        String s5;
        if (log.isInfoEnabled()) {
            log.info((Object)"");
        }
        Banner.banner();
        ServletContext context = e.getServletContext();
        this.effectiveInitParams = new LinkedHashMap<String, String>();
        Enumeration names = context.getInitParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String value = context.getInitParameter(name);
            this.effectiveInitParams.put(name, value);
        }
        Map initParamOverrides = (Map)context.getAttribute(INIT_PARAM_OVERRIDES);
        if (initParamOverrides != null) {
            this.effectiveInitParams.putAll(initParamOverrides);
        }
        if ((s5 = this.getInitParameter("namespace")) == null) {
            s5 = "kb";
        }
        String namespace = s5;
        if (log.isInfoEnabled()) {
            log.info((Object)("namespace=" + namespace));
        }
        boolean create = (s4 = this.getInitParameter("create")) != null ? Boolean.valueOf(s4) : true;
        if (log.isInfoEnabled()) {
            log.info((Object)("create=" + create));
        }
        if (context.getAttribute(IIndexManager.class.getName()) != null) {
            indexManager = (IIndexManager)context.getAttribute(IIndexManager.class.getName());
            this.closeIndexManager = false;
        } else {
            String defaultValue;
            String FQN_PROPERTY_FILE = ConfigParams.class.getName() + "." + "propertyFile";
            String propertyFile = System.getProperty(FQN_PROPERTY_FILE, defaultValue = this.getInitParameter("propertyFile"));
            if (propertyFile == null) {
                throw new RuntimeException("Required config-param: propertyFile");
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("propertyFile=" + propertyFile));
            }
            indexManager = this.openIndexManager(propertyFile);
            this.closeIndexManager = true;
        }
        if (create) {
            Properties properties = indexManager instanceof IBigdataFederation ? ((IBigdataFederation)indexManager).getClient().getProperties() : ((Journal)indexManager).getProperties();
            AbstractApiTask.submitApiTask(indexManager, new CreateKBTask(namespace, properties));
        }
        this.txs = indexManager instanceof Journal ? ((Journal)indexManager).getTransactionManager().getTransactionService() : ((IBigdataFederation)indexManager).getTransactionService();
        String s6 = this.getInitParameter("readLock");
        Long l = this.readLock = s6 == null ? null : Long.valueOf(s6);
        if (this.readLock != null) {
            try {
                timestamp = this.txs.newTx(this.readLock);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            log.warn((Object)("Holding read lock: readLock=" + this.readLock + ", tx: " + timestamp));
        } else {
            timestamp = -1L;
        }
        String s7 = this.getInitParameter("queryThreadPoolSize");
        int n = queryThreadPoolSize = s7 == null ? 16 : Integer.valueOf(s7);
        if (queryThreadPoolSize < 0) {
            throw new RuntimeException("queryThreadPoolSize : Must be non-negative, not: " + s7);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("queryThreadPoolSize=" + queryThreadPoolSize));
        }
        boolean bl = describeEachNamedGraph = (s3 = this.getInitParameter("describeEachNamedGraph")) == null ? false : Boolean.valueOf(s3);
        if (log.isInfoEnabled()) {
            log.info((Object)("describeEachNamedGraph=" + describeEachNamedGraph));
        }
        boolean bl2 = readOnly = (s2 = this.getInitParameter("readOnly")) == null ? false : Boolean.valueOf(s2);
        if (log.isInfoEnabled()) {
            log.info((Object)("readOnly=" + readOnly));
        }
        long l2 = queryTimeout = (s = this.getInitParameter("queryTimeout")) == null ? 0L : (long)Integer.valueOf(s).intValue();
        if (queryTimeout < 0L) {
            throw new RuntimeException("queryTimeout : Must be non-negative, not: " + s);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("queryTimeout=" + queryTimeout));
        }
        SparqlEndpointConfig config = new SparqlEndpointConfig(namespace, timestamp, queryThreadPoolSize, describeEachNamedGraph, readOnly, queryTimeout);
        this.rdfContext = new BigdataRDFContext(config, indexManager);
        context.setAttribute(BigdataServlet.ATTRIBUTE_INDEX_MANAGER, (Object)indexManager);
        context.setAttribute(BigdataRDFServlet.ATTRIBUTE_RDF_CONTEXT, (Object)this.rdfContext);
        boolean forceOverflow = Boolean.valueOf(this.getInitParameter("forceOverflow"));
        if (forceOverflow && indexManager instanceof IBigdataFederation) {
            log.warn((Object)("Forcing compacting merge of all data services: " + new Date()));
            ((AbstractDistributedFederation)indexManager).forceOverflow(true, false);
            log.warn((Object)("Did compacting merge of all data services: " + new Date()));
        }
        ServiceProviderHook.forceLoad();
        if (log.isInfoEnabled()) {
            log.info((Object)"done");
        }
    }

    public void contextDestroyed(ServletContextEvent e) {
        if (log.isInfoEnabled()) {
            log.info((Object)"");
        }
        if (this.rdfContext != null) {
            this.rdfContext.shutdownNow();
            this.rdfContext = null;
        }
        if (this.txs != null && this.readLock != null && this.readLock != -1L) {
            try {
                this.txs.abort(this.readLockTx);
            }
            catch (IOException ex) {
                log.error((Object)("Could not release transaction: tx=" + this.readLockTx), (Throwable)ex);
            }
            this.txs = null;
            this.readLock = null;
        }
        if (this.jnl != null) {
            if (this.closeIndexManager) {
                this.jnl.close();
            }
            this.jnl = null;
        }
        if (this.jiniClient != null) {
            if (this.closeIndexManager) {
                this.jiniClient.disconnect(true);
            }
            this.jiniClient = null;
        }
        this.effectiveInitParams = null;
        SynchronizedHardReferenceQueueWithTimeout.stopStaleReferenceCleaner();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IIndexManager openIndexManager(String propertyFile) {
        IIndexManager indexManager;
        block17: {
            URL propertyFileUrl;
            if (new File(propertyFile).exists()) {
                try {
                    propertyFileUrl = new URL("file:" + propertyFile);
                }
                catch (MalformedURLException ex) {
                    throw new RuntimeException(ex);
                }
            } else {
                propertyFileUrl = BigdataRDFServletContextListener.class.getClassLoader().getResource(propertyFile);
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("bigdata configuration: propertyFile=" + propertyFile + ", propertyFileUrl=" + propertyFileUrl));
            }
            if (propertyFileUrl == null) {
                throw new RuntimeException("Could not find file: file=" + propertyFile + ", user.dir=" + System.getProperty("user.dir"));
            }
            boolean isJini = false;
            if (propertyFile.endsWith(".config")) {
                isJini = true;
            } else if (propertyFile.endsWith(".properties")) {
                isJini = false;
            } else {
                throw new RuntimeException("File must have '.config' or '.properties' extension: " + propertyFile);
            }
            try {
                if (isJini) {
                    this.jiniClient = new JiniClient(new String[]{propertyFile});
                    this.jiniClient.setDelegate(new NanoSparqlServerFederationDelegate((IBigdataClient<?>)this.jiniClient, this));
                    indexManager = this.jiniClient.connect();
                    break block17;
                }
                Properties properties = new Properties();
                try (BufferedInputStream is = new BufferedInputStream(propertyFileUrl.openStream());){
                    properties.load(is);
                }
                if (System.getProperty(BigdataSail.Options.FILE) != null) {
                    properties.setProperty(BigdataSail.Options.FILE, System.getProperty(BigdataSail.Options.FILE));
                }
                this.jnl = new Journal(properties);
                indexManager = this.jnl;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return indexManager;
    }

    private static class NanoSparqlServerFederationDelegate<T>
    extends DefaultClientDelegate<T> {
        private final IBigdataClient<?> client;
        private final BigdataRDFServletContextListener servletContextListener;
        private static final String QUERY_ENGINE = "Query Engine";

        public NanoSparqlServerFederationDelegate(IBigdataClient<?> client, BigdataRDFServletContextListener servletContextListener) {
            super(client, null);
            this.client = client;
            if (servletContextListener == null) {
                throw new IllegalArgumentException();
            }
            this.servletContextListener = servletContextListener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reattachDynamicCounters() {
            CounterSet tmp;
            CounterSet tmp2;
            IBigdataFederation<?> fed;
            try {
                fed = this.client.getFederation();
                assert (fed != null);
            }
            catch (IllegalStateException ex) {
                log.warn((Object)("Closed: " + ex));
                return;
            }
            CounterSet serviceRoot = fed.getServiceCounterSet();
            CounterSet counterSet = tmp2 = serviceRoot.makePath("Memory");
            synchronized (counterSet) {
                tmp2.detach("DirectBufferPool");
                tmp2.makePath("DirectBufferPool").attach(DirectBufferPool.getCounters());
            }
            QueryEngine queryEngine = QueryEngineFactory.getQueryController(fed);
            CounterSet counterSet2 = tmp = serviceRoot;
            synchronized (counterSet2) {
                tmp.detach(QUERY_ENGINE);
                tmp.makePath(QUERY_ENGINE).attach(queryEngine.getCounters());
            }
        }

        @Override
        public AbstractHTTPD newHttpd(int httpdPort, ICounterSetAccess access) throws IOException {
            return null;
        }
    }
}

