/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp;

import com.bigdata.blueprints.BigdataGraphBulkLoad;
import com.bigdata.rdf.sail.BigdataSailRepositoryConnection;
import com.bigdata.rdf.sail.webapp.AbstractRestApiTask;
import com.bigdata.rdf.sail.webapp.BigdataRDFServlet;
import com.bigdata.rdf.sail.webapp.client.MiniMime;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.util.io.graphml.GraphMLReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class BlueprintsServlet
extends BigdataRDFServlet {
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(BlueprintsServlet.class);
    public static final List<String> mimeTypes = Arrays.asList("application/graphml+xml");
    static final transient String ATTR_BLUEPRINTS = "blueprints";

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String mimeType;
        String contentType = req.getContentType();
        if (log.isInfoEnabled()) {
            log.info((Object)("Request body: " + contentType));
        }
        if (!mimeTypes.contains(mimeType = new MiniMime(contentType).getMimeType().toLowerCase())) {
            BlueprintsServlet.buildAndCommitResponse(resp, 400, "text/plain", "Content-Type not recognized as graph data: " + contentType);
            return;
        }
        try {
            this.submitApiTask(new BlueprintsPostTask(req, resp, this.getNamespace(req), this.getTimestamp(req))).get();
        }
        catch (Throwable t) {
            BigdataRDFServlet.launderThrowable(t, resp, "");
        }
    }

    private static class BlueprintsPostTask
    extends AbstractRestApiTask<Void> {
        public BlueprintsPostTask(HttpServletRequest req, HttpServletResponse resp, String namespace, long timestamp) {
            super(req, resp, namespace, timestamp);
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            long begin = System.currentTimeMillis();
            BigdataSailRepositoryConnection conn = null;
            boolean success = false;
            try {
                conn = this.getUnisolatedConnection();
                BigdataGraphBulkLoad graph = new BigdataGraphBulkLoad(conn);
                GraphMLReader.inputGraph((Graph)graph, (InputStream)this.req.getInputStream());
                graph.commit();
                success = true;
                long nmodified = graph.getMutationCountLastCommit();
                long elapsed = System.currentTimeMillis() - begin;
                this.reportModifiedCount(nmodified, elapsed);
                Void void_ = null;
                return void_;
            }
            finally {
                if (conn != null) {
                    if (!success) {
                        conn.rollback();
                    }
                    conn.close();
                }
            }
        }
    }
}

