/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp;

import com.bigdata.BigdataStatics;
import com.bigdata.counters.CAT;
import com.bigdata.journal.AbstractJournal;
import com.bigdata.journal.IIndexManager;
import com.bigdata.journal.jini.ha.HAJournal;
import com.bigdata.rdf.sail.webapp.BigdataServlet;
import com.bigdata.rdf.sail.webapp.lbs.DefaultHARequestURIRewriter;
import com.bigdata.rdf.sail.webapp.lbs.IHALoadBalancerPolicy;
import com.bigdata.rdf.sail.webapp.lbs.IHAPolicyLifeCycle;
import com.bigdata.rdf.sail.webapp.lbs.IHARequestURIRewriter;
import com.bigdata.rdf.sail.webapp.lbs.policy.NOPLBSPolicy;
import com.bigdata.util.InnerCause;
import com.bigdata.util.StackInfoReport;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.AsyncContext;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.proxy.ProxyServlet;

public class HALoadBalancerServlet
extends ProxyServlet {
    private static final Logger log = Logger.getLogger(HALoadBalancerServlet.class);
    private static final long serialVersionUID = 1L;
    private static final RuntimeException CAUSE_NO_LBS_POLICY = new RuntimeException("No LBS policy");
    private static final RuntimeException CAUSE_BAD_REQUEST_URI = new RuntimeException("Bad Request-URI");
    private static final RuntimeException CAUSE_NO_REWRITER_POLICY = new RuntimeException("No rewriter policy");
    private static final RuntimeException CAUSE_DESTINATION_NOT_VALID = new RuntimeException("Could not validate destination");
    private String prefix;
    private static final String PATH_LBS = "/LBS";
    private static final String PATH_LEADER = "/leader";
    private static final String PATH_READ = "/read";
    private final AtomicReference<IHALoadBalancerPolicy> policyRef = new AtomicReference();
    private final AtomicReference<IHARequestURIRewriter> rewriterRef = new AtomicReference();
    private final CAT nforward = new CAT();
    private final CAT nproxy = new CAT();
    private final CAT nerror = new CAT();

    public void setLBSPolicy(IHALoadBalancerPolicy newValue) {
        if (newValue == null) {
            throw new IllegalArgumentException();
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("newValue=" + newValue));
        }
        this.setHAPolicy(newValue, this.policyRef);
    }

    public IHALoadBalancerPolicy getLBSPolicy() {
        return this.policyRef.get();
    }

    public void setRewriter(IHARequestURIRewriter newValue) {
        if (newValue == null) {
            throw new IllegalArgumentException();
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("newValue=" + newValue));
        }
        this.setHAPolicy(newValue, this.rewriterRef);
    }

    private <T extends IHAPolicyLifeCycle> void setHAPolicy(T newValue, AtomicReference<T> ref) {
        ServletConfig servletConfig = this.getServletConfig();
        ServletContext servletContext = servletConfig.getServletContext();
        IIndexManager indexManager = BigdataServlet.getIndexManager(servletContext);
        if (!(indexManager instanceof HAJournal)) {
            log.warn((Object)"Not HA");
            return;
        }
        try {
            newValue.init(servletConfig, indexManager);
        }
        catch (Throwable t) {
            if (InnerCause.isInnerCause(t, InterruptedException.class)) {
                return;
            }
            log.error((Object)("Could not setup policy: " + newValue), t);
            try {
                newValue.destroy();
            }
            catch (Throwable t2) {
                if (InnerCause.isInnerCause(t, InterruptedException.class)) {
                    return;
                }
                log.warn((Object)("Problem destroying policy: " + newValue), t2);
            }
            return;
        }
        IHAPolicyLifeCycle oldValue = (IHAPolicyLifeCycle)ref.getAndSet(newValue);
        if (oldValue != null && oldValue != newValue) {
            oldValue.destroy();
        }
    }

    public void init() throws ServletException {
        super.init();
        ServletConfig servletConfig = this.getServletConfig();
        this.prefix = BigdataStatics.getContextPath() + PATH_LBS;
        ServletContext servletContext = servletConfig.getServletContext();
        IIndexManager indexManager = BigdataServlet.getIndexManager(servletContext);
        if (indexManager instanceof HAJournal && ((AbstractJournal)indexManager).getQuorum() != null && ((AbstractJournal)indexManager).getQuorum().replicationFactor() > 1) {
            IHALoadBalancerPolicy policy = HALoadBalancerServlet.newInstance(servletConfig, HALoadBalancerServlet.class, IHALoadBalancerPolicy.class, "policy", InitParams.DEFAULT_POLICY);
            this.setLBSPolicy(policy);
            IHARequestURIRewriter rewriter = HALoadBalancerServlet.newInstance(servletConfig, HALoadBalancerServlet.class, IHARequestURIRewriter.class, "rewriter", InitParams.DEFAULT_REWRITER);
            this.setRewriter(rewriter);
        }
        servletContext.setAttribute("com.bigdata.rdf.sail.webapp.HALoadBalancerServlet.prefix", (Object)this.prefix);
        HALoadBalancerServlet.addServlet(servletContext, this);
        if (log.isInfoEnabled()) {
            log.info((Object)(servletConfig.getServletName() + " @ " + this.prefix + " :: policy=" + this.policyRef.get() + ", rewriter=" + this.rewriterRef.get()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addServlet(ServletContext servletContext, HALoadBalancerServlet servlet) {
        if (servletContext == null) {
            throw new IllegalArgumentException();
        }
        if (servlet == null) {
            throw new IllegalArgumentException();
        }
        ServletContext servletContext2 = servletContext;
        synchronized (servletContext2) {
            CopyOnWriteArraySet<HALoadBalancerServlet> servletSet = (CopyOnWriteArraySet<HALoadBalancerServlet>)servletContext.getAttribute("com.bigdata.rdf.sail.webapp.HALoadBalancerServlet.instances");
            if (servletSet == null) {
                servletSet = new CopyOnWriteArraySet<HALoadBalancerServlet>();
                servletContext.setAttribute("com.bigdata.rdf.sail.webapp.HALoadBalancerServlet.instances", servletSet);
            }
            servletSet.add(servlet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeServlet(ServletContext servletContext, HALoadBalancerServlet servlet) {
        if (servletContext == null) {
            throw new IllegalArgumentException();
        }
        if (servlet == null) {
            throw new IllegalArgumentException();
        }
        ServletContext servletContext2 = servletContext;
        synchronized (servletContext2) {
            CopyOnWriteArraySet servletSet = (CopyOnWriteArraySet)servletContext.getAttribute("com.bigdata.rdf.sail.webapp.HALoadBalancerServlet.instances");
            if (servletSet != null) {
                servletSet.remove((Object)servlet);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HALoadBalancerServlet[] getServlets(ServletContext servletContext) {
        if (servletContext == null) {
            throw new IllegalArgumentException();
        }
        ServletContext servletContext2 = servletContext;
        synchronized (servletContext2) {
            CopyOnWriteArraySet servletSet = (CopyOnWriteArraySet)servletContext.getAttribute("com.bigdata.rdf.sail.webapp.HALoadBalancerServlet.instances");
            if (servletSet == null) {
                return null;
            }
            return servletSet.toArray(new HALoadBalancerServlet[servletSet.size()]);
        }
    }

    public static void setLBSPolicy(ServletContext servletContext, IHALoadBalancerPolicy newValue) {
        if (newValue == null) {
            throw new IllegalArgumentException();
        }
        HALoadBalancerServlet[] servlets = HALoadBalancerServlet.getServlets(servletContext);
        if (servlets == null || servlets.length == 0) {
            return;
        }
        for (HALoadBalancerServlet servlet : servlets) {
            servlet.setLBSPolicy(newValue);
        }
    }

    public static String toString(ServletContext servletContext) {
        HALoadBalancerServlet[] servlets = HALoadBalancerServlet.getServlets(servletContext);
        if (servlets == null || servlets.length == 0) {
            return "Not running";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < servlets.length; ++i) {
            sb.append(servlets[i].toString());
        }
        return sb.toString();
    }

    public String toString() {
        return super.toString() + "{prefix=" + this.prefix + ",policy=" + this.policyRef.get() + ",rewriter=" + this.rewriterRef.get() + ",nforward=" + this.nforward.estimate_get() + ",nproxy=" + this.nproxy.estimate_get() + ",nerror=" + this.nerror.estimate_get() + "}";
    }

    public void destroy() {
        IHARequestURIRewriter rewriter;
        HALoadBalancerServlet.removeServlet(this.getServletContext(), this);
        IHALoadBalancerPolicy policy = this.policyRef.getAndSet(null);
        if (policy != null) {
            policy.destroy();
        }
        if ((rewriter = (IHARequestURIRewriter)this.rewriterRef.getAndSet(null)) != null) {
            rewriter.destroy();
        }
        this.prefix = null;
        this.getServletContext().setAttribute("com.bigdata.rdf.sail.webapp.HALoadBalancerServlet.prefix", null);
        super.destroy();
    }

    public static String getConfigParam(ServletConfig servletConfig, Class<?> owningClass, String name, String def) {
        String s = System.getProperty(owningClass.getName() + "." + name);
        if (s == null || s.trim().length() == 0) {
            s = owningClass == HALoadBalancerServlet.class ? servletConfig.getInitParameter(name) : servletConfig.getInitParameter(owningClass.getName() + "." + name);
        }
        if (s == null || s.trim().length() == 0) {
            s = def;
        }
        return s;
    }

    public static <T> T newInstance(ServletConfig servletConfig, Class<?> owningClass, Class<? extends T> iface, String name, String def) throws ServletException {
        Object t;
        Class<?> cls;
        String s = HALoadBalancerServlet.getConfigParam(servletConfig, owningClass, name, def);
        try {
            cls = Class.forName(s);
        }
        catch (ClassNotFoundException e) {
            throw new ServletException("cls=" + s + "cause=" + e, (Throwable)e);
        }
        if (!iface.isAssignableFrom(cls)) {
            throw new IllegalArgumentException(name + ":: " + s + " must extend " + iface.getName());
        }
        try {
            t = cls.newInstance();
        }
        catch (InstantiationException e) {
            throw new ServletException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ServletException((Throwable)e);
        }
        return (T)t;
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Boolean isLeaderRequest = this.isLeaderRequest(request);
        if (isLeaderRequest == null) {
            response.sendError(404);
            return;
        }
        IHALoadBalancerPolicy policy = this.policyRef.get();
        if (policy == null) {
            this.forwardToLocalService(isLeaderRequest, request, response);
            return;
        }
        if (policy.service(isLeaderRequest, this, request, response)) {
            return;
        }
        super.service(request, response);
    }

    public void forwardToLocalService(boolean isLeaderRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String path = request.getRequestURI();
        String prefix = (String)request.getServletContext().getAttribute("com.bigdata.rdf.sail.webapp.HALoadBalancerServlet.prefix");
        if (prefix == null) {
            response.sendError(500);
            return;
        }
        if (!path.startsWith(prefix)) {
            response.sendError(500);
            return;
        }
        String full_prefix = this.getFullPrefix(isLeaderRequest, prefix);
        String rest = path.substring(full_prefix.length());
        StringBuilder uri = new StringBuilder();
        if (!rest.startsWith("/")) {
            uri.append("/");
        }
        uri.append(rest);
        String newPath = uri.toString();
        RequestDispatcher requestDispatcher = request.getRequestDispatcher(newPath);
        try {
            this.nforward.increment();
            if (log.isInfoEnabled()) {
                log.info((Object)("forward: " + path + " => " + newPath));
            }
            requestDispatcher.forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (ServletException e) {
            throw new IOException("Could not forward: requestURL=" + path, e);
        }
    }

    private String getFullPrefix(boolean isLeaderRequest, String prefix) {
        String full_prefix = isLeaderRequest ? prefix + PATH_LEADER : prefix + PATH_READ;
        return full_prefix;
    }

    protected final URI rewriteURI(HttpServletRequest request) {
        try {
            URI rewritten = this.doRewriteURI(request);
            if (rewritten != null) {
                this.nproxy.increment();
            }
            return rewritten;
        }
        catch (Throwable t) {
            if (InnerCause.isInnerCause(t, InterruptedException.class)) {
                throw new RuntimeException(t);
            }
            this.nerror.increment();
            if (log.isDebugEnabled()) {
                log.warn((Object)t, t);
            } else {
                log.warn((Object)t);
            }
            return null;
        }
    }

    protected URI doRewriteURI(HttpServletRequest request) {
        IHALoadBalancerPolicy policy = this.policyRef.get();
        if (policy == null) {
            throw CAUSE_NO_LBS_POLICY;
        }
        String originalRequestURI = request.getRequestURI();
        if (!originalRequestURI.startsWith(this.prefix)) {
            throw CAUSE_BAD_REQUEST_URI;
        }
        Boolean isLeaderRequest = this.isLeaderRequest(request);
        if (isLeaderRequest == null) {
            throw CAUSE_BAD_REQUEST_URI;
        }
        String proxyToRequestURI = isLeaderRequest != false ? policy.getLeaderURI(request) : policy.getReaderURI(request);
        if (log.isDebugEnabled()) {
            log.debug((Object)("proxyToRequestURI=" + proxyToRequestURI));
        }
        if (proxyToRequestURI == null) {
            return null;
        }
        String full_prefix = this.getFullPrefix(isLeaderRequest, this.prefix);
        IHARequestURIRewriter rewriter = this.rewriterRef.get();
        if (rewriter == null) {
            throw CAUSE_NO_REWRITER_POLICY;
        }
        StringBuilder uri = rewriter.rewriteURI(isLeaderRequest, full_prefix, originalRequestURI, proxyToRequestURI, request);
        URI rewrittenURI = URI.create(uri.toString()).normalize();
        if (!this.validateDestination(rewrittenURI.getHost(), rewrittenURI.getPort())) {
            throw CAUSE_DESTINATION_NOT_VALID;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("rewrote: " + originalRequestURI + " => " + rewrittenURI));
        }
        return rewrittenURI;
    }

    protected void onRewriteFailed(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Boolean isLeaderRequest;
        if (log.isInfoEnabled()) {
            log.info((Object)("Could not rewrite: request=" + request), (Throwable)new StackInfoReport());
        }
        if ((isLeaderRequest = this.isLeaderRequest(request)) == null) {
            response.sendError(500, "Unknown prefix: requestURL=" + request.getRequestURL());
            return;
        }
        this.forwardToLocalService(isLeaderRequest, request, response);
    }

    protected void onResponseFailure(HttpServletRequest request, HttpServletResponse response, Response proxyResponse, Throwable failure) {
        log.error((Object)(this.getRequestId(request) + " proxying failed: " + request), failure);
        if (!response.isCommitted()) {
            if (failure instanceof TimeoutException) {
                response.setStatus(504);
            } else {
                response.setStatus(502);
            }
        }
        AsyncContext asyncContext = request.getAsyncContext();
        asyncContext.complete();
    }

    private Boolean isLeaderRequest(HttpServletRequest request) {
        String requestURI = request.getRequestURI();
        int indexLBS = requestURI.indexOf(this.prefix);
        if (indexLBS == -1) {
            return null;
        }
        String rest = requestURI.substring(indexLBS + this.prefix.length());
        if (rest.startsWith(PATH_LEADER)) {
            return Boolean.TRUE;
        }
        if (rest.startsWith(PATH_READ)) {
            return Boolean.FALSE;
        }
        return null;
    }

    public static interface InitParams {
        public static final String POLICY = "policy";
        public static final String DEFAULT_POLICY = NOPLBSPolicy.class.getName();
        public static final String REWRITER = "rewriter";
        public static final String DEFAULT_REWRITER = DefaultHARequestURIRewriter.class.getName();
    }
}

