/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp;

import com.bigdata.Banner;
import com.bigdata.BigdataStatics;
import com.bigdata.ha.HAGlue;
import com.bigdata.ha.HAStatusEnum;
import com.bigdata.ha.QuorumService;
import com.bigdata.ha.halog.IHALogReader;
import com.bigdata.ha.msg.HARemoteRebuildRequest;
import com.bigdata.ha.msg.HASnapshotRequest;
import com.bigdata.journal.CommitCounterUtility;
import com.bigdata.journal.IIndexManager;
import com.bigdata.journal.IRootBlockView;
import com.bigdata.journal.RootBlockView;
import com.bigdata.journal.jini.ha.HAJournal;
import com.bigdata.journal.jini.ha.HALogIndex;
import com.bigdata.journal.jini.ha.HALogNexus;
import com.bigdata.journal.jini.ha.ISnapshotPolicy;
import com.bigdata.journal.jini.ha.SnapshotIndex;
import com.bigdata.journal.jini.ha.SnapshotManager;
import com.bigdata.quorum.Quorum;
import com.bigdata.quorum.zk.ZKQuorumImpl;
import com.bigdata.rdf.sail.webapp.BigdataRDFServlet;
import com.bigdata.rdf.sail.webapp.StatusServlet;
import com.bigdata.rdf.sail.webapp.XMLBuilder;
import com.bigdata.zookeeper.DumpZookeeper;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.net.InetSocketAddress;
import java.security.DigestException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.Iterator;
import java.util.UUID;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooKeeper;

public class HAStatusServletUtil {
    private static final boolean debug = true;
    private static final transient Logger log = Logger.getLogger(HAStatusServletUtil.class);
    static final String REBUILD = "rebuild";
    static final String ERROR = "error";
    private final IIndexManager indexManager;

    public HAStatusServletUtil(IIndexManager indexManager) {
        if (indexManager == null) {
            throw new IllegalArgumentException();
        }
        this.indexManager = indexManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest req, HttpServletResponse resp, XMLBuilder.Node current) throws IOException {
        HAGlue haGlue;
        String val;
        long nbytes;
        QuorumService t;
        if (!(this.indexManager instanceof HAJournal)) {
            return;
        }
        HAJournal journal = (HAJournal)this.indexManager;
        ZKQuorumImpl quorum = (ZKQuorumImpl)journal.getQuorum();
        long quorumToken = quorum.token();
        long lastValidToken = quorum.lastValidToken();
        long haReadyToken = journal.getHAReady();
        int njoined = quorum.getJoined().length;
        try {
            t = (QuorumService)quorum.getClient();
        }
        catch (IllegalStateException ex) {
            t = null;
        }
        QuorumService quorumService = t;
        String str = req.getParameter("digests");
        StatusServlet.DigestEnum digestEnum = str == null ? null : (str.trim().isEmpty() ? StatusServlet.DEFAULT_DIGESTS : StatusServlet.DigestEnum.valueOf(str.trim()));
        current.node("h1", "High Availability");
        XMLBuilder.Node p = current.node("p");
        if (quorumService == null) {
            p.text("The local quorum service is ").node("span").attr("id", "quorum-state").text("not running").close().text(".").node("br").close();
        } else {
            p.text("The quorum is ").node("span").attr("id", "quorum-state").text((quorum.isQuorumMet() ? "" : "not ") + "met").close().text(".").node("br").close();
            p.node("span").attr("id", "njoined").text("" + njoined).close().text(" out of ").node("span").attr("id", "replication-factor").text("" + quorum.replicationFactor()).close().text(" services are joined.").node("br").close();
            p.text("quorumToken=").node("span").attr("id", "quorum-token").text("" + quorumToken).close().text(", lastValidToken=").node("span").attr("id", "last-valid-token").text("" + lastValidToken).close().node("br").close();
            p.text("logicalServiceZPath=").node("span").attr("id", "logical-service-z-path").text(quorumService.getLogicalServiceZPath()).close().node("br").close();
            p.text("PlatformStatsPlugIn=").node("span").attr("id", "platform-stats-plugin").text(journal.getPlatformStatisticsCollector() == null ? "N/A" : "Running").close().node("br").close();
            p.text("GangliaPlugIn=").node("span").attr("id", "ganglia-plugin").text(journal.getGangliaService() == null ? "N/A" : "Running").close().node("br").close();
            p.text("HAStatus: ").node("span").attr("id", "ha-status").text("" + (Object)((Object)((HAGlue)quorumService.getService()).getHAStatus())).close().text(", HAReadyToken=").node("span").attr("id", "ha-ready-token").text("" + haReadyToken).close().node("br").close();
            p.text("Service: serviceId=").node("span").attr("id", "service-id").text("" + quorumService.getServiceId()).close().node("br").close();
            p.text("Service: pid=").node("span").attr("id", "service-pid").text("" + quorumService.getPID()).close().node("br").close();
            p.text("Service: path=").node("span").attr("id", "service-path").text("" + quorumService.getServiceDir()).close().node("br").close();
            p.text("Service: proxy=").node("span").attr("id", "service-proxy").text("" + journal.getHAJournalServer().getProxy()).close().node("br").close();
        }
        SnapshotManager mgr = journal.getSnapshotManager();
        ISnapshotPolicy snapshotPolicy = mgr.getSnapshotPolicy();
        boolean takeSnapshot = mgr.isReadyToSnapshot(snapshotPolicy.newSnapshotRequest());
        p.text("Service: snapshotPolicy=").node("span").attr("id", "snapshot-policy").text("" + snapshotPolicy).close().text(", shouldSnapshot=").node("span").attr("id", "take-snapshot").text("" + takeSnapshot).close().node("br").close();
        p.text("Service: restorePolicy=").node("span").attr("id", "restore-policy").text("" + journal.getSnapshotManager().getRestorePolicy()).close().node("br").close();
        try {
            Class<?> cls = Class.forName("com.bigdata.rdf.sail.webapp.HALoadBalancerServlet");
            Method m = cls.getMethod("toString", ServletContext.class);
            String rep = (String)m.invoke(null, req.getServletContext());
            p.text("Service: LBSPolicy=").node("span").attr("id", "lbs-policy").text(rep).close().node("br").close();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        File file = journal.getFile();
        if (file != null) {
            String digestStr = null;
            if (digestEnum != null && (digestEnum == StatusServlet.DigestEnum.All || digestEnum == StatusServlet.DigestEnum.Journal)) {
                try {
                    MessageDigest digest = MessageDigest.getInstance("MD5");
                    journal.getBufferStrategy().computeDigest(null, digest);
                    digestStr = new BigInteger(1, digest.digest()).toString(16);
                }
                catch (NoSuchAlgorithmException ex) {
                }
                catch (DigestException ex) {
                    // empty catch block
                }
            }
            IRootBlockView rb = journal.getRootBlockView();
            long commitCounter = rb.getCommitCounter();
            long fileSize = file == null ? 0L : file.length();
            p.text("HAJournal: file=").node("span").attr("id", "ha-journal-file").text("" + file).close().text(", commitCounter=").node("span").attr("id", "ha-journal-commit-counter").text("" + commitCounter).close().text(", nbytes=").node("span").attr("id", "ha-journal-nbytes").text("" + fileSize).close();
            if (digestStr != null) {
                p.text(", md5=").node("span").attr("id", "ha-journal-md5").text(digestStr).close();
            }
            p.node("br").close();
            current.node("span").attr("id", "root-block").text(rb.toString()).close();
        }
        HALogNexus nexus = journal.getHALogNexus();
        int nfiles = 0;
        long nbytes2 = 0L;
        Iterator<HALogIndex.IHALogRecord> itr = nexus.getHALogs();
        HALogIndex.IHALogRecord r = null;
        while (itr.hasNext()) {
            r = itr.next();
            nbytes2 += r.sizeOnDisk();
            ++nfiles;
        }
        File currentFile = nexus.getHALogWriter().getFile();
        if (currentFile != null) {
            nbytes2 += currentFile.length();
            ++nfiles;
        }
        String compressorKey = journal.getProperties().getProperty("HALogCompressor", "DBS");
        p.text("HALogDir: nfiles=").node("span").attr("id", "ha-log-dir-nfiles").text("" + nfiles).close().text(", nbytes=").node("span").attr("id", "ha-log-dir-nbytes").text("" + nbytes2).close().text(", path=").node("span").attr("id", "ha-log-dir-path").text("" + nexus.getHALogDir()).close().text(", compressorKey=").node("span").attr("id", "ha-log-dir-compressor-key").text(compressorKey).close().text(", lastHALogClosed=").node("span").attr("id", "ha-log-dir-last-ha-log-closed").text(r == null ? "N/A" : CommitCounterUtility.getCommitCounterStr(r.getCommitCounter())).close().text(", liveLog=").node("span").attr("id", "ha-log-dir-live-log").text(currentFile == null ? "N/A" : currentFile.getName()).close().node("br").close();
        if (digestEnum != null && (digestEnum == StatusServlet.DigestEnum.All || digestEnum == StatusServlet.DigestEnum.HALogs)) {
            Iterator<HALogIndex.IHALogRecord> itr2 = nexus.getHALogs();
            while (itr2.hasNext()) {
                HALogIndex.IHALogRecord rec = itr2.next();
                nbytes = rec.sizeOnDisk();
                long closingCommitCounter = rec.getRootBlock().getCommitCounter();
                String digestStr = null;
                File file2 = nexus.getHALogFile(closingCommitCounter);
                try (IHALogReader r2 = nexus.getHALogWriter().getReader(closingCommitCounter);){
                    if (!r2.isEmpty()) {
                        try {
                            MessageDigest digest = MessageDigest.getInstance("MD5");
                            r2.computeDigest(digest);
                            digestStr = new BigInteger(1, digest.digest()).toString(16);
                        }
                        catch (NoSuchAlgorithmException ex) {
                        }
                        catch (DigestException ex) {
                            // empty catch block
                        }
                    }
                }
                p.text("HALogFile: closingCommitCounter=").node("span").attr("id", "ha-log-file-closing-commit-counter").text("" + closingCommitCounter).close().text(", file=").node("span").attr("id", "ha-log-file-file").text("" + file2).close().text(", nbytes=").node("span").attr("id", "ha-log-file-nbytes").text("" + nbytes).close();
                if (digestStr != null) {
                    p.text(", md5=").node("span").attr("id", "ha-log-file-digest-str").text(digestStr).close();
                }
                p.node("br").close();
            }
        }
        Iterator<SnapshotIndex.ISnapshotRecord> itr3 = journal.getSnapshotManager().getSnapshots();
        nfiles = 0;
        nbytes = 0L;
        while (itr3.hasNext()) {
            SnapshotIndex.ISnapshotRecord sr = itr3.next();
            nbytes += sr.sizeOnDisk();
            ++nfiles;
        }
        p.text("SnapshotDir: nfiles=").node("span").attr("id", "snapshot-dir-nfiles").text("" + nfiles).close().text(", nbytes=").node("span").attr("id", "snapshot-dir-nbytes").text("" + nbytes).close().text(", path=").node("span").attr("id", "snapshot-dir-path").text("" + journal.getSnapshotManager().getSnapshotDir()).close().node("br").close();
        itr3 = journal.getSnapshotManager().getSnapshots();
        while (itr3.hasNext()) {
            SnapshotIndex.ISnapshotRecord r3 = itr3.next();
            IRootBlockView rb = r3.getRootBlock();
            nbytes = r3.sizeOnDisk();
            String digestStr = null;
            if (digestEnum != null && (digestEnum == StatusServlet.DigestEnum.All || digestEnum == StatusServlet.DigestEnum.Snapshots)) {
                try {
                    MessageDigest digest = MessageDigest.getInstance("MD5");
                    journal.getSnapshotManager().getDigest(rb.getCommitCounter(), digest);
                    digestStr = new BigInteger(1, digest.digest()).toString(16);
                }
                catch (NoSuchAlgorithmException ex) {
                }
                catch (DigestException ex) {
                    // empty catch block
                }
            }
            p.text("SnapshotFile: commitTime=").node("span").attr("id", "snapshot-file-commit-time").text(RootBlockView.toString(rb.getLastCommitTime())).close().text(", commitCounter=").node("span").attr("id", "snapshot-file-commit-counter").text("" + rb.getCommitCounter()).close().text(", nbytes=").node("span").attr("id", "snapshot-file-nbytes").text("" + nbytes).close();
            if (digestStr != null) {
                p.text(", md5=").node("span").attr("id", "snapshot-file-md5").text(digestStr).close();
            }
            p.node("br").close();
        }
        String val2 = req.getParameter("snapshot");
        if (val2 != null) {
            int percentLogSize = 0;
            try {
                percentLogSize = Integer.parseInt(val2);
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
            journal.getSnapshotManager().takeSnapshot(new HASnapshotRequest(percentLogSize));
        }
        if (journal.getSnapshotManager().getSnapshotFuture() != null) {
            p.text("Snapshot running.").node("br").close();
        }
        p.close();
        current.node("span").attr("id", "quorum").text(quorum.toString()).close();
        if (quorumService != null && (val = req.getParameter(REBUILD)) != null && (haGlue = (HAGlue)quorumService.getService()).rebuildFromLeader(new HARemoteRebuildRequest()) != null) {
            current.node("h2").attr("id", REBUILD).text("Running Disaster Recovery for this service (REBUILD).");
        }
        if (quorumService != null && (val = req.getParameter(ERROR)) != null) {
            quorumService.enterErrorState();
        }
        if (quorumService != null) {
            ZooKeeper zk;
            UUID[] pipeline;
            current.node("h2", "Quorum Services");
            XMLBuilder.Node ul = current.node("ul").attr("id", "quorum-services");
            UUID[] joined = quorum.getJoined();
            for (UUID serviceId : pipeline = quorum.getPipeline()) {
                String extendedRunState;
                InetSocketAddress writePipelineAddr;
                int nssPort;
                String hostname;
                HAGlue remoteService;
                try {
                    remoteService = (HAGlue)quorumService.getService(serviceId);
                }
                catch (RuntimeException ex) {
                    if (!log.isInfoEnabled()) continue;
                    log.info((Object)ex, (Throwable)ex);
                    continue;
                }
                XMLBuilder.Node li = ul.node("li");
                try {
                    hostname = remoteService.getHostname();
                    nssPort = remoteService.getNSSPort();
                    writePipelineAddr = remoteService.getWritePipelineAddr();
                    extendedRunState = remoteService.getExtendedRunState();
                }
                catch (IOException ex) {
                    li.text("Unable to reach service: ").node("span").attr("class", "unreachable").text("" + remoteService).close().close();
                    log.error((Object)ex, (Throwable)ex);
                    continue;
                }
                boolean isLeader = serviceId.equals(quorum.getLeaderId());
                boolean isFollower = HAStatusServletUtil.indexOf(serviceId, joined) > 0;
                boolean isSelf = serviceId.equals(quorumService.getServiceId());
                int pipelineIndex = HAStatusServletUtil.indexOf(serviceId, pipeline);
                String nssUrl = "http://" + hostname + ":" + nssPort + BigdataStatics.getContextPath();
                li.node("a").attr("class", "nss-url").attr("href", nssUrl).text(nssUrl).close();
                li.text(" : ").node("span").attr("class", "service-status").text(isLeader ? "leader" : (isFollower ? "follower" : " is not joined")).close().text(", pipelineOrder=").node("span").attr("class", "service-pipeline-order").text("" + (pipelineIndex == -1 ? "N/A" : Integer.valueOf(pipelineIndex))).close().text(", writePipelineAddr=").node("span").attr("class", "service-write-pipeline-addr").text("" + writePipelineAddr).close().text(", service=").node("span").attr("class", "service-service").text(isSelf ? "self" : "other").close().text(", extendedRunState=").node("span").attr("class", "service-extended-run-state").text(extendedRunState).close().node("br").close();
                li.close();
            }
            ul.close();
            current.node("h2", "Zookeeper");
            try {
                zk = quorum.getZookeeper();
            }
            catch (InterruptedException e1) {
                zk = null;
            }
            if (zk == null || !zk.getState().isAlive()) {
                XMLBuilder.Node p2 = current.node("p");
                p2.text("ZooKeeper is not available.").attr("id", "zookeeper-unavailable").close();
            } else {
                current.getBuilder().getWriter().flush();
                PrintWriter out = new PrintWriter((OutputStream)resp.getOutputStream(), true);
                out.print("<span id=\"zookeeper\">\n");
                try {
                    DumpZookeeper dump = new DumpZookeeper(zk);
                    dump.dump(out, true, quorumService.getLogicalServiceZPath(), 0);
                }
                catch (InterruptedException e) {
                    e.printStackTrace(out);
                }
                catch (KeeperException e) {
                    e.printStackTrace(out);
                }
                out.print("\n</span>");
                out.flush();
            }
        }
    }

    private static int indexOf(UUID x, UUID[] a) {
        if (x == null) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < a.length; ++i) {
            if (!x.equals(a[i])) continue;
            return i;
        }
        return -1;
    }

    public void doHAStatus(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (!(this.indexManager instanceof HAJournal)) {
            return;
        }
        HAJournal journal = (HAJournal)this.indexManager;
        Quorum<HAGlue, QuorumService<HAGlue>> quorum = journal.getQuorum();
        QuorumService<HAGlue> quorumService = quorum.getClient();
        HAGlue haGlue = (HAGlue)quorumService.getService();
        HAStatusEnum status = haGlue.getHAStatus();
        resp.addHeader("Cache-Control", "no-cache");
        BigdataRDFServlet.buildAndCommitResponse(resp, 200, "text/plain", status.name());
        log.warn((Object)"Responding to HA status request");
    }

    public void doHealthStatus(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        StringWriter writer = new StringWriter();
        JsonFactory factory = new JsonFactory();
        JsonGenerator json = factory.createGenerator((Writer)writer);
        json.writeStartObject();
        json.writeStringField("version", Banner.getVersion());
        json.writeNumberField("timestamp", new Date().getTime());
        if (!(this.indexManager instanceof HAJournal)) {
            json.writeStringField("deployment", "standalone");
        } else {
            json.writeStringField("deployment", "HA");
            HAJournal journal = (HAJournal)this.indexManager;
            Quorum<HAGlue, QuorumService<HAGlue>> quorum = journal.getQuorum();
            if (quorum.isQuorumFullyMet(quorum.token())) {
                json.writeStringField("status", "Good");
                json.writeStringField("details", "All servers (" + quorum.replicationFactor() + ") joined");
            } else {
                if (quorum.isQuorumMet()) {
                    json.writeStringField("status", "Warning");
                } else {
                    json.writeStringField("status", "Bad");
                }
                json.writeStringField("details", "Only " + quorum.getJoined().length + " of target " + quorum.replicationFactor() + " servers joined");
            }
            json.writeFieldName("services");
            json.writeStartArray();
            UUID[] members = quorum.getMembers();
            UUID[] joined = quorum.getJoined();
            for (UUID serviceId : members) {
                boolean isLeader = serviceId.equals(quorum.getLeaderId());
                boolean isFollower = HAStatusServletUtil.indexOf(serviceId, joined) > 0;
                json.writeStartObject();
                json.writeStringField("id", serviceId.toString());
                json.writeStringField("status", isLeader ? "leader" : (isFollower ? "follower" : "unready"));
                json.writeEndObject();
            }
            json.writeEndArray();
        }
        json.writeEndObject();
        json.close();
        resp.addHeader("Cache-Control", "no-cache");
        BigdataRDFServlet.buildAndCommitResponse(resp, 200, "application/json", writer.toString());
    }
}

